/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.technician;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.ADAPUserActionsHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class TechnicianRolesConfig
extends DispatchAction {
    private static Logger logger = Logger.getLogger(TechnicianRolesConfig.class.getName());

    public ActionForward createRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "CreateTechRole";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
        try {
            DynaActionForm bean = (DynaActionForm)form;
            String action = request.getParameter("action");
            if (action.equals("create")) {
                ArrayList roleActionsList = ADAPUserActionsHandler.getActionDetails((HttpServletRequest)request);
                request.setAttribute("roleActionsList", (Object)roleActionsList);
            } else if (action.equals("save")) {
                JSONObject jsonObj = new JSONObject(request.getParameter("params"));
                String roleName = jsonObj.getString("roleName");
                String description = jsonObj.getString("roleDescription");
                String selectedActions = jsonObj.getString("selectedActions");
                if (accessType == 32) {
                    String message = TDUtil.createRole((String)roleName, (String)description, (String)selectedActions);
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_created", new String[]{roleName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_created", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.getString("adap.access_denied.TechnicianRolesConfig.createrole"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
                ArrayList rolesList = TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, (String)request.getParameter("searchStr"));
                request.setAttribute("rolesList", (Object)rolesList);
                forward = "ViewTechRole";
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.problem_created_tech_role", new String[]{ee.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_created", "-"}));
        }
        return mapping.findForward(forward);
    }

    public ActionForward modifyRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "ModifyTechRole";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
        try {
            DynaActionForm bean = (DynaActionForm)form;
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            String action = jsonObj.getString("action");
            Long roleId = Long.parseLong(jsonObj.getString("roleId"));
            if (action.equals("modify")) {
                ArrayList roleActionsList = ADAPUserActionsHandler.getActionDetails((HttpServletRequest)request);
                request.setAttribute("roleActionsList", (Object)roleActionsList);
                JSONObject roleDetails = ADAPUserActionsHandler.getRoleDetails((Long)roleId);
                request.setAttribute("roleDetails", (Object)roleDetails);
                forward = "CreateTechRole";
            } else if (action.equals("update")) {
                if (accessType == 32) {
                    String message = TDUtil.updateRole((Long)roleId, (String)jsonObj.getString("roleName"), (String)jsonObj.getString("description"), (String)jsonObj.getString("selectedActions"));
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_modified", new String[]{jsonObj.getString("roleName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_modified", "-"}));
                } else {
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.getString("adap.access_denied.TechnicianRolesConfig.modifyrole"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
                }
                ArrayList rolesList = TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, (String)request.getParameter("searchStr"));
                request.setAttribute("rolesList", (Object)rolesList);
                forward = "ViewTechRole";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.problem_updated_tech_role", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_modified", "-"}));
        }
        return mapping.findForward(forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward copyRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
        try {
            JSONObject jsonObj = new JSONObject(request.getParameter("params"));
            Long roleId = Long.parseLong(jsonObj.getString("roleId"));
            if (accessType == 32) {
                message = TDUtil.copyRole((Long)roleId, (String)jsonObj.getString("roleName"), (String)jsonObj.getString("description"));
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_copied", new String[]{jsonObj.getString("roleName")}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_copied", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.getString("adap.access_denied.TechnicianRolesConfig.copyrole"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            message = "adap.TechnicianRolesConfig.Some_Problem_While_copying_role";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 4, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.proble_role_copied", new String[]{ex.getMessage()}), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_copied", "-"}));
        }
        finally {
            request.setAttribute("message", (Object)rb.getString(message));
            request.setAttribute("rolesList", (Object)TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, null));
        }
        return mapping.findForward("ViewTechRole");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward deleteRole(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = "";
        HttpSession session = request.getSession();
        ADAPAuthObject authObj = (ADAPAuthObject)session.getAttribute("ADAP_AUTH_OBJ");
        Integer accessType = AdminHandler.getAccessType((String)"TechniciansSettings", (ADAPAuthObject)authObj);
        try {
            Long roleId = Long.parseLong(request.getParameter("roleId"));
            String roleName = TDHandler.getRoleName((Long)roleId);
            if (accessType == 32) {
                message = TDUtil.deleteRole((Long)roleId);
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.tech_role_deleted", new String[]{roleName}), 8, 8, "adap.ADAPUserAuditSeverities.audit_name.tech_role_deleted", "-"}));
            } else {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 2, "Admin", rb.getString("adap.access_denied.TechnicianRolesConfig.deleterole"), 8, 16, "adap.ADAPUserAuditSeverities.audit_name.access_denied", "-"}));
            }
        }
        catch (Exception ex) {
            message = "adap.TechnicianRoleConfig.Problem_While_deleting_Role";
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 8, "Admin", rb.handleGetObject("adap.TechnicianRolesConfig.audit_entry.problem_deleting_role", new String[]{ex.getMessage()}), 8, rb, 16, "adap.ADAPUserAuditSeverities.audit_name.tech_role_deleted", "-"}));
            ex.printStackTrace();
        }
        finally {
            request.setAttribute("message", (Object)rb.getString(message));
            request.setAttribute("rolesList", (Object)TDUtil.getTDRolesDetails((AdventNetResourceBundle)rb, null));
        }
        return mapping.findForward("ViewTechRole");
    }
}

