/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.manageengine.ads.fw.api.RestAPIAuthorization;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ADAPAPIAuthorization
implements RestAPIAuthorization {
    private Logger logger = Logger.getLogger("ADSLogger");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAuthorized(HttpServletRequest request) throws Exception {
        String requestAPI = request.getRequestURI();
        String userName = request.getParameter("userName");
        String domainName = request.getParameter("domainName");
        String isProductUser = request.getParameter("isProductUser");
        if ("true".equalsIgnoreCase(isProductUser)) {
            domainName = "ADAuditPlus Authentication";
        } else {
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
            if (domainDetails.length() != 0) {
                domainName = domainDetails.getString("DOMAIN_NAME");
            }
        }
        this.logger.log(Level.INFO, "Inside ADAPAPIAuthorization - isAuthorized method");
        this.logger.log(Level.INFO, "requestAPI " + requestAPI);
        this.logger.log(Level.INFO, "userName " + userName);
        this.logger.log(Level.INFO, "domainName " + domainName);
        if (requestAPI.contains("GetDashboard")) {
            if (request.getParameter("params") == null) throw new Exception("00000009");
            JSONObject params = new JSONObject(request.getParameter("params"));
            this.logger.log(Level.INFO, "params " + params);
            if (!params.has("domainName")) {
                throw new Exception("00000009");
            }
            String requestedDomain = params.getString("domainName");
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)requestedDomain);
            if (domainDetails.length() != 0) {
                requestedDomain = domainDetails.getString("DOMAIN_NAME");
            }
            this.logger.log(Level.INFO, "requestedDomain " + requestedDomain);
            this.isUserAuthorized(userName.trim(), domainName.trim(), requestedDomain.trim());
            return true;
        }
        if (!requestAPI.contains("GetURIResponse")) return true;
        Boolean isResource = Boolean.parseBoolean(request.getParameter("isResource"));
        String url = request.getParameter("url");
        if ((url == null || !url.equalsIgnoreCase("index.html")) && isResource.booleanValue()) return true;
        this.logger.log(Level.INFO, "URL " + url);
        this.logger.log(Level.INFO, "ISREsource " + isResource);
        try {
            if (!domainName.equals("ADAuditPlus Authentication")) {
                Properties domainProperties = DomainHandler.getUnAuthenticatedDomainDetails((String)domainName, (String)"DOMAIN_NAME");
                domainName = domainProperties.getProperty("DOMAIN_FLAT_NAME");
            }
            AuthUtil.getUserId((String)userName.trim(), (String)domainName);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("00000004");
        }
    }

    private boolean isUserAuthorized(String userName, String domainName, String requestedDomain) throws Exception {
        boolean isUserAuthorized = true;
        this.logger.log(Level.INFO, "Inside ADAPAPIAuthorization - isUserAuthorized method");
        try {
            Persistence per = CommonUtil.getPersistence((boolean[])new boolean[0]);
            DataObject obj = per.get("ADSMDomainConfiguration", new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"), (Object)requestedDomain, 0));
            if (obj.isEmpty()) {
                throw new Exception("00000010");
            }
            if (!domainName.equals("ADAuditPlus Authentication")) {
                Properties domainProperties = DomainHandler.getUnAuthenticatedDomainDetails((String)domainName, (String)"DOMAIN_NAME");
                domainName = domainProperties.getProperty("DOMAIN_FLAT_NAME");
            }
            try {
                AuthUtil.getUserId((String)userName, (String)domainName);
            }
            catch (Exception ex) {
                throw new Exception("00000004");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, "isUserAuthorized = " + isUserAuthorized);
        return isUserAuthorized;
    }
}

