/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.internal.WritableCredential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.auditing.webclient.ember.api.common.LeftTreeHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.manageengine.ads.fw.i18n.I18NUtil;
import com.manageengine.ads.fw.util.CommonUtil;
import java.io.InputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetURIResponse
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String url = request.getParameter("url");
            String operation = request.getParameter("operation");
            String isResource = request.getParameter("isResource");
            if (isResource != null && Boolean.parseBoolean(isResource)) {
                url = url.startsWith("/") ? url : "/" + url;
                try {
                    byte[] data = IOUtils.toByteArray((InputStream)request.getSession().getServletContext().getResourceAsStream(url));
                    response.getOutputStream().write(Base64.encodeBase64((byte[])data));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                String locale;
                String userName = request.getParameter("userName");
                String domainName = request.getParameter("domainName");
                String domainFlatName = request.getParameter("domainFlatName");
                String isProductUser = request.getParameter("isProductUser");
                if ("true".equalsIgnoreCase(isProductUser)) {
                    domainFlatName = "ADAuditPlus Authentication";
                }
                if (domainFlatName == null) {
                    JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
                    domainFlatName = domainDetails.getString("DOMAIN_FLAT_NAME");
                }
                if ((locale = request.getParameter("locale")) != null) {
                    request.getSession().setAttribute("USER_LOCALE", (Object)I18NUtil.getLocale((String)locale));
                }
                Long userId = AuthUtil.getUserId((String)userName, (String)domainFlatName);
                Long loginId = CommonUtil.getLoginId((Long)userId, (String)domainFlatName);
                ADAPAuthObject authObject = new ADAPAuthObject(loginId);
                request.getSession().setAttribute("ADAP_AUTH_OBJ", (Object)authObject);
                request.getSession().setAttribute("ADAP_SESSION_LOGIN_ID", (Object)loginId);
                request.setCharacterEncoding("UTF-8");
                WritableCredential cred = new WritableCredential();
                cred.setUserId(userId);
                cred.setLoginName(userName);
                cred.setDomainName(domainFlatName);
                AuthUtil.setUserCredential((Credential)AuthUtil.transform((WritableCredential)cred));
                if (url != null) {
                    HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

                        public String getParameter(String name) {
                            String[] values = (String[])this.getParameterMap().get(name);
                            String value = values != null ? values[0] : null;
                            try {
                                String decodedValue;
                                if (value != null && value.equals(Base64.encodeBase64URLSafeString((byte[])(decodedValue = new String(Base64.decodeBase64((String)value), "UTF-8")).getBytes()))) {
                                    value = decodedValue;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            return value;
                        }
                    };
                    request.getRequestDispatcher(url).forward((ServletRequest)wrappedRequest, (ServletResponse)response);
                } else if (operation != null && operation.equalsIgnoreCase("getReportsList")) {
                    JSONArray reportsList = new JSONArray();
                    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(I18NUtil.getLocale((String)locale));
                    LeftTreeHandler.getReportCategories(reportsList, null, 1, 2, request, rb);
                    LeftTreeHandler.getInstance().getStaticLeftTreeDetails(request, reportsList, 1, false, rb);
                    GetURIResponse.updateReportsList(reportsList);
                    response.getWriter().write(reportsList.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static void updateReportsList(JSONArray reportsList) {
        try {
            for (int i = 0; i < reportsList.length(); ++i) {
                JSONObject report = reportsList.getJSONObject(i);
                report.put("NAME", (Object)report.getString("name"));
                if (report.has("routeName")) {
                    report.put("ROUTE", (Object)report.getString("routeName").replace(".report", ""));
                }
                if (report.has("list")) {
                    JSONArray list = (JSONArray)report.remove("list");
                    report.put("LIST", (Object)list);
                    GetURIResponse.updateReportsList(list);
                    continue;
                }
                report.put("REPORT_ID", report.get("modelId"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

