/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.common.webclient.util.LicenseUpgradeAction;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.i18n.I18N;
import com.manageengine.ads.fw.license.LicenseManager;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class LicenseMgr
extends DispatchAction {
    private static Logger logger = Logger.getLogger("ADSLogger");
    private static final String SUCCESS = "Success";
    private static final String DISPLAY_TEXT = "{MemberServer:[{KEY:NumberOfMemberServers,DISPLAY_VALUE:adap.license_page.upgrade_license.ads_license_content.no_of_member_servers}],FileServer:[{KEY:NumberOfFileServers,DISPLAY_VALUE:adap.license_page.upgrade_license.ads_license_content.no_of_fileservers}],DomainController:[{KEY:NumberOfDomainControllers,DISPLAY_VALUE:adap.license_page.upgrade_license.ads_license_content.no_of_domain_controllers}],CIFSServer:[{KEY:NumberOfCIFSServers,DISPLAY_VALUE:adap.license_page.upgrade_license.ads_license_content.no_of_netapp_filers}],WorkStation:[{KEY:NumberOfWorkStations,DISPLAY_VALUE:adap.license_page.upgrade_license.ads_license_content.no_of_workstations}]}";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String upgradeStatusMsg = null;
            String licenseContent = request.getParameter("license");
            LicenseManager licenseManager = new LicenseManager("ManageEngine ADAudit Plus", licenseContent);
            if (LicenseUpgradeAction.upgradeLicense(request, licenseManager.getLicenseFileLocation())) {
                upgradeStatusMsg = SUCCESS;
            }
            request.setAttribute("RESPONSE", (Object)upgradeStatusMsg);
            logger.log(Level.INFO, "License upgrade staus - " + upgradeStatusMsg);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while applying license : " + e);
            request.setAttribute("RESPONSE", (Object)e.getMessage());
        }
        return mapping.findForward("result");
    }

    public ActionForward getLicenseDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ADSResourceBundle rb = I18N.getInstance().getBundle("adap/ApplicationResources", request);
        try {
            LicenseManager licenseManager = new LicenseManager();
            JSONObject licenseDetails = licenseManager.getLicenseDetails();
            JSONObject components = new JSONObject(DISPLAY_TEXT);
            JSONObject componentDetails = new JSONObject();
            Iterator iterator = components.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                JSONArray propList = components.getJSONArray(key);
                for (int i = 0; i < propList.length(); ++i) {
                    JSONObject prop = (JSONObject)propList.get(i);
                    componentDetails.put(rb.getString(prop.getString("DISPLAY_VALUE")), new JSONObject(licenseDetails.getJSONObject("COMPONENT_DETAILS").getString(key)).get(prop.getString("KEY")));
                }
            }
            licenseDetails.put("COMPONENT_DETAILS", (Object)componentDetails);
            request.setAttribute("RESPONSE", (Object)licenseDetails.toString());
        }
        catch (Exception e) {
            request.setAttribute("RESPONSE", (Object)e.getMessage());
        }
        return mapping.findForward("result");
    }
}

