/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilder;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilderAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.graphs.model.ChartModel;
import com.adventnet.sym.adsm.common.webclient.graphs.util.ReportChartUtil;
import de.laures.cewolf.DatasetProduceException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADAPChartHandler {
    public String opt_id = null;
    public String domainName = null;
    private static Logger logger = Logger.getLogger(ADAPChartHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static QueryBuilder queryBuilder = null;

    public ADAPChartHandler(String opt_id, String domainName) {
        this.opt_id = opt_id;
        this.domainName = domainName;
        queryBuilder = QueryBuilderAPI.getInstance().getQueryBuilder();
    }

    public Object getDataSet(HashMap graphHashMap) throws Exception {
        HashMap m = new HashMap();
        ChartModel cm = new ChartModel(graphHashMap);
        Object o = cm.produceDataset(m);
        logger.log(Level.FINE, "DataSet -> " + o);
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Object> getHighChartData(Long noofday) throws Exception {
        HashMap<String, Object> graphDataMap = new HashMap<String, Object>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String xColumnValue;
            Long graph_opt_id = Long.parseLong(this.opt_id);
            Criteria c = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID"), (Object)graph_opt_id, 0);
            DataObject graphsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDGraphOptions", c);
            logger.log(Level.FINE, "GraphDO in ADAPChartHandler.java-> " + graphsDO);
            Long graphOptId = (Long)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_OPT_ID");
            Long cvID = (Long)graphsDO.getFirstValue("AUDGraphOptions", "CV_ID");
            logger.log(Level.FINE, "domainName is  " + this.domainName);
            DataObject homePageDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDHomeGraphs", new Criteria(Column.getColumn((String)"AUDHomeGraphs", (String)"GRAPH_OPT_ID"), (Object)graph_opt_id, 0));
            String sqlString = null;
            if (((Boolean)homePageDO.getFirstValue("AUDHomeGraphs", "IS_THIS_REPORT_GRAPH")).booleanValue()) {
                HashMap inputParamsMap = ADAPSQLQueryUtil.getInputParamsMap((Long)noofday, (String)this.domainName);
                if (((Boolean)homePageDO.getFirstValue("AUDHomeGraphs", "IS_INPUT_NEEDED")).booleanValue()) {
                    Long reportId = null;
                    Criteria cri = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"CV_ID"), (Object)cvID, 0);
                    DataObject cvMapDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDReportCVMapping", cri);
                    if (!cvMapDO.isEmpty()) {
                        Row audReportRow = cvMapDO.getRow("AUDReportCVMapping");
                        reportId = (Long)audReportRow.get("AUDIT_REPORT_ID");
                    }
                    AuditReportAPI.getInstance();
                    inputParamsMap = AuditReportAPI.getInputMap((Long)graphOptId, (HashMap)inputParamsMap, reportId);
                }
                HashMap map = ReportChartUtil.getInstance().getReportGraphSQLString(cvID, inputParamsMap, null);
                sqlString = (String)map.get("sqlString");
            } else {
                sqlString = AuditReportAPI.getInstance().getGraphReportRows(cvID, this.domainName, graphOptId, noofday);
                String dbServerName = CommonUtil.getDBServerName();
            }
            String condition = "TO_CHAR(TO_TIMESTAMP(TIME_GENERATED)";
            String condition2 = "DATEPART(HH,DATEADD(ss,TIME_GENERATED+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'))";
            if (sqlString.contains(condition) && !sqlString.contains("ORDER BY")) {
                if (!sqlString.contains("TO_CHAR(TO_TIMESTAMP(TIME_GENERATED), 'DD Mon YY') as TIME_GENERATED")) {
                    sqlString = sqlString + " ORDER BY TO_CHAR";
                }
            } else if (sqlString.contains(condition2) && !sqlString.contains("ORDER BY")) {
                sqlString = sqlString + " ORDER BY " + condition2;
            }
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlString);
            String graphType = (String)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_TYPE");
            String xLabel = "";
            String yLabel = "";
            if (graphsDO.getFirstValue("AUDGraphOptions", "XLABEL") != null) {
                xLabel = rb.getString((String)graphsDO.getFirstValue("AUDGraphOptions", "XLABEL"));
            }
            if (graphsDO.getFirstValue("AUDGraphOptions", "YLABEL") != null) {
                yLabel = rb.getString((String)graphsDO.getFirstValue("AUDGraphOptions", "YLABEL"));
            }
            if ((xColumnValue = queryBuilder.replaceFunctionPattern((String)graphsDO.getFirstValue("AUDGraphOptions", "XCOLUMN"))).indexOf("TO_CHAR") == -1) {
                graphDataMap.put("xcolumn", xColumnValue);
            } else {
                graphDataMap.put("xcolumn", "to_char");
            }
            String mColumn = (String)graphsDO.getFirstValue("AUDGraphOptions", "MCOLUMN");
            if (mColumn != null) {
                graphDataMap.put("mColumn", mColumn);
            }
            graphDataMap.put("ycolumn", (String)graphsDO.getFirstValue("AUDGraphOptions", "YCOLUMN"));
            graphDataMap.put("xlabel", xLabel);
            graphDataMap.put("ylabel", yLabel);
            graphDataMap.put("viewname", (String)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_NAME"));
            graphDataMap.put("graphTitle", rb.getString((String)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_TITLE")));
            graphDataMap.put("charttype", graphType);
            graphDataMap.put("actionname", "reportView");
            if (graphType.equalsIgnoreCase("stackedhorizontalbar") || graphType.equalsIgnoreCase("stackedverticalbar") || graphType.equalsIgnoreCase("stackedhorizontalbar3d") || graphType.equalsIgnoreCase("stackedverticalbar3d")) {
                graphDataMap.put("actionname", "stackedBarChartReport");
            }
            graphDataMap.put("domainName", this.domainName);
            graphDataMap.put("cvId", cvID);
            graphDataMap.put("graphOptId", graphOptId);
            graphDataMap.put("noofday", noofday);
            JSONObject reportObj = new JSONObject();
            if (graphType.equals("stackedhorizontalbar3d") || graphType.equals("stackedverticalbar3d")) {
                ArrayList<String> categories = new ArrayList<String>();
                LinkedHashMap categoryMap = new LinkedHashMap();
                JSONArray cateArray = new JSONArray();
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                ArrayList<String> stackList = new ArrayList<String>();
                boolean isEmpty = true;
                while (resultSet.next()) {
                    LinkedHashMap<String, Long> stackMap;
                    String category = resultSet.getString(2);
                    String stack = resultSet.getString(3);
                    Long stackValue = resultSet.getLong(1);
                    if (!categories.contains(category)) {
                        categories.add(category);
                        cateArray.put((Object)category);
                    }
                    if ((stackMap = (LinkedHashMap<String, Long>)categoryMap.get(category)) == null) {
                        stackMap = new LinkedHashMap<String, Long>();
                        categoryMap.put(category, stackMap);
                    }
                    if (!stackList.contains(stack)) {
                        stackList.add(stack);
                    }
                    stackMap.put(stack, stackValue);
                }
                Iterator it = categoryMap.entrySet().iterator();
                ArrayList catList = new ArrayList();
                JSONObject map2 = new JSONObject();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    catList.add(pair.getKey());
                    LinkedHashMap obj = (LinkedHashMap)pair.getValue();
                    for (int i = 0; i < stackList.size(); ++i) {
                        String stack = (String)stackList.get(i);
                        Long stackValue = null;
                        if (obj.get(stack) == null) {
                            stackValue = 0L;
                        } else {
                            stackValue = (Long)obj.get(stack);
                            if (stackValue != 0L) {
                                isEmpty = false;
                            }
                        }
                        JSONArray l2 = map2.optJSONArray(stack);
                        if (l2 == null) {
                            l2 = new JSONArray();
                            map2.put(stack, (Object)l2);
                        }
                        l2.put((Object)stackValue);
                    }
                }
                Criteria optIdCrit = new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
                optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DAYS"), (Object)noofday, 0));
                optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DOMAIN_NAME"), (Object)this.domainName, 0));
                CommonUtil.getPersistenceLite().delete(optIdCrit);
                JSONArray l3 = new JSONArray();
                Iterator it2 = map2.keys();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    if (!(map2.get(key) instanceof JSONArray)) continue;
                    JSONObject map3 = new JSONObject();
                    map3.put("name", (Object)key);
                    map3.put("data", (Object)map2.getJSONArray(key));
                    l3.put((Object)map3);
                }
                reportObj.put("xList", (Object)cateArray);
                reportObj.put("yList", (Object)l3);
                if (!isEmpty) {
                    Row graphRow = new Row("AUDHomeGraphsData");
                    graphRow.set("GRAPH_OPT_ID", (Object)graphOptId);
                    graphRow.set("DAYS", (Object)noofday);
                    graphRow.set("DOMAIN_NAME", (Object)this.domainName);
                    graphRow.set("JSON_VALUE", (Object)reportObj.toString());
                    dataObj.addRow(graphRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                if (isEmpty) {
                    graphDataMap.put("isEmpty", true);
                }
            } else if (graphType.equals("timeseries") || graphType.equals("line")) {
                ArrayList<String> categories = new ArrayList<String>();
                LinkedHashMap categoryMap = new LinkedHashMap();
                JSONArray cateArray = new JSONArray();
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                ArrayList<String> stackList = new ArrayList<String>();
                boolean isEmpty = true;
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int numberOfColumns = rsmd.getColumnCount();
                while (resultSet.next()) {
                    LinkedHashMap<String, Long> stackMap;
                    String category = resultSet.getString(2);
                    String stack = null;
                    stack = numberOfColumns == 3 ? resultSet.getString(3) : (String)graphDataMap.get("viewname");
                    Long stackValue = resultSet.getLong(1);
                    if (!categories.contains(category)) {
                        categories.add(category);
                        cateArray.put((Object)category);
                    }
                    if ((stackMap = (LinkedHashMap<String, Long>)categoryMap.get(category)) == null) {
                        stackMap = new LinkedHashMap<String, Long>();
                        categoryMap.put(category, stackMap);
                    }
                    if (!stackList.contains(stack)) {
                        stackList.add(stack);
                    }
                    stackMap.put(stack, stackValue);
                }
                Iterator it = categoryMap.entrySet().iterator();
                ArrayList catList = new ArrayList();
                JSONObject map2 = new JSONObject();
                while (it.hasNext()) {
                    Map.Entry pair = it.next();
                    catList.add(pair.getKey());
                    LinkedHashMap obj = (LinkedHashMap)pair.getValue();
                    for (int i = 0; i < stackList.size(); ++i) {
                        String stack = (String)stackList.get(i);
                        Long stackValue = null;
                        if (obj.get(stack) == null) {
                            stackValue = 0L;
                        } else {
                            stackValue = (Long)obj.get(stack);
                            if (stackValue != 0L) {
                                isEmpty = false;
                            }
                        }
                        JSONArray l2 = map2.optJSONArray(stack);
                        if (l2 == null) {
                            l2 = new JSONArray();
                            map2.put(stack, (Object)l2);
                        }
                        l2.put((Object)stackValue);
                    }
                }
                Criteria optIdCrit = new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
                optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DAYS"), (Object)noofday, 0));
                optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DOMAIN_NAME"), (Object)this.domainName, 0));
                CommonUtil.getPersistenceLite().delete(optIdCrit);
                JSONArray l3 = new JSONArray();
                Iterator it2 = map2.keys();
                while (it2.hasNext()) {
                    String key = (String)it2.next();
                    if (!(map2.get(key) instanceof JSONArray)) continue;
                    JSONObject map3 = new JSONObject();
                    map3.put("name", (Object)key);
                    map3.put("data", (Object)map2.getJSONArray(key));
                    l3.put((Object)map3);
                }
                reportObj.put("xList", (Object)cateArray);
                reportObj.put("yList", (Object)l3);
                if (!isEmpty) {
                    Row graphRow = new Row("AUDHomeGraphsData");
                    graphRow.set("GRAPH_OPT_ID", (Object)graphOptId);
                    graphRow.set("DAYS", (Object)noofday);
                    graphRow.set("DOMAIN_NAME", (Object)this.domainName);
                    graphRow.set("JSON_VALUE", (Object)reportObj.toString());
                    dataObj.addRow(graphRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
                if (isEmpty) {
                    graphDataMap.put("isEmpty", true);
                }
            } else {
                boolean isEmpty = true;
                ArrayList<String> xlist = new ArrayList<String>();
                ArrayList<Long> ylist = new ArrayList<Long>();
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                while (resultSet.next()) {
                    xlist.add(resultSet.getString(2));
                    ylist.add(resultSet.getLong(1));
                }
                Criteria optIdCrit = new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"GRAPH_OPT_ID"), (Object)graphOptId, 0);
                optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DAYS"), (Object)noofday, 0));
                optIdCrit = optIdCrit.and(new Criteria(Column.getColumn((String)"AUDHomeGraphsData", (String)"DOMAIN_NAME"), (Object)this.domainName, 0));
                CommonUtil.getPersistenceLite().delete(optIdCrit);
                reportObj.put("xList", (Object)new JSONArray(xlist));
                reportObj.put("yList", (Object)new JSONArray(ylist));
                JSONArray xList = reportObj.getJSONArray("xList");
                String xValue = xList.optString(0);
                if (xValue == null || xValue.equals("") || xValue.equals("null")) {
                    graphDataMap.put("isEmpty", true);
                    isEmpty = true;
                } else {
                    isEmpty = false;
                }
                if (!isEmpty) {
                    Row graphRow = new Row("AUDHomeGraphsData");
                    graphRow.set("GRAPH_OPT_ID", (Object)graphOptId);
                    graphRow.set("DAYS", (Object)noofday);
                    graphRow.set("DOMAIN_NAME", (Object)this.domainName);
                    graphRow.set("JSON_VALUE", (Object)reportObj.toString());
                    dataObj.addRow(graphRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                }
            }
            graphDataMap.put("graphData", reportObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return graphDataMap;
    }

    public Object getGraphsList(Long noofday) throws DataAccessException, DatasetProduceException, Exception {
        String xColumnValue;
        logger.log(Level.FINE, "Into getGraphsList");
        Long graph_opt_id = Long.parseLong(this.opt_id);
        Criteria c = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"GRAPH_OPT_ID"), (Object)graph_opt_id, 0);
        DataObject graphsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDGraphOptions", c);
        logger.log(Level.FINE, "GraphDO in ADAPChartHandler.java-> " + graphsDO);
        Long graphOptID = (Long)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_OPT_ID");
        Long cvID = (Long)graphsDO.getFirstValue("AUDGraphOptions", "CV_ID");
        logger.log(Level.FINE, "domainName is  " + this.domainName);
        DataObject homePageDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AUDHomeGraphs", new Criteria(Column.getColumn((String)"AUDHomeGraphs", (String)"GRAPH_OPT_ID"), (Object)graph_opt_id, 0));
        String sqlString = null;
        if (((Boolean)homePageDO.getFirstValue("AUDHomeGraphs", "IS_THIS_REPORT_GRAPH")).booleanValue()) {
            HashMap inputParamsMap = ADAPSQLQueryUtil.getInputParamsMap((Long)noofday, (String)this.domainName);
            if (((Boolean)homePageDO.getFirstValue("AUDHomeGraphs", "IS_INPUT_NEEDED")).booleanValue()) {
                AuditReportAPI.getInstance();
                inputParamsMap = AuditReportAPI.getInputMap((Long)graphOptID, (HashMap)inputParamsMap, null);
            }
            HashMap map = ReportChartUtil.getInstance().getReportGraphSQLString(cvID, inputParamsMap, null);
            sqlString = (String)map.get("sqlString");
        } else {
            sqlString = AuditReportAPI.getInstance().getGraphReportRows(cvID, this.domainName, graphOptID, noofday);
            String dbServerName = CommonUtil.getDBServerName();
        }
        String condition = "TO_CHAR(TO_TIMESTAMP(TIME_GENERATED)";
        String condition2 = "DATEPART(HH,DATEADD(ss,TIME_GENERATED+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'))";
        if (sqlString.contains(condition) && !sqlString.contains("ORDER BY")) {
            if (!sqlString.contains("TO_CHAR(TO_TIMESTAMP(TIME_GENERATED), 'DD Mon YY') as TIME_GENERATED")) {
                sqlString = sqlString + " ORDER BY TO_CHAR";
            }
        } else if (sqlString.contains(condition2) && !sqlString.contains("ORDER BY")) {
            sqlString = sqlString + " ORDER BY " + condition2;
        }
        HashMap<String, Object> graphDataMap = new HashMap<String, Object>();
        Connection connection = null;
        DataSet dataSet = null;
        RelationalAPI relAPI = RelationalAPI.getInstance();
        connection = relAPI.getConnection();
        dataSet = relAPI.executeQuery(sqlString, connection);
        String graphType = (String)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_TYPE");
        String xLabel = "";
        String yLabel = "";
        if (graphsDO.getFirstValue("AUDGraphOptions", "XLABEL") != null) {
            xLabel = rb.getString((String)graphsDO.getFirstValue("AUDGraphOptions", "XLABEL"));
        }
        if (graphsDO.getFirstValue("AUDGraphOptions", "YLABEL") != null) {
            yLabel = rb.getString((String)graphsDO.getFirstValue("AUDGraphOptions", "YLABEL"));
        }
        if ((xColumnValue = queryBuilder.replaceFunctionPattern((String)graphsDO.getFirstValue("AUDGraphOptions", "XCOLUMN"))).indexOf("TO_CHAR") == -1) {
            graphDataMap.put("xcolumn", xColumnValue);
        } else {
            graphDataMap.put("xcolumn", "to_char");
        }
        String mColumn = (String)graphsDO.getFirstValue("AUDGraphOptions", "MCOLUMN");
        if (mColumn != null) {
            graphDataMap.put("mColumn", mColumn);
        }
        graphDataMap.put("ycolumn", (String)graphsDO.getFirstValue("AUDGraphOptions", "YCOLUMN"));
        graphDataMap.put("xlabel", xLabel);
        graphDataMap.put("ylabel", yLabel);
        graphDataMap.put("viewname", (String)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_NAME"));
        graphDataMap.put("graphTitle", rb.getString((String)graphsDO.getFirstValue("AUDGraphOptions", "GRAPH_TITLE")));
        graphDataMap.put("charttype", graphType);
        graphDataMap.put("actionname", "reportView");
        if (graphType.equalsIgnoreCase("stackedhorizontalbar") || graphType.equalsIgnoreCase("stackedverticalbar") || graphType.equalsIgnoreCase("stackedhorizontalbar3d") || graphType.equalsIgnoreCase("stackedverticalbar3d")) {
            graphDataMap.put("actionname", "stackedBarChartReport");
        }
        graphDataMap.put("domainName", this.domainName);
        graphDataMap.put("cvID", cvID);
        graphDataMap.put("graphOptID", graphOptID);
        graphDataMap.put("noofday", noofday);
        ChartModel cm = new ChartModel(graphDataMap);
        cm.updateModel(null, dataSet);
        ADAPChartHandler.safeClose(dataSet);
        ADAPChartHandler.safeClose(connection);
        return cm;
    }

    public ChartModel getGraphData(Long noofday) throws DataAccessException, SQLException, Exception {
        logger.log(Level.FINE, "Into getGraphData.........noofday>>>" + noofday);
        return (ChartModel)((Object)this.getGraphsList(noofday));
    }

    public static void safeClose(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void safeClose(DataSet dataSet) {
        if (dataSet != null) {
            try {
                dataSet.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

