/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.model;

import com.adventnet.client.components.table.web.TableDatasetModel;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.graphs.util.ChartUtil;
import com.adventnet.sym.adsm.common.webclient.graphs.util.DefaultLinkGenerator;
import com.adventnet.sym.adsm.common.webclient.graphs.util.DefaultToolTipGenerator;
import de.laures.cewolf.ChartPostProcessor;
import de.laures.cewolf.DatasetProduceException;
import de.laures.cewolf.DatasetProducer;
import de.laures.cewolf.links.CategoryItemLinkGenerator;
import de.laures.cewolf.links.LinkGenerator;
import de.laures.cewolf.links.PieSectionLinkGenerator;
import de.laures.cewolf.links.XYItemLinkGenerator;
import de.laures.cewolf.tooltips.CategoryToolTipGenerator;
import de.laures.cewolf.tooltips.PieToolTipGenerator;
import de.laures.cewolf.tooltips.XYToolTipGenerator;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartModel
extends TableDatasetModel
implements DatasetProducer {
    private HashMap chartHash = null;
    private String viewName = null;
    private String xColumn = null;
    private String yColumn = null;
    private String mColumn = null;
    private String xLabel = null;
    private String yLabel = null;
    private String chartType = null;
    private String legendorientaion = null;
    private String actionName = null;
    private String granularity = null;
    private static Logger logger = Logger.getLogger(ChartModel.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ChartModel(HashMap chartMap) {
        logger.log(Level.FINE, "chartMap is " + chartMap);
        this.chartHash = chartMap;
        this.viewName = (String)chartMap.get("viewname");
        this.xColumn = (String)chartMap.get("xcolumn");
        this.yColumn = (String)chartMap.get("ycolumn");
        this.mColumn = (String)chartMap.get("mColumn");
        this.xLabel = (String)chartMap.get("xlabel");
        this.yLabel = (String)chartMap.get("ylabel");
        this.chartType = (String)chartMap.get("charttype");
        this.legendorientaion = (String)chartMap.get("legendorientaion");
        this.actionName = (String)chartMap.get("actionname");
        if (this.xLabel.equalsIgnoreCase(rb.getString("adap.AUDGraphOptions.xlabel.HOUR"))) {
            this.granularity = "Hourly";
        }
    }

    public String getProducerId() {
        return this.viewName;
    }

    public HashMap getChartHash() {
        return this.chartHash;
    }

    public boolean hasExpired(Map map, Date date) {
        return false;
    }

    public Object produceDataset(Map map) throws DatasetProduceException {
        logger.log(Level.FINE, "Chart Map -> " + this.viewName);
        if (this.chartType != null) {
            if (this.chartType.equalsIgnoreCase("pie") || this.chartType.equalsIgnoreCase("pie3d")) {
                DefaultPieDataset pieDataset = new DefaultPieDataset();
                int xColumnIndex = this.getColumnIndex(this.xColumn);
                int yColumnIndex = this.getColumnIndex(this.yColumn);
                logger.log(Level.INFO, "xColumnIndex " + xColumnIndex);
                logger.log(Level.INFO, "yColumnIndex >>>>>" + yColumnIndex);
                logger.log(Level.INFO, "This " + this.tableData);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    Object xVal = (Comparable)this.getValueAt(i, xColumnIndex);
                    xVal = xVal == null ? "-" : xVal;
                    logger.log(Level.INFO, "xVal -> " + xVal);
                    Number yVal = (Number)this.getValueAt(i, yColumnIndex);
                    String actionName = this.actionName;
                    if (this.chartType.equalsIgnoreCase("pie") && actionName.equals("parent.alertView")) {
                        Integer xValIn = Integer.valueOf(xVal.toString());
                        if (xValIn == 0) {
                            pieDataset.setValue((Comparable)((Object)rb.getString("adap.NotificationAPI.Clear")), yVal);
                        }
                        if (xValIn == 1) {
                            pieDataset.setValue((Comparable)((Object)rb.getString("adap.NotificationAPI.Attention")), yVal);
                        }
                        if (xValIn == 2) {
                            pieDataset.setValue((Comparable)((Object)rb.getString("adap.NotificationAPI.Trouble")), yVal);
                        }
                        if (xValIn != 3) continue;
                        pieDataset.setValue((Comparable)((Object)rb.getString("adap.NotificationAPI.Critical")), yVal);
                        continue;
                    }
                    pieDataset.setValue((Comparable)xVal, yVal);
                }
                return pieDataset;
            }
            if (this.chartType.equalsIgnoreCase("horizontalbar") || this.chartType.equalsIgnoreCase("horizontalbar3d") || this.chartType.equalsIgnoreCase("verticalbar") || this.chartType.equalsIgnoreCase("verticalbar3d") || this.chartType.equalsIgnoreCase("line")) {
                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                int xColumnIndex = this.getColumnIndex(this.xColumn);
                if (this.mColumn == null) {
                    int yColumnIndex = this.getColumnIndex(this.yColumn);
                    logger.log(Level.FINE, "This " + this.tableData);
                    logger.log(Level.FINE, "xColumnIndex " + xColumnIndex);
                    logger.log(Level.FINE, "yColumnIndex " + yColumnIndex);
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        Object xVal = (Comparable)this.getValueAt(i, xColumnIndex);
                        xVal = xVal == null ? "-" : xVal;
                        Number yVal = (Number)this.getValueAt(i, yColumnIndex);
                        dataset.addValue(yVal, (Comparable)((Object)this.xLabel), (Comparable)xVal);
                    }
                    return dataset;
                }
                if (!this.mColumn.equals("wa_type2")) {
                    int mColumnIndex = this.getColumnIndex(this.mColumn);
                    int yColumnIndex = this.getColumnIndex(this.yColumn);
                    for (int i = 0; i < this.getRowCount(); ++i) {
                        Object mVal = (Comparable)this.getValueAt(i, mColumnIndex);
                        Object xVal = (Comparable)this.getValueAt(i, xColumnIndex);
                        xVal = xVal == null ? "-" : xVal;
                        mVal = mVal == null ? "-" : mVal;
                        Number yVal = (Number)this.getValueAt(i, yColumnIndex);
                        dataset.addValue(yVal, (Comparable)mVal, (Comparable)xVal);
                    }
                } else {
                    int i;
                    StringTokenizer st = new StringTokenizer(this.yColumn, ",");
                    String[] yCol = new String[st.countTokens()];
                    int[] yColIndex = new int[yCol.length];
                    for (i = 0; i < yCol.length; ++i) {
                        yCol[i] = st.nextToken();
                        yColIndex[i] = this.getColumnIndex(yCol[i]);
                    }
                    for (i = 0; i < this.getRowCount(); ++i) {
                        Comparable xVal = (Comparable)this.getValueAt(i, xColumnIndex);
                        for (int j = 0; j < yCol.length; ++j) {
                            Number yVal = (Number)this.getValueAt(i, yColIndex[j]);
                            dataset.addValue(yVal, (Comparable)((Object)yCol[j]), xVal);
                        }
                    }
                }
                return dataset;
            }
            if (this.chartType.equalsIgnoreCase("stackedhorizontalbar") || this.chartType.equalsIgnoreCase("stackedverticalbar") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                boolean threeTokens;
                DefaultCategoryDataset dcs = null;
                if (this.xColumn.indexOf(",") < 0) {
                    return dcs;
                }
                StringTokenizer stk = new StringTokenizer(this.xColumn, ",");
                boolean bl = threeTokens = stk.countTokens() == 3;
                if (stk.countTokens() == 3 || stk.countTokens() == 2) {
                    String actualXCol = stk.nextToken();
                    String stackCol1 = stk.nextToken();
                    String stackCol2 = null;
                    if (threeTokens) {
                        stackCol2 = stk.nextToken();
                    }
                    int count = this.getColumnCount();
                    int stCol1 = -1;
                    int stCol2 = -1;
                    int xPos = -1;
                    int yPos = -1;
                    for (int i = 0; i < count; ++i) {
                        String tempString = this.getColumnName(i);
                        if (tempString.equals(actualXCol)) {
                            xPos = i;
                        }
                        if (tempString.equals(this.yColumn)) {
                            yPos = i;
                        }
                        if (tempString.equals(stackCol1)) {
                            stCol1 = i;
                        }
                        if (!tempString.equals(stackCol2)) continue;
                        stCol2 = i;
                    }
                    dcs = new DefaultCategoryDataset();
                    if (stackCol1 == null || stackCol2 != null) {
                        // empty if block
                    }
                    int size = this.getRowCount();
                    boolean seriesCount = false;
                    for (int i = 0; i < size; ++i) {
                        Number yVal;
                        Comparable xVal = (Comparable)this.getValueAt(i, xPos);
                        Object yVal1 = this.getValueAt(i, stCol1);
                        if (yVal1 instanceof Number) {
                            yVal = (Number)this.getValueAt(i, yPos);
                            dcs.setValue(yVal, (Comparable)yVal1, xVal);
                        } else if (yVal1 instanceof String) {
                            yVal = (Number)this.getValueAt(i, yPos);
                            dcs.setValue(yVal, (Comparable)yVal1, xVal);
                        }
                        if (!threeTokens) continue;
                        Number yVal2 = (Number)this.getValueAt(i, stCol2);
                        dcs.addValue(yVal2, (Comparable)((Object)stackCol2), xVal);
                    }
                }
                return dcs;
            }
            if (this.chartType.equalsIgnoreCase("area") || this.chartType.equalsIgnoreCase("stackedarea")) {
                DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                int xColumnIndex = this.getColumnIndex(this.xColumn);
                int yColumnIndex = this.getColumnIndex(this.yColumn);
                int mColumnIndex = this.getColumnIndex(this.mColumn);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    Comparable mVal = (Comparable)this.getValueAt(i, mColumnIndex);
                    Comparable xVal = (Comparable)this.getValueAt(i, xColumnIndex);
                    Number yVal = (Number)this.getValueAt(i, yColumnIndex);
                    dataset.addValue(yVal, xVal, mVal);
                }
                return dataset;
            }
            if (this.chartType.equalsIgnoreCase("xy") || this.chartType.equalsIgnoreCase("areaxy")) {
                XYSeriesCollection dataset = new XYSeriesCollection();
                int xColumnIndex = this.getColumnIndex(this.xColumn);
                int yColumnIndex = this.getColumnIndex(this.yColumn);
                XYSeries series = new XYSeries((Comparable)((Object)this.xColumn), false, false);
                for (int i = 0; i < this.getRowCount(); ++i) {
                    Number xVal = (Number)this.getValueAt(i, xColumnIndex);
                    Number yVal = (Number)this.getValueAt(i, yColumnIndex);
                    series.add(xVal, yVal);
                }
                dataset.addSeries(series);
                return dataset;
            }
            if (this.chartType.equalsIgnoreCase("timeseries")) {
                TimeSeriesCollection dataSet = null;
                if (this.mColumn != null) {
                    dataSet = this.produceTimeSeriesDataSet();
                } else {
                    TimeSeries time = null;
                    time = this.granularity != null && this.granularity.equalsIgnoreCase("Hourly") ? new TimeSeries(this.viewName, Hour.class) : new TimeSeries(this.viewName, Day.class);
                    int counter = this.getColumnCount();
                    int xPos = -1;
                    int yPos = -1;
                    for (int i = 0; i < counter && (xPos <= -1 || yPos <= -1); ++i) {
                        String tempString = this.getColumnName(i);
                        if (tempString.equals(this.xColumn) || this.xColumn.toLowerCase().indexOf(tempString) != -1) {
                            xPos = i;
                        }
                        if (!tempString.equals(this.yColumn)) continue;
                        yPos = i;
                    }
                    int rows = this.getRowCount();
                    logger.log(Level.FINE, "time series rows<->{0}" + Integer.valueOf(rows));
                    for (int i = 0; i < rows; ++i) {
                        Object xObj = this.getValueAt(i, xPos);
                        Date hour = null;
                        if (xObj instanceof Timestamp) {
                            hour = new Date(((Timestamp)xObj).getTime());
                        } else if (xObj instanceof String) {
                            try {
                                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                                hour = format.parse(xObj.toString());
                            }
                            catch (Exception ee) {
                                logger.log(Level.INFO, " FORMAT TO PARSE IS ==yyyy-MM-dd HH:mm given string is {0}" + xObj);
                                try {
                                    SimpleDateFormat format = new SimpleDateFormat("HH");
                                    hour = format.parse(xObj.toString());
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        } else if (xObj instanceof Long) {
                            if (this.xLabel.equalsIgnoreCase(rb.getString("adap.AUDGraphOptions.xlabel.HOUR"))) {
                                hour = new Date(System.currentTimeMillis());
                                hour.setHours(((Long)xObj).intValue());
                            } else {
                                hour = new Date((Long)xObj);
                            }
                        } else if (xObj instanceof Integer) {
                            hour = new Date(System.currentTimeMillis());
                            hour.setHours((Integer)xObj);
                        } else if (xObj instanceof Double) {
                            if (this.xLabel.equalsIgnoreCase(rb.getString("adap.AUDGraphOptions.xlabel.HOUR"))) {
                                hour = new Date(System.currentTimeMillis());
                                hour.setHours(((Double)xObj).intValue());
                            } else {
                                hour = new Date(((Double)xObj).longValue());
                            }
                        }
                        Number yVal = (Number)this.getValueAt(i, yPos);
                        if (this.xLabel.equalsIgnoreCase(rb.getString("adap.AUDGraphOptions.xlabel.HOUR"))) {
                            time.add((RegularTimePeriod)new Hour(hour), yVal);
                            continue;
                        }
                        time.add((RegularTimePeriod)new Day(hour), yVal);
                    }
                    dataSet = new TimeSeriesCollection();
                    dataSet.addSeries(time);
                }
                return dataSet;
            }
            return null;
        }
        return null;
    }

    public TimeSeriesCollection produceTimeSeriesDataSet() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        LinkedHashMap<String, TimeSeries> seriesMap = new LinkedHashMap<String, TimeSeries>();
        String idColumn = null;
        String valueColumn = null;
        StringTokenizer token = new StringTokenizer(this.mColumn, ",");
        if (token.countTokens() == 2) {
            idColumn = token.nextToken();
            valueColumn = token.nextToken();
        }
        int xColumnIndex = this.getColumnIndex(this.xColumn);
        int yColumnIndex = this.getColumnIndex(this.yColumn);
        Integer idColumnIndex = null;
        Integer valueColumnIndex = null;
        Integer mColumnIndex = null;
        if (idColumn != null) {
            idColumnIndex = this.getColumnIndex(idColumn);
            valueColumnIndex = this.getColumnIndex(valueColumn);
        } else {
            mColumnIndex = this.getColumnIndex(this.mColumn);
        }
        int counter = this.getRowCount();
        for (int i = 0; i < counter; ++i) {
            TimeSeries series = null;
            String key = null;
            Date date = null;
            Object xVal = this.getValueAt(i, xColumnIndex);
            if (xVal instanceof Timestamp) {
                date = new Date(((Timestamp)xVal).getTime());
            } else if (xVal instanceof Date) {
                date = (Date)xVal;
            } else if (xVal instanceof String) {
                try {
                    SimpleDateFormat format = new SimpleDateFormat("dd MMM yy");
                    date = format.parse(xVal.toString());
                }
                catch (Exception ee) {
                    logger.log(Level.INFO, " FORMAT TO PARSE IS ==yyyy-MM-dd HH:mm given string is {0}" + xVal);
                    try {
                        SimpleDateFormat format = new SimpleDateFormat("HH");
                        date = format.parse(xVal.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            Number yVal = (Number)this.getValueAt(i, yColumnIndex);
            if (idColumn != null) {
                key = this.getValueAt(i, idColumnIndex).toString();
                String val = this.getValueAt(i, valueColumnIndex).toString();
                series = (TimeSeries)seriesMap.get(key);
                if (series == null) {
                    series = this.granularity != null && this.granularity.equalsIgnoreCase("Hourly") ? new TimeSeries(val, Hour.class) : new TimeSeries(val, Day.class);
                }
            } else {
                key = this.getValueAt(i, mColumnIndex) != null ? this.getValueAt(i, mColumnIndex).toString() : "-";
                series = (TimeSeries)seriesMap.get(key);
                if (series == null) {
                    series = this.granularity != null && this.granularity.equalsIgnoreCase("Hourly") ? new TimeSeries(key, Hour.class) : new TimeSeries(key, Day.class);
                }
            }
            if (this.granularity != null && this.granularity.equalsIgnoreCase("Hourly")) {
                series.addOrUpdate((RegularTimePeriod)new Hour(date), yVal);
            } else {
                series.addOrUpdate((RegularTimePeriod)new Day(date), yVal);
            }
            seriesMap.put(key, series);
        }
        for (TimeSeries series : seriesMap.values()) {
            dataset.addSeries(series);
        }
        return dataset;
    }

    public ChartPostProcessor getPP() {
        Object cpp = null;
        if (this.chartType.equalsIgnoreCase("pie3D")) {
            cpp = new ChartPostProcessor(){

                public void processChart(Object chart, Map params) {
                    ChartUtil.processPieCharts((JFreeChart)chart, ChartModel.this.chartHash);
                }
            };
        } else if (this.chartType.equalsIgnoreCase("pie")) {
            cpp = new ChartPostProcessor(){

                public void processChart(Object chart, Map params) {
                    ChartUtil.process2DPieCharts((JFreeChart)chart, ChartModel.this.chartHash);
                }
            };
        } else if (this.chartType.equalsIgnoreCase("horizontalbar") || this.chartType.equalsIgnoreCase("horizontalbar3d") || this.chartType.equalsIgnoreCase("verticalbar") || this.chartType.equalsIgnoreCase("verticalbar3d")) {
            cpp = new ChartPostProcessor(){

                public void processChart(Object chart, Map params) {
                    ChartUtil.processBarCharts((JFreeChart)chart, ChartModel.this.chartHash);
                }
            };
        } else if (this.chartType.equalsIgnoreCase("line")) {
            cpp = new ChartPostProcessor(){

                public void processChart(Object chart, Map params) {
                    ChartUtil.processLineCharts((JFreeChart)chart, ChartModel.this.chartHash);
                }
            };
        } else if (this.chartType.equalsIgnoreCase("timeseries")) {
            cpp = new ChartPostProcessor(){

                public void processChart(Object chart, Map params) {
                    ChartUtil.processTimeSeriesChart((JFreeChart)chart, ChartModel.this.chartHash);
                }
            };
        } else if (this.chartType.equalsIgnoreCase("stackedhorizontalbar") || this.chartType.equalsIgnoreCase("stackedverticalbar") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("stackedverticalbar3d")) {
            cpp = new ChartPostProcessor(){

                public void processChart(Object chart, Map params) {
                    ChartUtil.processStackedBarCharts((JFreeChart)chart, ChartModel.this.chartHash);
                }
            };
        }
        return cpp;
    }

    public Object getToolTipGenerator() {
        if (this.chartType.equalsIgnoreCase("pie") || this.chartType.equalsIgnoreCase("pie3D")) {
            PieToolTipGenerator toolTip = new PieToolTipGenerator(){
                private DefaultToolTipGenerator dToolTip = new DefaultToolTipGenerator();

                public String generateToolTip(PieDataset dataSet, Comparable key, int pieIndex) {
                    return this.dToolTip.generateToolTip(dataSet, key, pieIndex, ChartModel.this.chartHash);
                }
            };
            return toolTip;
        }
        if (this.chartType.equalsIgnoreCase("horizontalbar") || this.chartType.equalsIgnoreCase("horizontalbar3d") || this.chartType.equalsIgnoreCase("verticalbar") || this.chartType.equalsIgnoreCase("verticalbar3d") || this.chartType.equalsIgnoreCase("stackedhorizontalbar") || this.chartType.equalsIgnoreCase("stackedverticalbar") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("stackedverticalbar3d") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("line")) {
            CategoryToolTipGenerator toolTip = new CategoryToolTipGenerator(){
                private DefaultToolTipGenerator dToolTip;
                {
                    this.dToolTip = new DefaultToolTipGenerator(ChartModel.this.mColumn);
                }

                public String generateToolTip(CategoryDataset dataSet, int series, int category) {
                    return this.dToolTip.generateToolTip(dataSet, series, category, ChartModel.this.chartHash);
                }
            };
            return toolTip;
        }
        if (this.chartType.equalsIgnoreCase("XYSeries") || this.chartType.equalsIgnoreCase("xy") || this.chartType.equalsIgnoreCase("timeseries")) {
            XYToolTipGenerator toolTip = new XYToolTipGenerator(){
                private DefaultToolTipGenerator dToolTip;
                {
                    this.dToolTip = new DefaultToolTipGenerator(ChartModel.this.mColumn);
                }

                public String generateToolTip(XYDataset dataSet, int series, int item) {
                    return this.dToolTip.generateToolTip(dataSet, series, item, ChartModel.this.chartHash);
                }
            };
            return toolTip;
        }
        return null;
    }

    public LinkGenerator getLinkGenerator() {
        Object link = null;
        if (this.chartType.equalsIgnoreCase("pie") || this.chartType.equalsIgnoreCase("pie3D")) {
            link = new PieSectionLinkGenerator(){
                private DefaultLinkGenerator dlink;
                {
                    this.dlink = new DefaultLinkGenerator(ChartModel.this.chartHash);
                }

                public String generateLink(Object dataset, Object category) {
                    return this.dlink.generateLink(dataset, category);
                }
            };
            return link;
        }
        if (this.chartType.equalsIgnoreCase("horizontalbar") || this.chartType.equalsIgnoreCase("horizontalbar3d") || this.chartType.equalsIgnoreCase("verticalbar") || this.chartType.equalsIgnoreCase("verticalbar3d") || this.chartType.equalsIgnoreCase("stackedhorizontalbar") || this.chartType.equalsIgnoreCase("stackedverticalbar") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("stackedverticalbar3d") || this.chartType.equalsIgnoreCase("stackedhorizontalbar3d") || this.chartType.equalsIgnoreCase("line")) {
            link = new CategoryItemLinkGenerator(){
                private DefaultLinkGenerator dlink;
                {
                    this.dlink = new DefaultLinkGenerator(ChartModel.this.chartHash);
                }

                public String generateLink(Object dataset, int series, Object category) {
                    return this.dlink.generateLink(dataset, series, category);
                }
            };
            return link;
        }
        if (this.chartType.equalsIgnoreCase("XYSeries") || this.chartType.equalsIgnoreCase("xy") || this.chartType.equalsIgnoreCase("timeseries")) {
            link = new XYItemLinkGenerator(){
                private DefaultLinkGenerator dlink;
                {
                    this.dlink = new DefaultLinkGenerator(ChartModel.this.chartHash);
                }

                public String generateLink(Object dataset, int series, int item) {
                    return this.dlink.generateLink(dataset, series, item);
                }
            };
            return link;
        }
        return null;
    }
}

