/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.schedule;

import com.adventnet.sym.adsm.common.server.model.GraphGenerator;
import com.adventnet.sym.adsm.common.server.model.ReportInterface;
import com.adventnet.sym.adsm.common.webclient.dashboard.ADAPURLGenerator;
import com.adventnet.sym.adsm.common.webclient.graphs.ADAPChartHandler;
import com.adventnet.sym.adsm.common.webclient.graphs.model.ChartModel;
import com.adventnet.sym.adsm.common.webclient.graphs.util.ChartUtil;
import com.adventnet.sym.adsm.common.webclient.graphs.util.DefaultLinkGenerator;
import com.adventnet.sym.adsm.common.webclient.graphs.util.DefaultToolTipGenerator;
import com.adventnet.sym.adsm.common.webclient.graphs.util.ReportChartUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

public class DefaultGraphGenerator
implements GraphGenerator {
    public HashMap<String, Object> generateHighCharts(Long graphOptId, String domainName, Long days, ArrayList<HashMap<String, Object>> paramList) throws Exception {
        HashMap<String, Object> graphData = new HashMap<String, Object>();
        try {
            if (days != 0L) {
                ChartUtil.setExport(0);
                ADAPChartHandler chartHandler = new ADAPChartHandler(graphOptId.toString(), domainName);
                HashMap<String, Object> graphDataMap = chartHandler.getHighChartData(days);
                String chartType = (String)graphDataMap.get("charttype");
                graphData.put("graphData", graphDataMap.get("graphData"));
                graphData.put("xlabel", graphDataMap.get("xlabel"));
                graphData.put("ylabel", graphDataMap.get("ylabel"));
                if (graphDataMap.get("graphTitle").toString().length() > 28) {
                    graphData.put("graphTitleTrimTxt", graphDataMap.get("graphTitle").toString().substring(0, 28) + "...");
                } else {
                    graphData.put("graphTitleTrimTxt", graphDataMap.get("graphTitle"));
                }
                graphData.put("graphTitle", graphDataMap.get("graphTitle"));
                graphData.put("graphOptId", graphDataMap.get("graphOptId"));
                graphData.put("cvId", graphDataMap.get("cvId"));
                graphData.put("chartType", graphDataMap.get("charttype"));
                graphData.put("isEmpty", graphDataMap.get("isEmpty"));
                graphData.put("days", days);
                graphData.put("graphId", "graphId_" + graphDataMap.get("graphOptId") + "_" + days + "_day");
                graphData.put("graphName", "graphName_" + graphDataMap.get("graphOptId") + "_" + days + "_day");
                graphData.put("graphClassId", "graphClass_" + graphDataMap.get("graphOptId") + "_day");
                graphData.put("chartLoaderId", "chartLoader_" + graphDataMap.get("graphOptId") + "_day");
                graphData.put("isHomeGraph", true);
                if (chartType.equals("stackedhorizontalbar3d")) {
                    graphData.put("width", 300);
                    graphData.put("height", 250);
                } else {
                    graphData.put("width", 300);
                    graphData.put("height", 250);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return graphData;
    }

    public Properties generateGraph(Long graphOptId, String domainName, Long days, String className, ArrayList<HashMap> paramList) throws Exception {
        CategoryPlot plot;
        StackedBarRenderer3D renderer;
        NumberAxis3D valueAxis;
        CategoryAxis3D categoryAxis;
        CategoryDataset categoryDataset;
        Properties props = new Properties();
        String imageMap = "";
        boolean isExport = false;
        JFreeChart chart = null;
        ChartModel chartModel = null;
        String htmlFileName = "";
        if (days != 0L) {
            isExport = false;
            ChartUtil.setExport(0);
            ADAPChartHandler chartHandler = new ADAPChartHandler(graphOptId.toString(), domainName);
            chartModel = chartHandler.getGraphData(days);
        } else {
            isExport = true;
            ChartUtil.setExport(1);
            HashMap inputGraphMap = paramList.get(0);
            HashMap cvIdMap = paramList.get(1);
            HashMap searchMap = paramList.get(2);
            Class<?> classToInvoke1 = Class.forName("com.adventnet.sym.adsm.common.webclient.graphs.util.ReportChartUtil");
            ReportInterface reportInterface = (ReportInterface)classToInvoke1.newInstance();
            ADAPChartHandler chartHandler = new ADAPChartHandler(graphOptId.toString(), domainName);
            chartModel = ReportChartUtil.getInstance().getReportGraphChartModel(reportInterface.getReportGraphSQLString((Long)cvIdMap.get("cvId"), (HashMap)inputGraphMap.get("inputParamsMap"), (String)searchMap.get("searchCriteria")));
        }
        HashMap chartHash = chartModel.getChartHash();
        String chartType = (String)chartHash.get("charttype");
        HashMap<String, String> chartProducerMap = new HashMap<String, String>();
        chartProducerMap.put("de.laures.cewolf.DatasetProducer.id", graphOptId + "_" + domainName + "_Data");
        boolean isEmpty = true;
        if (chartType.equalsIgnoreCase("pie") || chartType.equalsIgnoreCase("pie3d")) {
            DefaultPieDataset defaultPieDataset = (DefaultPieDataset)chartModel.produceDataset(chartProducerMap);
            List keyList = defaultPieDataset.getKeys();
            if (!keyList.isEmpty()) {
                isEmpty = false;
            }
            chart = ChartFactory.createPieChart3D((String)"", (PieDataset)defaultPieDataset, (boolean)true, (boolean)true, (boolean)true);
            ChartUtil.processPieCharts(chart, chartHash);
            PiePlot3D piePlot3D = (PiePlot3D)chart.getPlot();
            piePlot3D.setToolTipGenerator((PieToolTipGenerator)new ADAPURLGenerator(chartHash));
            piePlot3D.setURLGenerator((PieURLGenerator)new ADAPURLGenerator(chartHash));
        } else if (chartType.equalsIgnoreCase("horizontalbar") || chartType.equalsIgnoreCase("horizontalbar3d") || chartType.equalsIgnoreCase("verticalbar") || chartType.equalsIgnoreCase("line") || chartType.equalsIgnoreCase("verticalbar3d")) {
            LineAndShapeRenderer renderer2;
            categoryDataset = (CategoryDataset)chartModel.produceDataset(chartProducerMap);
            int rowCount = categoryDataset.getRowCount();
            if (rowCount > 0) {
                isEmpty = false;
            }
            categoryAxis = new CategoryAxis3D((String)chartHash.get("xlabel"));
            valueAxis = new NumberAxis3D((String)chartHash.get("ylabel"));
            CategoryPlot plot2 = null;
            if (chartType.equalsIgnoreCase("line")) {
                renderer2 = new LineAndShapeRenderer();
                renderer2.setToolTipGenerator((CategoryToolTipGenerator)new ADAPURLGenerator(chartHash));
                renderer2.setItemURLGenerator((CategoryURLGenerator)new ADAPURLGenerator(chartHash));
                plot2 = new CategoryPlot(categoryDataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer2);
                plot2.setOrientation(PlotOrientation.VERTICAL);
                chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot2, true);
                ChartUtil.processLineCharts(chart, chartHash);
            } else {
                renderer2 = new BarRenderer3D();
                renderer2.setToolTipGenerator((CategoryToolTipGenerator)new ADAPURLGenerator(chartHash));
                renderer2.setItemURLGenerator((CategoryURLGenerator)new ADAPURLGenerator(chartHash));
                plot2 = new CategoryPlot(categoryDataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer2);
                plot2.setOrientation(PlotOrientation.VERTICAL);
                chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot2, true);
                ChartUtil.processBarCharts(chart, chartHash);
            }
        } else if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
            categoryDataset = (CategoryDataset)chartModel.produceDataset(chartProducerMap);
            int rowCount = categoryDataset.getRowCount();
            if (rowCount > 0) {
                isEmpty = false;
            }
            categoryAxis = new CategoryAxis3D((String)chartHash.get("xlabel"));
            valueAxis = new NumberAxis3D((String)chartHash.get("ylabel"));
            renderer = new StackedBarRenderer3D();
            renderer.setToolTipGenerator((CategoryToolTipGenerator)new ADAPURLGenerator(chartHash));
            renderer.setItemURLGenerator((CategoryURLGenerator)new ADAPURLGenerator(chartHash));
            plot = new CategoryPlot(categoryDataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
            plot.setOrientation(PlotOrientation.VERTICAL);
            chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            ChartUtil.processStackedBarCharts(chart, chartHash);
        } else if (chartType.equalsIgnoreCase("timeseries")) {
            TimeSeriesCollection timeSeriesCollection = (TimeSeriesCollection)chartModel.produceDataset(chartProducerMap);
            int seriesCount = timeSeriesCollection.getSeriesCount();
            if (seriesCount > 0) {
                isEmpty = false;
            }
            DateAxis domainAxis = new DateAxis((String)chartHash.get("xlabel"));
            NumberAxis rangeAxis = new NumberAxis((String)chartHash.get("ylabel"));
            renderer = new XYLineAndShapeRenderer(true, true);
            renderer.setToolTipGenerator((XYToolTipGenerator)new ADAPURLGenerator(chartHash));
            renderer.setURLGenerator((XYURLGenerator)new ADAPURLGenerator(chartHash));
            plot = new XYPlot((XYDataset)timeSeriesCollection, (ValueAxis)domainAxis, (ValueAxis)rangeAxis, (XYItemRenderer)renderer);
            chart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
            ChartUtil.processTimeSeriesChart(chart, chartHash);
        }
        String dirName = System.getProperty("server.home");
        String baseChartDirectory = dirName + File.separator + "webapps" + File.separator + "adap" + File.separator + "cewolf_charts";
        File chartDir = new File(baseChartDirectory);
        if (!chartDir.exists()) {
            chartDir.mkdirs();
        }
        String chartId = graphOptId + "_" + domainName + "_" + days + "day";
        String chartName = chartId + "_Data";
        File imageFile = new File(baseChartDirectory + File.separator + chartName + ".png");
        if (!isEmpty) {
            ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
            if (isExport) {
                if (chartType.equals("pie3d")) {
                    ChartUtilities.saveChartAsPNG((File)imageFile, (JFreeChart)chart, (int)350, (int)180, (ChartRenderingInfo)info);
                } else {
                    ChartUtilities.saveChartAsPNG((File)imageFile, (JFreeChart)chart, (int)450, (int)360, (ChartRenderingInfo)info);
                }
            } else {
                ChartUtilities.saveChartAsPNG((File)imageFile, (JFreeChart)chart, (int)250, (int)180, (ChartRenderingInfo)info);
            }
            htmlFileName = chartName + ".html";
            File htmlFile = new File(baseChartDirectory + File.separator + htmlFileName);
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(htmlFile));
            PrintWriter writer = new PrintWriter(outStream);
            imageMap = ImageMapUtilities.getImageMap((String)chartId, (ChartRenderingInfo)info);
            writer.println(imageMap);
            writer.close();
        } else {
            try {
                File htmlFile;
                if (imageFile.exists()) {
                    imageFile.delete();
                }
                if ((htmlFile = new File(baseChartDirectory + File.separator + chartName + ".html")).exists()) {
                    htmlFile.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        props.put("htmlFileName", htmlFileName);
        props.put("imageMap", imageMap);
        return props;
    }

    public String generateGraph(Long graphOptId, String domainName, Long days, ArrayList<HashMap> paramList) throws Exception {
        Properties props = this.generateGraph(graphOptId, domainName, days, null, paramList);
        return props.get("htmlFileName").toString();
    }

    public class ADAPURLTagFragmentGenerator
    implements URLTagFragmentGenerator {
        int clickURL = 1;

        public String generateURLFragment(String urlText) {
            return urlText;
        }
    }

    public class ADAPToolTipTagFragmentGenerator
    implements ToolTipTagFragmentGenerator {
        public String generateToolTipFragment(String toolTipText) {
            return toolTipText;
        }
    }

    class ADAPToolTipGenerator
    implements CategoryToolTipGenerator,
    PieToolTipGenerator,
    XYToolTipGenerator,
    CategoryURLGenerator,
    PieURLGenerator,
    XYURLGenerator {
        private HashMap chartHash = null;

        public ADAPToolTipGenerator(HashMap chartHash) {
            this.chartHash = chartHash;
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            String toolTip = new DefaultToolTipGenerator().generateToolTip(dataset, row, column, this.chartHash);
            return " ALT=\"" + toolTip + "\" TITLE=\"" + toolTip + "\"";
        }

        public String generateToolTip(PieDataset pieDataSet, Comparable key) {
            String toolTip = new DefaultToolTipGenerator().generateToolTip(pieDataSet, key, 0, this.chartHash);
            return " ALT=\"" + toolTip + "\" TITLE=\"" + toolTip + "\"";
        }

        public String generateToolTip(XYDataset xyDataset, int series, int item) {
            String toolTip = new DefaultToolTipGenerator().generateToolTip(xyDataset, series, item, this.chartHash);
            return " ALT=\"" + toolTip + "\" TITLE=\"" + toolTip + "\"";
        }

        public String generateURL(CategoryDataset categoryDataset, int series, int category) {
            String url = new DefaultLinkGenerator(this.chartHash).generateLink((Object)categoryDataset, series, categoryDataset.getColumnKey(category));
            return " HREF=\"" + url + "\" ";
        }

        public String generateURL(PieDataset pieDataset, Comparable key, int pieIndex) {
            String url = new DefaultLinkGenerator(this.chartHash).generateLink(pieDataset, key);
            return " HREF=\"" + url + "\" ";
        }

        public String generateURL(XYDataset xyDataset, int series, int item) {
            String url = new DefaultLinkGenerator(this.chartHash).generateLink((Object)xyDataset, series, item);
            return " HREF=\"" + url + "\" ";
        }
    }
}

