/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.graphs.util;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ReportInterface;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilder;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilderAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.graphs.model.ChartModel;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;

public class ReportChartUtil
implements ReportInterface {
    private static ReportChartUtil reportUtil = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static QueryBuilder queryBuilder = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportChartUtil getInstance() {
        if (reportUtil != null) return reportUtil;
        Class<ReportChartUtil> clazz = ReportChartUtil.class;
        synchronized (ReportChartUtil.class) {
            if (reportUtil != null) return reportUtil;
            reportUtil = new ReportChartUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return reportUtil;
        }
    }

    public ReportChartUtil() {
        queryBuilder = QueryBuilderAPI.getInstance().getQueryBuilder();
    }

    public HashMap getReportGraphSQLString(Long cvID, HashMap inputParamsMap, String searchCriteria) {
        HashMap<String, Object> graphMap = new HashMap<String, Object>();
        String group_by = null;
        try {
            String dbServerName = CommonUtil.getDBServerName();
            if (searchCriteria == null) {
                searchCriteria = "1=1";
            }
            HashMap addionalSQLPropsMap = new HashMap();
            String constructedSQL = null;
            String countColumnString = null;
            DataObject cvDO = AUDCustomViewAPI.getInstance().getGraphDO(cvID);
            Criteria crit = new Criteria(Column.getColumn((String)"AUDGraphOptions", (String)"CV_ID"), (Object)cvID, 0);
            if (cvDO.size("AUDSQLQuery") > 0) {
                String sqlQueryStringColumnName = "COUNT_SQL_STRING";
                String groupByUsedColumnName = "GROUPBYUSED";
                String groupByColumnName = "GROUP_BY";
                String unionUsedColumnName = "UNION_USED";
                String xColumnName = "XCOLUMN";
                String yColumnName = "YCOLUMN";
                String graphOptionGroupBy = "GROUP_BY";
                String limitValueColumnName = "LIMIT_VALUE";
                String unionCountQueryColumnName = "UNION_COUNT_QUERY";
                Row row = cvDO.getRow("AUDSQLQuery");
                constructedSQL = (String)row.get(sqlQueryStringColumnName);
                Boolean group_by_used = (Boolean)row.get(groupByUsedColumnName);
                if (group_by_used.booleanValue()) {
                    group_by = (String)row.get(groupByColumnName);
                }
                if (cvDO.size("AUDGraphOptions") > 0) {
                    Boolean unionUsed;
                    String mColumn;
                    Row graphRow = cvDO.getRow("AUDGraphOptions", crit);
                    String chartType = (String)graphRow.get("GRAPH_TYPE");
                    String groupByString = queryBuilder.replaceFunctionPattern(graphRow.get(graphOptionGroupBy).toString());
                    String xColumnString = queryBuilder.replaceFunctionPattern(graphRow.get(xColumnName).toString());
                    String yColumnString = graphRow.get(yColumnName).toString();
                    String string = mColumn = graphRow.get("MCOLUMN") != null ? (String)graphRow.get("MCOLUMN") : null;
                    if (mColumn != null) {
                        graphMap.put("mColumn", mColumn);
                    }
                    String limitValue = (String)graphRow.get(limitValueColumnName);
                    countColumnString = String.valueOf(xColumnString) + "," + yColumnString;
                    String columnString = ", " + groupByString;
                    if (!dbServerName.equalsIgnoreCase("mysql")) {
                        String asName = groupByString.replace("'", "''");
                        columnString = "," + groupByString;
                        if (groupByString.contains("DATEPART") || groupByString.contains("DATENAME")) {
                            columnString = "," + groupByString + " as " + "'" + asName + "'";
                        }
                        if (!groupByString.equalsIgnoreCase(xColumnString) && groupByString.indexOf("TO_CHAR") == -1) {
                            String xColumnNameAsName = String.valueOf(xColumnString) + " as  " + "'" + xColumnString.replace("'", "''") + "'";
                            columnString = String.valueOf(',') + xColumnNameAsName + columnString;
                        } else if (groupByString.equalsIgnoreCase(xColumnString) && groupByString.indexOf("TO_CHAR") != -1) {
                            columnString = String.valueOf(columnString) + ", TIME_GENERATED";
                            if (mColumn != null) {
                                xColumnString = groupByString = String.valueOf(groupByString) + "," + mColumn;
                                columnString = String.valueOf(columnString) + (mColumn.equalsIgnoreCase("TIME_GENERATED") ? "" : "," + mColumn);
                            }
                            constructedSQL = constructedSQL.replace("${COLUMNS}", " , " + xColumnString);
                            constructedSQL = constructedSQL.replace("${GROUP_BY}", "GROUP BY " + groupByString);
                            groupByString = String.valueOf(groupByString) + " , TIME_GENERATED";
                        }
                        if ((chartType.equalsIgnoreCase("timeseries") || chartType.equalsIgnoreCase("line")) && dbServerName.equalsIgnoreCase("mssql")) {
                            if (mColumn != null) {
                                groupByString = String.valueOf(groupByString) + "," + mColumn;
                                columnString = String.valueOf(columnString) + "," + mColumn;
                            }
                            constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                            constructedSQL = constructedSQL.replace("${GROUP_BY}", "GROUP BY " + groupByString);
                            columnString = String.valueOf(columnString) + ",TIME_GENERATED";
                            groupByString = String.valueOf(groupByString) + ",TIME_GENERATED";
                        }
                    } else {
                        if (!groupByString.equalsIgnoreCase(xColumnString)) {
                            columnString = " , " + xColumnString + columnString;
                        }
                        if ((chartType.equalsIgnoreCase("timeseries") || chartType.equalsIgnoreCase("line")) & mColumn != null) {
                            groupByString = String.valueOf(groupByString) + "," + mColumn;
                            columnString = String.valueOf(columnString) + "," + mColumn;
                            constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                            constructedSQL = constructedSQL.replace("${GROUP_BY}", "GROUP BY " + groupByString);
                            columnString = String.valueOf(columnString) + ",TIME_GENERATED";
                            groupByString = String.valueOf(groupByString) + ",TIME_GENERATED";
                        }
                    }
                    if ((unionUsed = (Boolean)row.get(unionUsedColumnName)).booleanValue()) {
                        ArrayList unionQueryList = ADAPSQLQueryUtil.getUnionQueries((Long)((Long)row.get("QUERY_ID")), (String)unionCountQueryColumnName);
                        String queryString = "";
                        for (Object object : unionQueryList) {
                            if (unionQueryList.indexOf(object) > 0) {
                                queryString = String.valueOf(queryString) + "UNION ALL ";
                            }
                            queryString = String.valueOf(queryString) + " ";
                            queryString = String.valueOf(queryString) + ADAPSQLQueryAPI.getInstance().getSQLString((String)object, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, groupByString);
                            queryString = String.valueOf(queryString) + " ";
                        }
                        constructedSQL = constructedSQL.replace("${UNION_QUERY}", queryString);
                        constructedSQL = constructedSQL.replace("${UNION_COUNT_QUERY}", queryString);
                        constructedSQL = constructedSQL.replace("${COLUMNS}", columnString);
                        if (limitValue != null) {
                            constructedSQL = QueryBuilderAPI.getInstance().getQueryBuilder().replaceGraphRangeValues(constructedSQL, limitValue);
                        } else {
                            constructedSQL = constructedSQL.replace("${GRAPHTOPVAL}", "");
                            constructedSQL = constructedSQL.replace("${LIMIT}", "");
                        }
                        constructedSQL = constructedSQL.replace("${GROUP_BY}", "GROUP BY " + groupByString);
                        String sortOrder = (String)graphRow.get("SORT_ORDER");
                        if (sortOrder != null) {
                            constructedSQL = constructedSQL.replace("${ORDER_BY}", "ORDER BY adapcount DESC");
                        }
                        constructedSQL = constructedSQL.replace("${ORDER_BY}", "ORDER BY 2");
                    } else {
                        constructedSQL = ADAPSQLQueryAPI.getInstance().getSQLString(constructedSQL, columnString, searchCriteria, inputParamsMap, addionalSQLPropsMap, group_by);
                    }
                    String xlabel = "";
                    String ylabel = "";
                    if (graphRow.get("XLABEL") != null) {
                        xlabel = rb.getString((String)graphRow.get("XLABEL"));
                    }
                    if (graphRow.get("YLABEL") != null) {
                        ylabel = rb.getString((String)graphRow.get("YLABEL"));
                    }
                    String ms_hour = "DATEPART(HH,DATEADD(ss,TIME_GENERATED+(DATEDIFF(ss,GETUTCDATE(),GETDATE())),'19700101'))";
                    String xLabelValue = graphRow.get("XLABEL").toString();
                    if (xLabelValue.trim().endsWith("HOUR") && !constructedSQL.contains("ORDER BY")) {
                        if (dbServerName.equals("pgsql")) {
                            constructedSQL = String.valueOf(constructedSQL) + " ORDER BY TO_CHAR";
                        } else if (dbServerName.equals("mssql")) {
                            constructedSQL = String.valueOf(constructedSQL) + " ORDER BY " + ms_hour;
                        }
                    } else if (xLabelValue.trim().endsWith("DAY") && !constructedSQL.contains("ORDER BY")) {
                        constructedSQL = constructedSQL.contains("MIN_TIME") ? String.valueOf(constructedSQL) + ",MIN_TIME   ORDER BY MIN_TIME" : String.valueOf(constructedSQL) + " ORDER BY MIN(TIME_GENERATED)";
                    }
                    constructedSQL = ADAPSQLQueryAPI.getInstance().getConstructedSQL(constructedSQL);
                    constructedSQL = ADAPSQLQueryAPI.getInstance().objectReplaceString(constructedSQL);
                    System.out.println("Graph SQL String ::: " + constructedSQL);
                    graphMap.put("sqlString", constructedSQL);
                    graphMap.put("viewname", graphRow.get("GRAPH_NAME"));
                    graphMap.put("charttype", chartType);
                    graphMap.put("xlabel", xlabel);
                    graphMap.put("ylabel", ylabel);
                    graphMap.put("graphTitle", rb.getString((String)graphRow.get("GRAPH_TITLE")));
                    graphMap.put("graphOptID", graphRow.get("GRAPH_OPT_ID"));
                    graphMap.put("limitValue", limitValue);
                    if (xColumnString.indexOf("TO_CHAR") == -1) {
                        graphMap.put("xcolumn", queryBuilder.replaceFunctionPattern(graphRow.get(xColumnName).toString()));
                    } else {
                        graphMap.put("xcolumn", "to_char");
                    }
                    graphMap.put("ycolumn", yColumnString);
                    graphMap.put("cvID", cvID);
                    graphMap.put("actionname", "reportView");
                    if (chartType.equalsIgnoreCase("stackedhorizontalbar") || chartType.equalsIgnoreCase("stackedverticalbar") || chartType.equalsIgnoreCase("stackedhorizontalbar3d") || chartType.equalsIgnoreCase("stackedverticalbar3d")) {
                        graphMap.put("actionname", "stackedBarChartReport");
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return graphMap;
    }

    public ChartModel getReportGraphChartModel(HashMap graphMap) {
        ChartModel chartModel = new ChartModel(graphMap);
        Connection connection = null;
        DataSet dataSet = null;
        try {
            try {
                String sqlString = (String)graphMap.remove("sqlString");
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                dataSet = relAPI.executeQuery(sqlString, connection);
                chartModel.updateModel(null, dataSet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return chartModel;
    }
}

