/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.tracker;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ADAPUrlClicksHandler {
    private static ADAPUrlClicksHandler handler = null;
    private DataObject dataObj = null;
    private int noOfClicksReport = 0;
    private static HashMap<Long, String> uvhMaps = null;

    private ADAPUrlClicksHandler() {
        try {
            this.getURLs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ADAPUrlClicksHandler getInstance() {
        if (handler != null) return handler;
        Class<ADAPUrlClicksHandler> clazz = ADAPUrlClicksHandler.class;
        synchronized (ADAPUrlClicksHandler.class) {
            handler = new ADAPUrlClicksHandler();
            uvhMaps = new HashMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public void updateEmberClientClicks(HttpServletRequest request, Long meTrackerFeatureId) {
        try {
            if (meTrackerFeatureId == 1L) {
                JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
                HashMap returnListMap = new HashMap();
                this.updateEmberClientReportClicks(reportReqData.getJSONObject("reportInputParams").getLong("reportId"));
            } else if (meTrackerFeatureId == 289L) {
                JSONObject reportReqData = new JSONObject(request.getParameter("JSONString"));
                JSONObject serverInputParams = reportReqData.getJSONObject("inputParams");
                Long machineType = serverInputParams.getLong("machineType");
                if (machineType == 4L) {
                    this.updateEmberClientOtherClicks(289L);
                } else if (machineType == 256L) {
                    this.updateEmberClientOtherClicks(291L);
                } else if (machineType == 131072L) {
                    this.updateEmberClientOtherClicks(292L);
                }
            } else {
                this.updateEmberClientOtherClicks(meTrackerFeatureId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateEmberClientReportClicks(Long reportId) {
        try {
            Iterator rows = this.dataObj.getRows("ADAPReportURLClicks");
            Row matchRow = null;
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                String s = (String)r.get("URL_STRING");
                String tableName = (String)r.get("TABLE_NAME");
                if (!s.startsWith("AuditReports.do?selectedTab=reports&methodToCall=report&init=true&reportId=")) continue;
                String tableUVH = (String)r.get("UVH_VALUE");
                String value = this.getUVHValue(reportId);
                if (tableUVH == null || !tableUVH.equals(value)) continue;
                matchRow = r;
            }
            this.updateNoOfClicks(matchRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateEmberClientOtherClicks(Long featureId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADAPReportURLClicks", (String)"FEATURE_ID"), (Object)featureId, 0);
            Row r = this.dataObj.getRow("ADAPReportURLClicks", crit);
            if (r != null) {
                this.updateNoOfClicks(r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateClicks(HttpServletRequest servletrequest) {
        String url = servletrequest.getRequestURI() + "?" + servletrequest.getQueryString();
        if ((url = url.substring(1)).contains("AuditReports.do?")) {
            this.updateReportClicks(url, servletrequest);
        } else {
            this.updateOtherClicks(url, servletrequest);
        }
    }

    private void updateReportClicks(String url, HttpServletRequest servletrequest) {
        try {
            HttpSession session = servletrequest.getSession();
            Iterator rows = this.dataObj.getRows("ADAPReportURLClicks");
            int minRemainCount = -1;
            Row matchRow = null;
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                String s = (String)r.get("URL_STRING");
                String tableName = (String)r.get("TABLE_NAME");
                if (!url.startsWith(s)) continue;
                String parameterName = (String)r.get("PARAMETER_NAME");
                String uvhId = (String)r.get("UVH_VALUE");
                Long paramValue = parameterName != null ? Long.valueOf(servletrequest.getParameter(parameterName) != null ? Long.parseLong(servletrequest.getParameter(parameterName)) : (Long)session.getAttribute("AUDIT_REPORT_ID")) : null;
                String value = this.getUVHValue(paramValue);
                if (uvhId != null && !uvhId.equals(value) || (uvhId == null || !uvhId.equals(value)) && (uvhId != null || value != null)) continue;
                int remainCount = url.compareTo(s);
                if (minRemainCount != -1 && remainCount > minRemainCount) continue;
                minRemainCount = remainCount;
                matchRow = r;
            }
            this.updateNoOfClicks(matchRow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateOtherClicks(String url, HttpServletRequest servletrequest) {
        try {
            Iterator rows = this.dataObj.getRows("ADAPReportURLClicks");
            int minRemainCount = -1;
            Row matchRow = null;
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                String s = (String)r.get("URL_STRING");
                if (!url.startsWith(s)) continue;
                int remainCount = url.compareTo(s);
                if (minRemainCount != -1 && remainCount > minRemainCount) continue;
                minRemainCount = remainCount;
                matchRow = r;
            }
            this.updateNoOfClicks(matchRow);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateNoOfClicks(Row matchRow) throws Exception {
        if (matchRow != null) {
            Long val = (Long)matchRow.get("NO_OF_CLICKS");
            matchRow.set("NO_OF_CLICKS", (Object)new Long(val + 1L));
            this.dataObj.updateRow(matchRow);
            ++this.noOfClicksReport;
        }
        if (this.noOfClicksReport == 10) {
            this.update();
            this.noOfClicksReport = 0;
        }
    }

    public String getUVHValue(Long reportId) {
        if (reportId == null) {
            return null;
        }
        if (uvhMaps.get(reportId) == null) {
            this.setUVHValuesMap();
        }
        return uvhMaps.get(reportId);
    }

    public void setUVHValuesMap() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"UVHValues", (String)"TABLE_NAME"), (Object)"AUDReports", 0);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("UVHValues", crit);
            Iterator iterator = dObj.getRows("UVHValues");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                uvhMaps.put((Long)row.get("GENVALUES"), (String)row.get("PATTERN"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        try {
            Iterator rows = this.dataObj.getRows("ADAPReportUrlClicks");
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                r.set("NO_OF_CLICKS", (Object)new Long(0L));
                this.dataObj.updateRow(r);
            }
            this.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        try {
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateAudit() {
        try {
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(this.dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getURLs() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ADAPReportURLClicks"));
            Criteria criter = new Criteria(new Column("ADAPReportURLClicks", "URL_STRING"), (Object)"", 1);
            query.setCriteria(criter);
            query.addSortColumn(new SortColumn("ADAPReportURLClicks", "FEATURE_ID", true));
            query.addSelectColumn(new Column("ADAPReportURLClicks", "*"));
            this.dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

