/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.InheritedHostHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.WorkGroupHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.tools.prevalent.CMDClass;
import com.adventnet.tools.prevalent.LUtil;
import com.adventnet.tools.prevalent.Validation;
import com.adventnet.tools.prevalent.Wield;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.license.LicenseXMLParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;

public class LicenseUpgradeAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger("ReportLogger");

    public ActionForward loadDetails(ActionMapping mapping, ActionForm fout, HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String licenseType = Validation.getInstance().getUserType();
        HttpSession session = request.getSession();
        try {
            Properties domainController;
            Validation w = Validation.getInstance();
            String productName = w.getProductName();
            String productExpiryDate = w.getEvaluationExpiryDate();
            String licenseType1 = LicenseUtil.getLicenseTypeString();
            licenseType = w.getUserType();
            long noOfDays = w.getEvaluationDays();
            String productVersion = CommonUtil.getProductVersion();
            String licenseMsg = "";
            String upgradeMsg = "";
            String noOfDaysToGo = String.valueOf(noOfDays);
            String licensedTo = w.getCompanyName();
            boolean flag = true;
            boolean sent = true;
            boolean adminUser = true;
            String currentUser = request.getUserPrincipal().getName();
            if (adminUser) {
                request.setAttribute("adminUser", (Object)Boolean.TRUE);
            }
            if (licenseType != null && licenseType.equals("T")) {
                licenseType = rb.getString("adap.LicenseUpgradeAction.Evaluation_Edition__Trial_Version");
                licenseMsg = rb.handleGetObject("adap.LicenseUpgradeAction.You_are_using_", new String[]{licenseType});
                upgradeMsg = rb.getString("adap.LicenseUpgradeAction.Extend_your_trial_period_or");
                request.setAttribute("noOfDaysToGo", (Object)noOfDaysToGo);
                domainController = Validation.getInstance().getModuleProperties("DomainController");
                String numberOfDomainController = domainController.getProperty("NumberOfDomainControllers");
                request.setAttribute("numberOfDomainControllers", (Object)numberOfDomainController);
                Properties memberServer = Validation.getInstance().getModuleProperties("MemberServer");
                String numberOfMemberServer = MSHandler.getLicenseCount((Integer)16).toString();
                if (memberServer != null) {
                    numberOfMemberServer = memberServer.getProperty("NumberOfMemberServers");
                }
                request.setAttribute("numberOfMemberServers", (Object)numberOfMemberServer);
                Properties fileServer = Validation.getInstance().getModuleProperties("FileServer");
                String numberOfFileServer = MSHandler.getLicenseCount((Integer)4).toString();
                if (fileServer != null) {
                    numberOfFileServer = fileServer.getProperty("NumberOfFileServers");
                }
                request.setAttribute("numberOfFileServers", (Object)numberOfFileServer);
                Properties cifsServer = Validation.getInstance().getModuleProperties("CIFSServer");
                String numberOfcifsServer = MSHandler.getLicenseCount((Integer)256).toString();
                if (cifsServer != null) {
                    numberOfcifsServer = cifsServer.getProperty("NumberOfCIFSServers");
                }
                request.setAttribute("numberOfCIFSServers", (Object)numberOfcifsServer);
                Properties workStation = Validation.getInstance().getModuleProperties("WorkStation");
                String numberOfWorkStations = MSHandler.getLicenseCount((Integer)new Integer(4096)).toString();
                if (workStation != null) {
                    numberOfWorkStations = workStation.getProperty("NumberOfWorkStations");
                }
                logger.log(Level.INFO, "number of workstations " + numberOfWorkStations);
                request.setAttribute("numberOfWorkStations", (Object)numberOfWorkStations);
            } else if (licenseType != null && licenseType.equals("F")) {
                licenseType = rb.getString("adap.LicenseUpgradeAction.Free_Edition");
                noOfDaysToGo = rb.getString("adap.LicenseUpgradeAction.Never");
                licenseMsg = rb.handleGetObject("adap.LicenseUpgradeAction.You_are_using__licenseType", new String[]{licenseType, noOfDaysToGo});
                upgradeMsg = rb.getString("adap.LicenseUpgradeAction._Upgrade_to_Professional_Edition");
                domainController = Validation.getInstance().getModuleProperties("DomainController");
                String numberOfDomainController = domainController.getProperty("NumberOfDomainControllers");
                request.setAttribute("numberOfDomainControllers", (Object)numberOfDomainController);
                Properties memberServer = Validation.getInstance().getModuleProperties("MemberServer");
                String numberOfMemberServer = "0";
                if (memberServer != null) {
                    numberOfMemberServer = memberServer.getProperty("NumberOfMemberServers");
                }
                request.setAttribute("numberOfMemberServers", (Object)numberOfMemberServer);
                Properties fileServer = Validation.getInstance().getModuleProperties("FileServer");
                String numberOfFileServer = "0";
                if (fileServer != null) {
                    numberOfFileServer = fileServer.getProperty("NumberOfFileServers");
                }
                request.setAttribute("numberOfFileServers", (Object)numberOfFileServer);
                Properties cifsServer = Validation.getInstance().getModuleProperties("CIFSServer");
                String numberOfcifsServer = "0";
                if (cifsServer != null) {
                    numberOfcifsServer = cifsServer.getProperty("NumberOfCIFSServers");
                }
                request.setAttribute("numberOfCIFSServers", (Object)numberOfcifsServer);
                Properties workStation = Validation.getInstance().getModuleProperties("WorkStation");
                String numberOfWorkStations = "0";
                if (workStation != null) {
                    numberOfWorkStations = workStation.getProperty("NumberOfWorkStations");
                }
                request.setAttribute("numberOfWorkStations", (Object)numberOfWorkStations);
                logger.log(Level.INFO, "number of workstations " + numberOfWorkStations);
            } else if (licenseType != null && licenseType.equals("R")) {
                licenseType = rb.handleGetObject("adap.LicenseUpgradeAction.licenseType1___Registered_Version", new String[]{licenseType1});
                licenseMsg = rb.handleGetObject("adap.LicenseUpgradeAction.You_are_using__licenseType", new String[]{licenseType, productExpiryDate});
                domainController = Validation.getInstance().getModuleProperties("DomainController");
                String numberOfDomainController = domainController.getProperty("NumberOfDomainControllers");
                Properties memberServer = Validation.getInstance().getModuleProperties("MemberServer");
                String numberOfMemberServer = MSHandler.getLicenseCount((Integer)16).toString();
                if (memberServer != null) {
                    numberOfMemberServer = memberServer.getProperty("NumberOfMemberServers");
                }
                request.setAttribute("numberOfMemberServers", (Object)numberOfMemberServer);
                int numberOfInheritedMemberServers = MSHandler.getInheritedHostcount();
                if (numberOfInheritedMemberServers != 0) {
                    request.setAttribute("numberOfInheritedMemberServers", (Object)numberOfMemberServer);
                }
                Properties fileServer = Validation.getInstance().getModuleProperties("FileServer");
                String numberOfFileServer = MSHandler.getLicenseCount((Integer)4).toString();
                if (fileServer != null) {
                    numberOfFileServer = fileServer.getProperty("NumberOfFileServers");
                }
                request.setAttribute("numberOfFileServers", (Object)numberOfFileServer);
                Properties cifsServer = Validation.getInstance().getModuleProperties("CIFSServer");
                String numberOfcifsServer = MSHandler.getLicenseCount((Integer)256).toString();
                if (cifsServer != null && numberOfcifsServer.equals("0")) {
                    numberOfcifsServer = cifsServer.getProperty("NumberOfCIFSServers");
                }
                request.setAttribute("numberOfCIFSServers", (Object)numberOfcifsServer);
                Properties workStation = Validation.getInstance().getModuleProperties("WorkStation");
                String numberOfWorkStations = MSHandler.getLicenseCount((Integer)new Integer(4096)).toString();
                if (workStation != null) {
                    numberOfWorkStations = workStation.getProperty("NumberOfWorkStations");
                }
                request.setAttribute("numberOfWorkStations", (Object)numberOfWorkStations);
                logger.log(Level.INFO, "number of workstations " + numberOfWorkStations);
                Calendar cal = Calendar.getInstance();
                StringTokenizer stt = new StringTokenizer(productExpiryDate, " ");
                if (stt.countTokens() == 3) {
                    int yyyy = Integer.parseInt(stt.nextToken());
                    int mm = Integer.parseInt(stt.nextToken());
                    int dd = Integer.parseInt(stt.nextToken());
                    cal.set(yyyy, mm, dd);
                    SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy");
                    productExpiryDate = sdf.format(cal.getTime());
                }
                request.setAttribute("productExpiryDate", (Object)productExpiryDate);
                request.setAttribute("licensedTo", (Object)licensedTo);
                request.setAttribute("numberOfDomainControllers", (Object)numberOfDomainController);
            }
            String isDemoMode = String.valueOf(CommonUtil.isDemo());
            request.setAttribute("isDemoMode", (Object)isDemoMode);
            if (isDemoMode.equals("true")) {
                request.setAttribute("demoModeMessage", (Object)"Running in restricted Mode");
            }
            request.setAttribute("licenseType", (Object)licenseType);
            request.setAttribute("licenseMsg", (Object)licenseMsg);
            request.setAttribute("upgradeMsg", (Object)upgradeMsg);
            request.setAttribute("productName", (Object)productName);
            request.setAttribute("productVersion", (Object)productVersion);
            request.setAttribute("buildNumber", (Object)CommonUtil.getBuildNumber());
            TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", rb.handleGetObject("adap.LicenseUpgradeAction.audit_entry.ADAP_License_Viewed"), 4, 8, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.WARNING, "Exception while loading upgrade license page ", ex);
        }
        return mapping.findForward("licensePage");
    }

    public ActionForward upgrade(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        boolean upgradestatus = false;
        String upgradestatusmsg = null;
        String licensePath = null;
        try {
            String fileName = null;
            DynaActionForm dynForm = (DynaActionForm)form;
            FormFile formFile = (FormFile)dynForm.get("browse");
            fileName = formFile.getFileName();
            if (fileName != null) {
                try {
                    LicenseUtil.resetLicenseType();
                    licensePath = this.storeFile(fileName, formFile);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Exception while storing the license file ", ex);
                }
            } else {
                upgradestatusmsg = "adap.LicenseUpgradeAction.License_is_not_Applied_properly";
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
            }
            if (licensePath != null) {
                upgradestatus = LicenseUpgradeAction.upgradeLicense(request, licensePath);
                if (upgradestatus || (upgradestatus = LicenseUpgradeAction.upgradeAD360License(request, licensePath))) {
                    upgradestatusmsg = "adap.LicenseUpgradeAction.License_upgraded_Successfully";
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 8, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                } else {
                    upgradestatusmsg = "adap.LicenseUpgradeAction.Please_Enter_a_valid_License";
                    TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                    File tmpFile = new File(licensePath);
                    tmpFile.delete();
                }
            }
            LicenseUtil.resetValues();
            CommonUtil.updateSytemTime();
        }
        catch (Exception ex) {
            upgradestatusmsg = "adap.LicenseUpgradeAction.License_is_not_Applied_properly";
            try {
                TDHandler.addAuditEntries((HashMap)ReportUtil.formMap((String[])TDConstants.AUDIT_COLUMNS, (Object[])new Object[]{request.getSession().getAttribute("CREDENTIAL"), 1, "License", upgradestatusmsg, 8, 16, "adap.ADAPUserAuditSeverities.audit_name.login_success", "-"}));
                if (!licensePath.equals("")) {
                    File tmpFile = new File(licensePath);
                    tmpFile.delete();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            logger.log(Level.WARNING, "Exception while upgrading the license file ", ex);
        }
        request.setAttribute("upgradestatus", (Object)upgradestatus);
        request.setAttribute("upgradestatusmsg", (Object)rb.getString(upgradestatusmsg));
        return this.loadDetails(mapping, form, request, response);
    }

    public static boolean upgradeLicense(HttpServletRequest request, String licensePath) {
        boolean upgradestatus = false;
        String productHomeDir = System.getProperty("server.dir");
        String upgradestatusmsg = "";
        try {
            String existing_license_dir = productHomeDir + File.separator;
            LUtil.setLicenseDir((String)"lib");
            CMDClass cmd = new CMDClass();
            boolean success = false;
            Wield w = Wield.getInstance();
            Validation valid = Validation.getInstance();
            String user = (String)cmd.getUserList(licensePath).elementAt(0);
            success = w.doValidation(existing_license_dir, user, licensePath, false, true);
            if (success) {
                valid.copyLicenseFile(existing_license_dir, licensePath);
                w.reloadXmlFile();
                w.validateInvoke("AdventNet ManageEngine ADAudit Plus");
                LicenseUtil.resetValues();
                String noOfDcs = LicenseUtil.getLicenseProperty((String)"DomainController", (String)"NumberOfDomainControllers");
                LicenseUpgradeAction.enableDisableSchedulers(noOfDcs);
                Integer noOfServers = MSHandler.getLicenseCount((Integer)16);
                LicenseUtil.disableEnableMemberServers((Integer)16, (Integer)noOfServers, (Boolean)false);
                WorkGroupHandler.enableDisableWorkgroup();
                noOfServers = MSHandler.getLicenseCount((Integer)4);
                LicenseUtil.disableEnableMemberServers((Integer)4, (Integer)noOfServers, (Boolean)false);
                LicenseUtil.disableEnableMemberServers((Integer)64, (Integer)noOfServers, (Boolean)false);
                noOfServers = MSHandler.getLicenseCount((Integer)256);
                LicenseUtil.disableEnableMemberServers((Integer)256, (Integer)noOfServers, (Boolean)false);
                LicenseUtil.disableEnableMemberServers((Integer)524288, (Integer)noOfServers, (Boolean)false);
                LicenseUtil.disableEnableMemberServers((Integer)131072, (Integer)noOfServers, (Boolean)false);
                noOfServers = MSHandler.getLicenseCount((Integer)4096);
                LicenseUtil.disableEnableMemberServers((Integer)4096, (Integer)noOfServers, (Boolean)false);
                System.setProperty("licenseType", Validation.getInstance().getUserType());
                request.getSession().setAttribute("licenseType", (Object)Validation.getInstance().getUserType());
                upgradestatus = true;
                if (InheritedHostHandler.publishLicenseStatus()) {
                    MSHandler.synchronizeNow((String)"to Sync Host Details After License upgrade", (boolean)false);
                }
            } else {
                w.validateInvoke("AdventNet ManageEngine ADAudit Plus");
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception while applying the license file ", ex);
        }
        return upgradestatus;
    }

    private String storeFile(String fileName, FormFile formFile) throws Exception {
        FileOutputStream fout = null;
        File saveFile = null;
        try {
            InputStream fileInput = formFile.getInputStream();
            byte[] file = new byte[fileInput.available()];
            fileInput.read(file);
            String currentPath = System.getProperty("user.dir");
            String directory = currentPath + File.separator + "license";
            File saveDir = new File(directory);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File(directory + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write(file);
            fout.close();
            logger.log(Level.INFO, "The License File stored successfully...");
            return saveFile.getAbsolutePath();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Exception while storing the licence file under license directory ", ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while storing the licence file under license directory ", ex);
            throw ex;
        }
    }

    private static void enableDisableSchedulers(String noOfDCs) {
        try {
            ArrayList enabledSchedulers = EventSchedulerUtil.getEventSchedulers((int)3);
            int count = enabledSchedulers.size();
            logger.log(Level.INFO, "License : Enabled Schedulers Count : " + count);
            Integer dcs = Integer.parseInt(noOfDCs);
            logger.log(Level.INFO, "License : Count from License : " + dcs);
            int excessCount = count - dcs;
            if (excessCount > 0) {
                for (int i = 0; i < excessCount; ++i) {
                    Long scheduleId = (Long)enabledSchedulers.get(count - i - 1);
                    logger.log(Level.INFO, "Disabling Scheduler : " + scheduleId);
                    EventSchedulerUtil.enableDisableScheduler((Long)scheduleId, (String)"Disable");
                }
            } else if (excessCount < 0) {
                ArrayList disabledSchedulers = EventSchedulerUtil.getEventSchedulers((int)4);
                int lessCount = dcs - count;
                for (int i = 0; i < lessCount && i < disabledSchedulers.size(); ++i) {
                    Long scheduleId = (Long)disabledSchedulers.get(i);
                    logger.log(Level.INFO, "Enabling Scheduler : " + scheduleId);
                    EventSchedulerUtil.enableDisableScheduler((Long)scheduleId, (String)"Enable");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean upgradeAD360License(HttpServletRequest request, String licensePath) {
        boolean upgradeStatus = false;
        try {
            LicenseXMLParser xmlParser = new LicenseXMLParser(licensePath);
            if (xmlParser.isComponentPresent("ManageEngine ADAudit Plus")) {
                logger.log(Level.INFO, "AD360 License : ADAP License is available! Going to upgrade ADAP");
                String adapLicense = xmlParser.getComponentLicense("ManageEngine ADAudit Plus");
                LicenseManager licenseManager = new LicenseManager("ManageEngine ADAudit Plus", adapLicense);
                upgradeStatus = LicenseUpgradeAction.upgradeLicense(request, licenseManager.getLicenseFileLocation());
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while applying AD360 license : " + e.getMessage());
        }
        return upgradeStatus;
    }
}

