/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.adviewer.webclient;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.adviewer.server.util.ADViewerUtil;
import com.adventnet.sym.adsm.adviewer.webclient.util.ADClientUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.security.server.TemplateHandler;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.validator.DynaValidatorForm;

public class ObjectPropertiesAction
extends Action {
    protected String sessionID1 = "0";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "object";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            String domainName = request.getParameter("domainName");
            if (domainName == null) {
                Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
            }
            String[] days = new String[]{"sunday", "monday", "Tuesday", "wednesday", "thursday", "friday", "saturday"};
            String[] time = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"};
            try {
                String selectedObjectTab = request.getParameter("selectedObjectTab");
                String guid = request.getParameter("guid");
                String objectClass = request.getParameter("objectClass");
                String nodeClicked = request.getParameter("nodeClicked");
                String objectName = request.getParameter("objectName");
                String sid = request.getParameter("sid");
                if (selectedObjectTab.equalsIgnoreCase("sidProperties")) {
                    DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("ReportBean");
                    String[] domainList = (String[])bean.get("domains");
                    Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                    if (domainList[0] != null) {
                        domainName = (String)dnDomainNameMap.get(domainList[0]);
                    }
                    sid = sid.substring(sid.indexOf("{") + 1, sid.indexOf("}"));
                    Properties prop = ADHandler.getObjectPropertiesFromSid((String)domainName, (Long)loginId, (String)sid);
                    ArrayList classList = (ArrayList)prop.get("objectClass");
                    ArrayList guidList = (ArrayList)prop.get("objectGUID");
                    ArrayList nameList = (ArrayList)prop.get("name");
                    guid = (String)guidList.get(0);
                    objectName = (String)nameList.get(0);
                    objectClass = (String)classList.get(classList.size() - 1);
                    selectedObjectTab = "properties";
                }
                String objClass = objectClass.equalsIgnoreCase("container") ? "organizationalUnit" : objectClass;
                Row r = DirectoryObjectAPI.getInstance().getObject(guid, objClass);
                if (r != null) {
                    nodeClicked = (String)r.get("DISTINGUISHED_NAME");
                    String columnName = DirectoryObjectAPI.getInstance().getColumnName(objClass, "name");
                    if (columnName != null && r.get(columnName) != null) {
                        objectName = (String)r.get(columnName);
                    }
                    if (objectName == null) {
                        columnName = DirectoryObjectAPI.getInstance().getColumnName(objClass, "cn");
                        objectName = (String)r.get(columnName);
                    }
                }
                if (guid != null && !guid.equalsIgnoreCase("") && objectClass != null) {
                    String dateModified;
                    String dateCreated;
                    Properties p1;
                    Properties p;
                    String guidStr = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
                    if (selectedObjectTab.equalsIgnoreCase("properties")) {
                        System.out.println("The objectclass : " + objectClass + " - for the domain : " + domainName);
                        p = this.getObjectPropertiesFromAD(domainName, loginId, objectClass, guidStr);
                        if (objectClass.equalsIgnoreCase("computer")) {
                            p1 = (Properties)p.get("General");
                            ArrayList bitlokcerInfo = ObjectPropertiesAction.getBitlockerInfo((String)p1.get("name"), domainName);
                            p.put("bitlockerDetails", bitlokcerInfo);
                            if (bitlokcerInfo.size() == 0) {
                                p.put("status", ObjectPropertiesAction.checkStatus((String)p1.get("name"), domainName, rb));
                            }
                        }
                        if ((p1 = (Properties)p.remove("Object")) != null) {
                            String groupScope;
                            Properties genProp;
                            dateCreated = (String)p1.remove("whenCreated");
                            if (dateCreated != null) {
                                p1.setProperty("whenCreated", DateTimeUtil.getDateFromFileTime((Long)new Long(dateCreated), (Long)loginId));
                                p.put("Object", p1);
                            }
                            if ((dateModified = (String)p1.remove("whenChanged")) != null) {
                                p1.setProperty("whenChanged", DateTimeUtil.getDateFromFileTime((Long)new Long(dateModified), (Long)loginId));
                                p.put("Object", p1);
                            }
                            if (objectClass.equalsIgnoreCase("group") && (genProp = (Properties)p.remove("General")) != null && (groupScope = (String)genProp.remove("groupType")) != null) {
                                genProp.setProperty("groupScope", rb.getString(this.getGroupScope(groupScope)));
                                p.put("General", genProp);
                            }
                            request.setAttribute("objectProp", (Object)p);
                            if (objectClass.equalsIgnoreCase("user") || objectClass.equalsIgnoreCase("computer") || objectClass.equalsIgnoreCase("group") || objectClass.equalsIgnoreCase("organizationalUnit") || objectClass.equalsIgnoreCase("contact") || objectClass.equalsIgnoreCase("volume") || objectClass.equalsIgnoreCase("printQueue") || objectClass.equalsIgnoreCase("domainDNS")) {
                                forwardPage = objectClass;
                            }
                            if (request.getParameter("reportProperties") != null && !objectClass.equalsIgnoreCase("msExchDynamicDistributionList") && !objectClass.equalsIgnoreCase("container")) {
                                forwardPage = objectClass + "Properties";
                            }
                            request.setAttribute("days", (Object)days);
                            request.setAttribute("time", (Object)time);
                            request.setAttribute("object", (Object)objectClass);
                        }
                    } else if (selectedObjectTab.equalsIgnoreCase("sidProperties")) {
                        p = this.getObjectPropertiesFromAD(domainName, loginId, objectClass, guidStr);
                        p1 = (Properties)p.remove("Object");
                        if (p1 != null) {
                            dateCreated = (String)p1.remove("whenCreated");
                            if (dateCreated != null) {
                                p1.setProperty("whenCreated", DateTimeUtil.getDateFromFileTime((Long)new Long(dateCreated), (Long)loginId));
                                p.put("Object", p1);
                            }
                            if ((dateModified = (String)p1.remove("whenChanged")) != null) {
                                p1.setProperty("whenChanged", DateTimeUtil.getDateFromFileTime((Long)new Long(dateModified), (Long)loginId));
                                p.put("Object", p1);
                            }
                            request.setAttribute("objectProp", (Object)p);
                            if (objectClass.equalsIgnoreCase("user") || objectClass.equalsIgnoreCase("computer") || objectClass.equalsIgnoreCase("group") || objectClass.equalsIgnoreCase("organizationalUnit") || objectClass.equalsIgnoreCase("contact") || objectClass.equalsIgnoreCase("volume") || objectClass.equalsIgnoreCase("printQueue") || objectClass.equalsIgnoreCase("domainDNS")) {
                                forwardPage = objectClass;
                            }
                            if (request.getParameter("reportProperties") != null) {
                                forwardPage = objectClass + "Properties";
                            }
                            request.setAttribute("days", (Object)days);
                            request.setAttribute("time", (Object)time);
                            request.setAttribute("object", (Object)objectClass);
                        }
                    } else if (selectedObjectTab.equalsIgnoreCase("acls")) {
                        String columnName = "ACE_TYPE";
                        if (request.getParameter("columnName") != null) {
                            columnName = request.getParameter("columnName");
                        }
                        request.setAttribute("columnName", (Object)columnName);
                        String ascending = "true";
                        if (request.getParameter("ascending") != null) {
                            ascending = request.getParameter("ascending");
                        }
                        request.setAttribute("ascending", (Object)ascending);
                        this.getAcls(request, "ADSMADExplorerACLs", domainName, guid, nodeClicked);
                        ArrayList sidList = ADViewerUtil.getSIDs((String)nodeClicked);
                        DynaActionForm objectPropBean = (DynaActionForm)form;
                        objectPropBean.set("sidListForFilter", (Object)sidList);
                        objectPropBean.set("sidForFilter", (Object)((String)sidList.get(0)));
                        System.out.println("The Props that are set are sidForFilter :" + objectPropBean.get("sidForFilter") + "\n" + "sidListForFilter is " + objectPropBean.get("sidListForFilter"));
                        String[] sortColumns = new String[]{"ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSION", "APPLIES_TO"};
                        for (int i = 0; i < sortColumns.length; ++i) {
                            if (!columnName.equals(sortColumns[i])) continue;
                            request.setAttribute("sortColumnIndex", (Object)new Integer(i));
                        }
                        if (ascending.equals("true")) {
                            request.setAttribute("sortImage", (Object)"images/sortdown.gif");
                        } else {
                            request.setAttribute("sortImage", (Object)"images/sortup.gif");
                        }
                        forwardPage = "acls";
                    } else if (selectedObjectTab.equalsIgnoreCase("role")) {
                        ArrayList list = TemplateHandler.checkForDelegation((String)nodeClicked);
                        int size = 0;
                        if (list.isEmpty()) {
                            request.setAttribute("size", (Object)new Integer(0));
                        } else {
                            size = list.size();
                            request.setAttribute("size", (Object)new Integer(size));
                            request.setAttribute("delegationList", (Object)list);
                        }
                        forwardPage = "role";
                    } else if (selectedObjectTab.equalsIgnoreCase("mailboxRights")) {
                        ArrayList sidList;
                        String ascending;
                        ArrayList objectList = null;
                        boolean isMailBox = false;
                        objectList = ExchangeHandler.getMailBoxUsers(null, (String)domainName, (int)-1, (int)-1);
                        for (int i = 0; i < objectList.size(); ++i) {
                            Properties object = (Properties)objectList.get(i);
                            String dn = object.getProperty("DISTINGUISHED_NAME");
                            if (!dn.equalsIgnoreCase(nodeClicked)) continue;
                            isMailBox = true;
                            break;
                        }
                        if (isMailBox) {
                            String columnName = "ACE_TYPE";
                            if (request.getParameter("columnName") != null) {
                                columnName = request.getParameter("columnName");
                            }
                            request.setAttribute("columnName", (Object)columnName);
                            ascending = "true";
                            if (request.getParameter("ascending") != null) {
                                ascending = request.getParameter("ascending");
                            }
                            request.setAttribute("ascending", (Object)ascending);
                            this.getAcls(request, "ADSMMailBoxACLs", domainName, guid, nodeClicked);
                            sidList = ADViewerUtil.getSIDs((String)nodeClicked);
                            DynaActionForm objectPropBean = (DynaActionForm)form;
                            objectPropBean.set("sidListForFilter", (Object)sidList);
                            objectPropBean.set("sidForFilter", (Object)((String)sidList.get(0)));
                            System.out.println("The Props that are set are sidForFilter :" + objectPropBean.get("sidForFilter") + "\n" + "sidListForFilter is " + objectPropBean.get("sidListForFilter"));
                            String[] sortColumns = new String[]{"ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSION", "APPLIES_TO"};
                            for (int i = 0; i < sortColumns.length; ++i) {
                                if (!columnName.equals(sortColumns[i])) continue;
                                request.setAttribute("sortColumnIndex", (Object)new Integer(i));
                            }
                            if (ascending.equals("true")) {
                                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
                            } else {
                                request.setAttribute("sortImage", (Object)"images/sortup.gif");
                            }
                            request.setAttribute("Acltype", (Object)"mailbox");
                            forwardPage = "acls";
                        } else {
                            String columnName = "ACE_TYPE";
                            if (request.getParameter("columnName") != null) {
                                columnName = request.getParameter("columnName");
                            }
                            request.setAttribute("columnName", (Object)columnName);
                            ascending = "true";
                            if (request.getParameter("ascending") != null) {
                                ascending = request.getParameter("ascending");
                            }
                            request.setAttribute("ascending", (Object)ascending);
                            this.getAcls(request, "ADSMADExplorerACLs", domainName, guid, nodeClicked);
                            sidList = ADViewerUtil.getSIDs((String)nodeClicked);
                            DynaActionForm objectPropBean = (DynaActionForm)form;
                            objectPropBean.set("sidListForFilter", (Object)sidList);
                            objectPropBean.set("sidForFilter", (Object)((String)sidList.get(0)));
                            System.out.println("The Props that are set are sidForFilter :" + objectPropBean.get("sidForFilter") + "\n" + "sidListForFilter is " + objectPropBean.get("sidListForFilter"));
                            String[] sortColumns = new String[]{"ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSION", "APPLIES_TO"};
                            for (int i = 0; i < sortColumns.length; ++i) {
                                if (!columnName.equals(sortColumns[i])) continue;
                                request.setAttribute("sortColumnIndex", (Object)new Integer(i));
                            }
                            if (ascending.equals("true")) {
                                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
                            } else {
                                request.setAttribute("sortImage", (Object)"images/sortup.gif");
                            }
                            forwardPage = "acls";
                            request.setAttribute(selectedObjectTab, (Object)"acls");
                        }
                    }
                    ArrayList templateList = SecurityClientUtil.getTemplates(loginId);
                    request.setAttribute("templateList", (Object)templateList);
                    request.setAttribute("icon", (Object)ADClientUtil.getIcon(objectClass));
                    request.setAttribute("objectName", (Object)objectName);
                    request.setAttribute("guid", (Object)guid);
                    request.setAttribute("domainName", (Object)domainName);
                    request.setAttribute("objectClass", (Object)objectClass);
                    request.setAttribute("selectedObjectTab", (Object)selectedObjectTab);
                    this.fillTabProperties(request, guid, nodeClicked, objectName);
                    System.out.println("********ObjectPropertiesAction*********");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    private void getAcls(HttpServletRequest request, String tableName, String domainName, String guid, String nodeClicked) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String columnName = "ACE_TYPE";
        if (request.getParameter("columnName") != null) {
            columnName = request.getParameter("columnName");
        }
        request.setAttribute("columnName", (Object)columnName);
        String ascending = "true";
        if (request.getParameter("ascending") != null) {
            ascending = request.getParameter("ascending");
        }
        request.setAttribute("ascending", (Object)ascending);
        if (guid != null && !guid.equalsIgnoreCase("")) {
            guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
        }
        String[] keyProps = new String[]{"DISTINGUISHED_NAME", "ACE_TYPE", "SECURITY_PRINCIPAL", "PERMISSION", "APPLIES_TO", "SESSION_ID"};
        ArrayList list = new ArrayList();
        String sessionID = request.getSession().getId();
        if (sessionID == this.sessionID1) {
            list = ADViewerUtil.getACLS((String)tableName, (String)"DISTINGUISHED_NAME", (String)nodeClicked, (String[])keyProps, (String)columnName, (String)ascending, (String)sessionID);
        }
        if (sessionID != this.sessionID1 || list == null || list.size() <= 0) {
            ADViewerUtil.cleanUp((String)sessionID);
            Properties p = null;
            ArrayList aclsList = null;
            if (tableName.equalsIgnoreCase("ADSMADExplorerACLs")) {
                p = this.getACLsFromAD(domainName, loginId, guid);
                aclsList = (ArrayList)p.get("acls");
            } else if (tableName.equalsIgnoreCase("ADSMMailBoxACLs")) {
                aclsList = this.getMailBoxACLsFromAD(domainName, loginId, nodeClicked);
            }
            if (!aclsList.isEmpty()) {
                for (int i = 0; i < aclsList.size(); ++i) {
                    Properties props = (Properties)aclsList.get(i);
                    if (props == null || props.isEmpty()) continue;
                    Properties values = new Properties();
                    values.put("SESSION_ID", session.getId());
                    values.put("DISTINGUISHED_NAME", nodeClicked);
                    values.put("ACE_TYPE", rb.getString((String)props.get("aceType")));
                    values.put("SECURITY_PRINCIPAL", props.get("trustee"));
                    Object object = props.get("permission");
                    if (object instanceof List) {
                        ArrayList permList = (ArrayList)object;
                        StringBuffer permissionsBuffer = new StringBuffer();
                        for (int j = 0; j < permList.size(); ++j) {
                            if (j > 0) {
                                permissionsBuffer.append(", ");
                            }
                            String temp = (String)permList.get(j);
                            String objectTypeStr = (String)props.get("objectTypeStr");
                            if (objectTypeStr != null) {
                                if (temp.equalsIgnoreCase("")) {
                                    temp = objectTypeStr;
                                }
                                temp = MessageFormat.format(rb.getString(temp), objectTypeStr);
                            } else {
                                temp = rb.getString(temp);
                            }
                            temp = temp.trim();
                            if (temp.startsWith(" ")) {
                                temp = temp.substring(1, temp.length());
                            }
                            permissionsBuffer.append(temp);
                        }
                        values.put("PERMISSION", permissionsBuffer.toString());
                    } else if (object instanceof String) {
                        String permString = (String)object;
                        values.put("PERMISSION", rb.getString(permString));
                    } else {
                        System.out.println("Not matched with any java objects listed above");
                    }
                    if (props.get("appliesToObject") != null && ((String)props.get("appliesToObject")).equalsIgnoreCase("true")) {
                        values.put("APPLIES_TO", MessageFormat.format(rb.getString("admp.common.permissions.appliesTo_user_objects"), props.get("appliesTo")));
                    } else {
                        values.put("APPLIES_TO", rb.getString((String)props.get("appliesTo")));
                    }
                    ADViewerUtil.addACLS((String)tableName, (String[])keyProps, (Properties)values);
                }
            }
            list = ADViewerUtil.getACLS((String)tableName, (String)"DISTINGUISHED_NAME", (String)nodeClicked, (String[])keyProps, (String)columnName, (String)ascending, (String)sessionID);
            this.sessionID1 = request.getSession().getId();
        }
        request.setAttribute("list", (Object)list);
    }

    private void fillTabProperties(HttpServletRequest request, String guid, String nodeClicked, String objectName) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String objectClass = request.getParameter("objectClass");
        String domainName = request.getParameter("domainName");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (domainName == null) {
            Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
            domainName = selectedDomain.getProperty("DOMAIN_NAME");
        }
        System.out.println("********StartfillTabProperties*********");
        ArrayList<String> tabDisplayNames = new ArrayList<String>();
        tabDisplayNames.add(0, rb.getString("admp.ad_explorer.view_props.heading.properties"));
        tabDisplayNames.add(1, rb.getString("admp.ad_explorer.view_props.heading.security"));
        ArrayList<String> tabDisplayIds = new ArrayList<String>();
        tabDisplayIds.add(0, "properties");
        tabDisplayIds.add(1, "acls");
        ArrayList<String> tabImages = new ArrayList<String>();
        tabImages.add(0, "/images/properties_icon.gif");
        tabImages.add(1, "/images/security_icon.gif");
        ArrayList objectList = null;
        objectList = ExchangeHandler.getMailBoxUsers(null, (String)domainName, (int)-1, (int)-1);
        if (objectList != null) {
            for (int i = 0; i < objectList.size(); ++i) {
                Properties object = (Properties)objectList.get(i);
                String dn = object.getProperty("DISTINGUISHED_NAME");
                if (!dn.equalsIgnoreCase(nodeClicked)) continue;
                tabDisplayNames.add(2, rb.getString("admp.ad_explorer.view_props.heading.mailbox_rights"));
                tabDisplayIds.add(2, "mailboxRights");
                tabImages.add(2, "/images/security_icon.gif");
            }
        }
        ArrayList<Properties> tabList = new ArrayList<Properties>();
        for (int i = 0; i < tabDisplayNames.size(); ++i) {
            Properties p = new Properties();
            p.setProperty("displayName", (String)tabDisplayNames.get(i));
            p.setProperty("domainName", domainName);
            if (nodeClicked != null) {
                p.setProperty("nodeClicked", nodeClicked);
            }
            p.setProperty("guid", guid);
            String actionLink = "'guid=" + guid + "&objectClass=" + objectClass + "'";
            if (objectClass != null) {
                p.setProperty("objectClass", objectClass);
            }
            p.setProperty("objectName", objectName);
            p.setProperty("actionLink", actionLink);
            p.setProperty("displayID", (String)tabDisplayIds.get(i));
            p.setProperty("image", (String)tabImages.get(i));
            tabList.add(p);
        }
        request.setAttribute("objectTabList", tabList);
    }

    private String getGMT(String datevalue, Long loginId) {
        String textDate = datevalue;
        try {
            SimpleDateFormat formatter = DateTimeUtil.getDateFormat((Long)loginId);
            SimpleDateFormat sdfInput = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a");
            sdfInput.setTimeZone(TimeZone.getTimeZone("GMT-00"));
            Date date = sdfInput.parse(textDate);
            System.out.println("Parsed Date is " + date);
            textDate = formatter.format(date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return textDate;
    }

    private String getGroupScope(String scope) {
        String groupScope = null;
        try {
            int bitops = Integer.parseInt(scope);
            if ((bitops & 2) == 2) {
                groupScope = "admp.common.group_scopes.global";
            } else if ((bitops & 4) == 4) {
                groupScope = "admp.common.group_scopes.domain_local";
            } else if ((bitops & 8) == 8) {
                groupScope = "admp.common.group_scopes.universal";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return groupScope;
    }

    private Properties getACLsFromAD(String domainName, Long loginId, String guid) {
        Properties p = new Properties();
        try {
            p = ADHandler.getACLs((String)domainName, (Long)loginId, (String)guid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    private ArrayList getMailBoxACLsFromAD(String domainName, Long loginId, String distinguishedName) {
        ArrayList list = new ArrayList();
        try {
            list = ADHandler.getMailBoxRights((String)domainName, (Long)loginId, (String)distinguishedName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private Properties getObjectPropertiesFromAD(String domainName, Long loginId, String objectClass, String guid) {
        Properties p = new Properties();
        try {
            p = objectClass.equalsIgnoreCase("user") ? ADHandler.getUserObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("group") ? ADHandler.getGroupObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("computer") ? ADHandler.getComputerObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("organizationalUnit") ? ADHandler.getOUObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("contact") ? ADHandler.getContactObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("volume") ? ADHandler.getSharedFolderObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("printQueue") ? ADHandler.getPrinterObject((String)domainName, (Long)loginId, (String)guid) : (objectClass.equalsIgnoreCase("domainDNS") ? ADHandler.getDomainDNSObject((String)domainName, (Long)loginId, (String)guid) : ADHandler.getObject((String)domainName, (Long)loginId, (String)guid))))))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static String checkStatus(String computerName, String domainName, AdventNetResourceBundle rb) {
        ArrayList bitlokcerInfo = new ArrayList();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"COMPUTER_NAME"), (Object)computerName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"BITLOCKER_STATUS"), null, 1));
            DataObject datobject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            Iterator iterator = datobject.getRows("ADSMComputerGeneralDetails");
            if (iterator.hasNext()) {
                Properties p1 = new Properties();
                Row r = (Row)iterator.next();
                return rb.getString("admp.mgmt.user_mgmt.ts_env.input.enable");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb.getString("admp.mgmt.user_mgmt.ts_env.input.disable");
    }

    public static ArrayList getBitlockerInfo(String computerName, String domainName) {
        ArrayList<Properties> bitlokcerInfo = new ArrayList<Properties>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMBitlockerGeneralDetails", (String)"COMPUTER_NAME"), (Object)computerName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMBitlockerGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject datobject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMBitlockerGeneralDetails", criteria);
            Iterator iterator = datobject.getRows("ADSMBitlockerGeneralDetails");
            while (iterator.hasNext()) {
                Properties p1 = new Properties();
                Row r = (Row)iterator.next();
                p1.setProperty("name", StrUtil.getNameFromDN((String)((String)r.get("DISTINGUISHED_NAME"))));
                p1.setProperty("reoveryGuid", (String)r.get("RECOVERY_GUID"));
                p1.setProperty("recoverPassword", (String)r.get("RECOVERY_PASSWORD"));
                bitlokcerInfo.add(p1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitlokcerInfo;
    }
}

