/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticatorForMobile;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import com.adventnet.sym.adsm.mobilesso.TicketHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ads.fw.util.FeatureUtil;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ADMgmtAPIcall {
    public static String getAuthInfo(HttpServletRequest request) {
        JSONObject jsonTemplateNames = new JSONObject();
        try {
            ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
            jsonTemplateNames.put("AdmpAuthObject", (Object)admpAuthObject.toJSONStringForMobile());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonTemplateNames.toString();
    }

    public static String configureTrustedProduct(HttpServletRequest request) throws Exception {
        JSONObject json = new JSONObject();
        String productName = request.getParameter("PRODUCT_NAME");
        String operation = request.getParameter("operation");
        Long productId = productName != null ? CommonUtil.getProductId((String)productName) : null;
        JSONObject prop = new JSONObject();
        prop.put("PRODUCT_ID", (Object)productId);
        prop.put("PROTOCOL", (Object)request.getParameter("PROTOCOL"));
        prop.put("HOST", (Object)request.getParameter("HOST"));
        prop.put("PORT", (Object)request.getParameter("PORT"));
        if (JumpToHandler.testConnection((JSONObject)prop, (boolean)false)) {
            JumpToHandler.updateSettings((JSONObject)prop);
            AdminHandler.addToTrustedProduct((String)productName);
        }
        json.put("status", (Object)"SUCCESS");
        return json.toString();
    }

    public static String removeTrustedProduct(HttpServletRequest request) throws Exception {
        JSONObject json = new JSONObject();
        String productName = request.getParameter("PRODUCT_NAME");
        String operation = request.getParameter("operation");
        Long productId = productName != null ? CommonUtil.getProductId((String)productName) : null;
        JumpToHandler.removeSettings((Long)productId);
        AdminHandler.removeFromTrustedProduct((String)productName);
        json.put("status", (Object)"success");
        return json.toString();
    }

    public static String getAuthToken(HttpServletRequest request) throws Exception {
        String resultResponse = null;
        try {
            TicketHandler ticketHandler = TicketHandler.getInstance();
            String domainName = request.getParameter("domainName");
            String loginName = request.getParameter("loginName");
            String productName = request.getParameter("PRODUCT_NAME");
            String serviceName = "System";
            String authObjectString = "";
            ADMPADAuthenticatorForMobile authenticator = new ADMPADAuthenticatorForMobile();
            authenticator.initForAPIAuthorization(request, loginName, domainName, serviceName);
            if (!AdminHandler.isTrustedProduct((String)productName).booleanValue()) {
                throw new Exception("00000005");
            }
            authenticator.authenticateTechnicianForTrustedProduct(request);
            Ticket ticket = new Ticket();
            if (authenticator.getAuthenticationSuccess()) {
                request.setAttribute("IS_REST_API_CALL", (Object)"true");
                ticket = ticketHandler.setTicket(request, null, authenticator);
                ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
                authObjectString = admpAuthObject.toJSONStringForMobile();
            }
            Properties prop = new Properties();
            prop.setProperty("LoginStatus", new Boolean(authenticator.getAuthenticationSuccess()).toString());
            prop.setProperty("AuthTicket", ticket.getTicket());
            prop.setProperty("LoginStatusMessage", authenticator.getLoginStatusMessage());
            prop.setProperty("ValidDate", ticket.getValidDate().toString());
            prop.setProperty("AdmpAuthObject", authObjectString);
            resultResponse = ADMPAPIUtil.getJSONString(prop);
            request.setAttribute("RESPONSE", (Object)resultResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return resultResponse;
    }

    public static String removeAuthToken(HttpServletRequest request) throws Exception {
        Properties props = new Properties();
        String productName = request.getParameter("PRODUCT_NAME");
        if (AdminHandler.isTrustedProduct((String)productName).booleanValue()) {
            TicketHandler ticketHandler = TicketHandler.getInstance();
            String authToken = request.getParameter("AuthToken");
            Ticket authTokenObj = null;
            if (authToken != null) {
                authTokenObj = ticketHandler.getTicketFrmCache(authToken);
            }
            if (authTokenObj == null) {
                props.put("AuthtokenFound", "false");
            } else if (authToken != null) {
                ticketHandler.removeTicket(authToken);
            }
        } else {
            throw new Exception("00000005");
        }
        props.setProperty("success", "true");
        return ADMPAPIUtil.getJSONString(props);
    }

    public static String getAuthTokenForAPI(HttpServletRequest request) throws Exception {
        String resultResponse = null;
        try {
            String password;
            TicketHandler ticketHandler = TicketHandler.getInstance();
            String authToken = request.getParameter("AuthToken");
            if (authToken != null) {
                ticketHandler.removeTicket(authToken);
            }
            String domainName = request.getParameter("domainName");
            String loginName = request.getParameter("loginName");
            if (loginName == null) {
                loginName = request.getParameter("username");
            }
            if ((password = request.getParameter("password")) == null) {
                password = request.getParameter("pwd");
            }
            String serviceName = "System";
            String authObjectString = "";
            Long loginId = 0L;
            String loginNameFromUserProp = "";
            ADMPADAuthenticatorForMobile authenticator = new ADMPADAuthenticatorForMobile();
            authenticator.init(request, loginName, domainName, password, serviceName);
            authenticator.authenticateUser();
            Ticket ticket = new Ticket();
            if (authenticator.getAuthenticationSuccess()) {
                request.setAttribute("IS_REST_API_CALL", (Object)"true");
                ticket = ticketHandler.setTicket(request, null, authenticator);
                ADMPAuthObject admpAuthObject = (ADMPAuthObject)request.getAttribute("ADMP_AUTH_OBJECT");
                authObjectString = admpAuthObject.toJSONStringForMobile();
                loginId = admpAuthObject.getLoginId();
                loginNameFromUserProp = admpAuthObject.getLoginName();
            }
            Properties prop = new Properties();
            prop.setProperty("LoginStatus", new Boolean(authenticator.getAuthenticationSuccess()).toString());
            prop.setProperty("AuthTicket", ticket.getTicket());
            prop.setProperty("LoginStatusMessage", authenticator.getLoginStatusMessage());
            prop.setProperty("ValidDate", ticket.getValidDate().toString());
            prop.setProperty("AdmpAuthObject", authObjectString);
            prop.setProperty("LoginName", loginNameFromUserProp);
            prop.setProperty("LoginId", loginId.toString());
            resultResponse = ADMPAPIUtil.getJSONString(prop);
            request.setAttribute("RESPONSE", (Object)resultResponse);
            String tp_source = request.getParameter("PRODUCT_NAME");
            if (tp_source != null && tp_source.equalsIgnoreCase("Zendesk")) {
                FeatureUtil.disableFeature((String)"CLICK_JACKING");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return resultResponse;
    }
}

