/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.api.APIRequestsCountHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.metrack.METrackerConstantsUtil;
import com.adventnet.sym.adsm.common.server.metrack.ModuleFeatureCountsHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class MEnableDisableCommitListener
extends MobileCommitListener {
    String isEnable = "true";
    int userAccountControl = 0;
    int andUserAccountControl = 0xFFFFFFF;
    String unableMsgKey = "usermanagement.messages.unable_modify_user";
    String errorMsgKey = "admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error";
    String successMsgKey = "admp.mgmt.user_mgmt.mgmtname.enable_disable_user";
    boolean accountExpiresAuthorized = false;

    public MEnableDisableCommitListener(HttpServletRequest request) throws Exception {
        super(request);
        this.isEnable = (String)request.getAttribute("isEnable");
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            ADMPAuthObject authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsIds = authObject.getDomainActionMap();
            Long actionId = MgmtActionIdConstants.USERS_ENABLE_DISABLE_ACTIONID;
            if (this.isComputerObject()) {
                actionId = MgmtActionIdConstants.COMPUTERS_ENABLE_DISABLE_ACTIONID;
            }
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)actionId);
            this.accountExpiresAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, 1209L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void commitMobileRequest() {
        if (this.isUserObject()) {
            this.reportId = (int)ReportsUtil.ENABLE_DISABLE_USER_MGMT_REPORT_ID;
        } else if (this.isComputerObject()) {
            this.reportId = (int)ReportsUtil.ENABLE_DISABLE_COMPUTER_MGMT_REPORT_ID;
            this.unableMsgKey = "client.computermanagement.EnableDisableComputers.unable_to_modify_the_computer_error";
            this.errorMsgKey = "client.computermanagement.EnableDisableComputers.unable_to_modify_the_computer";
            this.successMsgKey = "admp.mgmt.comp_mgmt.common.mgmtname.enable_disable_computers";
        }
        try {
            ArrayList<Long> auditIdList = new ArrayList<Long>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            ArrayList<String> objectOUList = new ArrayList<String>();
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                JSONObject singleResultFormat = this.commit(jsonObj, auditIdList, auditObjectIdList, objectOUList);
                this.outputFormat.put((Object)singleResultFormat);
            }
            if (!auditObjectIdList.isEmpty()) {
                Integer userObjectId = 1;
                Long viewId = FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID;
                if (this.isComputerObject()) {
                    userObjectId = 3;
                    viewId = FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID;
                }
                this.triggerNotification(auditIdList, auditObjectIdList, userObjectId, null, this.reportId, viewId, objectOUList);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject commit(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singelResultJsonFormat = new JSONObject();
        singelResultJsonFormat = this.enableDisable(jsonObj, auditIdList, auditObjectIdList, objectOUList);
        return singelResultJsonFormat;
    }

    public JSONObject enableDisable(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singleResultJsonFormat = new JSONObject();
        DataObject auditDataObj = null;
        Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
        try {
            String dn;
            String guid;
            String sid;
            String userPrincipalName;
            String sAMAccountName = jsonObj.getString("sAMAccountName");
            if (jsonObj.has("userPrincipalName") && jsonObj.has("objectSID") && jsonObj.has("objectGUID") && jsonObj.has("distinguishedName")) {
                userPrincipalName = jsonObj.getString("userPrincipalName");
                sid = jsonObj.getString("objectSID");
                guid = jsonObj.getString("objectGUID");
                dn = jsonObj.getString("distinguishedName");
            } else {
                Properties userProperties = this.getUserDetails(sAMAccountName);
                if (userProperties.size() > 0) {
                    userPrincipalName = (String)userProperties.get("LOGON_NAME");
                    sid = (String)userProperties.get("SID_STRING");
                    guid = (String)userProperties.get("OBJECT_GUID");
                    dn = (String)userProperties.get("DISTINGUISHED_NAME");
                } else {
                    singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
                    singleResultJsonFormat.put("status", (Object)"0");
                    singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.user_mgmt.native.failure.no_such_user_matched"));
                    System.out.println(" Finished exectuing enableDisable in MEnableDisableCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                    return singleResultJsonFormat;
                }
            }
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)userPrincipalName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            Long apiId = "true".equalsIgnoreCase(this.isEnable) ? APIRequestsCountHandler.ENABLE_USER_API_ID : APIRequestsCountHandler.DISABLE_USER_API_ID;
            if (this.isLicenseRestricted.booleanValue() && !APIRequestsCountHandler.getInstance().isAllowed(apiId)) {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.api.mgmt.api_limit_exceeded"));
                System.out.println(" Finished exectuing enableDisable in MEnableDisableCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
                return singleResultJsonFormat;
            }
            Hashtable<String, String> result = new Hashtable<String, String>();
            String disablePolicyMsg = "";
            boolean disableUserTask = false;
            result.put("OBJECT_GUID", guid);
            guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
            StringBuffer message = new StringBuffer();
            String hostId = this.request.getRemoteHost();
            hostId = hostId == null ? "Mobile" : hostId;
            auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = this.isComputerObject() ? HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)userPrincipalName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true) : HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)sAMAccountName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
            ArrayList winNTProviderList = new ArrayList();
            String accountStatus = "";
            if ("true".equalsIgnoreCase(this.isEnable)) {
                this.andUserAccountControl &= 0xFFFFFD;
                accountStatus = this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.enabled");
            } else {
                this.userAccountControl |= 2;
                accountStatus = this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.disabled");
                disableUserTask = true;
            }
            if (this.userAccountControl != 0 || this.andUserAccountControl != 0xFFFFFFF) {
                Properties p1 = new Properties();
                p1.put("DATA_HANDLER_TYPE", new Long(7L));
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("ATTRIB_LDAP_NAME", "userAccountControl");
                p1.put("ATTRIB_VALUE", String.valueOf(this.userAccountControl));
                p1.put("ATTRIB_AND_VALUE", String.valueOf(this.andUserAccountControl));
                modifyAttributeList.add(p1);
            }
            String accountExpires = this.request.getParameter("accountExpires");
            HashMap policyStatusMap = new HashMap();
            if (accountExpires != null && (accountExpires.equalsIgnoreCase("Never") || accountExpires.equalsIgnoreCase("EndOf"))) {
                if (this.accountExpiresAuthorized) {
                    Properties p = new Properties();
                    p.put("DATA_HANDLER_TYPE", new Long(10L));
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "accountExpires");
                    Long expireTime = new Long(0L);
                    try {
                        if (accountExpires.equalsIgnoreCase("EndOf")) {
                            String s = this.request.getParameter("expireTime");
                            SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
                            Date date = dateFormat.parse(s);
                            expireTime = DateTimeUtil.getFileTimeFromSystemTime((Long)date.getTime());
                        }
                        p.put("ATTRIB_VALUE", expireTime);
                        setAttributeList.add(p);
                    }
                    catch (NumberFormatException | ParseException ex) {
                        ex.printStackTrace();
                        message.append(this.rb.getString("admp.user_mgmt.native.warning.setting_attributes") + " accountExpires : " + this.rb.getString("admp.admin.gen_settgs.person.statmsg.invalid_date_time_format"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        message.append(this.rb.getString("admp.user_mgmt.native.warning.setting_attributes") + " accountExpires : " + e.getMessage());
                    }
                } else {
                    message.append(MessageFormat.format(this.rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_not_authorized"), "accountExpires"));
                }
            }
            if (modifyAttributeList.size() != 0 || setAttributeList.size() != 0) {
                try {
                    ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)this.loginId, (String)sid, (String)dn, (String)userPrincipalName, setAttributeList, modifyAttributeList, winNTProviderList, (ArrayList)this.getAttributeList(), null);
                    singleResultJsonFormat.put("status", (Object)"1");
                    if (disableUserTask) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_disabled"));
                    } else {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_enabled"));
                    }
                    auditObjectIdList.add(object_id);
                    singleResultJsonFormat.put("statusMessage", (Object)message);
                    if (disableUserTask) {
                        disablePolicyMsg = DeleteUtil.executeDisablePolicyTasks(this.domainName, this.loginId, guid, dn, sid, result, this.rb, policyStatusMap);
                        singleResultJsonFormat.put("statusMessage", (Object)(message + disablePolicyMsg));
                    }
                }
                catch (LocalizedException le) {
                    singleResultJsonFormat.put("status", (Object)"0");
                    singleResultJsonFormat.put("statusMessage", (Object)(this.rb.getString(this.unableMsgKey) + le.getMessage(this.rb)));
                }
                catch (Exception e) {
                    singleResultJsonFormat.put("status", (Object)"0");
                    singleResultJsonFormat.put("statusMessage", (Object)(this.rb.getString(this.unableMsgKey) + e.getMessage()));
                }
            } else {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString(this.errorMsgKey));
            }
            if (policyStatusMap.size() > 0) {
                CommonUtil.getAttributeModified(policyStatusMap, modifyAttributeList, (AdventNetResourceBundle)this.rb);
            }
            if (!accountStatus.equals("")) {
                Properties p2 = (Properties)modifyAttributeList.get(0);
                p2.put("ATTRIB_LDAP_NAME", "UserAccountStatus");
                p2.put("ATTRIB_VALUE", accountStatus);
            }
            if (this.isComputerObject()) {
                TechAuditAPI.getInstance().auditComputerModification(this.loginId, this.rb.getString(this.successMsgKey), userPrincipalName, this.domainName, setAttributeList, modifyAttributeList, new ArrayList(), singleResultJsonFormat.get("statusMessage").toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            } else {
                TechAuditAPI.getInstance().auditUserModification(this.loginId, this.rb.getString(this.successMsgKey), sAMAccountName, this.domainName, setAttributeList, modifyAttributeList, new ArrayList(), singleResultJsonFormat.get("statusMessage").toString() + disablePolicyMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
            audit_info.put("error_msg", singleResultJsonFormat.get("statusMessage").toString());
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
            if (this.isLicenseRestricted.booleanValue() && singleResultJsonFormat.get("status") == "1") {
                APIRequestsCountHandler.getInstance().updateCount(apiId, 1);
                ModuleFeatureCountsHandler.getInstance().updateFeatureCount("admp.mgmt.user_mgmt.mgmtname.enable_disable_user_api", METrackerConstantsUtil.OBJECTS_COUNT, Long.valueOf(1L), this.loginId, false, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" Finished exectuing enableDisable in MEnableDisableCommitListener: singleResultJsonFormat " + singleResultJsonFormat);
        return singleResultJsonFormat;
    }

    public void fillResultFormat() {
        JSONObject singleResultJsonFormat = new JSONObject();
        try {
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                singleResultJsonFormat = new JSONObject();
                if (jsonObj.has("sAMAccountName")) {
                    singleResultJsonFormat.put("sAMAccountName", (Object)jsonObj.getString("sAMAccountName"));
                }
                if (jsonObj.has("userPrincipalName")) {
                    singleResultJsonFormat.put("userPrincipalName", (Object)jsonObj.getString("userPrincipalName"));
                }
                if (jsonObj.has("distinguishedName")) {
                    singleResultJsonFormat.put("distinguishedName", (Object)jsonObj.getString("distinguishedName"));
                }
                if (jsonObj.has("objectGUID")) {
                    singleResultJsonFormat.put("objectGUID", (Object)jsonObj.getString("objectGUID"));
                }
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.mgmt.common.statmsg.access_denied"));
                this.outputFormat.put((Object)singleResultJsonFormat);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

