/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcBulkLayoutController;
import com.adventnet.sym.adsm.common.server.layout.FcIamApps;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutAuth;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.IMgmtListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBUCResultsDataSource;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class MModifyBulkUserCommitListener
extends MobileCommitListener {
    private static Logger out = Logger.getLogger("APILogger");
    JSONObject currentCSVStatusObj = new JSONObject();
    ADMPAuthObject authObject = null;
    boolean invalidDomain = false;
    String managerErrorMsg = "";
    String memberOfErrorMsg = "";
    String removeMemberOfErrorMsg = "";
    String[] pwdErrorMsg;
    String actionName = "";
    String reportActionName = "";
    Long requestId = 0L;
    Vector headerVector = new Vector();
    ArrayList<Vector> list = new ArrayList();
    Long tempCategoryId = 0L;
    Long tempLayoutId = 0L;
    private static Long USER_MODIFICATION_SYSTEM_TEMPLATE = 8L;

    public MModifyBulkUserCommitListener(HttpServletRequest request) throws Exception {
        super(request);
        this.actionName = request.getParameter("modifyAction");
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            this.authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Properties domainProp = DomainUtil.getDomainDetails((String)this.domainName);
            if (domainProp.isEmpty()) {
                this.invalidDomain = true;
                return false;
            }
            Long actionId = 0L;
            if (this.actionName.equals("unlockAdUsers")) {
                actionId = MgmtActionIdConstants.USERS_UNLOCK_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.unlock_users";
            } else if (this.actionName.equals("enableDisableAdUsers")) {
                actionId = MgmtActionIdConstants.USERS_ENABLE_DISABLE_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.account_attrib";
            } else if (this.actionName.equals("resetAdUsersPassword")) {
                actionId = MgmtActionIdConstants.USERS_RESET_PWD_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.reset_pwd";
            } else if (this.actionName.equals("modifyAdUsersDept")) {
                actionId = MgmtActionIdConstants.USERS_MODIFY_DEPT_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.add_org_attrib";
            } else if (this.actionName.equals("modifyAdUsersManager")) {
                actionId = MgmtActionIdConstants.USERS_MODIFY_MANAGER_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.add_org_attrib";
            } else if (this.actionName.equals("addAdUsersToGroup")) {
                actionId = MgmtActionIdConstants.USER_ADDTOGROUP_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.group_attrib";
            } else if (this.actionName.equals("removeAdUsersFromGroup")) {
                actionId = MgmtActionIdConstants.USER_REMOVEFROMGROUP_ACTIONID;
                this.reportActionName = "admp.deleg.hdt_deleg.cre_role.action_name.group_attrib";
            }
            Hashtable domainVsIds = this.authObject.getDomainActionMap();
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)actionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void constructInputList() {
        try {
            String reqId;
            JSONObject additionalDataJson;
            String additionalData;
            String jsonStr = this.request.getParameter("inputFormat");
            JSONArray userDetails = new JSONArray(jsonStr);
            JSONObject modifyAttributes = new JSONObject();
            JSONArray groupList = new JSONArray();
            if (this.request.getParameter("modifyList") != null) {
                jsonStr = this.request.getParameter("modifyList");
                if (!jsonStr.equals("")) {
                    modifyAttributes = new JSONObject(jsonStr);
                }
            } else if (this.request.getParameter("addGroup") != null) {
                jsonStr = this.request.getParameter("addGroup");
                if (!jsonStr.equals("")) {
                    groupList = new JSONArray(jsonStr);
                }
            } else if (this.request.getParameter("removeGroup") != null && !(jsonStr = this.request.getParameter("removeGroup")).equals("")) {
                groupList = new JSONArray(jsonStr);
            }
            this.tempCategoryId = new Long(this.request.getParameter("templateCategoryId"));
            this.tempLayoutId = new Long(this.request.getParameter("tempId"));
            this.headerVector.add("sAMAccountName");
            this.headerVector.add("userPrincipalName");
            if (this.actionName.equals("unlockAdUsers")) {
                this.headerVector.add("lockOutTime");
                for (int i = 0; i < userDetails.length(); ++i) {
                    JSONObject singleUser = userDetails.getJSONObject(i);
                    Vector<String> valuesVector = new Vector<String>();
                    valuesVector.add((String)singleUser.get("sAMAccountName"));
                    valuesVector.add((String)singleUser.get("userPrincipalName"));
                    valuesVector.add("0");
                    this.list.add(valuesVector);
                }
            } else if (this.actionName.equals("enableDisableAdUsers")) {
                String modifyType = modifyAttributes.getString("modifyType");
                String uacValue = "0;2";
                if (modifyType.equals("disableUser")) {
                    uacValue = "2;0";
                }
                this.headerVector.add("userAccountControl");
                for (int i = 0; i < userDetails.length(); ++i) {
                    JSONObject singleUser = userDetails.getJSONObject(i);
                    Vector<String> valuesVector = new Vector<String>();
                    valuesVector.add((String)singleUser.get("sAMAccountName"));
                    valuesVector.add((String)singleUser.get("userPrincipalName"));
                    valuesVector.add(uacValue);
                    this.list.add(valuesVector);
                }
            } else if (this.actionName.equals("resetAdUsersPassword")) {
                this.pwdErrorMsg = new String[userDetails.length()];
                this.headerVector.add("password");
                this.headerVector.add("pwdLastSet");
                String pwd = modifyAttributes.getString("password");
                String mustChngPwd = modifyAttributes.getString("mustChangePassword");
                String pwdLastSetValue = "-1";
                for (int i = 0; i < userDetails.length(); ++i) {
                    JSONObject singleUser = userDetails.getJSONObject(i);
                    Vector<String> valuesVector = new Vector<String>();
                    valuesVector.add((String)singleUser.get("sAMAccountName"));
                    valuesVector.add((String)singleUser.get("userPrincipalName"));
                    valuesVector.add(pwd);
                    this.pwdErrorMsg[i] = "";
                    if (mustChngPwd.equals("true")) {
                        String dn;
                        String sid = (String)singleUser.get("objectSID");
                        boolean checkPasswordNeverExpires = ADHandlerForMgmt.checkPasswordNeverExpires((String)this.domainName, (Long)this.loginId, (String)sid, (String)(dn = (String)singleUser.get("distinguishedName")));
                        if (checkPasswordNeverExpires) {
                            pwdLastSetValue = "-1";
                            this.pwdErrorMsg[i] = this.rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.pwd_never_expires_set_so_cannot_set_change_pwd_next_logon");
                        } else {
                            pwdLastSetValue = "0";
                        }
                    } else {
                        pwdLastSetValue = "-1";
                    }
                    valuesVector.add(pwdLastSetValue);
                    this.list.add(valuesVector);
                }
            } else if (this.actionName.equals("modifyAdUsersDept")) {
                this.headerVector.add("department");
                String deptVal = modifyAttributes.getString("department");
                for (int i = 0; i < userDetails.length(); ++i) {
                    JSONObject singleUser = userDetails.getJSONObject(i);
                    Vector<String> valuesVector = new Vector<String>();
                    valuesVector.add((String)singleUser.get("sAMAccountName"));
                    valuesVector.add((String)singleUser.get("userPrincipalName"));
                    valuesVector.add(deptVal);
                    this.list.add(valuesVector);
                }
            } else if (this.actionName.equals("modifyAdUsersManager")) {
                this.headerVector.add("manager");
                String managerVal = modifyAttributes.getString("manager");
                for (int i = 0; i < userDetails.length(); ++i) {
                    JSONObject singleUser = userDetails.getJSONObject(i);
                    Vector<String> valuesVector = new Vector<String>();
                    valuesVector.add((String)singleUser.get("sAMAccountName"));
                    valuesVector.add((String)singleUser.get("userPrincipalName"));
                    valuesVector.add(managerVal);
                    this.list.add(valuesVector);
                }
            } else if (this.actionName.equals("addAdUsersToGroup") || this.actionName.equals("removeAdUsersFromGroup")) {
                int i;
                if (this.actionName.equals("addAdUsersToGroup")) {
                    this.headerVector.add("memberOf");
                } else {
                    this.headerVector.add("removeMemberOf");
                }
                String groupValue = "";
                for (i = 0; i < groupList.length(); ++i) {
                    JSONObject groupJSON = (JSONObject)groupList.get(i);
                    String groupDN = (String)groupJSON.get("distinguishedName");
                    groupValue = groupValue + groupDN + ";";
                }
                for (i = 0; i < userDetails.length(); ++i) {
                    JSONObject singleUser = userDetails.getJSONObject(i);
                    Vector<String> valuesVector = new Vector<String>();
                    valuesVector.add((String)singleUser.get("sAMAccountName"));
                    valuesVector.add((String)singleUser.get("userPrincipalName"));
                    valuesVector.add(groupValue);
                    this.list.add(valuesVector);
                }
            }
            if ((additionalData = this.request.getParameter("additionalData")) != null && !additionalData.equals("") && (additionalDataJson = new JSONObject(additionalData)).has("reqId") && !(reqId = String.valueOf(additionalDataJson.get("reqId"))).equals("-") && !reqId.equals("")) {
                this.requestId = Long.valueOf(reqId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkAttributesAuthorization() {
        try {
            String groupName;
            JSONObject groupAuthorizationDetails;
            String templateName = FcLayoutViewHandler.getLayoutName((Long)this.tempLayoutId, null);
            String templateErrorMsg = "";
            if (templateName == null || templateName.equals("")) {
                templateErrorMsg = this.rb.getString("admp.restapi.error.given_template_not_found");
            } else {
                String tempName;
                ArrayList tempVectorList = new ArrayList();
                Vector<String> tempVector = new Vector<String>();
                tempVector.add(templateName);
                tempVectorList.add(tempVector);
                JSONObject layoutAuthorizationDetails = FcLayoutAuth.validateTemplateNames((int)0, tempVectorList, (Long)this.tempCategoryId, (Long)this.loginId, (String)this.domainName, (AdventNetResourceBundle)this.rb);
                if (layoutAuthorizationDetails.has("inValid") && layoutAuthorizationDetails.getBoolean("inValid")) {
                    tempName = layoutAuthorizationDetails.getString("templateName");
                    templateErrorMsg = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.template_name_is_not_valid"), this.rb.getString(tempName));
                    this.tempLayoutId = USER_MODIFICATION_SYSTEM_TEMPLATE;
                    out.log(Level.INFO, templateErrorMsg + " System Template will be applied. ");
                }
                if (layoutAuthorizationDetails.has("unAuthorized")) {
                    tempName = layoutAuthorizationDetails.getString("templateName");
                    templateErrorMsg = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.template_name_is_not_authorized"), this.rb.getString(tempName));
                    this.tempLayoutId = USER_MODIFICATION_SYSTEM_TEMPLATE;
                    out.log(Level.INFO, templateErrorMsg + " System Template will be applied. ");
                }
                if (layoutAuthorizationDetails.has("isAllTemplatesAuthorized") && layoutAuthorizationDetails.getBoolean("isAllTemplatesAuthorized")) {
                    templateErrorMsg = "TemplateAuthorized";
                    out.log(Level.INFO, templateErrorMsg + " " + templateName + " will be applied. ");
                }
            }
            int headerIndex = -1;
            ArrayList<Vector> singleVectorList = new ArrayList<Vector>();
            singleVectorList.add(this.list.get(0));
            headerIndex = FcExecuteFormFlow.getLdapNameIndex(this.headerVector, "manager");
            if (headerIndex != -1) {
                JSONObject userAuthorizationDetails = FcLayoutAuth.isAuthorizedUser((int)headerIndex, singleVectorList, null, new Hashtable(), (boolean)false, (Long)this.loginId);
                boolean isAllUsersAuthorized = userAuthorizationDetails.getBoolean("isAllUsersAuthorized");
                if (!isAllUsersAuthorized) {
                    String userName = userAuthorizationDetails.getString("userName");
                    this.managerErrorMsg = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.user_name_is_not_authorized"), userName);
                } else {
                    this.managerErrorMsg = "ManagerAuthorized";
                }
            } else {
                this.managerErrorMsg = "ManagerAuthorized";
            }
            headerIndex = FcExecuteFormFlow.getLdapNameIndex(this.headerVector, "memberOf");
            if (headerIndex != -1) {
                groupAuthorizationDetails = FcLayoutAuth.isAuthorizedGroups((int)headerIndex, singleVectorList, (Long)this.loginId, (String)this.domainName, (boolean)false);
                boolean isAllGroupsAuthorized = groupAuthorizationDetails.getBoolean("isAllGroupsAuthorized");
                if (!isAllGroupsAuthorized) {
                    groupName = groupAuthorizationDetails.getString("groupName");
                    this.memberOfErrorMsg = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName);
                } else {
                    this.memberOfErrorMsg = "MemberOfAuthorized";
                }
            } else {
                this.memberOfErrorMsg = "MemberOfAuthorized";
            }
            headerIndex = FcExecuteFormFlow.getLdapNameIndex(this.headerVector, "removeMemberOf");
            if (headerIndex != -1) {
                groupAuthorizationDetails = FcLayoutAuth.isAuthorizedGroups((int)headerIndex, singleVectorList, (Long)this.loginId, (String)this.domainName, (boolean)false);
                boolean isAllGroupsAuthorized = groupAuthorizationDetails.getBoolean("isAllGroupsAuthorized");
                if (!isAllGroupsAuthorized) {
                    groupName = groupAuthorizationDetails.getString("groupName");
                    this.removeMemberOfErrorMsg = MessageFormat.format(this.rb.getString("admp.api.mgmt.fc_layout_error.group_name_is_not_authorized"), groupName);
                } else {
                    this.removeMemberOfErrorMsg = "RemoveMemberOfAuthorized";
                }
            } else {
                this.removeMemberOfErrorMsg = "RemoveMemberOfAuthorized";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commitMobileRequest() {
        try {
            this.constructInputList();
            this.checkAttributesAuthorization();
            if (this.managerErrorMsg.equals("ManagerAuthorized") && this.memberOfErrorMsg.equals("MemberOfAuthorized") && this.removeMemberOfErrorMsg.equals("RemoveMemberOfAuthorized")) {
                FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
                fcBulkExecuteFormBean.initBean(this.request);
                fcBulkExecuteFormBean.setDefaultLayoutId(this.tempLayoutId);
                Long objectCreationId = fcBulkExecuteFormBean.getObjectCreationId();
                this.currentCSVStatusObj = fcBulkExecuteFormBean.getCurrentCSVStatusObj();
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                JSONObject errorDetailsObj = new JSONObject();
                boolean status = FcBulkExecuteFormFlow.addObjectDetails(objectCreationId, this.request, dataObj, errorDetailsObj, this.headerVector, this.list, this.tempCategoryId, this.loginId, this.rb, this.domainName, false, -1, this.tempLayoutId, false, fcBulkExecuteFormBean.getDPValues());
                if (!status) {
                    StringBuffer finalStatus = new StringBuffer();
                    JSONArray errorList = errorDetailsObj.getJSONArray("errorMsg");
                    for (int j = 0; j < errorList.length(); ++j) {
                        JSONObject errJson;
                        Object obj = errorList.get(j);
                        if (obj instanceof String) {
                            finalStatus.append(errorList.get(j).toString());
                            continue;
                        }
                        if (!(obj instanceof JSONObject) || !(errJson = (JSONObject)errorList.get(j)).has("error")) continue;
                        if (errJson.getString("error").equalsIgnoreCase("Attributes_Not_Authorized")) {
                            finalStatus.append(MessageFormat.format(this.rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_not_authorized"), errJson.getString("values")));
                            continue;
                        }
                        if (errJson.getString("error").equalsIgnoreCase("Attributes_hidden")) {
                            finalStatus.append(MessageFormat.format(this.rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_are_hidden"), errJson.getString("values")));
                            continue;
                        }
                        if (!errJson.getString("error").equalsIgnoreCase("Read-Only")) continue;
                        finalStatus.append(MessageFormat.format(this.rb.getString("admp.admin.tp_integ.createsingleuser.statmsg.follng_attributes_are_read_only"), errJson.getString("values")));
                    }
                    this.setErrorMsg(finalStatus.toString());
                    return;
                }
                if (FcLayoutViewHandler.isAnyObjectHasValidationError((Long)objectCreationId, (int)-1, (int)-1)) {
                    FcBUCResultsDataSource bucResultObj = new FcBUCResultsDataSource();
                    RVReqParams reqParams = new RVReqParams();
                    reqParams.setRange(this.list.size());
                    reqParams.setLoginId(this.loginId);
                    reqParams.setRvId(203);
                    reqParams.setGenerationId(objectCreationId.longValue());
                    bucResultObj.initDataSource(this.rb, reqParams, null, false, false);
                    ArrayList resultList = (ArrayList)bucResultObj.getTableData();
                    ArrayList columnList = bucResultObj.getColumnList();
                    for (int counter = 0; counter < resultList.size(); ++counter) {
                        HashMap hash = (HashMap)resultList.get(counter);
                        JSONObject resultJson = new JSONObject();
                        for (int index = 0; index < columnList.size(); ++index) {
                            HashMap details = (HashMap)columnList.get(index);
                            Integer visibleId = (Integer)details.get("VISIBLE");
                            if (visibleId != 2) continue;
                            String colName = (String)details.get("DISPLAY_NAME");
                            Integer colId = (Integer)details.get("COLUMN_ID");
                            resultJson.put(colName, (Object)((String)hash.get(colId)));
                        }
                        String creationStatus = "SEVERE";
                        resultJson.put("status", (Object)creationStatus);
                        String msg = (String)hash.get(609);
                        msg = CommonUtil.htmlEscape((String)msg);
                        msg = CommonUtil.htmlEscapeForAuditReport((String)msg);
                        msg = CommonUtil.htmlDeEscape((String)msg);
                        resultJson.put("statusMessage", (Object)msg);
                        this.outputFormat.put((Object)resultJson);
                    }
                } else {
                    fcBulkExecuteFormBean.setStartIndex(1);
                    IMgmtListener listener = fcBulkExecuteFormBean.getIMgmtListener();
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)201, 0);
                    DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
                    Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                    String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                    StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
                    FcBulkLayoutController.getInstance().addStatusUpdator(fcBulkExecuteFormBean.getObjectCreationId(), statusUpdater);
                    FcIamApps fcIamApps = fcBulkExecuteFormBean.getIamApps();
                    String moduleUsed = this.getModule();
                    listener.setModuleUsed(moduleUsed);
                    listener.setActionName(this.reportActionName);
                    listener.setActionCategory("admp.deleg.hdt_deleg.cre_role.action_name.user_mod_gen_attrib");
                    listener.setRequestId(this.requestId);
                    listener.doBulkAction(this.request, (Object)fcBulkExecuteFormBean, (Object)fcIamApps, this.loginId);
                    while (!listener.getIsCompleted()) {
                        Thread.sleep(100L);
                    }
                    FcBUCResultsDataSource bucResultObj = new FcBUCResultsDataSource();
                    RVReqParams reqParams = new RVReqParams();
                    reqParams.setRange(this.list.size());
                    reqParams.setLoginId(this.loginId);
                    reqParams.setRvId(203);
                    reqParams.setGenerationId(objectCreationId.longValue());
                    bucResultObj.initDataSource(this.rb, reqParams, null, false, false);
                    ArrayList resultList = (ArrayList)bucResultObj.getTableData();
                    ArrayList columnList = bucResultObj.getColumnList();
                    for (int counter = 0; counter < resultList.size(); ++counter) {
                        HashMap hash = (HashMap)resultList.get(counter);
                        JSONObject resultJson = new JSONObject();
                        for (int index = 0; index < columnList.size(); ++index) {
                            HashMap details = (HashMap)columnList.get(index);
                            Integer visibleId = (Integer)details.get("VISIBLE");
                            if (visibleId != 2) continue;
                            String colName = (String)details.get("DISPLAY_NAME");
                            Integer colId = (Integer)details.get("COLUMN_ID");
                            resultJson.put(colName, (Object)((String)hash.get(colId)));
                        }
                        String creationStatus = bucResultObj.getCreationStatus(objectCreationId);
                        if (creationStatus == null) {
                            creationStatus = "SEVERE";
                        }
                        String creationMessage = (String)hash.get(604);
                        if (!creationStatus.equals("SEVERE") && this.actionName.equals("resetAdUsersPassword")) {
                            creationMessage = creationMessage + this.pwdErrorMsg[counter];
                        }
                        resultJson.put("status", (Object)creationStatus);
                        creationMessage = CommonUtil.htmlEscape((String)creationMessage);
                        creationMessage = CommonUtil.htmlEscapeForAuditReport((String)creationMessage);
                        creationMessage = CommonUtil.htmlDeEscape((String)creationMessage);
                        resultJson.put("statusMessage", (Object)creationMessage);
                        this.outputFormat.put((Object)resultJson);
                    }
                }
            } else if (!this.managerErrorMsg.equals("ManagerAuthorized")) {
                this.setErrorMsg(this.managerErrorMsg);
            } else if (!this.memberOfErrorMsg.equals("ManagerAuthorized")) {
                this.setErrorMsg(this.memberOfErrorMsg);
            } else if (!this.removeMemberOfErrorMsg.equals("ManagerAuthorized")) {
                this.setErrorMsg(this.removeMemberOfErrorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setErrorMsg(String errorMsg) {
        JSONObject currentCSVStatusObj = new JSONObject();
        try {
            errorMsg = CommonUtil.htmlEscape((String)errorMsg);
            errorMsg = CommonUtil.htmlEscapeForAuditReport((String)errorMsg);
            errorMsg = CommonUtil.htmlDeEscape((String)errorMsg);
            currentCSVStatusObj.put("statusMessage", (Object)errorMsg);
            currentCSVStatusObj.put("status", (Object)"SEVERE");
            this.outputFormat.put((Object)currentCSVStatusObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillResultFormat() {
        JSONObject errorJson = new JSONObject();
        try {
            if (this.invalidDomain) {
                errorJson.put("statusMessage", (Object)MessageFormat.format(this.rb.getString("admp.api.domain_settings.domain_not_configured"), this.domainName));
            } else {
                errorJson.put("statusMessage", (Object)"Access Denied");
            }
            errorJson.put("status", (Object)"SEVERE");
            this.outputFormat.put((Object)errorJson);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

