/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MModifyGroupCommitListener
extends MobileCommitListener {
    JSONArray addGroup = new JSONArray();
    JSONArray removeGroup = new JSONArray();
    JSONObject primaryGroup = new JSONObject();
    Hashtable domainVsIds = new Hashtable();
    Boolean isRemoveFromAllGroup = false;
    public ArrayList groupIncludeList = null;
    public ArrayList groupExcludeList = null;
    Long modifyGroupAttrs;
    Long addToGroupActionId;
    Long primaryGroupActionId;
    Long removeFromGroupActionId;
    String unAuthorizedAddGroupText;
    String unAuthorizedPrimaryGroupText;
    String unAuthorizedRemoveGroupText;
    String unableToModifyText;
    String baseTableName;
    protected static Logger logger = Logger.getLogger("ADMangLogger");

    public MModifyGroupCommitListener(HttpServletRequest request) throws Exception {
        super(request);
        if (request.getParameter("objectType") != null) {
            this.setObjectType(request.getParameter("objectType"));
        }
        this.initVariables();
        try {
            String primaryGroupStr;
            String removeGroupStr;
            String addGroupStr = request.getParameter("addGroup");
            if (addGroupStr != null && !addGroupStr.equals("")) {
                this.addGroup = new JSONArray(addGroupStr);
            }
            if ((removeGroupStr = request.getParameter("removeGroup")) != null && !removeGroupStr.equals("")) {
                this.removeGroup = new JSONArray(removeGroupStr);
            }
            if ((primaryGroupStr = request.getParameter("primaryGroup")) != null && !primaryGroupStr.equals("")) {
                this.primaryGroup = new JSONObject(primaryGroupStr);
            }
            this.isRemoveFromAllGroup = new Boolean(request.getParameter("isRemoveFromAllGroup"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initVariables() {
        this.reportId = (int)ReportsUtil.MODIFY_GROUP_USER_MGMT_REPORT_ID;
        this.addToGroupActionId = MgmtActionIdConstants.USER_ADDTOGROUP_ACTIONID;
        this.primaryGroupActionId = MgmtActionIdConstants.USER_PRIMARYGROUP_ACTIONID;
        this.removeFromGroupActionId = MgmtActionIdConstants.USER_REMOVEFROMGROUP_ACTIONID;
        this.unAuthorizedAddGroupText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.unauthorized_user_add_group");
        this.unAuthorizedPrimaryGroupText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.unauthorized_user_primarygroup");
        this.unAuthorizedRemoveGroupText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.unauthorized_user_remove_group");
        this.unableToModifyText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.Unable_to_modify_user_error");
        this.baseTableName = "ADSMUserGeneralDetails";
        this.modifyGroupAttrs = MgmtActionIdConstants.MODIFY_USER_GROUP_ATTRIBUTES;
        if (this.isComputerObject()) {
            this.reportId = (int)ReportsUtil.MODIFY_GROUP_COMPUTER_MGMT_REPORT_ID;
            this.addToGroupActionId = MgmtActionIdConstants.COMPUTER_ADDTOGROUP_ACTIONID;
            this.primaryGroupActionId = MgmtActionIdConstants.COMPUTER_PRIMARYGROUP_ACTIONID;
            this.removeFromGroupActionId = MgmtActionIdConstants.COMPUTER_REMOVEFROMGROUP_ACTIONID;
            this.unAuthorizedAddGroupText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.unauthorized_user_add_group");
            this.unAuthorizedPrimaryGroupText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.unauthorized_user_primarygroup");
            this.unAuthorizedRemoveGroupText = this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.statmsg.unauthorized_user_remove_group");
            this.unableToModifyText = this.rb.getString("client.computermanagement.ModifyComputersGeneral.unable_to_modify_the_computer_error");
            this.baseTableName = "ADSMComputerGeneralDetails";
            this.modifyGroupAttrs = MgmtActionIdConstants.MODIFY_COMPUTER_GROUP_ATTRIBUTES;
        }
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            ADMPAuthObject admpAuthObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            this.domainVsIds = admpAuthObject.getDomainActionMap();
            isAuthorized = ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)this.modifyGroupAttrs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void commitMobileRequest() {
        try {
            ArrayList<Long> auditIdList = new ArrayList<Long>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            ArrayList<String> objectOUList = new ArrayList<String>();
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                JSONObject singleResultFormat = this.commit(jsonObj, auditIdList, auditObjectIdList, objectOUList);
                this.outputFormat.put((Object)singleResultFormat);
            }
            if (!auditObjectIdList.isEmpty()) {
                Integer userObjectId = 1;
                Long viewId = FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID;
                if (this.isComputerObject()) {
                    userObjectId = 3;
                    viewId = FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID;
                }
                this.triggerNotification(auditIdList, auditObjectIdList, userObjectId, null, this.reportId, viewId, objectOUList);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject commit(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singelResultJsonFormat = new JSONObject();
        singelResultJsonFormat = this.addRemoveGroups(jsonObj, auditIdList, auditObjectIdList, objectOUList);
        return singelResultJsonFormat;
    }

    public JSONObject addRemoveGroups(JSONObject jsonObj, ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, ArrayList<String> objectOUList) {
        JSONObject singleResultJsonFormat = new JSONObject();
        ArrayList<String> modifiedMemberOfValues = new ArrayList<String>();
        ArrayList<Properties> modifyMembersList = new ArrayList<Properties>();
        try {
            int i;
            int errorFlag = 0;
            String userPrincipalName = jsonObj.getString("userPrincipalName");
            String sid = jsonObj.getString("objectSID");
            String sAMAccountName = jsonObj.getString("sAMAccountName");
            String userDN = jsonObj.getString("distinguishedName");
            String fullName = "";
            if (jsonObj.has("name")) {
                fullName = jsonObj.getString("name");
            }
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            String hostId = this.request.getRemoteHost();
            hostId = hostId == null ? "Mobile" : hostId;
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            String moduleUsed = this.getModule();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)hostId, (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)moduleUsed);
            auditIdList.add(audit_id);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, null, null, (String)sAMAccountName, (String)this.domainName, (DataObject)auditDataObj, (Boolean)true);
            audit_info.put("object_id", object_id);
            String status = "";
            String groupModifyStatusMessage = "";
            singleResultJsonFormat.put("objectSID", (Object)sid);
            singleResultJsonFormat.put("userPrincipalName", (Object)userPrincipalName);
            singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
            StringBuffer message = new StringBuffer();
            ArrayList<String> addToGroupList = new ArrayList<String>();
            ArrayList<String> addToGroupNameList = new ArrayList<String>();
            ArrayList<String> removeFromGroupSidList = new ArrayList<String>();
            ArrayList<String> removeFromGroupNameList = new ArrayList<String>();
            for (i = 0; i < this.addGroup.length(); ++i) {
                JSONObject addGroupJSON = (JSONObject)this.addGroup.get(i);
                String groupDN = (String)addGroupJSON.get("distinguishedName");
                String groupName = "";
                if (addGroupJSON.has("groupName")) {
                    groupName = (String)addGroupJSON.get("groupName");
                }
                addToGroupList.add(groupDN);
                addToGroupNameList.add(groupName);
            }
            for (i = 0; i < this.removeGroup.length(); ++i) {
                JSONObject removeGroupJSON = (JSONObject)this.removeGroup.get(i);
                String groupName = "";
                if (removeGroupJSON.has("groupName")) {
                    groupName = (String)removeGroupJSON.get("groupName");
                }
                removeFromGroupSidList.add((String)removeGroupJSON.get("SID"));
                removeFromGroupNameList.add(groupName);
            }
            int noOfFailure = 0;
            int noOfOperation = 0;
            ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
            if (this.primaryGroup.length() != 0) {
                if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)this.primaryGroupActionId)) {
                    ++noOfOperation;
                    handleErrorList = new ArrayList();
                    ArrayList<Properties> removeGroupUserPropList = new ArrayList<Properties>();
                    Properties prop1 = new Properties();
                    prop1.put("ATTRIB_VALUE", userDN);
                    prop1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    prop1.put("DATA_HANDLER_TYPE", new Long(1L));
                    prop1.put("ATTRIB_LDAP_NAME", "member");
                    prop1.put("DW_CONTROL_CODE", new Long(3L));
                    removeGroupUserPropList.add(prop1);
                    String primaryGroupSID = (String)this.primaryGroup.get("primaryGroupSID");
                    String primaryGroupName = "";
                    if (this.primaryGroup.has("primaryGroupName")) {
                        primaryGroupName = (String)this.primaryGroup.get("primaryGroupName");
                    }
                    try {
                        ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)primaryGroupSID, (String)userDN, removeGroupUserPropList, null, (boolean)true);
                    }
                    catch (LocalizedException le) {
                        this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                        status = le.getMsgFromDetails(this.rb);
                    }
                    catch (Exception e) {
                        message.append(e.getMessage());
                        status = e.getMessage();
                    }
                    this.fillAttribs(removeGroupUserPropList, "memberOf", primaryGroupName);
                    ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                    String groupSID = primaryGroupSID;
                    groupSID = groupSID.substring(groupSID.lastIndexOf("-") + 1);
                    Properties prop3 = new Properties();
                    prop3.put("ATTRIB_LDAP_NAME", "primaryGroupID");
                    prop3.put("ATTRIB_VALUE", groupSID);
                    prop3.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    prop3.put("DATA_HANDLER_TYPE", new Long(3L));
                    setAttributeList.add(prop3);
                    String successMsg = this.rb.getString("admp.mgmt.mod_grp_attribs.statmsg.primary_group_success");
                    try {
                        ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)this.loginId, (String)sid, (String)userDN, setAttributeList, new ArrayList(), null, null);
                    }
                    catch (LocalizedException le) {
                        Hashtable<String, String> primaryGroupErrorDetails = new Hashtable<String, String>();
                        primaryGroupErrorDetails.put("ERROR_MESSAGE", le.getMessage(this.rb));
                        primaryGroupErrorDetails.put("NATIVE_ERROR_MESSAGE", le.getMessage(this.rb));
                        handleErrorList.add(primaryGroupErrorDetails);
                        status = le.getMsgFromDetails(this.rb);
                        successMsg = "";
                        ++noOfFailure;
                    }
                    catch (Exception e) {
                        message.append(e.getMessage());
                        status = e.getMessage();
                        successMsg = "";
                    }
                    groupModifyStatusMessage = GroupErrorHandler.setPrimaryGroupStatusMessage(handleErrorList, successMsg, this.rb);
                    message.append(groupModifyStatusMessage);
                    if (primaryGroupName != null) {
                        modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.common.attrib_disp_name.primary_group") + "</B> : <br/>" + primaryGroupName);
                    }
                    logger.log(Level.INFO, "User Mgmt - Primary Group Message " + groupModifyStatusMessage);
                } else {
                    message.append(this.unAuthorizedPrimaryGroupText);
                }
            }
            if (this.isRemoveFromAllGroup.booleanValue()) {
                Properties props1;
                String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + CommonUtil.escapeSpecialCharacters((String)userDN) + "))";
                Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
                ArrayList<String> groupAttributeList = new ArrayList<String>();
                groupAttributeList.add("cn");
                groupAttributeList.add("distinguishedName");
                groupAttributeList.add("objectSid");
                ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
                removeFromGroupSidList = new ArrayList();
                removeFromGroupNameList = new ArrayList();
                ArrayList<Properties> authorizedGrouplistProps = new ArrayList<Properties>();
                if (!grouplistProps.isEmpty()) {
                    this.populateIncludedAndExcludedGroup(this.domainName, this.loginId);
                    for (int index = 0; index < grouplistProps.size(); ++index) {
                        props1 = (Properties)grouplistProps.get(index);
                        if (props1 == null) continue;
                        ArrayList ouDNList = (ArrayList)props1.get("distinguishedName");
                        String ouDN = (String)ouDNList.get(0);
                        if (!HelpdeskUtil.isExcludedGroup((String)ouDN, (ArrayList)this.groupExcludeList) && HelpdeskUtil.isAuthorizedGroup((String)ouDN, (ArrayList)this.groupIncludeList)) {
                            authorizedGrouplistProps.add(props1);
                            continue;
                        }
                        logger.log(Level.INFO, "Not Authorized Group- " + ouDN);
                    }
                }
                if (authorizedGrouplistProps.isEmpty()) {
                    if (message.length() != 0) {
                        message.append(". ");
                    }
                    if (!grouplistProps.isEmpty()) {
                        message.append((CharSequence)new StringBuilder(this.rb.getString("groupmanagement.messages.not_authorized_remove_group")));
                    } else {
                        message.append((CharSequence)new StringBuilder(this.rb.getString("admp.workflow.view_request.stat_msg.user_not_part_of_any_group_other_than_primary")));
                    }
                    ++noOfFailure;
                } else {
                    for (int index = 0; index < authorizedGrouplistProps.size(); ++index) {
                        props1 = (Properties)authorizedGrouplistProps.get(index);
                        if (props1 == null) continue;
                        ArrayList groupObjectSid = (ArrayList)props1.get("objectSid");
                        removeFromGroupSidList.add((String)groupObjectSid.get(0));
                        ArrayList groupObjectName = (ArrayList)props1.get("cn");
                        removeFromGroupNameList.add((String)groupObjectName.get(0));
                    }
                }
            }
            if (!removeFromGroupSidList.isEmpty()) {
                if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)this.removeFromGroupActionId)) {
                    ++noOfOperation;
                    String userPrimaryGroup = "";
                    handleErrorList = new ArrayList();
                    ArrayList<Properties> removeGroupUserPropList = new ArrayList<Properties>();
                    Properties prop = new Properties();
                    prop.put("ATTRIB_VALUE", userDN);
                    prop.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    prop.put("DATA_HANDLER_TYPE", new Long(3L));
                    prop.put("ATTRIB_LDAP_NAME", "member");
                    prop.put("DW_CONTROL_CODE", new Long(4L));
                    removeGroupUserPropList.add(prop);
                    boolean flag = false;
                    int removeFailCount = 0;
                    for (int index = 0; index < removeFromGroupSidList.size(); ++index) {
                        try {
                            ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)((String)removeFromGroupSidList.get(index)), (String)userDN, removeGroupUserPropList, null, (boolean)true);
                            continue;
                        }
                        catch (LocalizedException le) {
                            this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                            status = le.getMsgFromDetails(this.rb);
                            flag = true;
                            ++removeFailCount;
                            continue;
                        }
                        catch (Exception ex) {
                            message.append(ex.getMessage());
                            status = ex.getMessage();
                            flag = true;
                            ++removeFailCount;
                        }
                    }
                    if (flag) {
                        ++noOfFailure;
                        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(this.baseTableName, new Criteria(Column.getColumn((String)this.baseTableName, (String)"DISTINGUISHED_NAME"), (Object)userDN, 0));
                        Iterator rows = dataObj.getRows(this.baseTableName);
                        while (rows.hasNext()) {
                            Row r = (Row)rows.next();
                            userPrimaryGroup = (String)r.get("PRIMARY_GROUP_ID");
                        }
                    }
                    groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, removeFromGroupSidList.size(), this.rb, removeFromGroupNameList, userPrimaryGroup, "remove", removeFailCount);
                    message.append(groupModifyStatusMessage);
                    logger.log(Level.INFO, "User Mgmt - Remove from Group Message " + groupModifyStatusMessage);
                    this.fillAttribs(removeGroupUserPropList, "memberOf", removeFromGroupNameList);
                    StringBuilder removeGroupStr = new StringBuilder();
                    if (removeFromGroupNameList != null && !removeFromGroupNameList.isEmpty()) {
                        for (String removedGroup : removeFromGroupNameList) {
                            if (removeGroupStr.length() > 0) {
                                removeGroupStr.append(", ");
                            }
                            removeGroupStr.append(removedGroup);
                        }
                    } else {
                        removeGroupStr.append("-");
                    }
                    modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.removed") + "</B> : <br/>" + removeGroupStr);
                } else {
                    message.append(this.unAuthorizedRemoveGroupText);
                }
            }
            if (!addToGroupList.isEmpty()) {
                if (ClientUtil.checkAuthorization(this.domainVsIds, this.domainName, (long)this.addToGroupActionId)) {
                    ArrayList<Properties> list = new ArrayList<Properties>();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", addToGroupList);
                    p.put("ATTRIB_VALUE_COUNT", new Long(addToGroupList.size()));
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(3L));
                    list.add(p);
                    ++noOfOperation;
                    try {
                        NativeError errHdlr = ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)sid, (String)userDN, null, addToGroupList, (boolean)true);
                        for (int index = 0; index < addToGroupList.size(); ++index) {
                            String errorSeverity = errHdlr.getSeverityLevel(addToGroupList.get(index));
                            if (errorSeverity == null || !errorSeverity.equals("WARNING")) continue;
                            Hashtable errorDetails = errHdlr.getErrorDetails(addToGroupList.get(index));
                            if (errorDetails != null) {
                                handleErrorList.add(errorDetails);
                            }
                            ++errorFlag;
                        }
                    }
                    catch (LocalizedException le) {
                        this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                        ++noOfFailure;
                        status = le.getMsgFromDetails(this.rb);
                    }
                    catch (Exception ex) {
                        message.append(ex.getMessage());
                        ++noOfFailure;
                        status = ex.getMessage();
                    }
                    if (addToGroupList.size() == errorFlag) {
                        ++noOfFailure;
                    }
                    groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, addToGroupList.size(), this.rb, removeFromGroupSidList, "primaryGroupSid", "add", errorFlag);
                    message.append(groupModifyStatusMessage);
                    this.fillAttribs(list, "memberOf", addToGroupNameList);
                    StringBuilder addedGroupsStr = new StringBuilder();
                    if (addToGroupNameList != null && !addToGroupNameList.isEmpty()) {
                        for (String addedGroup : addToGroupNameList) {
                            if (addedGroupsStr.length() > 0) {
                                addedGroupsStr.append(", ");
                            }
                            addedGroupsStr.append(addedGroup);
                        }
                    } else {
                        addedGroupsStr.append("-");
                    }
                    modifiedMemberOfValues.add("<B>" + this.rb.getString("admp.audit.display_text.added") + "</B> : <br/>" + addedGroupsStr);
                    logger.log(Level.INFO, "User Mgmt - Add To Group Message " + groupModifyStatusMessage);
                } else {
                    message.append(this.unAuthorizedAddGroupText);
                }
            }
            if (noOfFailure == noOfOperation) {
                message.insert(0, this.unableToModifyText);
            } else if (noOfFailure == 0) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            } else if (noOfFailure < noOfOperation) {
                message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.partially_modified") + ". ");
            }
            if (noOfFailure == 0) {
                singleResultJsonFormat.put("status", (Object)"1");
            } else {
                singleResultJsonFormat.put("status", (Object)"0");
            }
            if (noOfFailure < noOfOperation) {
                auditObjectIdList.add(object_id);
            }
            singleResultJsonFormat.put("statusMessage", (Object)message);
            audit_info.put("error_msg", message.toString());
            Properties auditProps = new Properties();
            auditProps.put("ATTRIB_VALUE", modifiedMemberOfValues);
            auditProps.put("ATTRIB_VALUE_COUNT", new Long(modifiedMemberOfValues.size()));
            auditProps.put("DATA_HANDLER_TYPE", new Long(3L));
            auditProps.put("ATTRIB_LDAP_NAME", "memberOf");
            auditProps.put("DW_CONTROL_CODE", new Long(4L));
            modifyMembersList.add(auditProps);
            TechAuditAPI.getInstance().auditUserModification(this.loginId, this.rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.add_to_group"), fullName, this.domainName, modifyMembersList, new ArrayList(), new ArrayList(), status, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)userDN);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
        }
        catch (Exception e) {
            try {
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.unableToModifyText);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            e.printStackTrace();
        }
        return singleResultJsonFormat;
    }

    public void fillResultFormat() {
        JSONObject singleResultJsonFormat = new JSONObject();
        try {
            int size = this.inputFormat.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObj = this.inputFormat.getJSONObject(i);
                String guid = jsonObj.getString("objectSID");
                String name = jsonObj.getString("userPrincipalName");
                String sAMAccountName = jsonObj.getString("sAMAccountName");
                singleResultJsonFormat = new JSONObject();
                singleResultJsonFormat.put("sAMAccountName", (Object)sAMAccountName);
                singleResultJsonFormat.put("userPrincipalName", (Object)name);
                singleResultJsonFormat.put("objectSID", (Object)guid);
                singleResultJsonFormat.put("status", (Object)"0");
                singleResultJsonFormat.put("statusMessage", (Object)this.unableToModifyText);
                this.outputFormat.put((Object)singleResultJsonFormat);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }

    public void fillAttribs(ArrayList list, String attribName, Object attribValue) {
        Properties prop = (Properties)list.get(0);
        prop.put("ATTRIB_LDAP_NAME", attribName);
        if (attribValue instanceof String) {
            prop.put("ATTRIB_VALUE", attribValue.toString());
        } else if (attribValue instanceof ArrayList) {
            prop.put("ATTRIB_LDAP_NAME", attribName);
            prop.put("ATTRIB_VALUE_COUNT", (Object)2L);
            prop.put("ATTRIB_VALUE", attribValue);
        }
    }

    public void populateIncludedAndExcludedGroup(String domainName, Long loginId) {
        Hashtable includeExcludeGroupOUMap = HelpdeskUtil.getIncludeExcludeGroupOUMap((Long)loginId, (String)domainName);
        this.groupIncludeList = (ArrayList)includeExcludeGroupOUMap.get("INCLUDED_GROUPOU");
        this.groupExcludeList = (ArrayList)includeExcludeGroupOUMap.get("EXCLUDED_GROUPOU");
    }
}

