/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobileCommitListener
extends AbstractListener {
    private boolean isCompleted = true;
    protected Long loginId = null;
    protected String domainName = "erp";
    protected JSONArray inputFormat = null;
    protected JSONArray outputFormat = null;
    protected HttpServletRequest request = null;
    protected String objectType = "user";
    protected Long actionId = null;
    protected Boolean isLicenseRestricted = false;

    public MobileCommitListener(HttpServletRequest request) {
        this.request = request;
        this.domainName = request.getParameter("domainName");
        this.loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        this.outputFormat = new JSONArray();
        this.rb = ResourceBundleMgr.getInstance().getBundle(request);
        this.initAPILicenseRestriction();
    }

    public void initAPILicenseRestriction() {
        String val;
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("servicenow", "zendesk"));
        String source = this.request.getParameter("PRODUCT_NAME");
        if (source == null) {
            source = this.request.getParameter("source");
        }
        if (source == null) {
            source = "";
        }
        if ("true".equalsIgnoreCase(val = (String)this.request.getAttribute("isLicenseRestricted")) || list.contains(source.toLowerCase())) {
            this.isLicenseRestricted = true;
        }
    }

    public void setObjectType(String objType) {
        this.objectType = objType;
    }

    public void getInputRecords() throws Exception {
        Boolean doAllObjects = false;
        if (this.request.getParameter("doAllObjects") != null) {
            doAllObjects = new Boolean(this.request.getParameter("doAllObjects"));
        }
        if (doAllObjects.booleanValue()) {
            this.inputFormat = this.prepareInputFormatForAllObjects(this.request);
        } else {
            try {
                String inputFormatString = this.request.getParameter("inputFormat");
                this.inputFormat = new JSONArray(inputFormatString.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
                throw new Exception("00000016");
            }
        }
    }

    private JSONArray prepareInputFormatForAllObjects(HttpServletRequest request) {
        Long generationId = Long.parseLong(request.getParameter("generationId"));
        Integer reportId = Integer.parseInt(request.getParameter("reportId"));
        String searchText = "";
        if (request.getParameter("searchText") != null) {
            String searchPattern = request.getParameter("searchText");
            searchText = !searchPattern.equals("") ? "*" + searchPattern + "*" : "*";
        }
        Row r = ReportHandler.getReportDetailsRow((Integer)reportId);
        String resultTableName = (String)r.get("RESULT_TABLE_NAME");
        String reportBaseTableName = (String)r.get("BASE_TABLE_NAME");
        String tableKey = "OBJECT_GUID";
        ArrayList<Integer> attrList = new ArrayList<Integer>();
        if (this.isUserObject()) {
            attrList.add(1005);
            attrList.add(1144);
            attrList.add(1006);
            attrList.add(1145);
            attrList.add(1004);
        } else if (this.isComputerObject()) {
            attrList.add(3001);
            attrList.add(3018);
            attrList.add(3032);
            attrList.add(3017);
            attrList.add(3020);
        }
        ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributeProps(attrList);
        JSONArray inputFormat = new JSONArray();
        boolean isCompleted = false;
        int startIndex = 1;
        int range = 50;
        while (!isCompleted) {
            ArrayList reportObjectList = ReportResultUtil.getRowsForAPI(generationId, resultTableName, reportBaseTableName, attributeList, startIndex, range, searchText, tableKey);
            try {
                for (int i = 0; i < reportObjectList.size(); ++i) {
                    JSONObject jsonObj = new JSONObject();
                    Properties prop = (Properties)reportObjectList.get(i);
                    if (this.isUserObject()) {
                        jsonObj.put("userPrincipalName", prop.get("LOGON_NAME"));
                        jsonObj.put("sAMAccountName", prop.get("SAM_ACCOUNT_NAME"));
                    } else if (this.isComputerObject()) {
                        jsonObj.put("userPrincipalName", prop.get("COMPUTER_NAME"));
                        jsonObj.put("sAMAccountName", prop.get("COMPUTER_NAME"));
                    }
                    jsonObj.put("objectSID", prop.get("SID_STRING"));
                    jsonObj.put("objectGUID", prop.get("OBJECT_GUID"));
                    jsonObj.put("distinguishedName", prop.get("DISTINGUISHED_NAME"));
                    inputFormat.put((Object)jsonObj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (reportObjectList == null || reportObjectList.size() == 0) {
                isCompleted = true;
            }
            startIndex += range;
        }
        return inputFormat;
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public JSONArray getFormattedResult() {
        return this.outputFormat;
    }

    public boolean isUserObject() {
        return this.objectType == null || this.objectType.equalsIgnoreCase("user");
    }

    public boolean isComputerObject() {
        return this.objectType != null && this.objectType.equalsIgnoreCase("computer");
    }

    public void triggerNotification(ArrayList<Long> auditIdList, ArrayList<Long> auditObjectIdList, Integer objectId, Hashtable nameVsDetails, Integer reportId, Long viewId, ArrayList<String> objectOUList) {
        try {
            MgmtNotificationListener notifyListener = new MgmtNotificationListener();
            ArrayList viewColumnList = ColumnConfiguration.getColumnList((long)viewId, (int)2);
            if (nameVsDetails == null) {
                nameVsDetails = new Hashtable();
            }
            notifyListener.triggerNotification(auditIdList, auditObjectIdList, objectId, nameVsDetails, this.loginId, reportId, this.domainName, this.rb, this.getViewColumnList(viewId), objectOUList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList getViewColumnList(Long viewId) {
        ArrayList columnList = null;
        try {
            if (viewId.equals(FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID)) {
                columnList = ColumnConfiguration.getColumnList((long)viewId, (int)2);
            } else if (viewId.equals(FcExecuteActionConstants.BCPC_LAYOUT_VIEW_ID)) {
                columnList = new ArrayList();
                HashMap<String, String> attributeProp1 = new HashMap<String, String>();
                attributeProp1.put("COLUMN_NAME", "admp.common.attrib_disp_name.full_name");
                attributeProp1.put("COL_NAME", "FULL_NAME");
                columnList.add(attributeProp1);
                HashMap<String, String> attributeProp2 = new HashMap<String, String>();
                attributeProp2.put("COLUMN_NAME", "admp.common.attrib_disp_name.desc");
                attributeProp2.put("COL_NAME", "DESCRIPTION");
                columnList.add(attributeProp2);
                HashMap<String, String> attributeProp3 = new HashMap<String, String>();
                attributeProp3.put("COLUMN_NAME", "admp.common.attrib_disp_name.manager");
                attributeProp3.put("COL_NAME", "MANAGER");
                columnList.add(attributeProp3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnList;
    }

    protected String getModule() {
        String source;
        String module = "";
        String userAgent = this.request.getHeader("user-agent");
        String string = source = this.request.getParameter("PRODUCT_NAME") != null ? this.request.getParameter("PRODUCT_NAME") : this.request.getParameter("source");
        if (source != null) {
            return source;
        }
        if (userAgent != null && !userAgent.isEmpty()) {
            module = userAgent.equals("ADMPAndroid") ? this.rb.getString("admp.mobile.android.androidapp") : (userAgent.contains("admp") ? this.rb.getString("admp.mobile.android.iphoneapp") : this.rb.getString("admp.home.text.sd_plus"));
        }
        return module;
    }

    protected Properties getUserDetails(String sAMAccountName) {
        Properties properties = new Properties();
        String tableName = "ADSMUserGeneralDetails";
        try {
            Table baseTable = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Criteria criteria = new Criteria(new Column(tableName, "SAM_ACCOUNT_NAME"), (Object)sAMAccountName, 0);
            criteria = criteria.and(new Criteria(new Column(tableName, "DOMAIN_NAME"), (Object)this.domainName, 0));
            criteria = criteria.and(new Criteria(new Column(tableName, "IS_DELETED"), (Object)new Integer(1), 0));
            query.addSelectColumn(new Column(tableName, "LOGON_NAME"));
            query.addSelectColumn(new Column(tableName, "OBJECT_GUID"));
            query.addSelectColumn(new Column(tableName, "SID_STRING"));
            query.addSelectColumn(new Column(tableName, "DISTINGUISHED_NAME"));
            query.addSelectColumn(new Column(tableName, "SAM_ACCOUNT_NAME"));
            query.setCriteria(criteria);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                if (r.get("LOGON_NAME") == null || ((String)r.get("LOGON_NAME")).equalsIgnoreCase("")) {
                    return this.getUserDetailsAD(sAMAccountName);
                }
                properties.put("SAM_ACCOUNT_NAME", (String)r.get("SAM_ACCOUNT_NAME"));
                properties.put("LOGON_NAME", (String)r.get("LOGON_NAME"));
                properties.put("OBJECT_GUID", (String)r.get("OBJECT_GUID"));
                properties.put("SID_STRING", (String)r.get("SID_STRING"));
                properties.put("DISTINGUISHED_NAME", (String)r.get("DISTINGUISHED_NAME"));
            } else {
                properties = this.getUserDetailsAD(sAMAccountName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    private Properties getUserDetailsAD(String sAMAccountName) {
        Properties properties = new Properties();
        String tableName = "ADSMUserGeneralDetails";
        ArrayList<String> attributeList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        try {
            attributeList.add("sAMAccountName");
            attributeList.add("objectGUID");
            attributeList.add("objectSid");
            attributeList.add("userPrincipalName");
            attributeList.add("distinguishedName");
            String searchString = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + sAMAccountName + "))";
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)this.loginId);
            list = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, (String)searchString);
            if (list.size() > 0) {
                Properties p = (Properties)list.get(0);
                properties.put("SAM_ACCOUNT_NAME", StrUtil.getString((Properties)p, (String)"sAMAccountName"));
                properties.put("LOGON_NAME", StrUtil.getString((Properties)p, (String)"userPrincipalName"));
                properties.put("OBJECT_GUID", StrUtil.getString((Properties)p, (String)"objectGUID"));
                properties.put("SID_STRING", StrUtil.getString((Properties)p, (String)"objectSid"));
                properties.put("DISTINGUISHED_NAME", StrUtil.getString((Properties)p, (String)"distinguishedName"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public void setActionId(Long actionId) {
        this.actionId = actionId;
    }
}

