/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.clientapi.mgmt;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.clientapi.mgmt.MobileCommitListener;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.cvc.CVCDataUtil;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtErrorHandler;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtTask;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerTaskManager;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerTaskMgmtUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.MgmtTask;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFTask;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskSet;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RestAPIFSMHandler
extends MobileCommitListener {
    JSONObject foldersComponent = new JSONObject();
    JSONObject checkBoxComponent = new JSONObject();
    JSONObject revertDurationComponent = new JSONObject();
    JSONObject folderLevelComponent = new JSONObject();
    JSONArray permissionsComponent = new JSONArray();
    Boolean isInherited = true;
    Boolean removeExisting = false;
    Boolean applyInherit = false;
    String duration = "0";
    String durationType = "-";
    Integer reportId = 0;
    Long thirdPartyRequestId = 0L;
    Long timeOut = 10L;

    public RestAPIFSMHandler(HttpServletRequest request) throws Exception {
        super(request);
    }

    public boolean checkAuthorization() {
        boolean isAuthorized = false;
        try {
            ADMPAuthObject authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsIds = authObject.getDomainActionMap();
            isAuthorized = ClientUtil.checkAuthorization(domainVsIds, this.domainName, (long)this.actionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorized;
    }

    public void init() {
        try {
            String reqId;
            JSONObject additionalDataJson;
            String foldersString = this.request.getParameter("folders");
            this.foldersComponent = new JSONObject().put("folder", (Object)new JSONObject(foldersString));
            String permissionString = this.request.getParameter("PERMISSION_COMPONENT");
            this.permissionsComponent = new JSONArray(permissionString);
            if (this.request.getParameter("IsInherited") != null) {
                this.isInherited = new Boolean(this.request.getParameter("IsInherited"));
            }
            if (this.request.getParameter("RemoveExisting") != null) {
                this.removeExisting = new Boolean(this.request.getParameter("RemoveExisting"));
            }
            if (this.request.getParameter("ApplyInherit") != null) {
                this.applyInherit = new Boolean(this.request.getParameter("ApplyInherit"));
            }
            this.checkBoxComponent = new JSONObject();
            this.checkBoxComponent.put("IsInherited", (Object)this.isInherited);
            this.checkBoxComponent.put("RemoveExisting", (Object)this.removeExisting);
            this.checkBoxComponent.put("ApplyInherit", (Object)this.applyInherit);
            this.revertDurationComponent = new JSONObject();
            String revertDurationString = this.request.getParameter("revertDuration");
            if (revertDurationString != null && !revertDurationString.equals("")) {
                this.revertDurationComponent = new JSONObject(revertDurationString);
                this.duration = this.revertDurationComponent.getString("duration");
                this.durationType = this.revertDurationComponent.getString("durationType");
            }
            Integer folderlevel = 0;
            String folderLevelString = this.request.getParameter("FolderLevel");
            if (folderLevelString != null && !folderLevelString.equals("")) {
                folderlevel = new Integer(this.request.getParameter("FolderLevel"));
            }
            this.folderLevelComponent = new JSONObject();
            this.folderLevelComponent.put("folderlevel", (Object)folderlevel);
            String additionalData = this.request.getParameter("additionalData");
            if (additionalData != null && !additionalData.equals("") && (additionalDataJson = new JSONObject(additionalData)).has("reqId") && !(reqId = String.valueOf(additionalDataJson.get("reqId"))).equals("-") && !reqId.equals("")) {
                this.thirdPartyRequestId = Long.valueOf(reqId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void commitAPIRequest() {
        try {
            JSONObject singleResultFormat = new JSONObject();
            String folderPath = "";
            String foldersString = this.request.getParameter("folders");
            JSONObject folders = new JSONObject(foldersString);
            Iterator it = folders.keys();
            if (it.hasNext()) {
                folderPath = (String)it.next();
            }
            if (!RestAPIFSMHandler.isValidFileServer(folderPath, this.loginId).booleanValue()) {
                singleResultFormat.put("status", (Object)"0");
                singleResultFormat.put("statusMessage", (Object)this.rb.getString("admp.admin.tp_integ.perm_mgmt.not_have_access_to_the_computer"));
                this.outputFormat.put((Object)singleResultFormat);
                return;
            }
            this.init();
            HttpSession session = this.request.getSession();
            session.setAttribute("ADMP_SESSION_LOGIN_ID", this.request.getAttribute("ADMP_SESSION_LOGIN_ID"));
            if (this.actionId == 1909L) {
                this.reportId = 8001;
                Long actionTypeId = 1L;
                String actionValueId = "";
                String actionValue = "";
                if (this.request.getParameter("actionId") != null) {
                    actionTypeId = new Long(this.request.getParameter("actionId"));
                    actionValueId = this.request.getParameter("actionValueId");
                    actionValue = this.request.getParameter("actionValue");
                }
                try {
                    if (!this.durationType.equals("-") && !this.duration.equals("0")) {
                        JSONArray multipleInput = new JSONArray();
                        JSONObject fieldObj = new JSONObject();
                        fieldObj.put("label", (Object)"FOLDER_SELECTION_COMPONENT");
                        fieldObj.put("value", (Object)this.foldersComponent);
                        fieldObj.put("isSelected", (Object)"false");
                        multipleInput.put((Object)fieldObj);
                        fieldObj = new JSONObject();
                        fieldObj.put("label", (Object)"PERMISSION_COMPONENT");
                        fieldObj.put("value", (Object)this.permissionsComponent);
                        fieldObj.put("isSelected", (Object)"false");
                        multipleInput.put((Object)fieldObj);
                        fieldObj = new JSONObject();
                        fieldObj.put("label", (Object)"REVERT_PERMISSION_DURATION");
                        fieldObj.put("value", (Object)this.revertDurationComponent);
                        fieldObj.put("isSelected", (Object)"false");
                        multipleInput.put((Object)fieldObj);
                        JSONObject inputValue = new JSONObject();
                        inputValue.put("name", (Object)"");
                        inputValue.put("value", (Object)"");
                        inputValue.put("isMultiple", (Object)"true");
                        inputValue.put("singleInputId", (Object)"-1");
                        inputValue.put("multipleInput", (Object)multipleInput);
                        JSONObject paramsJSON = new JSONObject();
                        paramsJSON.put("subject", (Object)this.rb.getString("admp.admin.tp_integ.perm_mgmt.set_folder_permission"));
                        paramsJSON.put("description", (Object)MessageFormat.format(this.rb.getString("admp.admin.tp_integ.perm_mgmt.workflow_request.description"), this.getModule()));
                        paramsJSON.put("requestAction", 5001);
                        paramsJSON.put("domainName", (Object)this.domainName);
                        paramsJSON.put("priority", 1);
                        paramsJSON.put("categoryId", 5);
                        paramsJSON.put("inputValue", (Object)inputValue);
                        paramsJSON.put("guidList", (Object)this.guidList);
                        JSONObject guidJSON = this.permissionsComponent.getJSONObject(0).getJSONObject("account").getJSONObject("user");
                        ArrayList<String> sidList = new ArrayList<String>();
                        Iterator itr = guidJSON.keys();
                        while (itr.hasNext()) {
                            sidList.add((String)itr.next());
                        }
                        WorkFlowClientUtil.createRequest(this.request, paramsJSON, sidList, this.reportId);
                        Long requestId = (Long)this.request.getAttribute("requestId");
                        WFViewRequest wfViewRequest = new WFViewRequest(requestId, this.rb);
                        ArrayList wfTaskSetList = wfViewRequest.getInstantTaskSetList();
                        if (actionTypeId != 1L) {
                            for (WFTaskSet wfTaskSet : wfTaskSetList) {
                                for (WFTask wfTask : wfTaskSet.getAdmpTaskList()) {
                                    Long reqMonitirTaskId = wfTask.getReqMonitorTaskId();
                                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"WFCVCDataSummary"));
                                    Criteria criteria = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"REQ_MONITOR_TASK_ID"), (Object)reqMonitirTaskId, 0);
                                    query.setCriteria(criteria);
                                    query.addSelectColumn(new Column("WFCVCDataSummary", "*"));
                                    DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                                    Row row = dataObject.getFirstRow("WFCVCDataSummary");
                                    row.set("ACTION_ID", (Object)actionTypeId);
                                    row.set("ACTION_VALUE", (Object)actionValue);
                                    row.set("ACTION_VALUE_ID", (Object)actionValueId);
                                    dataObject.updateRow(row);
                                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                                }
                            }
                        }
                        String comment = MessageFormat.format(this.rb.getString("admp.admin.tp_integ.perm_mgmt.workflow_request.comment"), this.getModule());
                        if (this.thirdPartyRequestId != 0L) {
                            comment = MessageFormat.format(this.rb.getString("admp.admin.tp_integ.perm_mgmt.workflow_request.comment_with_req_id"), this.getModule(), this.thirdPartyRequestId);
                        }
                        wfViewRequest.setAdditionalExecutionActions(new ArrayList());
                        String message = wfViewRequest.commitRequestedTask(this.loginId, comment, this.rb);
                        for (WFTaskSet wfTaskSet : wfTaskSetList) {
                            for (WFTask wfTask : wfTaskSet.getAdmpTaskList()) {
                                Long reqMonitirTaskId = wfTask.getReqMonitorTaskId();
                                Hashtable<String, Object> requestProperties = new Hashtable<String, Object>();
                                requestProperties.put("RANGE", 25);
                                requestProperties.put("FROM_INDEX", 1L);
                                requestProperties.put("ascending", "true");
                                requestProperties.put("attributeId", wfTask.getSortColumnId());
                                ArrayList resultList = wfTask.getRequestResultRows(requestProperties, wfTask.getColumnList(), new Hashtable());
                                message = (String)((HashMap)resultList.get(0)).get(1101454);
                            }
                        }
                        singleResultFormat.put("status", (Object)"1");
                        singleResultFormat.put("requestId", (Object)requestId);
                        singleResultFormat.put("statusMessage", (Object)(this.rb.getString(message) + " " + this.rb.getString("admp.admin.tp_integ.perm_mgmt.refer_admp_wf_for_successive_task")));
                    } else {
                        String accountId = (String)this.permissionsComponent.getJSONObject(0).getJSONObject("account").getJSONObject("user").keys().next();
                        if (actionTypeId == 1L) {
                            singleResultFormat = this.setFolderPermissionToFolder();
                        } else if (actionTypeId == 2L) {
                            singleResultFormat = this.addToGroup(actionValueId, actionValue, accountId, true);
                        } else if (actionTypeId == 3L) {
                            singleResultFormat = this.addToGroupAndAssignToFolder(actionValueId, actionValue, accountId);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    singleResultFormat.put("status", (Object)"0");
                    singleResultFormat.put("statusMessage", (Object)this.rb.getString("admp.workflow.workflow_result.problem_in_setting_permission"));
                }
            } else if (this.actionId == 1910L) {
                this.reportId = 8002;
                singleResultFormat = this.removeFolderPermission();
            }
            this.outputFormat.put((Object)singleResultFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JSONObject setFolderPermissionToFolder() {
        JSONObject singleResultFormat = new JSONObject();
        try {
            JSONObject cvcData = new JSONObject();
            cvcData.put("FOLDER_SELECTION_COMPONENT", (Object)this.foldersComponent);
            cvcData.put("PERMISSION_COMPONENT", (Object)this.permissionsComponent);
            cvcData.put("CHECK_BOX_COMPONENT", (Object)this.checkBoxComponent);
            singleResultFormat = this.setFolderPermission(cvcData, "modify", 1L, "", "", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return singleResultFormat;
    }

    public JSONObject addToGroup(String actionValueId, String actionValue, String accountId, Boolean isAuditRequired) {
        JSONObject singleResultFormat = new JSONObject();
        String message = this.rb.getString("admp.mgmt.fileserver.perm_mgmt.succesfully_modified");
        String addToGroupNativeErr = null;
        try {
            try {
                ArrayList<String> addToGroupSidList = new ArrayList<String>();
                addToGroupSidList.add(actionValueId);
                String dn = CommonUtil.getDistinguishedName((String)this.domainName, (String)accountId);
                ArrayList groupList = GroupHandler.getDNList((String)this.domainName, addToGroupSidList);
                NativeError errHdlr = ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)this.loginId, (String)accountId, (String)dn, new ArrayList(), (ArrayList)groupList, (boolean)true);
                String errorSeverity = errHdlr.getSeverityLevel(groupList.get(0));
                if (errorSeverity == null) {
                    singleResultFormat.put("status", (Object)"1");
                    singleResultFormat.put("statusMessage", (Object)message);
                } else {
                    Hashtable errorDetails = errHdlr.getErrorDetails(groupList.get(0));
                    message = this.rb.getString("admp.workflow.workflow_result.problem_in_setting_permission");
                    addToGroupNativeErr = (String)errorDetails.get("NATIVE_ERROR_MESSAGE");
                    singleResultFormat.put("status", (Object)"0");
                    singleResultFormat.put("statusMessage", (Object)(this.rb.getString((String)errorDetails.get("ERROR_MESSAGE")) + " " + errorDetails.get("NATIVE_ERROR_MESSAGE")));
                    singleResultFormat.put("addToGroupNativeErr", (Object)addToGroupNativeErr);
                }
            }
            catch (Exception e) {
                message = this.rb.getString("admp.workflow.workflow_result.problem_in_setting_permission");
                singleResultFormat.put("status", (Object)"0");
                singleResultFormat.put("statusMessage", (Object)message);
                e.printStackTrace();
            }
            if (isAuditRequired.booleanValue()) {
                JSONObject cvcData = new JSONObject();
                cvcData.put("FOLDER_SELECTION_COMPONENT", (Object)this.foldersComponent);
                cvcData.put("PERMISSION_COMPONENT", (Object)this.permissionsComponent);
                cvcData.put("CHECK_BOX_COMPONENT", (Object)this.checkBoxComponent);
                DataObject cvcDataDO = CVCDataUtil.saveCVCData((JSONObject)cvcData);
                Long cvcDataId = (Long)cvcDataDO.getFirstRow("CVConfigurationData").get("CVC_DATA_ID");
                Long generationID = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)"", (Long)this.loginId);
                Long folderInputId = (Long)cvcDataDO.getFirstRow("CVCFolderSelectionData").get("INPUT_ID");
                Long permInputId = (Long)cvcDataDO.getFirstRow("CVCPermissionData").get("INPUT_ID");
                Long accessMaskId = (Long)cvcDataDO.getFirstRow("CVCAccessMaskData").get("UNIQUE_ID");
                String folderPath = (String)cvcDataDO.getFirstRow("CVCFolderSelectionData").get("FOLDER_PATH");
                String folderName = (String)cvcDataDO.getFirstRow("CVCFolderSelectionData").get("FOLDER_NAME");
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Row r = new Row("ADSMFolderModificationResult");
                r.set("REPORT_GENERATION_ID", (Object)generationID);
                r.set("FOLDER_PATH", (Object)folderPath);
                r.set("FOLDER_NAME", (Object)folderName);
                r.set("CVC_FOLDER_ID", (Object)folderInputId);
                r.set("CVC_PERMISSION_ID", (Object)accessMaskId);
                r.set("ERROR_CODE", (Object)0L);
                dataObj.addRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                this.setAuditObjectDetails(folderInputId, permInputId, cvcDataId, 2L, actionValue, actionValueId, generationID, addToGroupNativeErr);
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)System.getProperty("user.name"), (Integer)this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)this.rb, (String)this.getModule(), (Long)this.thirdPartyRequestId);
                Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (Long)folderInputId, null, (String)folderPath, (String)this.domainName, (String)"fsm", (Boolean)true, (DataObject)auditDataObj);
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                audit_info.put("object_id", object_id);
                audit_info.put("error_msg", message);
                HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return singleResultFormat;
    }

    public JSONObject addToGroupAndAssignToFolder(String actionValueId, String actionValue, String accountId) {
        JSONObject singleResultFormat = new JSONObject();
        try {
            singleResultFormat = this.addToGroup(actionValueId, actionValue, accountId, false);
            String accountName = "";
            JSONObject valueJSON = this.permissionsComponent.getJSONObject(0).getJSONObject("account").getJSONObject("user");
            Iterator it1 = valueJSON.keys();
            if (it1.hasNext()) {
                accountName = (String)valueJSON.get((String)it1.next());
            }
            JSONObject accountDetails = new JSONObject().put("group", (Object)new JSONObject().put(actionValueId, (Object)accountName));
            this.permissionsComponent.getJSONObject(0).put("account", (Object)accountDetails);
            JSONObject cvcData = new JSONObject();
            cvcData.put("FOLDER_SELECTION_COMPONENT", (Object)this.foldersComponent);
            cvcData.put("PERMISSION_COMPONENT", (Object)this.permissionsComponent);
            cvcData.put("CHECK_BOX_COMPONENT", (Object)this.checkBoxComponent);
            String addToGroupNativeErr = singleResultFormat.has("addToGroupNativeErr") ? singleResultFormat.getString("addToGroupNativeErr") : null;
            singleResultFormat = this.setFolderPermission(cvcData, "modify", 3L, actionValue, actionValueId, addToGroupNativeErr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return singleResultFormat;
    }

    public JSONObject removeFolderPermission() {
        JSONObject singleResultFormat = new JSONObject();
        try {
            JSONObject cvcData = new JSONObject();
            cvcData.put("FOLDER_SELECTION_COMPONENT", (Object)this.foldersComponent);
            cvcData.put("PERMISSION_COMPONENT", (Object)this.permissionsComponent);
            cvcData.put("FOLDER_LEVEL_COMPONENT", (Object)this.folderLevelComponent);
            singleResultFormat = this.setFolderPermission(cvcData, "remove", 6L, "", "", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return singleResultFormat;
    }

    public JSONObject setFolderPermission(JSONObject cvcData, String action, Long actionId, String actionValue, String actionValueId, String errMsg) {
        Long startTime = System.currentTimeMillis();
        JSONObject singleResultFormat = new JSONObject();
        String message = this.rb.getString("admp.mgmt.fileserver.perm_mgmt.succesfully_modified");
        try {
            Long cvcDataId = 0L;
            Long generationId = 0L;
            DataObject rvcDataObject = null;
            ADMPAuthObject authObject = (ADMPAuthObject)this.request.getAttribute("ADMP_AUTH_OBJECT");
            String hostId = this.request.getRemoteHost();
            DataObject cvcDataDO = CVCDataUtil.saveCVCData((JSONObject)cvcData);
            cvcDataId = (Long)cvcDataDO.getFirstRow("CVConfigurationData").get("CVC_DATA_ID");
            Long folderInputId = (Long)cvcDataDO.getFirstRow("CVCFolderSelectionData").get("INPUT_ID");
            Long permInputId = (Long)cvcDataDO.getFirstRow("CVCPermissionData").get("INPUT_ID");
            rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)this.reportId);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            statusUpdater.init(rvcDataObject, cvcDataId);
            generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)"", (Long)this.loginId);
            Long cvId = ColumnConfiguration.getCVId((String)"PermissionMgmt", (long)DelegationUtil.ADMIN_LOGIN_ID);
            ArrayList columnList = ColumnConfiguration.getHeaderColumnList((Long)cvId);
            this.setAuditObjectDetails(folderInputId, permInputId, cvcDataId, actionId, actionValue, actionValueId, generationId, errMsg);
            FileServerMgmtTask task = new FileServerMgmtTask(statusUpdater, generationId, this.loginId, cvcDataDO, action, columnList, this.reportId, hostId, this.rb, authObject);
            task.setmoduleName(this.getModule());
            task.setRequestId(this.thirdPartyRequestId);
            task.setIsWorkFlowMode(Boolean.valueOf(true));
            Boolean ret = FileServerTaskManager.getInstance().addTask((MgmtTask)task, generationId);
            if (!ret.booleanValue()) {
                throw new Exception("ERROR");
            }
            HttpSession session = this.request.getSession();
            CVCUtil.saveDataModelId((String)session.getId(), (Long)this.loginId, (Integer)this.reportId, (Long)cvcDataId, (Long)generationId);
            Row reportToViewMappingrow = rvcDataObject.getRow("ADSMReportToRVCDataMapping");
            Integer rvcDataId = (Integer)reportToViewMappingrow.get("RVC_ID");
            JSONObject rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)this.reportId, (Integer)rvcDataId, (Long)cvcDataId, (DataObject)rvcDataObject, (AdventNetResourceBundle)this.rb, (Long)this.loginId);
            rvcJsonObject.put("generationId", (Object)generationId);
            rvcJsonObject.put("isReportRunning", true);
            JSONObject reqJSONObject = new JSONObject();
            reqJSONObject.put("cvcDataId", (Object)cvcDataId);
            reqJSONObject.put("rvId", 151);
            reqJSONObject.put("reportId", (Object)this.reportId);
            reqJSONObject.put("generationId", (Object)generationId);
            reqJSONObject.put("rvFilterIdList", (Object)new JSONArray("[151]"));
            reqJSONObject.put("filterIdAttributeList", (Object)new JSONArray("[[95,96,97]]"));
            StatusUpdater dynamicUpdator = FileServerTaskManager.getInstance().getTaskStatus(generationId);
            JSONObject statusObject = new JSONObject();
            if (dynamicUpdator == null) {
                statusObject = new JSONObject();
                statusObject.put("isCompleted", true);
                HashMap genDetails = FileServerTaskMgmtUtil.getGenerationStatus((AdventNetResourceBundle)this.rb, (Long)generationId);
                statusObject.put("statusMessage", genDetails.get("statusMessage"));
                statusObject.put("status", genDetails.get("status"));
            } else {
                statusObject = dynamicUpdator.getJSONObject(reqJSONObject, this.rb);
            }
            Boolean isCompleted = (Boolean)statusObject.get("isCompleted");
            while (!isCompleted.booleanValue()) {
                if (System.currentTimeMillis() - startTime > this.timeOut * 1000L) {
                    singleResultFormat.put("status", (Object)"1");
                    singleResultFormat.put("statusMessage", (Object)(MessageFormat.format(this.rb.getString("admp.mgmt.fileserver.perm_mgmt.modify_perm.statmsg.have_tasks_running_in_background"), 1) + " Please refer ADManager Plus audit for the task details."));
                    return singleResultFormat;
                }
                Thread.sleep(100L);
                statusObject = dynamicUpdator.getJSONObject(reqJSONObject, this.rb);
                isCompleted = (Boolean)statusObject.get("isCompleted");
            }
            try {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMFolderModificationResult"));
                Criteria c2FolderCVC = new Criteria(Column.getColumn((String)"ADSMFolderModificationResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                query.setCriteria(c2FolderCVC);
                query.addSelectColumn(Column.getColumn(null, (String)"*"));
                DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                Row r = dObj.getFirstRow("ADSMFolderModificationResult");
                Long errorCode = (Long)r.get("ERROR_CODE");
                message = this.rb.getString(FileServerMgmtErrorHandler.getErrorMessage((Long)errorCode));
                if (errorCode == 0L) {
                    singleResultFormat.put("status", (Object)"1");
                } else {
                    singleResultFormat.put("status", (Object)"0");
                }
                singleResultFormat.put("statusMessage", (Object)message);
            }
            catch (Exception e) {
                message = this.rb.getString("admp.workflow.workflow_result.problem_in_setting_permission");
                singleResultFormat.put("status", (Object)"0");
                singleResultFormat.put("statusMessage", (Object)message);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return singleResultFormat;
    }

    public void fillResultFormat() {
        try {
            JSONObject singleResultJsonFormat = new JSONObject();
            singleResultJsonFormat.put("status", (Object)"0");
            singleResultJsonFormat.put("statusMessage", (Object)this.rb.getString("admp.workflow.workflow_result.problem_in_setting_permission"));
            this.outputFormat.put((Object)singleResultJsonFormat);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setTimeOut(Long timeOut) {
        this.timeOut = timeOut;
    }

    public static Boolean isValidFileServer(String folderPath, Long loginId) {
        Boolean isValidFileServer = false;
        if (folderPath != null && !folderPath.equals("")) {
            Hashtable fileServerListHash;
            Boolean isAllSelected;
            String computer = folderPath.substring(folderPath.indexOf("\\\\") + 2);
            if (computer.indexOf("\\") != -1) {
                computer = computer.substring(0, computer.indexOf("\\"));
            }
            if (computer.contains(".")) {
                computer = computer.substring(0, computer.indexOf("."));
            }
            if ((isAllSelected = (Boolean)(fileServerListHash = HelpdeskUtil.getFileServersList((Long)loginId, (String)"ADMPUserAllfileserverMap", (String)"ADMPUsersFileServerMap", (String)"LOGIN_ID")).get("isAllSelected")).booleanValue()) {
                isValidFileServer = true;
            } else {
                ArrayList fileServerList = (ArrayList)fileServerListHash.get("fileServerList");
                for (Properties fsProp : fileServerList) {
                    String fsName = (String)fsProp.get("NAME");
                    if (!computer.equalsIgnoreCase(fsName)) continue;
                    isValidFileServer = true;
                    break;
                }
            }
        } else {
            isValidFileServer = true;
        }
        return isValidFileServer;
    }

    private void setAuditObjectDetails(Long folderInputId, Long permInputId, Long cvcDataId, Long actionId, String actionValue, String actionValueId, Long generationId, String errmsg) {
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row reqMonitorRow = new Row("ADSMReqMonitor");
            dataObj.addRow(reqMonitorRow);
            DataAccess.fillGeneratedValues((DataObject)dataObj);
            Long autoMonitorId = (Long)reqMonitorRow.get("REQ_MONITOR_ID");
            Row reqMonitorTaskSetRow = new Row("ADSMReqMonitorTaskSet");
            reqMonitorTaskSetRow.set("REQ_MONITOR_ID", (Object)autoMonitorId);
            reqMonitorTaskSetRow.set("SCHEDULE_ID", (Object)0L);
            reqMonitorTaskSetRow.set("IS_EXECUTED", (Object)true);
            reqMonitorTaskSetRow.set("AUTOMATIC_EXECUTION_ENABLED", (Object)false);
            reqMonitorTaskSetRow.set("EXECUTION_STATUS", (Object)WorkFlowUtil.TASKSET_SCHEDULER_COMMITED);
            dataObj.addRow(reqMonitorTaskSetRow);
            Row reqMonitorTaskRow = new Row("ADSMReqMonitorTask");
            reqMonitorTaskRow.set("REQ_MONITOR_TASKSET_ID", reqMonitorTaskSetRow.get("REQ_MONITOR_TASKSET_ID"));
            reqMonitorTaskRow.set("REQUEST_ACTION", (Object)5001L);
            reqMonitorTaskRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            dataObj.addRow(reqMonitorTaskRow);
            DataAccess.fillGeneratedValues((DataObject)dataObj);
            Long reqMonitorTaskId = (Long)reqMonitorTaskRow.get("REQ_MONITOR_TASK_ID");
            JSONObject cvcSummary = new JSONObject();
            cvcSummary.put("CVC_FOLDER_INPUT_ID", (Object)folderInputId);
            cvcSummary.put("CVC_PERMISSION_INPUT_ID", (Object)permInputId);
            Row summaryRow = new Row("WFCVCDataSummary");
            summaryRow.set("UNIQUE_ID", (Object)folderInputId);
            summaryRow.set("CVC_DATA_ID", (Object)cvcDataId);
            summaryRow.set("CVC_DATA_SUMMARY", (Object)cvcSummary.toString());
            summaryRow.set("REQ_MONITOR_TASK_ID", (Object)reqMonitorTaskId);
            summaryRow.set("ACTION_ID", (Object)actionId);
            summaryRow.set("ACTION_VALUE", (Object)actionValue);
            summaryRow.set("ACTION_VALUE_ID", (Object)actionValueId);
            summaryRow.set("ACTION_VALUE_DOMAIN", (Object)this.domainName);
            summaryRow.set("IS_EXECUTED", (Object)true);
            if (errmsg != null) {
                summaryRow.set("ACTION_RESULT", (Object)errmsg);
            }
            dataObj.addRow(summaryRow);
            Row generationMap = new Row("RequestCVCResultGenerationMap");
            generationMap.set("REQ_MONITOR_TASK_ID", (Object)reqMonitorTaskId);
            generationMap.set("REPORT_GENERATION_ID", (Object)generationId);
            dataObj.addRow(generationMap);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

