/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.layout.component;

import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.layout.component.Component;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RFInactiveComputerFilter
extends Component {
    private String filter = "lastlogontime";
    private String value = "7";

    public void init(JSONObject fcComponentJsonObject) {
        try {
            this.value = fcComponentJsonObject.getString("value");
            this.filter = fcComponentJsonObject.getString("filter");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public JSONObject serializeToJSONObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("value", (Object)this.value);
            jsonObject.put("filter", (Object)this.filter);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    public void fillMgmtRuleValue(JSONObject valueObj) {
        try {
            if (valueObj.has("fieldValues")) {
                JSONArray valueArray = valueObj.getJSONArray("fieldValues");
                for (int index = 0; index < valueArray.length(); ++index) {
                    JSONObject admpInputJsonObj = valueArray.getJSONObject(index);
                    AdmpInput admpInput = new AdmpInput(admpInputJsonObj);
                    if (admpInput.getName().equalsIgnoreCase("filter")) {
                        this.filter = admpInput.getValue();
                        continue;
                    }
                    this.value = admpInput.getValue();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<AdmpInput> getAdmpInputList() {
        ArrayList<AdmpInput> admpInputList = new ArrayList<AdmpInput>();
        try {
            AdmpInput admpInput = new AdmpInput("filter", this.filter, false);
            admpInputList.add(admpInput);
            admpInput = new AdmpInput("VAL", this.value, false);
            admpInputList.add(admpInput);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return admpInputList;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getValue() {
        return this.value;
    }
}

