/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.mfw.Starter;
import com.adventnet.mfw.logging.LoggerUtil;
import com.adventnet.mfw.service.Service;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.persistence.json.Do2JsonConverter;
import com.adventnet.persistence.json.Json2DoConverter;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayout;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutField;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutFieldGroup;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutRhsConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutSubTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutSubTabGroup;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutTab;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleGroup;
import com.adventnet.sym.adsm.common.server.layout.rule.MgmtRuleHandler;
import com.adventnet.sym.adsm.common.server.util.AdvancedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FileManager;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.webclient.util.CustomAttribUtil;
import com.manageengine.ads.fw.mail.MailHandler;
import com.zoho.framework.utils.FileUtils;
import com.zoho.net.handshake.HandShakeUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ADSMConfigBackupRestoreHandler
implements FcLayoutConstants,
FcLayoutRhsConstants {
    private static final String DefaultBackupDirectory = System.getProperty("server.home") + "/Backup/";
    private static Logger out = null;
    private static final String[] defaultSchedulers = new String[]{"admp.reports.sched_reports.sch_view.scheduler_name.ad_update_scheduler", "admp.reports.sched_reports.sch_view.scheduler_name.daily_report_scheduler", "admp.reports.sched_reports.sch_view.scheduler_name.significant_reports"};
    private static final String[] scheduleDependencyTables = new String[]{"ADSMDomainConfiguration", "ADSMWAADDomainConfiguration", "WAADADMapping", "ADSMWAADDomainDetails", "ADSMWAADADDomainLinkDetails", "O365AccountConfiguration", "O365Domains", "ADSMailSettings", "ScheduleIdVsLoginIdMapping"};
    private static final Integer[] existingModules = new Integer[]{0, 1, 2, 3};
    private static String prefixStr = null;
    private static Hashtable customAttribHash = new Hashtable();
    private static Hashtable scheduleIdHash = new Hashtable();
    private static Hashtable o365AccountIdHash = new Hashtable();
    private static Service service = null;
    private static final Integer ALL_MODULES = 0;
    private static final Integer SCHEDULER_MODULE = 1;
    private static final Integer LAYOUT_MODULE = 2;
    private static final Integer DELEGATION_MODULE = 3;

    public static void main(String[] args) throws Exception {
        Properties p = new Properties();
        try {
            for (int i = 0; i < args.length; i += 2) {
                p.setProperty(args[i].toUpperCase(Locale.ENGLISH), args[i + 1]);
            }
            boolean serverRunning = false;
            if (HandShakeUtil.isServerListening()) {
                serverRunning = true;
            }
            if (serverRunning) {
                throw new RuntimeException("Server seems to be running. Please shutdown server and try invoking the script.");
            }
            ArrayList<Integer> modules = new ArrayList<Integer>();
            if (!p.getProperty("MODULES").equals("") && !p.getProperty("MODULES").equals("null")) {
                String moduleSelectedString = p.getProperty("MODULES");
                String[] modulesStr = moduleSelectedString.split(":");
                for (int i = 0; i < modulesStr.length; ++i) {
                    try {
                        Integer module = Integer.parseInt(modulesStr[i]);
                        if (module.equals(ALL_MODULES)) {
                            modules.clear();
                            break;
                        }
                        modules.add(module);
                        continue;
                    }
                    catch (Exception e) {
                        ConsoleOut.println((String)(modulesStr[i] + " is an invalid module."));
                    }
                }
            }
            if (modules.isEmpty()) {
                modules.add(ALL_MODULES);
            }
            if (p.getProperty("OPERATION").equals("-b")) {
                LoggerUtil.initLog((String)"BackupConfig");
                out = Logger.getLogger("BackupConfig");
                ConsoleOut.println((String)"Backing up configuration data..");
                ADSMConfigBackupRestoreHandler.backupData(modules);
                ConsoleOut.println((String)"Configuration data backed up successfully..");
            } else {
                LoggerUtil.initLog((String)"RestoreConfig");
                out = Logger.getLogger("RestoreConfig");
                ConsoleOut.println((String)"Restoring configuration data...");
                String restoreFile = null;
                if (!p.getProperty("BACKUPFILE").equals("") && !p.getProperty("BACKUPFILE").equals("null")) {
                    restoreFile = p.getProperty("BACKUPFILE");
                }
                ADSMConfigBackupRestoreHandler.restoreData(restoreFile, modules);
                ConsoleOut.println((String)"Configuration data restored successfully");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ConsoleOut.println((String)"Exception occured..Please check the logs");
            System.exit(1);
        }
        System.exit(0);
    }

    public static void backupData(ArrayList<Integer> modules) throws Exception {
        String path = null;
        try {
            out.log(Level.INFO, "Backing up configuration data started..");
            Starter.loadSystemProperties();
            Starter.LoadJars();
            File file = new File(DefaultBackupDirectory);
            if (!file.exists()) {
                file.mkdirs();
            }
            String confFileDir = System.getProperty("server.home") + "/conf/";
            PersistenceInitializer.initializeDB((String)confFileDir);
            PersistenceInitializer.initializeMickey((boolean)false);
            ADSMConfigBackupRestoreHandler.handleCacheService("init");
            Date today = Calendar.getInstance().getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            String backupFileName = "ConfigDataBackup_" + formatter.format(today);
            ConsoleOut.println((String)("Backup Directory  : " + DefaultBackupDirectory));
            ConsoleOut.println((String)("Backup File Name  : " + backupFileName));
            path = DefaultBackupDirectory + "/" + backupFileName;
            File file1 = new File(path);
            File zipFile = new File(path + ".zip");
            if (!(zipFile.exists() || file1.exists() || file1.isDirectory())) {
                file1.mkdirs();
            }
            out.log(Level.INFO, "Backup zip file name--" + path);
            block15: for (Integer module : modules) {
                switch (module) {
                    case 0: {
                        out.log(Level.INFO, "Backing up All Modules");
                        ADSMConfigBackupRestoreHandler.backupADMPRoles(path);
                        ADSMConfigBackupRestoreHandler.backupUserLoginData(path);
                        ADSMConfigBackupRestoreHandler.backupUserDelegationData(path);
                        ADSMConfigBackupRestoreHandler.backupADMPGroupBasedHDT(path);
                        ADSMConfigBackupRestoreHandler.backupADMPFileServerMapping(path);
                        ADSMConfigBackupRestoreHandler.backupScheduler(path);
                        ADSMConfigBackupRestoreHandler.backupO365GroupData(path);
                        ADSMConfigBackupRestoreHandler.backupDependacyTables(path);
                        ADSMConfigBackupRestoreHandler.backupCustomAttributes(path);
                        ADSMConfigBackupRestoreHandler.backupNamingFormats(path);
                        ADSMConfigBackupRestoreHandler.backupLayoutData(path);
                        ADSMConfigBackupRestoreHandler.backupHDTLayoutMapping(path);
                        continue block15;
                    }
                    case 1: {
                        out.log(Level.INFO, "Backing up Scheduler Module");
                        ADSMConfigBackupRestoreHandler.backupScheduler(path);
                        ADSMConfigBackupRestoreHandler.backupO365GroupData(path);
                        ADSMConfigBackupRestoreHandler.backupDependacyTables(path);
                        ADSMConfigBackupRestoreHandler.backupCustomAttributes(path);
                        continue block15;
                    }
                    case 2: {
                        out.log(Level.INFO, "Backing up Layout Module");
                        ADSMConfigBackupRestoreHandler.backupCustomAttributes(path);
                        ADSMConfigBackupRestoreHandler.backupNamingFormats(path);
                        ADSMConfigBackupRestoreHandler.backupLayoutData(path);
                        ADSMConfigBackupRestoreHandler.backupHDTLayoutMapping(path);
                        continue block15;
                    }
                    case 3: {
                        out.log(Level.INFO, "Backing up Delegation Module");
                        ADSMConfigBackupRestoreHandler.backupADMPRoles(path);
                        ADSMConfigBackupRestoreHandler.backupUserLoginData(path);
                        ADSMConfigBackupRestoreHandler.backupUserDelegationData(path);
                        ADSMConfigBackupRestoreHandler.backupADMPGroupBasedHDT(path);
                        ADSMConfigBackupRestoreHandler.backupADMPFileServerMapping(path);
                        continue block15;
                    }
                }
                ConsoleOut.println((String)("There is no such modules like : " + module));
            }
            FileManager.makeZip((String)path, (String)new StringBuilder(backupFileName).reverse().toString());
            ConsoleOut.println((String)("Backup File -" + path + ".zip"));
            out.log(Level.INFO, "Backing up configuration data completed..");
        }
        catch (Exception e) {
            ConsoleOut.println((String)"backupDB is aborted..");
            e.printStackTrace();
            throw new Exception("problem while taking config data backup");
        }
        finally {
            try {
                ADSMConfigBackupRestoreHandler.handleCacheService("destory");
                PersistenceInitializer.stopDB();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ConsoleOut.println((String)("Problem while Stopping DB -" + ex.getMessage()));
                throw new Exception("problem while stopping DB.");
            }
        }
    }

    private static void backupScheduler(String path) throws Exception {
        out.log(Level.INFO, "Backing up Normal schedulers");
        Table table = new Table("ADSMScheduler");
        SelectQueryImpl sq1 = new SelectQueryImpl(table);
        sq1.addSelectColumn(new Column("ADSMScheduler", "SCHEDULE_ID"));
        sq1.setCriteria(new Criteria(Column.getColumn((String)"ADSMScheduler", (String)"SCHEDULER_NAME"), (Object)defaultSchedulers, 9));
        DataObject dataObject1 = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq1);
        if (!dataObject1.isEmpty()) {
            Iterator iterator = dataObject1.getRows("ADSMScheduler");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long scheduleId = (Long)row.get("SCHEDULE_ID");
                DataObject tableDO = SchedulerHandler.getScheduleDataObject((Long)scheduleId);
                if (tableDO.isEmpty()) continue;
                String filePath = new File(path + File.separator + "ADSMSchedule_" + scheduleId + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)tableDO, (String)filePath);
            }
        }
        out.log(Level.INFO, "Backing up advanced schedulers");
        Table advancedScheduleTable = new Table("ADSMAdvancedScheduler");
        SelectQueryImpl sq2 = new SelectQueryImpl(advancedScheduleTable);
        sq2.addSelectColumn(Column.getColumn((String)"ADSMAdvancedScheduler", (String)"ADMP_SCHEDULE_ID"));
        sq2.addSelectColumn(Column.getColumn((String)"ADSMAdvancedScheduler", (String)"SCHEDULE_ID"));
        DataObject dataObject2 = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq2);
        if (!dataObject2.isEmpty()) {
            Iterator iterator = dataObject2.getRows("ADSMAdvancedScheduler");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long advancedScheduleId = (Long)row.get("SCHEDULE_ID");
                DataObject tableDO = AdvancedSchedulerUtil.getAdvancedScheduleDO((Long)advancedScheduleId);
                if (tableDO.isEmpty()) continue;
                String filePath = new File(path + File.separator + "ADSMAdvancedSchedule_" + advancedScheduleId + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)tableDO, (String)filePath);
            }
        }
    }

    private static void backupO365GroupData(String path) throws Exception {
        out.log(Level.INFO, "Backing up o365 group selection data started");
        ArrayList<String> o365GroupObjectIdList = new ArrayList<String>();
        Table o365GroupSelectDataTable = new Table("CVCO365GroupSelectData");
        SelectQueryImpl sq3 = new SelectQueryImpl(o365GroupSelectDataTable);
        sq3.addSelectColumn(new Column("CVCO365GroupSelectData", "*"));
        DataObject dataObject3 = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq3);
        if (!dataObject3.isEmpty()) {
            Iterator iterator = dataObject3.getRows("CVCO365GroupSelectData");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                o365GroupObjectIdList.add((String)row.get("OBJECT_ID"));
            }
        }
        out.log(Level.INFO, "Backing up o365 groups details from O365GroupGeneralDetails");
        if (!o365GroupObjectIdList.isEmpty()) {
            Table groupTable = Table.getTable((String)"O365GroupGeneralDetails");
            SelectQueryImpl groupSq = new SelectQueryImpl(groupTable);
            groupSq.addSelectColumn(Column.getColumn((String)"O365GroupGeneralDetails", (String)"*"));
            groupSq.setCriteria(new Criteria(Column.getColumn((String)"O365GroupGeneralDetails", (String)"OBJECT_ID"), (Object)o365GroupObjectIdList.toArray(), 8));
            DataObject groupDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)groupSq);
            if (!groupDO.isEmpty()) {
                String filePath = new File(path + File.separator + "O365GroupGeneralDetails" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)groupDO, (String)filePath);
            }
        }
        out.log(Level.INFO, "Backing up o365 group selection data finished");
    }

    private static void backupDependacyTables(String path) throws Exception {
        out.log(Level.INFO, "Backing up dependent tables started");
        for (String tableName : scheduleDependencyTables) {
            Table sqTable = new Table(tableName);
            SelectQueryImpl sq = new SelectQueryImpl(sqTable);
            if (tableName.equalsIgnoreCase("ADSMDomainConfiguration")) {
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
            } else {
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            }
            DataObject tableDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (tableDO.isEmpty()) continue;
            String filePath = new File(path + File.separator + tableName + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)tableDO, (String)filePath);
        }
        out.log(Level.INFO, "Backing up dependent tables finished");
    }

    private static void backupCustomAttributes(String path) throws Exception {
        out.log(Level.INFO, "Backing up Custom attribute table started");
        ArrayList<String> attribLdapNames = new ArrayList<String>();
        Table sqTable = new Table("ADSMCustomFields");
        SelectQueryImpl sq = new SelectQueryImpl(sqTable);
        sq.addSelectColumn(Column.getColumn((String)"ADSMCustomFields", (String)"*"));
        DataObject tableDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
        if (!tableDO.isEmpty()) {
            Iterator iterator = tableDO.getRows("ADSMCustomFields");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                attribLdapNames.add((String)row.get("LDAP_NAME"));
            }
            String filePath = new File(path + File.separator + "ADSMCustomFields" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)tableDO, (String)filePath);
        }
        out.log(Level.INFO, "Backing up custom attributes attrib_ids from adsmattributedetails");
        if (!attribLdapNames.isEmpty()) {
            Table attribSqTable = Table.getTable((String)"ADSMAttributeDetails");
            SelectQueryImpl attribSq = new SelectQueryImpl(attribSqTable);
            attribSq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            attribSq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            attribSq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            attribSq.setCriteria(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)attribLdapNames.toArray(), 8));
            DataObject attribDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)attribSq);
            if (!attribDO.isEmpty()) {
                String filePath = new File(path + File.separator + "CustomAttributeIds" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)attribDO, (String)filePath);
            }
        }
        out.log(Level.INFO, "Backing up Custom attribute table finished");
    }

    private static void backupNamingFormats(String path) throws Exception {
        out.log(Level.INFO, "Backing up Naming formats data started");
        Table formatTable = Table.getTable((String)"ADSMCustomFormats");
        SelectQueryImpl formatSq = new SelectQueryImpl(formatTable);
        formatSq.addJoin(new Join("ADSMCustomFormats", "ADSMFormats", new String[]{"FORMAT_ID"}, new String[]{"FORMAT_ID"}, 1));
        formatSq.addJoin(new Join("ADSMCustomFormats", "ADSMFormatRules", new String[]{"FORMAT_ID"}, new String[]{"FORMAT_ID"}, 1));
        formatSq.addJoin(new Join("ADSMFormatRules", "ADSMFormatRuleConditions", new String[]{"FORMAT_ID"}, new String[]{"FORMAT_ID"}, 1));
        formatSq.addJoin(new Join("ADSMFormatRuleConditions", "ADSMFormatRuleCondnCrits", new String[]{"CONDITION_ID"}, new String[]{"CONDITION_ID"}, 1));
        formatSq.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject formatDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)formatSq);
        if (!formatDO.isEmpty()) {
            String filePath = new File(path + File.separator + "NamingFormats" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)formatDO, (String)filePath);
        }
        Table umlautTable = Table.getTable((String)"ADSMUmlautConfigurations");
        SelectQueryImpl umlautSq = new SelectQueryImpl(umlautTable);
        umlautSq.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject umlautDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)umlautSq);
        if (!umlautDO.isEmpty()) {
            String filePath = new File(path + File.separator + "ADSMUmlautConfigurations" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)umlautDO, (String)filePath);
        }
        Table defFormatTable = Table.getTable((String)"ADSMFormatDefaultSettings");
        SelectQueryImpl defFormatSq = new SelectQueryImpl(defFormatTable);
        defFormatSq.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject defFormatDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)defFormatSq);
        if (!defFormatDO.isEmpty()) {
            String filePath = new File(path + File.separator + "ADSMFormatDefaultSettings" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)defFormatDO, (String)filePath);
        }
        out.log(Level.INFO, "Backing up Naming formats data Finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void backupLayoutData(String path) throws Exception {
        String filePath;
        out.log(Level.INFO, "Backing up Template data started");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        Table fcTable = Table.getTable((String)"FcLayout");
        SelectQueryImpl fcQuery = new SelectQueryImpl(fcTable);
        fcQuery.addSelectColumn(Column.getColumn((String)"FcLayout", (String)"*"));
        DataObject fcDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)fcQuery);
        Iterator fcIt = fcDO.getRows("FcLayout");
        while (fcIt.hasNext()) {
            MgmtRuleGroup mgmtRuleGroup;
            JSONObject mgmtRuleJSON;
            Row fcRow = (Row)fcIt.next();
            Long fcLayoutId = (Long)fcRow.get("LAYOUT_ID");
            FcLayout fcLayout = new FcLayout(fcLayoutId, rb);
            filePath = new File(path + File.separator + "Layout_" + fcLayoutId + ".json").getCanonicalPath();
            PrintWriter out = new PrintWriter(filePath);
            try {
                out.write(fcLayout.serializeToJsonString());
            }
            finally {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            Properties props = FcLayoutViewHandler.getTemplateCategoryDetails((Long)fcLayout.getTemplateCategoryId());
            if (!((Boolean)props.get("IS_RULE_AVAILABLE")).booleanValue() || (mgmtRuleJSON = (mgmtRuleGroup = new MgmtRuleGroup(fcLayoutId, rb)).serializeToJsonObject()).length() <= 0) continue;
            filePath = new File(path + File.separator + "MgmtRuleGroup_" + fcLayoutId + ".json").getCanonicalPath();
            out = new PrintWriter(filePath);
            try {
                out.write(mgmtRuleGroup.serializeToJsonObject().toString());
            }
            finally {
                if (out == null) continue;
                out.flush();
                out.close();
            }
        }
        Table attribFieldTable = Table.getTable((String)"FcFieldToAttributes");
        SelectQueryImpl attribFieldQuery = new SelectQueryImpl(attribFieldTable);
        attribFieldQuery.addSelectColumn(Column.getColumn((String)"FcFieldToAttributes", (String)"*"));
        DataObject attribDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)attribFieldQuery);
        if (!attribDO.isEmpty()) {
            filePath = new File(path + File.separator + "FcFieldToAttributes" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)attribDO, (String)filePath);
        }
        out.log(Level.INFO, "Backing up Template data finished");
    }

    private static void backupHDTLayoutMapping(String path) throws Exception {
        String filePath;
        out.log(Level.INFO, "Backing up HDT Template data started");
        Table loginTable = Table.getTable((String)"AaaLogin");
        SelectQueryImpl hdtLayoutSq = new SelectQueryImpl(loginTable);
        hdtLayoutSq.addJoin(new Join("AaaLogin", "FcHDTtoAllLayoutMapping", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        hdtLayoutSq.addJoin(new Join("AaaLogin", "FcHDTtoLayoutMapping", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1));
        hdtLayoutSq.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject hdtLayoutDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)hdtLayoutSq);
        if (!hdtLayoutDO.isEmpty()) {
            filePath = new File(path + File.separator + "FcHDTtoAllLayoutMapping" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)hdtLayoutDO, (String)filePath);
        }
        out.log(Level.INFO, "Backing up HDT Template data finished");
        try {
            out.log(Level.INFO, "Backing up Group Based HDT Template data started");
            loginTable = Table.getTable((String)"ADMPGroupBasedHDT");
            hdtLayoutSq = new SelectQueryImpl(loginTable);
            hdtLayoutSq.addJoin(new Join("ADMPGroupBasedHDT", "FcHDTGroupToAllLayoutMapping", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 2));
            hdtLayoutSq.addJoin(new Join("ADMPGroupBasedHDT", "FcHDTGroupToLayoutMapping", new String[]{"GROUP_ID"}, new String[]{"GROUP_ID"}, 1));
            hdtLayoutSq.addSelectColumn(Column.getColumn(null, (String)"*"));
            hdtLayoutDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)hdtLayoutSq);
            if (!hdtLayoutDO.isEmpty()) {
                filePath = new File(path + File.separator + "FcHDTGroupToAllLayoutMapping" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)hdtLayoutDO, (String)filePath);
            }
            out.log(Level.INFO, "Backing up Group Based HDT Template data finished");
        }
        catch (Exception e) {
            out.log(Level.INFO, "Problem in Group based HDT backup :: " + e.getMessage());
        }
        out.log(Level.INFO, "Backing up Requester Template data started");
        loginTable = Table.getTable((String)"AaaLogin");
        hdtLayoutSq = new SelectQueryImpl(loginTable);
        hdtLayoutSq.addJoin(new Join("AaaLogin", "FcRequesterAllLayoutMapping", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        hdtLayoutSq.addJoin(new Join("AaaLogin", "FcRequestertoLayoutMapping", new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1));
        hdtLayoutSq.addSelectColumn(Column.getColumn(null, (String)"*"));
        hdtLayoutDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)hdtLayoutSq);
        if (!hdtLayoutDO.isEmpty()) {
            filePath = new File(path + File.separator + "FcRequesterAllLayoutMapping" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)hdtLayoutDO, (String)filePath);
        }
        out.log(Level.INFO, "Backing up Requester Template data finished");
        try {
            out.log(Level.INFO, "Backing up Requester Policy Template data started");
            loginTable = Table.getTable((String)"RequesterPolicyConfiguration");
            hdtLayoutSq = new SelectQueryImpl(loginTable);
            hdtLayoutSq.addJoin(new Join("RequesterPolicyConfiguration", "FcRequesterPolicyAllLayoutMap", new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2));
            hdtLayoutSq.addJoin(new Join("RequesterPolicyConfiguration", "FcRequesterPolicytoLayoutMap", new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 1));
            hdtLayoutSq.addSelectColumn(Column.getColumn(null, (String)"*"));
            hdtLayoutDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)hdtLayoutSq);
            if (!hdtLayoutDO.isEmpty()) {
                filePath = new File(path + File.separator + "FcRequesterPolicyAllLayoutMap" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)hdtLayoutDO, (String)filePath);
            }
            out.log(Level.INFO, "Backing up Requester Policy Template data finished");
        }
        catch (Exception e) {
            out.log(Level.INFO, "Problem in Requester policy backup :: " + e.getMessage());
        }
    }

    private static void backupADMPRoles(String path) throws Exception {
        String filePath;
        out.log(Level.INFO, "Backing up ADSRoles data started");
        Table table = Table.getTable((String)"ADSRoles");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "ADSRoles" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up ADSRoles data finished");
        out.log(Level.INFO, "Backing up ADSActions data started");
        table = Table.getTable((String)"ADSActions");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn((String)"ADSActions", (String)"ACTION_ID"));
        query.addSelectColumn(Column.getColumn((String)"ADSActions", (String)"ACTION_NAME"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "ADSActions" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up ADSRoleVsActions data finished");
        out.log(Level.INFO, "Backing up ADSRoleVsActions data started");
        table = Table.getTable((String)"ADSRoleVsActions");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "ADSRoleVsActions" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up ADSRoleVsActions data finished");
        out.log(Level.INFO, "Backing up O365Tabs data started");
        table = Table.getTable((String)"O365Tabs");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn((String)"O365Tabs", (String)"TAB_ID"));
        query.addSelectColumn(Column.getColumn((String)"O365Tabs", (String)"TAB_NAME"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "O365Tabs" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up O365Tabs data finished");
        out.log(Level.INFO, "Backing up O365RoleVsTab data started");
        table = Table.getTable((String)"O365RoleVsTab");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "O365RoleVsTab" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up O365RoleVsTab data finished");
        out.log(Level.INFO, "Backing up O365LHSPanelMenus data started");
        table = Table.getTable((String)"O365LHSPanelMenus");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn((String)"O365LHSPanelMenus", (String)"MENU_ID"));
        query.addSelectColumn(Column.getColumn((String)"O365LHSPanelMenus", (String)"MENU_NAME"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "O365LHSPanelMenus" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up O365LHSPanelMenus data finished");
        out.log(Level.INFO, "Backing up O365RoleVsLHSMenu data started");
        table = Table.getTable((String)"O365RoleVsLHSMenu");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "O365RoleVsLHSMenu" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up O365RoleVsLHSMenu data finished");
        out.log(Level.INFO, "Backing up ADMPRoles data started");
        Table roleTable = Table.getTable((String)"ADMPRoles");
        query = new SelectQueryImpl(roleTable);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            String filePath2 = new File(path + File.separator + "ADMPRoles" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
        }
        out.log(Level.INFO, "Backing up ADMPRoles data finished");
        out.log(Level.INFO, "Backing up ADMPRolePermissions data started");
        Table rolePermissionTable = Table.getTable((String)"ADMPRolePermissions");
        query = new SelectQueryImpl(rolePermissionTable);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            String filePath3 = new File(path + File.separator + "ADMPRolePermissions" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath3);
        }
        out.log(Level.INFO, "Backing up ADMPRolePermissions data finished");
    }

    private static void backupADMPFileServerMapping(String path) {
        try {
            String filePath;
            Row row;
            out.log(Level.INFO, "Backing up ADMPGroupFileServerMap data started");
            Table table = Table.getTable((String)"ADMPGroupFileServerMap");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                String filePath2 = new File(path + File.separator + "ADMPGroupFileServerMap" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
            }
            out.log(Level.INFO, "Backing up ADMPGroupFileServerMap data finished");
            ArrayList<String> fileServerList = new ArrayList<String>();
            Iterator it = dataObj.getRows("ADMPGroupFileServerMap");
            while (it.hasNext()) {
                row = (Row)it.next();
                fileServerList.add((String)row.get("OBJECT_GUID"));
            }
            out.log(Level.INFO, "Backing up ADMPUsersFileServerMap data started");
            table = Table.getTable((String)"ADMPUsersFileServerMap");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                String filePath3 = new File(path + File.separator + "ADMPUsersFileServerMap" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath3);
            }
            out.log(Level.INFO, "Backing up ADMPUsersFileServerMap data finished");
            it = dataObj.getRows("ADMPUsersFileServerMap");
            while (it.hasNext()) {
                row = (Row)it.next();
                fileServerList.add((String)row.get("OBJECT_GUID"));
            }
            out.log(Level.INFO, "Backing up ADSMFileServers data started");
            String[] fileServerArray = new String[fileServerList.size()];
            fileServerArray = fileServerList.toArray(fileServerArray);
            table = Table.getTable((String)"ADSMFileServers");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSMFileServers", (String)"OBJECT_GUID"), (Object)fileServerArray, 8));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "ADSMFileServers" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up ADSMFileServers data finished");
            out.log(Level.INFO, "Backing up ADMPUserAllfileserverMap data started");
            table = Table.getTable((String)"ADMPUserAllfileserverMap");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "ADMPUserAllfileserverMap" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up ADMPUserAllfileserverMap data finished");
            out.log(Level.INFO, "Backing up ADMPGroupAllfileserverMap data started");
            table = Table.getTable((String)"ADMPGroupAllfileserverMap");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "ADMPGroupAllfileserverMap" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up ADMPGroupAllfileserverMap data finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            out.log(Level.INFO, "Exception while BackingUp ADMPFileServerMapping");
        }
    }

    private static void backupADMPGroupBasedHDT(String path) {
        try {
            String filePath;
            out.log(Level.INFO, "Backing up ADMPGroupBasedHDT data started");
            Table table = Table.getTable((String)"ADMPGroupBasedHDT");
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                String filePath2 = new File(path + File.separator + "ADMPGroupBasedHDT" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
            }
            out.log(Level.INFO, "Backing up ADMPGroupBasedHDT data finished");
            out.log(Level.INFO, "Backing up ADSMGroupGeneralDetails data started");
            ArrayList<String> groupGuidList = new ArrayList<String>();
            Iterator it = dataObj.getRows("ADMPGroupBasedHDT");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                groupGuidList.add((String)row.get("OBJECT_GUID"));
            }
            String[] groupGuidArray = new String[groupGuidList.size()];
            groupGuidArray = groupGuidList.toArray(groupGuidArray);
            table = Table.getTable((String)"ADSMGroupGeneralDetails");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.setCriteria(new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"OBJECT_GUID"), (Object)groupGuidArray, 8));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "ADSMGroupGeneralDetails" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up ADSMGroupGeneralDetails data finished");
            out.log(Level.INFO, "Backing up ADMPGroupsRoleMapping data started");
            table = Table.getTable((String)"ADMPGroupsRoleMapping");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "ADMPGroupsRoleMapping" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up ADMPGroupsRoleMapping data finished");
            out.log(Level.INFO, "Backing up ADMPGroupsOUMapping data started");
            table = Table.getTable((String)"ADMPGroupsOUMapping");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "ADMPGroupsOUMapping" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up ADMPGroupsOUMapping data finished");
            out.log(Level.INFO, "Backing up GroupBasedHDTGroupDelegation data started");
            table = Table.getTable((String)"GroupBasedHDTGroupDelegation");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "GroupBasedHDTGroupDelegation" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up GroupBasedHDTGroupDelegation data finished");
            out.log(Level.INFO, "Backing up LoginIDvsADMPGroupMapping data started");
            table = Table.getTable((String)"LoginIDvsADMPGroupMapping");
            query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                filePath = new File(path + File.separator + "LoginIDvsADMPGroupMapping" + ".json").getCanonicalPath();
                Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
            }
            out.log(Level.INFO, "Backing up LoginIDvsADMPGroupMapping data finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            out.log(Level.INFO, "Exception while BackingUp GroupBasedDelegation");
        }
    }

    private static void backupUserLoginData(String path) throws Exception {
        String filePath;
        String filePath2;
        out.log(Level.INFO, "Backing up AaaLogin data started");
        ArrayList<Long> loginIdList = ADSMConfigBackupRestoreHandler.getAllHDTs();
        Long[] loginIdArray = new Long[loginIdList.size()];
        loginIdArray = loginIdList.toArray(loginIdArray);
        Table table = Table.getTable((String)"AaaLogin");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginIdArray, 8);
        crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)new Long[]{1L, 2L, 3L}, 9));
        query.setCriteria(crit);
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            String filePath3 = new File(path + File.separator + "AaaLogin" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath3);
        }
        out.log(Level.INFO, "Backing up AaaLogin data finished");
        out.log(Level.INFO, "Backing up AaaUser data started");
        ArrayList<Long> userIdList = new ArrayList<Long>();
        loginIdList = new ArrayList<Long>();
        Iterator it = dataObj.getRows("AaaLogin");
        while (it.hasNext()) {
            Row row = (Row)it.next();
            loginIdList.add((Long)row.get("LOGIN_ID"));
            userIdList.add((Long)row.get("USER_ID"));
        }
        Long[] userIdArray = new Long[userIdList.size()];
        userIdArray = userIdList.toArray(userIdArray);
        table = Table.getTable((String)"AaaUser");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.setCriteria(new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)userIdArray, 8));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath2 = new File(path + File.separator + "AaaUser" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
        }
        out.log(Level.INFO, "Backing up AaaUser data finished");
        out.log(Level.INFO, "Backing up AaaAccount data started");
        loginIdArray = new Long[loginIdList.size()];
        loginIdArray = loginIdList.toArray(loginIdArray);
        table = Table.getTable((String)"AaaAccount");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.setCriteria(new Criteria(Column.getColumn((String)"AaaAccount", (String)"LOGIN_ID"), (Object)loginIdArray, 8));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath2 = new File(path + File.separator + "AaaAccount" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
        }
        ArrayList<Long> accountIdList = new ArrayList<Long>();
        it = dataObj.getRows("AaaAccount");
        while (it.hasNext()) {
            Row row = (Row)it.next();
            accountIdList.add((Long)row.get("ACCOUNT_ID"));
        }
        out.log(Level.INFO, "Backing up AaaAccount data finished");
        out.log(Level.INFO, "Backing up AaaAccountStatus data started");
        Long[] accountIdArray = new Long[accountIdList.size()];
        accountIdArray = accountIdList.toArray(accountIdArray);
        table = Table.getTable((String)"AaaAccountStatus");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        crit = new Criteria(Column.getColumn((String)"AaaAccountStatus", (String)"ACCOUNT_ID"), (Object)accountIdArray, 8);
        crit = crit.or(new Criteria(Column.getColumn((String)"AaaAccountStatus", (String)"ACCOUNT_ID"), (Object)new Long[]{2L, 3L}, 8));
        query.setCriteria(crit);
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "AaaAccountStatus" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up AaaAccountStatus data finished");
        out.log(Level.INFO, "Backing up AaaUserStatus data started");
        table = Table.getTable((String)"AaaUserStatus");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        crit = new Criteria(Column.getColumn((String)"AaaUserStatus", (String)"USER_ID"), (Object)userIdArray, 8);
        crit = crit.or(new Criteria(Column.getColumn((String)"AaaUserStatus", (String)"USER_ID"), (Object)new Long[]{2L, 3L}, 8));
        query.setCriteria(crit);
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "AaaUserStatus" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up AaaUserStatus data finished");
    }

    public static ArrayList getAllHDTs() {
        ArrayList<Long> loginIdList = new ArrayList<Long>();
        try {
            Long administratorRoleId = AuthUtil.getRoleId((String)"Administrator");
            Table aaaLoginTable = Table.getTable((String)"AaaLogin");
            Table aaaAccountTable = Table.getTable((String)"AaaAccount");
            Table aaaAuthorizedRoleTable = Table.getTable((String)"AaaAuthorizedRole");
            SelectQueryImpl query = new SelectQueryImpl(aaaAuthorizedRoleTable);
            query.addSelectColumn(Column.getColumn((String)"AaaAuthorizedRole", (String)"ROLE_ID"));
            query.addSelectColumn(Column.getColumn((String)"AaaAuthorizedRole", (String)"ACCOUNT_ID"));
            query.addSelectColumn(Column.getColumn((String)"AaaAccount", (String)"ACCOUNT_ID"));
            query.addSelectColumn(Column.getColumn((String)"AaaAccount", (String)"LOGIN_ID"));
            query.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            Join join = new Join(aaaAuthorizedRoleTable, aaaAccountTable, new String[]{"ACCOUNT_ID"}, new String[]{"ACCOUNT_ID"}, 1);
            query.addJoin(join);
            join = new Join(aaaAccountTable, aaaLoginTable, new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            query.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"AaaAuthorizedRole", (String)"ROLE_ID"), (Object)administratorRoleId, 0);
            query.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = dataObject.getRows("AaaLogin");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                loginIdList.add((Long)row.get("LOGIN_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginIdList;
    }

    public static void backupUserDelegationData(String path) throws Exception {
        String filePath;
        String filePath2;
        out.log(Level.INFO, "Backing up ADSTechnicianDelegatedRoles data started");
        Table table = Table.getTable((String)"ADSTechnicianDelegatedRoles");
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath2 = new File(path + File.separator + "ADSTechnicianDelegatedRoles" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
        }
        out.log(Level.INFO, "Backing up ADSTechnicianDelegatedRoles data finished");
        out.log(Level.INFO, "Backing up ADMPUsersRoleMapping data started");
        table = Table.getTable((String)"ADMPUsersRoleMapping");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath2 = new File(path + File.separator + "ADMPUsersRoleMapping" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
        }
        out.log(Level.INFO, "Backing up ADMPUsersRoleMapping data finished");
        out.log(Level.INFO, "Backing up ADMPUsersOUMapping data started");
        table = Table.getTable((String)"ADMPUsersOUMapping");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath2 = new File(path + File.separator + "ADMPUsersOUMapping" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath2);
        }
        out.log(Level.INFO, "Backing up ADMPUsersOUMapping data finished");
        out.log(Level.INFO, "Backing up ADSMOUDetails data started");
        ArrayList<String> ouGuidList = new ArrayList<String>();
        Iterator it = dataObj.getRows("ADMPUsersOUMapping");
        while (it.hasNext()) {
            Row row = (Row)it.next();
            ouGuidList.add((String)row.get("OBJECT_GUID"));
        }
        String[] ouGuidArray = new String[ouGuidList.size()];
        ouGuidArray = ouGuidList.toArray(ouGuidArray);
        table = Table.getTable((String)"ADSMOUDetails");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.setCriteria(new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)ouGuidArray, 8));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "ADSMOUDetails" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up ADSMOUDetails data finished");
        out.log(Level.INFO, "Backing up ADMPGroupDelegation data started");
        table = Table.getTable((String)"ADMPGroupDelegation");
        query = new SelectQueryImpl(table);
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            filePath = new File(path + File.separator + "ADMPGroupDelegation" + ".json").getCanonicalPath();
            Do2JsonConverter.serialize((DataObject)dataObj, (String)filePath);
        }
        out.log(Level.INFO, "Backing up ADMPGroupDelegation data finished");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void restoreData(String restoreZipFile, ArrayList<Integer> modules) throws Exception {
        String path = null;
        try {
            int k;
            boolean isModulesExists = true;
            ArrayList<Integer> existingModuleList = new ArrayList<Integer>(Arrays.asList(existingModules));
            for (k = 0; k < modules.size(); ++k) {
                if (existingModuleList.contains(modules.get(k))) continue;
                isModulesExists = false;
                break;
            }
            if (!isModulesExists) {
                ConsoleOut.println((String)("There is no such modules like : " + modules.get(k) + "..Please give a valid module number"));
            } else {
                out.log(Level.INFO, "restoring configuration data started..");
                path = restoreZipFile.substring(0, restoreZipFile.length() - 4);
                File folder = new File(path);
                if (!folder.exists() && !folder.isDirectory()) {
                    folder.mkdirs();
                }
                FileManager.extractZip((String)restoreZipFile, (String)path, (String)new StringBuilder(folder.getName()).reverse().toString());
                String confFileDir = System.getProperty("server.home") + "/conf/";
                PersistenceInitializer.initializeDB((String)confFileDir);
                PersistenceInitializer.initializeMickey((boolean)false);
                ADSMConfigBackupRestoreHandler.handleCacheService("init");
                Hashtable<Long, Long> oldVsNewLayoutIds = new Hashtable<Long, Long>();
                if (modules.contains(ALL_MODULES) || modules.contains(SCHEDULER_MODULE) || modules.contains(LAYOUT_MODULE)) {
                    ADSMConfigBackupRestoreHandler.addCustomAttributes(folder);
                }
                if (modules.contains(ALL_MODULES)) {
                    out.log(Level.INFO, "Restoring up All Modules");
                    ADSMConfigBackupRestoreHandler.restoreADMPRoles(folder);
                    ADSMConfigBackupRestoreHandler.restoreUserLoginData(folder);
                    ADSMConfigBackupRestoreHandler.restoreUserDelegationData(folder);
                    ADSMConfigBackupRestoreHandler.restoreADMPGroupBasedHDT(folder);
                    ADSMConfigBackupRestoreHandler.restoreADMPFileServerMapping(folder);
                    ADSMConfigBackupRestoreHandler.addMailSettingsConfiguration(folder);
                    ADSMConfigBackupRestoreHandler.addSchedulers(folder);
                    ADSMConfigBackupRestoreHandler.restoreNamingFormats(folder);
                    ADSMConfigBackupRestoreHandler.addLayouts(folder, oldVsNewLayoutIds);
                    ADSMConfigBackupRestoreHandler.restoreTechinicianLayoutMapping(folder, oldVsNewLayoutIds);
                } else {
                    if (modules.contains(DELEGATION_MODULE)) {
                        out.log(Level.INFO, "Restoring Delegation Module");
                        ADSMConfigBackupRestoreHandler.restoreADMPRoles(folder);
                        ADSMConfigBackupRestoreHandler.restoreUserLoginData(folder);
                        ADSMConfigBackupRestoreHandler.restoreUserDelegationData(folder);
                        ADSMConfigBackupRestoreHandler.restoreADMPGroupBasedHDT(folder);
                        ADSMConfigBackupRestoreHandler.restoreADMPFileServerMapping(folder);
                    }
                    if (modules.contains(SCHEDULER_MODULE)) {
                        out.log(Level.INFO, "Restoring Scheduler Module");
                        ADSMConfigBackupRestoreHandler.addMailSettingsConfiguration(folder);
                        ADSMConfigBackupRestoreHandler.addSchedulers(folder);
                    }
                    if (modules.contains(LAYOUT_MODULE)) {
                        out.log(Level.INFO, "Restoring Layout Module");
                        ADSMConfigBackupRestoreHandler.restoreNamingFormats(folder);
                        ADSMConfigBackupRestoreHandler.addLayouts(folder, oldVsNewLayoutIds);
                        ADSMConfigBackupRestoreHandler.restoreTechinicianLayoutMapping(folder, oldVsNewLayoutIds);
                    }
                }
                out.log(Level.INFO, "restoring configuration data completed..");
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                ConsoleOut.println((String)"problem while restoring configuration data..please check the logs");
                throw new Exception("problem while restoring configuration data");
            }
            catch (Throwable throwable) {
                try {
                    ADSMConfigBackupRestoreHandler.handleCacheService("destory");
                    if (path != null) {
                        FileUtils.deleteDir(path);
                    }
                    PersistenceInitializer.stopDB();
                    throw throwable;
                }
                catch (Exception ex1) {
                    ex1.printStackTrace();
                    ConsoleOut.println((String)("Problem while Stopping DB - " + ex1.getMessage()));
                    throw new Exception("Problem while Stopping DB");
                }
            }
        }
        try {
            ADSMConfigBackupRestoreHandler.handleCacheService("destory");
            if (path != null) {
                FileUtils.deleteDir((String)path);
            }
            PersistenceInitializer.stopDB();
            return;
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
            ConsoleOut.println((String)("Problem while Stopping DB - " + ex1.getMessage()));
            throw new Exception("Problem while Stopping DB");
        }
    }

    private static void restoreADMPRoles(File folder) throws Exception {
        ADSMConfigBackupRestoreHandler.addData(folder, "ADSRoles");
        ADSMConfigBackupRestoreHandler.addDataWithDependencyTableData(folder, "ADSRoleVsActions", "ADSActions", "ACTION_ID", "ACTION_NAME");
        ADSMConfigBackupRestoreHandler.addDataWithDependencyTableData(folder, "O365RoleVsTab", "O365Tabs", "TAB_ID", "TAB_NAME");
        ADSMConfigBackupRestoreHandler.addDataWithDependencyTableData(folder, "O365RoleVsLHSMenu", "O365LHSPanelMenus", "MENU_ID", "MENU_NAME");
        ADSMConfigBackupRestoreHandler.addData(folder, "ADMPRoles");
        ADSMConfigBackupRestoreHandler.addData(folder, "ADMPRolePermissions");
    }

    private static void restoreADMPGroupBasedHDT(File folder) {
        try {
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPGroupBasedHDT");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPGroupsRoleMapping");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPGroupsOUMapping");
            ADSMConfigBackupRestoreHandler.addData(folder, "GroupBasedHDTGroupDelegation");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADSMGroupGeneralDetails");
            ADSMConfigBackupRestoreHandler.addData(folder, "LoginIDvsADMPGroupMapping");
        }
        catch (Exception e) {
            e.printStackTrace();
            out.log(Level.INFO, "Exception while Restoring GroupBasedDelegation");
        }
    }

    private static void restoreADMPFileServerMapping(File folder) {
        try {
            ADSMConfigBackupRestoreHandler.addData(folder, "ADSMFileServers");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPGroupAllfileserverMap");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPGroupFileServerMap");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPUserAllfileserverMap");
            ADSMConfigBackupRestoreHandler.addData(folder, "ADMPUsersFileServerMap");
        }
        catch (Exception e) {
            e.printStackTrace();
            out.log(Level.INFO, "Exception while Restoring ADMPFileServerMapping");
        }
    }

    private static void restoreUserLoginData(File folder) throws Exception {
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AaaUser", (Criteria)null);
        dataObject.deleteRows("AaaUser", new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)new Long[]{1L, 2L, 3L}, 9));
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        String dataFilePath = folder.getCanonicalPath() + File.separator + "AaaUser" + ".json";
        File dataFileInfo = new File(dataFilePath);
        if (dataFileInfo.exists()) {
            DataObject aaaUserDataObj = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            dataFilePath = folder.getCanonicalPath() + File.separator + "AaaLogin" + ".json";
            dataFileInfo = new File(dataFilePath);
            DataObject aaaLoginDataObj = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            dataFilePath = folder.getCanonicalPath() + File.separator + "AaaAccount" + ".json";
            dataFileInfo = new File(dataFilePath);
            DataObject aaaAccountDataObj = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            Iterator it = aaaUserDataObj.getRows("AaaUser");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Row loginRestoreRow = aaaLoginDataObj.getRow("AaaLogin", new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), row.get("USER_ID"), 0));
                Row accountRestoreRow = aaaAccountDataObj.getRow("AaaAccount", new Criteria(Column.getColumn((String)"AaaAccount", (String)"LOGIN_ID"), loginRestoreRow.get("LOGIN_ID"), 0));
                DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Row userRow = new Row("AaaUser");
                userRow.set("FULL_NAME", row.get("FULL_NAME"));
                userRow.set("USER_ID", row.get("USER_ID"));
                userRow.set("DISPLAY_NAME", row.get("DISPLAY_NAME"));
                userRow.set("EMAIL_ADDRESS", row.get("EMAIL_ADDRESS"));
                userRow.set("FIRST_NAME", row.get("FIRST_NAME"));
                userRow.set("MIDDLE_NAME", row.get("MIDDLE_NAME"));
                userRow.set("LAST_NAME", row.get("LAST_NAME"));
                userRow.set("DESCRIPTION", row.get("DESCRIPTION"));
                dobj.addRow(userRow);
                Row loginRow = new Row("AaaLogin");
                loginRow.set("LOGIN_ID", loginRestoreRow.get("LOGIN_ID"));
                loginRow.set("NAME", loginRestoreRow.get("NAME"));
                loginRow.set("USER_ID", loginRestoreRow.get("USER_ID"));
                loginRow.set("DOMAINNAME", loginRestoreRow.get("DOMAINNAME"));
                dobj.addRow(loginRow);
                Row accRow = new Row("AaaAccount");
                accRow.set("ACCOUNT_ID", accountRestoreRow.get("ACCOUNT_ID"));
                accRow.set("SERVICE_ID", (Object)AuthUtil.getServiceId((String)"System"));
                accRow.set("ACCOUNTPROFILE_ID", (Object)AuthUtil.getAccountProfileId((String)"Profile 1"));
                accRow.set("LOGIN_ID", loginRow.get("LOGIN_ID"));
                Row passwordRow = new Row("AaaPassword");
                passwordRow.set("PASSWORD", loginRestoreRow.get("NAME"));
                passwordRow.set("PASSWDPROFILE_ID", (Object)AuthUtil.getPasswordProfileId((String)"Profile 1"));
                dobj.addRow(passwordRow);
                Row accPassRow = new Row("AaaAccPassword");
                accPassRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
                accPassRow.set("PASSWORD_ID", passwordRow.get("PASSWORD_ID"));
                dobj.addRow(accPassRow);
                Row accAuthRow = new Row("AaaAuthorizedRole");
                accAuthRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
                accAuthRow.set("ROLE_ID", (Object)AuthUtil.getRoleId((String)"Administrator"));
                dobj.addRow(accAuthRow);
                dobj.addRow(accRow);
                int noOfSubAccounts = -1;
                Row accOwnerProfileRow = new Row("AaaAccOwnerProfile");
                accOwnerProfileRow.set("ACCOUNT_ID", accRow.get("ACCOUNT_ID"));
                accOwnerProfileRow.set("ALLOWED_SUBACCOUNT", (Object)new Integer(noOfSubAccounts));
                dobj.addRow(accOwnerProfileRow);
                AuthUtil.createUserAccount((DataObject)dobj);
            }
        }
        ADSMConfigBackupRestoreHandler.addData(folder, "AaaAccountStatus");
        ADSMConfigBackupRestoreHandler.addData(folder, "AaaUserStatus");
        DataObject accDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AaaAccountStatus", new Criteria(Column.getColumn((String)"AaaAccountStatus", (String)"ACCOUNT_ID"), (Object)new Long[]{2L, 3L}, 8));
        Iterator iterator = accDataObject.getRows("AaaAccountStatus");
        ArrayList<Long> defaultTechIds = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Row r = (Row)iterator.next();
            Long accountId = (Long)r.get("ACCOUNT_ID");
            defaultTechIds.add(accountId);
        }
        Long[] defaultTechIdsArray = new Long[defaultTechIds.size()];
        defaultTechIdsArray = defaultTechIds.toArray(defaultTechIdsArray);
        dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AaaUser", new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)new Long[]{2L, 3L}, 8));
        dataObject.deleteRows("AaaUser", new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)defaultTechIdsArray, 9));
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
    }

    private static void restoreUserDelegationData(File folder) throws Exception {
        ADSMConfigBackupRestoreHandler.addData(folder, "ADSTechnicianDelegatedRoles");
        ADSMConfigBackupRestoreHandler.addData(folder, "ADMPUsersRoleMapping");
        ADSMConfigBackupRestoreHandler.addData(folder, "ADSMOUDetails");
        ADSMConfigBackupRestoreHandler.addData(folder, "ADMPUsersOUMapping");
        ADSMConfigBackupRestoreHandler.addData(folder, "ADMPGroupDelegation");
    }

    private static void addData(File folder, String tableName) throws Exception {
        Criteria crit = null;
        if (tableName.equalsIgnoreCase("AaaUserStatus") || tableName.equalsIgnoreCase("AaaAccountStatus")) {
            String columnName = tableName.equalsIgnoreCase("AaaUserStatus") ? "USER_ID" : "ACCOUNT_ID";
            crit = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)1L, 1);
        }
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
        dataObject.deleteRows(tableName, (Criteria)null);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        String dataFilePath = folder.getCanonicalPath() + File.separator + tableName + ".json";
        File dataFileInfo = new File(dataFilePath);
        if (dataFileInfo.exists()) {
            DataObject dataObj = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            if (tableName.equalsIgnoreCase("ADMPRolePermissions")) {
                ArrayList<Long> actionIds = new ArrayList<Long>();
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADMPActionDetails"));
                query.addSelectColumn(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"));
                DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                Iterator it = obj.getRows("ADMPActionDetails");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    actionIds.add((Long)r.get("ACTION_ID"));
                }
                dataObj.deleteRows(tableName, new Criteria(Column.getColumn((String)"ADMPRolePermissions", (String)"ACTION_ID"), (Object)actionIds.toArray(new Long[actionIds.size()]), 9));
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
    }

    private static void addDataWithDependencyTableData(File folder, String tableName, String dependencyTableName, String dependencyColumn, String mappingColumn) throws Exception {
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, (Criteria)null);
        dataObject.deleteRows(tableName, (Criteria)null);
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
        String dataFilePath = folder.getCanonicalPath() + File.separator + tableName + ".json";
        File dataFileInfo = new File(dataFilePath);
        String dependencyDataFilePath = folder.getCanonicalPath() + File.separator + dependencyTableName + ".json";
        File dependencydDataFileInfo = new File(dependencyDataFilePath);
        Hashtable<Object, Object> oldData = new Hashtable<Object, Object>();
        if (dependencydDataFileInfo.exists()) {
            DataObject dependenyDataObj = Json2DoConverter.transform((String)dependencydDataFileInfo.getCanonicalPath(), (boolean)false);
            Iterator it = dependenyDataObj.getRows(dependencyTableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                oldData.put(r.get(dependencyColumn), r.get(mappingColumn));
            }
        }
        Table currentDependencytable = Table.getTable((String)dependencyTableName);
        SelectQueryImpl query = new SelectQueryImpl(currentDependencytable);
        query.addSelectColumn(Column.getColumn((String)dependencyTableName, (String)dependencyColumn));
        query.addSelectColumn(Column.getColumn((String)dependencyTableName, (String)mappingColumn));
        DataObject currentDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        Hashtable<Object, Object> newData = new Hashtable<Object, Object>();
        if (!currentDataObj.isEmpty()) {
            Iterator it = currentDataObj.getRows(dependencyTableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                newData.put(r.get(mappingColumn), r.get(dependencyColumn));
            }
        }
        if (oldData.isEmpty() || newData.isEmpty()) {
            throw new Exception("cannot restore..DB entries missing for " + dependencyTableName);
        }
        if (dataFileInfo.exists()) {
            DataObject dataObj = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Object dependencyColumnValue = oldData.get(r.get(dependencyColumn));
                if (dependencyColumnValue == null) {
                    throw new Exception("Error while restoring  " + tableName);
                }
                Object updateValue = newData.get(dependencyColumnValue);
                if (updateValue == null) {
                    throw new Exception("Error while restoring  " + tableName);
                }
                r.set(dependencyColumn, updateValue);
                dataObj.updateRow(r);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
    }

    private static void addSchedulers(File folder) throws Exception {
        Long newScheduleId;
        Long oldScheduleId;
        DataObject aaaDataObj;
        prefixStr = "ADSMSchedule_";
        FilenameFilter filter1 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null ? name.startsWith(prefixStr) : false;
            }
        };
        File[] jsonFiles = folder.listFiles(filter1);
        out.log(Level.INFO, "restoring normal schedule json files");
        ArrayList<Long> loginIdList = new ArrayList<Long>();
        String aaaLoginFilePath = folder.getCanonicalPath() + File.separator + "AaaLogin" + ".json";
        File aaaDataFileInfo = new File(aaaLoginFilePath);
        if (aaaDataFileInfo.exists() && !(aaaDataObj = Json2DoConverter.transform((String)aaaDataFileInfo.getCanonicalPath(), (boolean)false)).isEmpty()) {
            Iterator it = aaaDataObj.getRows("AaaLogin");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                loginIdList.add((Long)row.get("LOGIN_ID"));
            }
        }
        if (jsonFiles != null) {
            for (File jsonFile : jsonFiles) {
                String jsonFileName = jsonFile.getName();
                out.log(Level.INFO, "data insetion for normal schedule: " + jsonFileName);
                String jsonFilePath = folder.getCanonicalPath() + File.separator + jsonFileName;
                File jsonFileInfo = new File(jsonFilePath);
                DataObject scheduleDataObject = Json2DoConverter.transform((String)jsonFileInfo.getCanonicalPath(), (boolean)false);
                Row r = scheduleDataObject.getFirstRow("ADSMScheduler");
                String scheduleName = (String)r.get("SCHEDULER_NAME");
                oldScheduleId = (Long)r.get("SCHEDULE_ID");
                newScheduleId = SchedulerHandler.createScheduleForCopy((String)scheduleName, (DataObject)scheduleDataObject, (Long)CommonUtil.ADMIN_LOGIN_ID, (Hashtable)customAttribHash, loginIdList);
                if (newScheduleId == null) continue;
                scheduleIdHash.put(oldScheduleId, newScheduleId);
            }
        }
        ADSMConfigBackupRestoreHandler.addO365AccountConfigData(folder);
        ADSMConfigBackupRestoreHandler.addO365Groups(folder);
        prefixStr = "ADSMAdvancedSchedule_";
        FilenameFilter filter2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null ? name.startsWith(prefixStr) : false;
            }
        };
        jsonFiles = folder.listFiles(filter2);
        out.log(Level.INFO, "restoring advanced schedule json files");
        if (jsonFiles != null) {
            for (File jsonFile : jsonFiles) {
                String jsonFileName = jsonFile.getName();
                out.log(Level.INFO, "data insetion for advanced schedule: " + jsonFileName);
                String jsonFilePath = folder.getCanonicalPath() + File.separator + jsonFileName;
                File jsonFileInfo = new File(jsonFilePath);
                DataObject scheduleDataObject = Json2DoConverter.transform((String)jsonFileInfo.getCanonicalPath(), (boolean)false);
                Row r = scheduleDataObject.getFirstRow("ADSMAdvancedScheduler");
                oldScheduleId = (Long)r.get("SCHEDULE_ID");
                newScheduleId = AdvancedSchedulerUtil.createAdvanceScheduleFromDO((DataObject)scheduleDataObject, (Hashtable)customAttribHash, (Hashtable)o365AccountIdHash, loginIdList);
                if (newScheduleId == null) continue;
                scheduleIdHash.put(oldScheduleId, newScheduleId);
            }
        }
        if (!scheduleIdHash.isEmpty()) {
            String shareScheduleTableName = "ScheduleIdVsLoginIdMapping";
            String shareScheduleFilePath = folder.getCanonicalPath() + File.separator + shareScheduleTableName + ".json";
            File shareScheduleFileInfo = new File(shareScheduleFilePath);
            if (shareScheduleFileInfo.exists()) {
                DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(shareScheduleTableName, (Criteria)null);
                dataObject.deleteRows(shareScheduleTableName, (Criteria)null);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
                DataObject shareScheduleDataObj = Json2DoConverter.transform((String)shareScheduleFileInfo.getCanonicalPath(), (boolean)false);
                if (!shareScheduleDataObj.isEmpty()) {
                    DataObject newShareScheduleDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    Iterator it = shareScheduleDataObj.getRows(shareScheduleTableName);
                    while (it.hasNext()) {
                        Row existingRow = (Row)it.next();
                        Long scheduleId = (Long)existingRow.get("SCHEDULE_ID");
                        if (scheduleIdHash.get(scheduleId) == null) continue;
                        Row newRow = new Row(shareScheduleTableName);
                        newRow.set("SCHEDULE_ID", (Object)((Long)scheduleIdHash.get(scheduleId)));
                        newRow.set("LOGIN_ID", existingRow.get("LOGIN_ID"));
                        newShareScheduleDataObject.addRow(newRow);
                    }
                    if (!newShareScheduleDataObject.isEmpty()) {
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(newShareScheduleDataObject);
                    }
                }
            }
        }
    }

    public static void addCustomAttributes(File folder) throws Exception {
        try {
            String dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMCustomFields" + ".json";
            File dataFileInfo = new File(dataFilePath);
            DataObject dependencyTableDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            ArrayList<String> attribLdapNames = new ArrayList<String>();
            if (!dependencyTableDO.isEmpty()) {
                Iterator iterator = dependencyTableDO.getRows("ADSMCustomFields");
                while (iterator.hasNext()) {
                    String mgmtActions;
                    Row row = (Row)iterator.next();
                    HashMap<String, Object> fieldDetails = new HashMap<String, Object>();
                    fieldDetails.put("displayName", (String)row.get("DISPLAY_NAME"));
                    String ldapName = (String)row.get("LDAP_NAME");
                    attribLdapNames.add(ldapName);
                    fieldDetails.put("ldapName", ldapName);
                    fieldDetails.put("dataType", (String)row.get("DATA_TYPE"));
                    String associatedReports = (String)row.get("FOR_REPORTS");
                    if (associatedReports == null) {
                        associatedReports = "";
                    }
                    ArrayList<String> associatedTables = new ArrayList<String>();
                    if (associatedReports.length() > 0) {
                        for (int i = 0; i < CustomAttribUtil.reports.length; ++i) {
                            if (!associatedReports.contains(CustomAttribUtil.reports[i])) continue;
                            associatedTables.add(CustomAttribUtil.tableArray[i]);
                        }
                    }
                    if ((mgmtActions = (String)row.get("MGMT_ACTIONS")) == null) {
                        mgmtActions = "";
                    }
                    ArrayList<String> mgmtArray = new ArrayList<String>();
                    if (mgmtActions.length() > 0) {
                        for (int i = 0; i < CustomAttribUtil.paramArray.length; ++i) {
                            if (!mgmtActions.contains(CustomAttribUtil.paramArray[i])) continue;
                            mgmtArray.add(CustomAttribUtil.paramArray[i]);
                        }
                    }
                    fieldDetails.put("associatedTables", associatedTables);
                    fieldDetails.put("forReports", associatedReports);
                    fieldDetails.put("mgmtAction", mgmtActions);
                    fieldDetails.put("mgmtArray", mgmtArray);
                    CustomAttribUtil.addCustomFields(CommonUtil.ADMIN_LOGIN_ID, fieldDetails);
                }
            }
            if (!attribLdapNames.isEmpty()) {
                String customFilePath;
                File customDataFileInfo;
                DataObject oldDO;
                Table attribSqTable = Table.getTable((String)"ADSMAttributeDetails");
                SelectQueryImpl attribSq = new SelectQueryImpl(attribSqTable);
                attribSq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
                attribSq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
                attribSq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
                attribSq.setCriteria(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)attribLdapNames.toArray(), 8));
                DataObject attribDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)attribSq);
                if (!attribDO.isEmpty() && !(oldDO = Json2DoConverter.transform((String)(customDataFileInfo = new File(customFilePath = folder.getCanonicalPath() + File.separator + "CustomAttributeIds" + ".json")).getCanonicalPath(), (boolean)false)).isEmpty()) {
                    Iterator iterator = attribDO.getRows("ADSMAttributeDetails");
                    while (iterator.hasNext()) {
                        Row newRow = (Row)iterator.next();
                        String tableName = (String)newRow.get("TABLE_NAME");
                        String attribLdapName = (String)newRow.get("ATTRIB_LDAP_NAME");
                        Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"), (Object)tableName, 0);
                        crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)attribLdapName, 0));
                        Row oldRow = oldDO.getRow("ADSMAttributeDetails", crit);
                        customAttribHash.put(oldRow.get("ATTRIB_ID"), newRow.get("ATTRIB_ID"));
                    }
                }
            }
        }
        catch (FileNotFoundException ex) {
            out.log(Level.INFO, "custom attributes does not exist..");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("exception occured while adding custom attributes");
        }
    }

    public static void addMailSettingsConfiguration(File folder) throws Exception {
        try {
            String dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMailSettings" + ".json";
            File dataFileInfo = new File(dataFilePath);
            DataObject dependencyTableDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            if (!dependencyTableDO.isEmpty()) {
                Row row = dependencyTableDO.getFirstRow("ADSMailSettings");
                JSONObject rowJSON = row.getAsJSON();
                JSONObject newJSON = new JSONObject();
                Iterator keys = rowJSON.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = rowJSON.get(key);
                    if (key.equalsIgnoreCase("unique_id") || value == null) continue;
                    newJSON.put(key.toUpperCase(), value);
                }
                MailHandler.setMailSettings((JSONObject)newJSON, (boolean[])new boolean[0]);
            }
        }
        catch (FileNotFoundException ex) {
            out.log(Level.INFO, "mail settings data does not exist..");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("exception occured while adding mailsettings");
        }
    }

    public static void addO365Groups(File folder) throws Exception {
        try {
            String dataFilePath = folder.getCanonicalPath() + File.separator + "O365GroupGeneralDetails" + ".json";
            File dataFileInfo = new File(dataFilePath);
            DataObject dependencyTableDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            if (!dependencyTableDO.isEmpty()) {
                DataObject toBeAddedDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Iterator iter = dependencyTableDO.getRows("O365GroupGeneralDetails");
                while (iter.hasNext()) {
                    Row newRow = new Row("O365GroupGeneralDetails");
                    Row existingRow = (Row)iter.next();
                    List columns = newRow.getColumns();
                    for (String columnName : columns) {
                        if (existingRow.get(columnName) == null) continue;
                        newRow.set(columnName, existingRow.get(columnName));
                    }
                    toBeAddedDataObject.addRow(newRow);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(toBeAddedDataObject);
            }
        }
        catch (FileNotFoundException ex) {
            out.log(Level.INFO, "o365 group data does not exist");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("exception occured while adding o365 groups");
        }
    }

    public static void addO365AccountConfigData(File folder) throws Exception {
        try {
            out.log(Level.INFO, "adding o365 account config");
            String dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMWAADDomainConfiguration" + ".json";
            File dataFileInfo = new File(dataFilePath);
            DataObject ADSMWAADDomainConfigurationDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            dataFilePath = folder.getCanonicalPath() + File.separator + "WAADADMapping" + ".json";
            dataFileInfo = new File(dataFilePath);
            DataObject WAADADMappingDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMWAADDomainDetails" + ".json";
            dataFileInfo = new File(dataFilePath);
            DataObject ADSMWAADDomainDetailsDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMWAADADDomainLinkDetails" + ".json";
            dataFileInfo = new File(dataFilePath);
            DataObject ADSMWAADADDomainLinkDetailsDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            if (!ADSMWAADDomainConfigurationDO.isEmpty()) {
                DataObject toBeAddedDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Iterator iter = ADSMWAADDomainConfigurationDO.getRows("ADSMWAADDomainConfiguration");
                while (iter.hasNext()) {
                    Row newRow;
                    DataObject o365DomainDataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    Row o365AccoutRow = new Row("ADSMWAADDomainConfiguration");
                    Row existingRow = (Row)iter.next();
                    List columns = o365AccoutRow.getColumns();
                    for (String columnName : columns) {
                        if (columnName.equalsIgnoreCase("WAAD_DOMAIN_ID") || existingRow.get(columnName) == null) continue;
                        o365AccoutRow.set(columnName, existingRow.get(columnName));
                    }
                    o365DomainDataObject.addRow(o365AccoutRow);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(o365DomainDataObject);
                    Long oldDomainId = (Long)existingRow.get("WAAD_DOMAIN_ID");
                    Row firstRow = o365DomainDataObject.getFirstRow("ADSMWAADDomainConfiguration");
                    Long newDomainId = (Long)firstRow.get("WAAD_DOMAIN_ID");
                    out.log(Level.INFO, "oldDomainId--" + oldDomainId);
                    o365AccountIdHash.put(oldDomainId, newDomainId);
                    Criteria childCrit = new Criteria(Column.getColumn((String)"WAADADMapping", (String)"WAAD_DOMAIN_ID"), (Object)oldDomainId, 0);
                    Iterator childIterator = WAADADMappingDO.getRows("WAADADMapping", childCrit);
                    while (childIterator.hasNext()) {
                        newRow = new Row("WAADADMapping");
                        existingRow = (Row)childIterator.next();
                        newRow.set("WAAD_DOMAIN_ID", (Object)newDomainId);
                        newRow.set("AD_OBJECT_CLASS_NAME", existingRow.get("AD_OBJECT_CLASS_NAME"));
                        newRow.set("ATTRIB_ID", existingRow.get("ATTRIB_ID"));
                        newRow.set("WAAD_ATTRIB_NAME", existingRow.get("WAAD_ATTRIB_NAME"));
                        toBeAddedDataObject.addRow(newRow);
                    }
                    childCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainDetails", (String)"WAAD_DOMAIN_ID"), (Object)oldDomainId, 0);
                    childIterator = ADSMWAADDomainDetailsDO.getRows("ADSMWAADDomainDetails", childCrit);
                    while (childIterator.hasNext()) {
                        newRow = new Row("ADSMWAADDomainDetails");
                        existingRow = (Row)childIterator.next();
                        columns = newRow.getColumns();
                        for (String columnName : columns) {
                            if (columnName.equalsIgnoreCase("UNIQUE_ID") || existingRow.get(columnName) == null) continue;
                            if (columnName.equalsIgnoreCase("WAAD_DOMAIN_ID")) {
                                newRow.set(columnName, (Object)newDomainId);
                                continue;
                            }
                            newRow.set(columnName, existingRow.get(columnName));
                        }
                        toBeAddedDataObject.addRow(newRow);
                    }
                    childCrit = new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"WAAD_DOMAIN_ID"), (Object)oldDomainId, 0);
                    childIterator = ADSMWAADADDomainLinkDetailsDO.getRows("ADSMWAADADDomainLinkDetails", childCrit);
                    while (childIterator.hasNext()) {
                        newRow = new Row("ADSMWAADADDomainLinkDetails");
                        existingRow = (Row)childIterator.next();
                        newRow.set("WAAD_DOMAIN_ID", (Object)newDomainId);
                        newRow.set("AD_DOMAIN_NAME", existingRow.get("AD_DOMAIN_NAME"));
                        newRow.set("IAMAPP_ID", existingRow.get("IAMAPP_ID"));
                        toBeAddedDataObject.addRow(newRow);
                    }
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(toBeAddedDataObject);
            }
            ADSMConfigBackupRestoreHandler.addData(folder, "O365AccountConfiguration");
            ADSMConfigBackupRestoreHandler.addData(folder, "O365Domains");
        }
        catch (FileNotFoundException ex) {
            out.log(Level.INFO, "o365 domain config does not exist");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("exception occured while adding o365 config data");
        }
    }

    private static void handleCacheService(String action) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"Service"));
            sq.addSelectColumn(Column.getColumn((String)"Service", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ServiceProperties", (String)"*"));
            Join j1 = new Join("Service", "ServiceProperties", new String[]{"SERVICE_ID"}, new String[]{"SERVICE_ID"}, 1);
            Join j2 = new Join("Service", "Module", new String[]{"MODULE_ID"}, new String[]{"MODULE_ID"}, 1);
            sq.addJoin(j1);
            sq.addJoin(j2);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"Module", (String)"MODULEORDER"), true));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"Service", (String)"ORDER_ID"), true));
            sq.setCriteria(new Criteria(Column.getColumn((String)"Service", (String)"SERVICE_NAME"), (Object)"CacheService", 0));
            DataObject services = DataAccess.get((SelectQuery)sq);
            Row serviceRow = services.getRow("Service");
            if (serviceRow != null) {
                WritableDataObject serviceDO = (WritableDataObject)services.getDataObject(services.getTableNames(), serviceRow);
                if (action.equals("init")) {
                    service = (Service)Class.forName((String)serviceRow.get(5)).newInstance();
                    service.create((DataObject)serviceDO);
                } else if (service != null) {
                    service.destroy();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void restoreNamingFormats(File folder) throws Exception {
        try {
            String dataFilePath = folder.getCanonicalPath() + File.separator + "NamingFormats" + ".json";
            File dataFileInfo = new File(dataFilePath);
            DataObject formatsDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADSMCustomFormats", (String)"FORMAT_ID"), null, 1));
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(formatsDO);
            dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMUmlautConfigurations" + ".json";
            dataFileInfo = new File(dataFilePath);
            formatsDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADSMUmlautConfigurations", (String)"UMLAUT_ID"), null, 1));
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(formatsDO);
            dataFilePath = folder.getCanonicalPath() + File.separator + "ADSMFormatDefaultSettings" + ".json";
            dataFileInfo = new File(dataFilePath);
            formatsDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADSMFormatDefaultSettings", (String)"SETTING_ID"), null, 1));
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(formatsDO);
        }
        catch (FileNotFoundException e) {
            out.log(Level.INFO, "Naming format config does not exist");
        }
    }

    public static void restoreTechinicianLayoutMapping(File folder, Hashtable<Long, Long> oldVsNewLayoutIds) throws Exception {
        try {
            out.log(Level.INFO, "Restoring HDT Template data started");
            ADSMConfigBackupRestoreHandler.addTechnicianLayoutMapping(folder, "AaaLogin", "LOGIN_ID", "FcHDTtoAllLayoutMapping", "FcHDTtoLayoutMapping", true, oldVsNewLayoutIds);
            out.log(Level.INFO, "Restoring HDT Template data finished");
            out.log(Level.INFO, "Restoring Group HDT Template data started");
            ADSMConfigBackupRestoreHandler.addTechnicianLayoutMapping(folder, "ADMPGroupBasedHDT", "GROUP_ID", "FcHDTGroupToAllLayoutMapping", "FcHDTGroupToLayoutMapping", false, oldVsNewLayoutIds);
            out.log(Level.INFO, "Restoring Group HDT Template data finished");
            out.log(Level.INFO, "Restoring Requester Template data started");
            ADSMConfigBackupRestoreHandler.addTechnicianLayoutMapping(folder, "AaaLogin", "LOGIN_ID", "FcRequesterAllLayoutMapping", "FcRequestertoLayoutMapping", false, oldVsNewLayoutIds);
            out.log(Level.INFO, "Restoring Requester Template data finished");
            out.log(Level.INFO, "Restoring Requester Policy Template data started");
            ADSMConfigBackupRestoreHandler.addTechnicianLayoutMapping(folder, "RequesterPolicyConfiguration", "POLICY_ID", "FcRequesterPolicyAllLayoutMap", "FcRequesterPolicytoLayoutMap", false, oldVsNewLayoutIds);
            out.log(Level.INFO, "Restoring Requester Policy Template data finished");
        }
        catch (FileNotFoundException e) {
            out.log(Level.INFO, "Layout mapping config does not exist");
        }
    }

    private static void addTechnicianLayoutMapping(File folder, String loginTableName, String loginColumn, String allLayoutTable, String layoutTable, Boolean isTypeOfDataAvail, Hashtable<Long, Long> oldVsNewLayoutIds) throws Exception {
        String dataFilePath = folder.getCanonicalPath() + File.separator + allLayoutTable + ".json";
        File dataFileInfo = new File(dataFilePath);
        if (dataFileInfo.exists()) {
            DataObject mappingDO = Json2DoConverter.transform((String)dataFileInfo.getCanonicalPath(), (boolean)false);
            Table loginTable = Table.getTable((String)loginTableName);
            SelectQueryImpl hdtLayoutSq = new SelectQueryImpl(loginTable);
            hdtLayoutSq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject hdtLayoutDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)hdtLayoutSq);
            out.log(Level.INFO, "All layout DO :: \n" + hdtLayoutDO);
            Iterator it = hdtLayoutDO.getRows(loginTableName);
            Boolean isChangesAvailable = false;
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String nameColumn = loginTableName.equals("AaaLogin") ? "NAME" : "OBJECT_GUID";
                String domainColumn = loginTableName.equals("AaaLogin") ? "DOMAINNAME" : "DOMAIN_NAME";
                String name = (String)r.get(nameColumn);
                String domainName = (String)r.get(domainColumn);
                Long loginId = (Long)r.get(loginColumn);
                out.log(Level.INFO, "Setting layout data for :: " + domainName + "\\" + name);
                Criteria mappingCri = new Criteria(Column.getColumn((String)loginTableName, (String)nameColumn), (Object)name, 0);
                Row loginMapRow = mappingDO.getRow(loginTableName, mappingCri = mappingCri.and(new Criteria(Column.getColumn((String)loginTableName, (String)domainColumn), (Object)domainName, 0)));
                if (loginMapRow == null) continue;
                out.log(Level.INFO, "Layput backup found.");
                Criteria deleteCri = new Criteria(Column.getColumn((String)allLayoutTable, (String)loginColumn), (Object)loginId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCri);
                deleteCri = new Criteria(Column.getColumn((String)layoutTable, (String)loginColumn), (Object)loginId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCri);
                Long mappingLoginId = (Long)loginMapRow.get(loginColumn);
                mappingCri = ADSMConfigBackupRestoreHandler.getLayoutCriteria(allLayoutTable, loginColumn, mappingLoginId);
                Iterator mappingRows = mappingDO.getRows(allLayoutTable, mappingCri);
                while (mappingRows.hasNext()) {
                    Row mappingRow = (Row)mappingRows.next();
                    mappingRow.set(loginColumn, (Object)loginId);
                    hdtLayoutDO.addRow(mappingRow);
                }
                mappingCri = ADSMConfigBackupRestoreHandler.getLayoutCriteria(layoutTable, loginColumn, mappingLoginId);
                Iterator mappedLayoutIt = mappingDO.getRows(layoutTable, mappingCri);
                while (mappedLayoutIt.hasNext()) {
                    Row mappedLayoutRow = (Row)mappedLayoutIt.next();
                    Long oldLayoutId = (Long)mappedLayoutRow.get("LAYOUT_ID");
                    Long oldTempCatId = (Long)mappedLayoutRow.get("TEMPLATE_CATEGORY_ID");
                    Integer oldTypeOfData = -1;
                    if (isTypeOfDataAvail.booleanValue()) {
                        oldTypeOfData = (Integer)mappedLayoutRow.get("TYPE_OF_DATA");
                    }
                    Boolean isDefaultLayout = (Boolean)mappedLayoutRow.get("IS_DEFAULT_LAYOUT");
                    String domain_Name = (String)mappedLayoutRow.get("DOMAIN_NAME");
                    Long layoutId = oldVsNewLayoutIds.get(oldLayoutId);
                    Row layoutRow = new Row(layoutTable);
                    layoutRow.set(loginColumn, (Object)loginId);
                    layoutRow.set("LAYOUT_ID", (Object)layoutId);
                    layoutRow.set("TEMPLATE_CATEGORY_ID", (Object)oldTempCatId);
                    if (isTypeOfDataAvail.booleanValue()) {
                        layoutRow.set("TYPE_OF_DATA", (Object)oldTypeOfData);
                    }
                    layoutRow.set("DOMAIN_NAME", (Object)domain_Name);
                    layoutRow.set("IS_DEFAULT_LAYOUT", (Object)isDefaultLayout);
                    hdtLayoutDO.addRow(layoutRow);
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(hdtLayoutDO);
        } else {
            out.log(Level.INFO, "No data found for  :: " + allLayoutTable);
        }
    }

    private static Criteria getLayoutCriteria(String layoutTable, String loginColumn, Long loginId) {
        Criteria mappingCri = new Criteria(Column.getColumn((String)layoutTable, (String)loginColumn), (Object)loginId, 0);
        return mappingCri;
    }

    public static void addLayouts(File folder, Hashtable<Long, Long> oldVsNewLayoutIds) throws Exception {
        prefixStr = "Layout_";
        FilenameFilter filter2 = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null ? name.startsWith(prefixStr) : false;
            }
        };
        File[] jsonFiles = folder.listFiles(filter2);
        out.log(Level.INFO, "Restoring Layout json files");
        if (jsonFiles != null) {
            SelectQueryImpl fieldQuery = new SelectQueryImpl(Table.getTable((String)"FcFields"));
            fieldQuery.addJoin(new Join("FcFields", "FcFieldToAttributes", new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 2));
            fieldQuery.addSelectColumn(Column.getColumn((String)"FcFields", (String)"FIELD_ID"));
            fieldQuery.addSelectColumn(Column.getColumn((String)"FcFields", (String)"FIELD_GROUP_ID"));
            fieldQuery.addSelectColumn(Column.getColumn((String)"FcFieldToAttributes", (String)"*"));
            fieldQuery.setCriteria(new Criteria(Column.getColumn((String)"FcFields", (String)"IS_CUSTOM_FIELD"), (Object)true, 0));
            DataObject customFieldsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)fieldQuery);
            DataObject layoutDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcLayout", (Criteria)null);
            for (File dataFileInfo : jsonFiles) {
                FcLayout fcLayout = new FcLayout();
                String jsonFilepath = dataFileInfo.getCanonicalPath();
                out.log(Level.INFO, "Layout File :: " + jsonFilepath);
                JSONObject fcLayoutJSON = ADSMConfigBackupRestoreHandler.getJSONObjectFromFile(jsonFilepath);
                if (fcLayoutJSON != null) {
                    fcLayout.init(fcLayoutJSON);
                    String layoutDomain = fcLayout.getDomainName();
                    Long oldLayoutId = fcLayout.getLayoutId();
                    String oldLayoutName = fcLayout.getLayoutName();
                    out.log(Level.INFO, "Going to restore template :: " + oldLayoutName + " :: Layout ID :: " + oldLayoutId);
                    if (layoutDomain != null && layoutDomain.trim().length() == 0) {
                        layoutDomain = null;
                        fcLayout.setDomainName(layoutDomain);
                    }
                    String action = "save";
                    Criteria existingLayoutCri = new Criteria(Column.getColumn((String)"FcLayout", (String)"LAYOUT_ID"), (Object)oldLayoutId, 0);
                    Row existingLayoutRow = layoutDo.getRow("FcLayout", existingLayoutCri);
                    if (existingLayoutRow != null) {
                        action = "Update";
                    }
                    ADSMConfigBackupRestoreHandler.updteCustomAttributeFieldIds(folder, fcLayout, customFieldsDO);
                    Long newLayoutId = FcLayoutUpdateHandler.saveLayout((FcLayout)fcLayout, (String)action, (Long)CommonUtil.ADMIN_LOGIN_ID);
                    out.log(Level.INFO, "New Layout ID :: " + newLayoutId);
                    oldVsNewLayoutIds.put(oldLayoutId, newLayoutId);
                    Properties props = FcLayoutViewHandler.getTemplateCategoryDetails((Long)fcLayout.getTemplateCategoryId());
                    if (!((Boolean)props.get("IS_RULE_AVAILABLE")).booleanValue()) continue;
                    String ruleFilePath = folder.getCanonicalPath() + File.separator + "MgmtRuleGroup_" + oldLayoutId + ".json";
                    JSONObject mgmtRuleJSON = ADSMConfigBackupRestoreHandler.getJSONObjectFromFile(ruleFilePath);
                    if (mgmtRuleJSON != null && mgmtRuleJSON.length() > 0) {
                        MgmtRuleHandler.saveMgmtRule((String)mgmtRuleJSON.toString(), (Long)newLayoutId, (String)layoutDomain, (Long)fcLayout.getTemplateCategoryId(), (String)"Update");
                        continue;
                    }
                    out.log(Level.INFO, "There is no associated Mgmt Rule for Layout : " + fcLayout.getDomainName());
                    continue;
                }
                out.log(Level.INFO, "Error in JSON Data.");
            }
        } else {
            out.log(Level.INFO, "No Layout JSONs found.");
        }
        out.log(Level.INFO, "Finished restoring Layout Data.");
    }

    private static void updteCustomAttributeFieldIds(File folder, FcLayout fcLayout, DataObject customFieldDO) throws Exception {
        try {
            String fieldFilePath = folder.getCanonicalPath() + File.separator + "FcFieldToAttributes" + ".json";
            File fieldFileInfo = new File(fieldFilePath);
            DataObject fieldToAttribDo = Json2DoConverter.transform((String)fieldFileInfo.getCanonicalPath(), (boolean)false);
            Long templateCategoryId = fcLayout.getTemplateCategoryId();
            Long fieldGroupId = FcLayoutUtil.getLHScustomFieldGroupId((Long)templateCategoryId);
            ArrayList fcTabList = fcLayout.getFcLayoutTabList();
            for (FcLayoutTab fcTab : fcTabList) {
                ArrayList fcSubTabGroupList = fcTab.getFcLayoutSubTabGroupList();
                for (FcLayoutSubTabGroup fcSubTabGroup : fcSubTabGroupList) {
                    ArrayList fcSubTabList = fcSubTabGroup.getFcLayoutSubTabList();
                    for (FcLayoutSubTab fcSubTab : fcSubTabList) {
                        ArrayList fcFieldGroupsList = fcSubTab.getFcLayoutFieldGroupsList();
                        for (FcLayoutFieldGroup fcFieldGroup : fcFieldGroupsList) {
                            ArrayList fcFieldsList = fcFieldGroup.getFcLayoutFieldsList();
                            block6: for (FcLayoutField fcField : fcFieldsList) {
                                Integer oldAttribId;
                                Integer newAttribId;
                                if (!fcField.getIsCustomField().booleanValue()) continue;
                                Long oldFieldId = fcField.getFieldId();
                                Criteria oldFieldCri = new Criteria(Column.getColumn((String)"FcFieldToAttributes", (String)"FIELD_ID"), (Object)oldFieldId, 0);
                                Row oldFieldRow = fieldToAttribDo.getRow("FcFieldToAttributes", oldFieldCri);
                                if (oldFieldRow == null || (newAttribId = (Integer)customAttribHash.get(oldAttribId = (Integer)oldFieldRow.get("ATTRIB_ID"))) == null) continue;
                                Criteria newFieldCri = new Criteria(Column.getColumn((String)"FcFieldToAttributes", (String)"ATTRIB_ID"), (Object)newAttribId, 0);
                                Iterator newFieldAttribIt = customFieldDO.getRows("FcFieldToAttributes", newFieldCri);
                                while (newFieldAttribIt.hasNext()) {
                                    Row newFieldAttribRow = (Row)newFieldAttribIt.next();
                                    Long newFieldId = (Long)newFieldAttribRow.get("FIELD_ID");
                                    newFieldCri = new Criteria(Column.getColumn((String)"FcFields", (String)"FIELD_GROUP_ID"), (Object)fieldGroupId, 0);
                                    Row newFieldRow = customFieldDO.getRow("FcFields", newFieldCri = newFieldCri.and(new Criteria(Column.getColumn((String)"FcFields", (String)"FIELD_ID"), (Object)newFieldId, 0)));
                                    if (newFieldRow == null) continue;
                                    fcField.setFieldId(newFieldId);
                                    continue block6;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            out.log(Level.INFO, "No FcFieldToAttributes JSON found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getJSONObjectFromFile(String jsonFilepath) throws Exception {
        JSONObject jsonObj = null;
        FileReader fileReader = null;
        Reader bufferedReader = null;
        StringBuilder jsonInput = new StringBuilder();
        try {
            int len;
            fileReader = new FileReader(jsonFilepath);
            bufferedReader = new BufferedReader(fileReader);
            char[] buff = new char[4096];
            while ((len = bufferedReader.read(buff)) != -1) {
                jsonInput.append(buff, 0, len);
            }
            jsonObj = new JSONObject(jsonInput.toString());
        }
        catch (FileNotFoundException e) {
            out.log(Level.INFO, "File not found :: " + jsonFilepath);
        }
        finally {
            if (fileReader != null) {
                fileReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return jsonObj;
    }
}

