/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.resultview.RVHandler;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.DelayedSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.SchedulerOperationHandler;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONException;
import org.json.JSONObject;

public class DelayedSchedulerAction
extends DispatchAction {
    public ActionForward viewDelayedTasks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardURL = "viewDelayedTasks";
        return mapping.findForward(forwardURL);
    }

    public ActionForward runNowScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String messageType = "";
        String statusMessage = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long schedule_id = 0L;
            String schedule_idStr = request.getParameter("schedule_id");
            schedule_id = new Long(schedule_idStr);
            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForDelayedTask();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long processingScheduleId = runNowObj.getProcessingScheduler(loginId);
            if (runNowObj.isSameSchedulerProcessing(loginId, schedule_id)) {
                messageType = "Error";
                statusMessage = rb.getString("admp.delayedtask.task_list_list.scheduler_already_in_progress");
            } else if (runNowObj.isSchedulerProcessing(loginId)) {
                messageType = "Error";
                statusMessage = rb.getString("admp.delayedtask.task_list_list.more_than_one_scheduler");
            } else {
                runNowObj.updateScheduleStatus(loginId, schedule_id, "PROCESSING", "", "");
                Long taskInstanceId = SchedulerUtil.getTaskInstanceId((Long)schedule_id);
                Long taskId = SchedulerUtil.getTaskID((String)"DelayedTask");
                if (taskInstanceId != null) {
                    SchedulerOperationHandler.getInstanceForDelayedTask();
                    String stat = SchedulerOperationHandler.execute(taskInstanceId, taskId, loginId, I18NUtil.getDefaultLocale((HttpServletRequest)request));
                    if (stat.equals("LIMIT_REACHED")) {
                        messageType = "Error";
                        statusMessage = rb.getString("admp.delayedtask.task_list.run_now_option_limit_reached");
                    } else {
                        messageType = "Success";
                        statusMessage = rb.getString("admp.delayedtask.run_now.status.successfully_started");
                    }
                }
            }
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = e.getMessage();
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("messageType", (Object)messageType);
        jsonObj.put("statusMessage", (Object)statusMessage);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward runNowSchedulerStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String taskStatus = "";
        String message = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForDelayedTask();
            String schedule_idStr = request.getParameter("schedule_id");
            Long schedule_id = new Long(schedule_idStr);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            taskStatus = runNowObj.getSchedulerStatus(loginId, schedule_id);
            try {
                JSONObject statusJson = new JSONObject(taskStatus);
                boolean isSuccess = statusJson.getBoolean("isSuccess");
                taskStatus = isSuccess ? "Success" : "Error";
                message = rb.getString(statusJson.getString("message"));
            }
            catch (JSONException ex) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("taskStatus", (Object)taskStatus);
                PrintWriter writer = response.getWriter();
                writer.print(jsonObj.toString());
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("taskStatus", (Object)taskStatus);
        jsonObj.put("message", (Object)message);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward modifyScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long scheduleId = Long.valueOf(request.getParameter("scheduleId"));
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String action = request.getParameter("action");
        String statusMessage = rb.getString("admp.mgmt.common.text.successfully_cancelled");
        String messageType = "Success";
        Long taskId = SchedulerUtil.getTaskID((String)"DelayedTask");
        try {
            if (action != null && action.equalsIgnoreCase("Disable")) {
                SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)4);
                DelayedSchedulerUtil.enableDisableDelayedTask((Long)scheduleId, (Boolean)false);
            }
            if (action != null && action.equalsIgnoreCase("Retry")) {
                SchedulerHandler.enableDisableScheduler((Long)scheduleId, (Long)taskId, (int)3);
                DelayedSchedulerUtil.enableDisableDelayedTask((Long)scheduleId, (Boolean)true);
                statusMessage = rb.getString("admp.mgmt.common.text.reset_retried");
            }
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + e.getMessage();
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, messageType, statusMessage);
        return null;
    }

    public ActionForward exportResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject paramsJson = new JSONObject(request.getParameter("params"));
            RVReqParams reqParams = new RVReqParams(paramsJson);
            String exportType = request.getParameter("exportType");
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)reqParams.getRvcId(), 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Hashtable viewConfig = RVHandler.getViewsDetailsForExport((DataObject)rvcDataObject, (Integer)reqParams.getRvcId(), (AdventNetResourceBundle)rb);
            ReportExportUtil.exportDelayedTask(viewConfig, reqParams, exportType, rvcDataObject, rb, true, request, response, loginId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

