/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class AdminUtil {
    public static DataObject getFormats() {
        return UserMgmtUtil.getFormats();
    }

    public static String getFormatValue(Long formatId) {
        String value = null;
        try {
            Criteria crit = new Criteria(new Column("ADSMFormats", "FORMAT_ID"), (Object)formatId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormats", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("ADSMFormats");
                value = (String)r.get("FORMAT_VALUE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getFormatDisplayName(Long formatId) {
        String value = null;
        try {
            Row r;
            Criteria crit = new Criteria(new Column("ADSMFormats", "FORMAT_ID"), (Object)formatId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormats", crit);
            if (!obj.isEmpty()) {
                r = obj.getFirstRow("ADSMFormats");
                value = (String)r.get("FORMAT_DISPLAY_NAME");
            }
            if (value == null) {
                crit = new Criteria(new Column("ADSMFormatRules", "FORMAT_ID"), (Object)formatId, 0);
                obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatRules", crit);
                if (!obj.isEmpty()) {
                    r = obj.getFirstRow("ADSMFormatRules");
                    value = (String)r.get("RULE_NAME");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static String getRuleDisplayName(Long ruleId) {
        String value = null;
        try {
            Criteria crit = new Criteria(new Column("ADSMFormatRules", "FORMAT_ID"), (Object)ruleId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatRules", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("ADSMFormatRules");
                value = (String)r.get("RULE_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static void setFormatsAndRules(HashMap props, HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            ArrayList displayList = new ArrayList();
            ArrayList valueList = new ArrayList();
            Hashtable<String, ArrayList> formatHash = FormatClientUtil.getNamingFormats(rb);
            displayList = formatHash.get("displayList");
            valueList = formatHash.get("valueList");
            props.put("formats", displayList);
            props.put("formatValues", valueList);
            displayList = new ArrayList();
            valueList = new ArrayList();
            Hashtable<String, ArrayList> ruleHash = FormatClientUtil.getNamingFormatRules(rb);
            displayList = ruleHash.get("displayList");
            valueList = ruleHash.get("valueList");
            props.put("rules", displayList);
            props.put("ruleValues", valueList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setFormats(HashMap props, HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            ArrayList<String> displayList = new ArrayList<String>();
            ArrayList<Object> valueList = new ArrayList<Object>();
            String element = rb.getString("admp.common.text.select_format");
            displayList.add(element);
            valueList.add("--");
            DataObject obj = AdminUtil.getFormats();
            Iterator it = obj.getRows("ADSMFormats");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String elt = rb.getString((String)r.get("FORMAT_DISPLAY_NAME"));
                displayList.add(elt);
                valueList.add(r.get("FORMAT_ID"));
            }
            props.put("formats", displayList);
            props.put("formatValues", valueList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setMailAliasFormats(HashMap props) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            ArrayList<String> displayList = new ArrayList<String>();
            ArrayList<Long> valueList = new ArrayList<Long>();
            DataObject obj = AdminUtil.getFormats();
            Iterator it = obj.getRows("ADSMFormats");
            while (it.hasNext()) {
                String elt;
                Row r = (Row)it.next();
                String formatValue = (String)r.get("FORMAT_VALUE");
                Long formatId = (Long)r.get("FORMAT_ID");
                if (formatValue.indexOf("logonName") != -1) {
                    elt = rb.getString((String)r.get("FORMAT_DISPLAY_NAME"));
                    displayList.add(0, elt);
                    valueList.add(0, formatId);
                    continue;
                }
                elt = rb.getString((String)r.get("FORMAT_DISPLAY_NAME"));
                displayList.add(elt);
                valueList.add(formatId);
            }
            props.put("formats", displayList);
            props.put("formatValues", valueList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setRefValue(String refParam, Boolean refValue) {
        try {
            Column col = new Column("ADSMRefParameters", "REF_PARAM_NAME");
            Criteria criteria = new Criteria(col, (Object)refParam, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMRefParameters", criteria);
            if (dataObject.isEmpty()) {
                Row row = new Row("ADSMRefParameters");
                row.set("REF_PARAM_NAME", (Object)refParam);
                row.set("REF_PARAM_VALUE", (Object)refValue.toString());
                dataObject.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
            } else {
                Row row = dataObject.getFirstRow("ADSMRefParameters");
                row.set("REF_PARAM_VALUE", (Object)refValue.toString());
                dataObject.updateRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean getRefValue(String refParam) {
        Boolean refValue = false;
        try {
            Column col = new Column("ADSMRefParameters", "REF_PARAM_NAME");
            Criteria criteria = new Criteria(col, (Object)refParam, 0);
            DataObject dataObject = CommonUtil.getCachedPersistence().get("ADSMRefParameters", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("ADSMRefParameters");
                refValue = Boolean.valueOf((String)row.get("REF_PARAM_VALUE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return refValue;
    }

    public static DataObject comboAttribs(String attribType) {
        return AdminUtil.comboAttribs(attribType, null);
    }

    public static DataObject comboAttribs(String attribType, String domainName) {
        DataObject obj = null;
        String tableName = "ADSMOrgAttributes";
        try {
            Criteria crit = new Criteria(new Column(tableName, "ORG_ATTRIB_TYPE"), (Object)attribType, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)"FALSE", 0));
            if (domainName != null) {
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            }
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            query.setCriteria(crit);
            query.addSortColumn(new SortColumn(tableName, "ORG_ATTRIB_NAME", true));
            query.addSelectColumn(new Column(tableName, "*"));
            obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static String getComboString(String attribType, AdventNetResourceBundle rb) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> comboList = new ArrayList<String>();
        try {
            DataObject dataObject = AdminUtil.comboAttribs(attribType);
            Iterator it = dataObject.getRows("ADSMOrgAttributes");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                comboList.add(rb.getString((String)r.get("ORG_ATTRIB_NAME")));
            }
            buffer.append("\"dummy\"");
            for (int i = 0; i < comboList.size(); ++i) {
                String value = (String)comboList.get(i);
                buffer.append(",\"" + i + "\"" + "," + "\"" + ClientUtil.scriptEscape(value) + "\"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static Hashtable getOrgAttrib(String attribID, AdventNetResourceBundle rb) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            Table table = new Table("ADSMOrgAttributes");
            Criteria crit = new Criteria(new Column("ADSMOrgAttributes", "ORG_ATTRIB_ID"), (Object)attribID, 0);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.setCriteria(crit);
            query.addSelectColumn(new Column("ADSMOrgAttributes", "*"));
            query.addSortColumn(new SortColumn("ADSMOrgAttributes", "ORG_ATTRIB_NAME", true));
            DataObject object = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Iterator it = object.getRows("ADSMOrgAttributes");
            if (it.hasNext()) {
                Row r = (Row)it.next();
                hash.put("ORG_ATTRIB_TYPE", r.get("ORG_ATTRIB_TYPE"));
                hash.put("ORG_ATTRIB_NAME", rb.getString((String)r.get("ORG_ATTRIB_NAME")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static HashMap<String, Object> isDeletableOrgAtrrib(String[] attribID, AdventNetResourceBundle rb) {
        HashMap attribDetails = new HashMap();
        ArrayList<Long> cantDeleteUniqueIdList = new ArrayList<Long>();
        ArrayList<String> deletableAttribsIdList = new ArrayList<String>(Arrays.asList(attribID));
        Hashtable<String, Long> orgAttribIdMapping = new Hashtable<String, Long>();
        String type = "";
        try {
            Criteria crit = null;
            for (int i = 0; i < attribID.length; ++i) {
                Hashtable attrib = AdminUtil.getOrgAttrib(attribID[i], rb);
                type = (String)attrib.get("ORG_ATTRIB_TYPE");
                String value = (String)attrib.get("ORG_ATTRIB_NAME");
                orgAttribIdMapping.put(type + "_" + value, Long.parseLong(attribID[i]));
                Criteria crit1 = new Criteria(Column.getColumn((String)"FcOrgAttributeVals", (String)"COL_NAME"), (Object)type, 0);
                crit1 = crit1.and(new Criteria(Column.getColumn((String)"FcOrgAttributeVals", (String)"VALUE"), (Object)value, 0, true));
                crit = crit != null ? crit.or(crit1) : crit1;
            }
            Criteria deleteCrit = (Criteria)crit.clone();
            crit = crit.and(new Criteria(Column.getColumn((String)"FcOrgAttributeVals", (String)"IS_SELECTED"), (Object)true, 0));
            DataObject object = CommonUtil.getPersistence((boolean[])new boolean[0]).get("FcOrgAttributeVals", crit);
            if (!object.isEmpty()) {
                Iterator it = object.getRows("FcOrgAttributeVals");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    type = (String)r.get("COL_NAME");
                    String value = (String)r.get("VALUE");
                    String orgAttribId = Long.toString((Long)orgAttribIdMapping.get(type + "_" + value));
                    deletableAttribsIdList.remove(orgAttribId);
                    cantDeleteUniqueIdList.add((Long)r.get("UNIQUE_ID"));
                    SelectQueryImpl queryLayout = new SelectQueryImpl(Table.getTable((String)"FcLayout"));
                    queryLayout.addSelectColumn(Column.getColumn((String)"FcLayout", (String)"TEMPLATE_CATEGORY_ID"));
                    queryLayout.addSelectColumn(Column.getColumn((String)"FcLayout", (String)"LAYOUT_NAME"));
                    queryLayout.addSelectColumn(Column.getColumn((String)"FcLayout", (String)"LAYOUT_ID"));
                    queryLayout.addJoin(new Join("FcLayout", "FcLayoutTab", new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 2));
                    queryLayout.addJoin(new Join("FcLayoutTab", "FcLayoutSubTabGroup", new String[]{"TAB_ID"}, new String[]{"TAB_ID"}, 2));
                    queryLayout.addJoin(new Join("FcLayoutSubTabGroup", "FcLayoutSubTab", new String[]{"SUB_TAB_GROUP_ID"}, new String[]{"SUB_TAB_GROUP_ID"}, 2));
                    queryLayout.addJoin(new Join("FcLayoutSubTab", "FcLayoutFieldGroups", new String[]{"SUB_TAB_ID"}, new String[]{"SUB_TAB_ID"}, 2));
                    queryLayout.addJoin(new Join("FcLayoutFieldGroups", "FcLayoutFields", new String[]{"FIELD_GROUP_ID"}, new String[]{"FIELD_GROUP_ID"}, 2));
                    queryLayout.addJoin(new Join("FcLayout", "FcTemplateCategory", new String[]{"TEMPLATE_CATEGORY_ID"}, new String[]{"TEMPLATE_CATEGORY_ID"}, 2));
                    queryLayout.addSelectColumn(Column.getColumn((String)"FcTemplateCategory", (String)"TEMPLATE_CATEGORY_NAME"));
                    queryLayout.addSelectColumn(Column.getColumn((String)"FcTemplateCategory", (String)"TEMPLATE_CATEGORY_ID"));
                    Criteria layoutCrit = new Criteria(Column.getColumn((String)"FcLayoutFields", (String)"LAYOUT_FIELD_ID"), (Object)((Long)r.get("LAYOUT_FIELD_ID")), 0);
                    queryLayout.setCriteria(layoutCrit);
                    DataObject tempDetailsObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)queryLayout);
                    Row r1 = tempDetailsObj.getRow("FcLayout");
                    Row r2 = tempDetailsObj.getRow("FcTemplateCategory");
                    String layoutName = (String)r1.get("LAYOUT_NAME");
                    String layoutCategory = (String)r2.get("TEMPLATE_CATEGORY_NAME");
                    HashMap existingAttribDetail = (HashMap)attribDetails.get(value);
                    HashMap<String, String> layoutDetail = new HashMap<String, String>();
                    if (existingAttribDetail != null) {
                        layoutDetail.putAll(existingAttribDetail);
                        String existingCategoryLayoutNames = (String)existingAttribDetail.get(layoutCategory);
                        if (existingCategoryLayoutNames != null) {
                            layoutName = existingCategoryLayoutNames + ", " + layoutName;
                        }
                    }
                    layoutDetail.put(layoutCategory, layoutName);
                    attribDetails.put(value, layoutDetail);
                }
            }
            if (deletableAttribsIdList.size() != 0) {
                Criteria updateADSMCriteria = new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_ID"), (Object)deletableAttribsIdList.toArray(new String[deletableAttribsIdList.size()]), 8);
                UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMOrgAttributes");
                updateQuery.setCriteria(updateADSMCriteria);
                updateQuery.setUpdateColumn("IS_DELETED", (Object)"TRUE");
                CommonUtil.getPersistenceNT().update((UpdateQuery)updateQuery);
                Criteria delFcCriteria1 = new Criteria(Column.getColumn((String)"FcOrgAttributeVals", (String)"UNIQUE_ID"), (Object)cantDeleteUniqueIdList.toArray(new Long[cantDeleteUniqueIdList.size()]), 9);
                deleteCrit = deleteCrit.and(delFcCriteria1);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCrit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Object> returnValues = new HashMap<String, Object>();
        returnValues.put("attribDetails", attribDetails);
        returnValues.put("deletedIds", deletableAttribsIdList);
        returnValues.put("type", type);
        return returnValues;
    }
}

