/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;

public class ConfigureSearchAction
extends DispatchAction {
    public static void setAttributes(ActionForm form, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Hashtable domains = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
            Hashtable searchProfileDetails = SearchProfileHandler.getInstance().getSearchProfileDetails(Long.valueOf(1L));
            ArrayList domainList = new ArrayList();
            if (loginId != 1L) {
                ArrayList initialdomainList = (ArrayList)domains.get("domainList");
                for (int i = 0; i < initialdomainList.size(); ++i) {
                    Properties domainProp = (Properties)initialdomainList.get(i);
                    String domainName = domainProp.getProperty("DOMAIN_NAME");
                    if (!ClientAuthorizationUtil.isAuthorized(request, domainName, AdminConfigConstants.CONFIGURE_AD_SEARCH_ACTION_ID).booleanValue()) continue;
                    domainList.add(initialdomainList.get(i));
                }
            } else {
                domainList = (ArrayList)domains.get("domainList");
            }
            bean.set("domainList", (Object)domainList);
            Hashtable domainOUs = SearchProfileHandler.getInstance().getSearchDomainsAndOus(Long.valueOf(1L));
            if (domainOUs.isEmpty()) {
                Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                bean.set("domains", (Object)new String[]{selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT")});
                bean.set("domainOUList", new Hashtable());
            } else {
                Hashtable domainsTable = new Hashtable();
                Enumeration e = domainOUs.keys();
                String[] domainsArray = new String[domainOUs.size()];
                int i = 0;
                while (e.hasMoreElements()) {
                    String domainName = (String)e.nextElement();
                    Hashtable ous = (Hashtable)domainOUs.get(domainName);
                    Enumeration e1 = ous.keys();
                    String defaultNamingContext = (String)e1.nextElement();
                    domainsTable.put(defaultNamingContext, ous.get(defaultNamingContext));
                    domainsArray[i] = defaultNamingContext;
                    ++i;
                }
                bean.set("domains", (Object)domainsArray);
                bean.set("domainOUList", domainsTable);
            }
            request.setAttribute("SEARCH_PROFILE_DETAILS", (Object)searchProfileDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward configureSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.CONFIGURE_AD_SEARCH_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        try {
            String action = request.getParameter("action");
            if (action != null && action.equalsIgnoreCase("setOUs")) {
                DynaValidatorForm bean = (DynaValidatorForm)form;
                if (request.getParameter("domains") == null) {
                    bean.set("domains", (Object)new String[0]);
                }
                Hashtable searchProfileDetails = SearchProfileHandler.getInstance().getSearchProfileDetails(Long.valueOf(1L));
                String isEnabled = request.getParameter("enableSearch") != null ? "1" : "0";
                searchProfileDetails.put("IS_ENABLED", isEnabled);
                if (isEnabled.equals("1")) {
                    for (String obj : SearchProfileHandler.supportedObjClass) {
                        String isObjEn = request.getParameter(obj + "_search") != null ? "1" : "0";
                        Properties objProp = (Properties)searchProfileDetails.get(obj);
                        objProp.put("IS_OBJECT_ENABLED", isObjEn);
                        if (!isObjEn.equals("1")) continue;
                        String[] selDisCols = request.getParameter(obj + "_DC_SEL").split(",");
                        ArrayList<String> dCs = new ArrayList<String>();
                        ArrayList<Properties> dCDetails = new ArrayList<Properties>();
                        ArrayList<Integer> dCIds = new ArrayList<Integer>();
                        int priority = 1;
                        for (String selDC : selDisCols) {
                            String[] vals = selDC.split(";;;");
                            Properties prop = new Properties();
                            prop.put("ATTRIB_ID", (Object)Integer.parseInt(vals[0]));
                            prop.put("ATTRIB_LDAP_NAME", vals[1]);
                            prop.put("ATTRIB_DISP_NAME", vals[2]);
                            prop.put("PRIORITY", (Object)priority++);
                            dCs.add(vals[2]);
                            dCIds.add(new Integer(vals[0]));
                            dCDetails.add(prop);
                        }
                        String[] selSeaCri = request.getParameter(obj + "_SC_SEL").split(",");
                        ArrayList<String> sCs = new ArrayList<String>();
                        ArrayList<Properties> sCDetails = new ArrayList<Properties>();
                        priority = 1;
                        for (String selSC : selSeaCri) {
                            String[] vals = selSC.split(";;;");
                            sCs.add(vals[2]);
                            Properties prop = new Properties();
                            prop.put("ATTRIB_ID", (Object)Integer.parseInt(vals[0]));
                            prop.put("ATTRIB_LDAP_NAME", vals[1]);
                            prop.put("ATTRIB_DISP_NAME", vals[2]);
                            prop.put("LDAP_CRITERIA", "(" + vals[1] + "=%searchString%)");
                            prop.put("PRIORITY", (Object)priority++);
                            sCDetails.add(prop);
                        }
                        objProp.put("SEL_DIS_COLS", dCs);
                        objProp.put("SEL_DIS_IDS", dCIds);
                        objProp.put("SEL_SEA_CRIS", sCs);
                        objProp.put("SEL_DIS_COLS_DET", dCDetails);
                        objProp.put("SEL_SEA_CRIS_DET", sCDetails);
                        searchProfileDetails.put(obj, objProp);
                    }
                }
                request.setAttribute("SEARCH_PROFILE_DETAILS", (Object)searchProfileDetails);
            } else {
                ConfigureSearchAction.setAttributes(form, request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("configureSearch");
    }

    public ActionForward saveSearchProfile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            SearchProfileHandler.getInstance().setSearchProfileDetails(request);
            Long isEnabled = request.getParameter("enableSearch") != null ? 1L : 0L;
            if (isEnabled.equals(1L)) {
                Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
                String[] domains = (String[])bean.get("domains");
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ArrayList configuredList = HDTDomainHandler.getDomainNamesList((Long)loginId);
                Hashtable domainVsDefaultNamingContext = DomainInfoCache.getInstance().getDomainVsDefaultNamingContext();
                ArrayList<String> unauthorizedDomainList = new ArrayList<String>();
                Enumeration keys = domainVsDefaultNamingContext.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (configuredList.contains(key)) continue;
                    unauthorizedDomainList.add(key);
                }
                if (domainOUList.isEmpty()) {
                    SearchProfileHandler.getInstance().setSearchDomains(Long.valueOf(1L), domains, unauthorizedDomainList);
                } else {
                    Hashtable reqDomOuList = new Hashtable();
                    for (int i = 0; i < domains.length; ++i) {
                        if (domainOUList.get(domains[i]) != null) {
                            reqDomOuList.put(domains[i], domainOUList.get(domains[i]));
                            continue;
                        }
                        reqDomOuList.put(domains[i], new ArrayList());
                    }
                    SearchProfileHandler.getInstance().setSearchDomainsAndOus(Long.valueOf(1L), reqDomOuList, unauthorizedDomainList);
                }
            }
            ConfigureSearchAction.setAttributes(form, request);
            request.setAttribute("statusMessage", (Object)(rb.getString("client.admin.ConfigureSearchAction.successfully_updated_the_settings") + " "));
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("statusMessage", (Object)(rb.getString("client.admin.ConfigureSearchAction.error_in_updating_the_settings") + " "));
        }
        return mapping.findForward("configureSearch");
    }
}

