/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.CustomAttribUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomAction
extends DispatchAction {
    public ActionForward setAttributes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.LDAP_ATTRIBUTES_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        request.setAttribute("ldapAttributes", (Object)CustomAttribUtil.getAttributes());
        return mapping.findForward("mainPage");
    }

    public ActionForward saveCustomFields(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.LDAP_ATTRIBUTES_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        String operation = request.getParameter("operation");
        ArrayList<Long> modifiedRoles = new ArrayList<Long>();
        Long fieldId = Long.parseLong(request.getParameter("fieldId"));
        String displayName = request.getParameter("DISPLAY_NAME");
        displayName = displayName.trim();
        String ldapName = request.getParameter("LDAP_NAME");
        String enablePII = request.getParameter("enablePII");
        String msg = null;
        HashMap<String, Object> fieldDetails = new HashMap<String, Object>();
        String reportTxt = "";
        fieldDetails.put("displayName", displayName);
        fieldDetails.put("ldapName", ldapName);
        fieldDetails.put("dataType", request.getParameter("DATA_TYPE"));
        if (operation.equalsIgnoreCase("add") && CustomAttribUtil.isDuplicateAttribute(ldapName, "LDAP_NAME") != false || operation.equalsIgnoreCase("add") && CustomAttribUtil.isDuplicateAttribute(displayName, "DISPLAY_NAME") != false || operation.equalsIgnoreCase("update") && CustomAttribUtil.isDuplicateAttribute(displayName, "DISPLAY_NAME", fieldId).booleanValue()) {
            msg = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg_custom_attribute_already_exist");
        } else {
            reportTxt = CustomAttribUtil.isAlreadyAssociatedLdap(request, CustomAttribUtil.tableArray, ldapName);
            if (!reportTxt.equals("")) {
                msg = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg_custom_attribute_already_associated"), rb.getString(reportTxt));
            } else {
                String forReports = "";
                ArrayList<String> associatedTables = new ArrayList<String>();
                for (int i = 0; i < CustomAttribUtil.tableArray.length; ++i) {
                    if (request.getParameter(CustomAttribUtil.tableArray[i]) == null) continue;
                    associatedTables.add(CustomAttribUtil.tableArray[i]);
                    if (forReports != "") {
                        forReports = forReports + ", ";
                    }
                    forReports = forReports + CustomAttribUtil.reports[i];
                }
                fieldDetails.put("associatedTables", associatedTables);
                fieldDetails.put("forReports", forReports);
                String mgmtAction = "";
                ArrayList<String> mgmtArray = new ArrayList<String>();
                for (int i = 0; i < CustomAttribUtil.paramArray.length; ++i) {
                    if (request.getParameter(CustomAttribUtil.paramArray[i]) == null) continue;
                    if (i != 0 && !mgmtAction.equals("")) {
                        mgmtAction = mgmtAction + ",";
                    }
                    mgmtAction = mgmtAction + CustomAttribUtil.paramArray[i];
                    mgmtArray.add(CustomAttribUtil.paramArray[i]);
                }
                fieldDetails.put("mgmtAction", mgmtAction);
                fieldDetails.put("mgmtArray", mgmtArray);
                if (operation.equalsIgnoreCase("add")) {
                    try {
                        modifiedRoles = CustomAttribUtil.addCustomFields(loginId, fieldDetails, enablePII);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        msg = rb.getString("admp.admin.custom_settgs.ldap_attrbs.statmsg_exception_occured_while_adding");
                    }
                    if (msg != null) {
                        try {
                            Criteria criter = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"LDAP_NAME"), (Object)ldapName, 0);
                            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criter);
                            msg = rb.getString("admp.admin.custom_settgs.ldap_attrbs.statmsg_exception_occured_while_adding");
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                } else {
                    try {
                        modifiedRoles = CustomAttribUtil.updateCustomFields(loginId, fieldDetails, fieldId, enablePII);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        msg = rb.getString("admp.admin.custom_settgs.ldap_attrbs.statmsg_exception_occured_while_updating");
                    }
                }
            }
        }
        this.listFields(response, request, modifiedRoles, msg);
        return null;
    }

    private void listFields(HttpServletResponse response, HttpServletRequest request, ArrayList<Long> modifiedRoles, String msg) {
        try {
            ArrayList fieldsList = new ArrayList();
            fieldsList = CustomAttribUtil.getFieldList();
            ByteArrayOutputStream outNode = this.getCustomFieldListXMLElement(request, fieldsList, modifiedRoles, msg);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ByteArrayOutputStream getCustomFieldListXMLElement(HttpServletRequest request, ArrayList fieldsList, ArrayList<Long> modifiedRoles, String msg) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            for (int i = 0; i < fieldsList.size(); ++i) {
                Properties fieldProp = (Properties)fieldsList.get(i);
                String[] elements = new String[]{"fieldIdElt", "ldapNameElt", "displayNameElt", "dataTypeElt", "fieldReportIdElt", "mgmtActionIdElt", "isPIIEnabledIdElt"};
                String[] attributes = new String[]{"fieldId", "ldapName", "displayName", "dataType", "fieldReportId", "mgmtActionId", "isPIIEnabled"};
                String[] props = new String[]{"FIELD_ID", "LDAP_NAME", "DISPLAY_NAME", "DATA_TYPE", "FOR_REPORTS", "MGMT_ACTIONS", "IS_PII_ENABLED"};
                for (int j = 0; j < elements.length; ++j) {
                    Element elt = document.createElement(elements[j]);
                    if (props[j].equalsIgnoreCase("DATA_TYPE")) {
                        String dataType = fieldProp.get(props[j]).toString();
                        String dataTypeDisplayText = "";
                        if (dataType.equalsIgnoreCase("CHAR")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_unicode_string");
                        } else if (dataType.equalsIgnoreCase("INTEGER")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_integer");
                        } else if (dataType.equalsIgnoreCase("BOOLEAN")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_boolean");
                        } else if (dataType.equalsIgnoreCase("BIGINT")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_large_integer");
                        } else if (dataType.equalsIgnoreCase("DATETIME")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_date_time");
                        } else if (dataType.equalsIgnoreCase("MULTIVALUE")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_multivalue_string");
                        } else if (dataType.equalsIgnoreCase("UTCTIME")) {
                            dataTypeDisplayText = rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_utc_coded_time");
                        }
                        elt.setAttribute(attributes[j], dataTypeDisplayText);
                    } else {
                        elt.setAttribute(attributes[j], fieldProp.get(props[j]).toString());
                    }
                    data.appendChild(elt);
                }
                String[] reportsI18Nd = new String[]{rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.user_reports"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.password_reports"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.groups_reports"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.computer_reports"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.exchange_reports"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.policy_reports"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.reportname.contact_reports")};
                String fieldReport = fieldProp.get("FOR_REPORTS").toString();
                for (int j = 0; j < CustomAttribUtil.reports.length; ++j) {
                    fieldReport = fieldReport.replaceAll(CustomAttribUtil.reports[j], reportsI18Nd[j]);
                }
                Element fieldReportElt = document.createElement("fieldReportElt");
                fieldReportElt.setAttribute("fieldReport", fieldReport);
                data.appendChild(fieldReportElt);
                String[] mgmtActionValueArray = new String[]{rb.getString("admp.admin.custom_settgs.ldap_attrbs.mgmtname.user_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.mgmtname.user_modification"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_contact_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_contact_modification"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_group_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_group_modification"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_sh_mailbox_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_sh_mailbox_modification"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_rm_mailbox_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_rm_mailbox_modification"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_eq_mailbox_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_eq_mailbox_modification"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_lk_mailbox_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.mgmtname.computer_creation"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.mgmtname.computer_modification")};
                String[] mgmtActionIdArray = new String[]{"userCreation", "userModification", "contactCreation", "contactModification", "groupCreation", "groupModification", "sharedMailboxCreation", "sharedMailboxModification", "rmMailboxCreation", "rmMailboxModification", "eqMailboxCreation", "eqMailboxModification", "linkedMailboxCreation", "computerCreation", "computerModification"};
                String mgmtAction = fieldProp.get("MGMT_ACTIONS").toString();
                for (int j = 0; j < mgmtActionIdArray.length; ++j) {
                    mgmtAction = mgmtAction.replaceAll(mgmtActionIdArray[j], mgmtActionValueArray[j]);
                }
                Element mgmtActionElt = document.createElement("mgmtActionElt");
                mgmtActionElt.setAttribute("mgmtAction", mgmtAction);
                data.appendChild(mgmtActionElt);
            }
            String modifiedRoleString = "";
            for (Long roleId : modifiedRoles) {
                String roleName = rb.getString(ADMPRoleHandler.getRoleName((Long)roleId));
                if (!modifiedRoleString.equals("")) {
                    modifiedRoleString = modifiedRoleString + ", " + roleName;
                    continue;
                }
                modifiedRoleString = roleName;
            }
            Element modifiedRoleNameElt = document.createElement("modifiedRoleNameElt");
            modifiedRoleNameElt.setAttribute("modifiedRoleName", modifiedRoleString);
            data.appendChild(modifiedRoleNameElt);
            Element msgElt = document.createElement("msgElt");
            msgElt.setAttribute("msg", msg);
            data.appendChild(msgElt);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public ActionForward deleteField(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String fieldIdstr = request.getParameter("fieldId");
            Long fieldId = Long.parseLong(fieldIdstr);
            String message = CustomAttribUtil.deleteCustomFields(fieldId);
            this.listFields(response, request, new ArrayList<Long>(), "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward checkIfMultivalue(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean isMultiValue = false;
            boolean isAvailable = false;
            String ldapName = request.getParameter("LDAP_NAME");
            ArrayList domainPropList = HDTDomainHandler.getConfiguredDomainsNativeProps((Long)CommonUtil.ADMIN_LOGIN_ID);
            ArrayList attributeSchemaList = new ArrayList();
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("isSingleValued");
            String searchString = "(&(objectClass=attributeSchema)(lDAPDisplayName=" + ldapName + "))";
            for (int i = 0; i < domainPropList.size(); ++i) {
                Properties domainDetails = (Properties)domainPropList.get(i);
                String domainName = (String)domainDetails.get("DOMAIN_NAME");
                attributeSchemaList = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("SCHEMA_NAMING_CONTEXT"), attributeList, (String)searchString);
                if (attributeSchemaList.size() > 0) {
                    isAvailable = true;
                    Properties attributeProp = (Properties)attributeSchemaList.get(0);
                    isMultiValue = attributeProp.get("isSingleValued").toString().equalsIgnoreCase("[0]");
                }
                if (isMultiValue) break;
            }
            if (isAvailable && isMultiValue) {
                AjaxUtil.writeResponse(response, "true");
            } else if (isAvailable) {
                AjaxUtil.writeResponse(response, "false");
            } else {
                AjaxUtil.writeResponse(response, "notAvailable");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

