/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.common.server.admin.DeprovisionConfig;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DeprovisionUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.zoho.framework.utils.crypto.EnDecryptImpl;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomDelete
extends DispatchAction {
    public ActionForward getPolicyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.DELETE_POLICY_ACTION_ID).booleanValue()) {
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList configuredDomainList = HDTDomainHandler.getDomainNamesList((Long)loginId);
            ArrayList<String> unAuthorizedDomainList = new ArrayList<String>();
            if (loginId != CommonUtil.ADMIN_LOGIN_ID) {
                for (String domain : configuredDomainList) {
                    if (ClientAuthorizationUtil.isAuthorized(request, domain, AdminConfigConstants.DELETE_POLICY_ACTION_ID).booleanValue()) continue;
                    unAuthorizedDomainList.add(domain);
                }
            }
            if (configuredDomainList != null) {
                configuredDomainList.removeAll(unAuthorizedDomainList);
            }
            JSONObject policyJson = DeprovisionUtil.getPolicyObject((ArrayList)configuredDomainList);
            request.setAttribute("policyJson", (Object)policyJson);
            request.setAttribute("domainList", (Object)configuredDomainList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("deletePolicy");
    }

    public ActionForward savePolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject policyJson = new JSONObject(request.getParameter("policyJson"));
            JSONArray domainsArray = policyJson.getJSONArray("policyJson");
            ArrayList<DeprovisionConfig> policyList = new ArrayList<DeprovisionConfig>();
            for (int i = 0; i < domainsArray.length(); ++i) {
                JSONObject domainJson = domainsArray.getJSONObject(i);
                String domainName = domainJson.names().getString(0);
                JSONObject policyObj = domainJson.getJSONObject(domainName);
                JSONObject deletePolicyObj = policyObj.getJSONObject("delete_policy");
                DeprovisionConfig deletePolicyConfig = new DeprovisionConfig(deletePolicyObj, domainName, DeprovisionUtil.DELETE_POLICY_ID);
                policyList.add(deletePolicyConfig);
                JSONObject disablePolicyObj = policyObj.getJSONObject("disable_policy");
                if (!disablePolicyObj.getString(DeprovisionUtil.PASSWORD_TASK_ID).equals("")) {
                    EnDecryptImpl enDecrypt = new EnDecryptImpl();
                    disablePolicyObj.put(DeprovisionUtil.PASSWORD_TASK_ID, (Object)enDecrypt.encrypt(disablePolicyObj.getString(DeprovisionUtil.PASSWORD_TASK_ID)));
                }
                DeprovisionConfig disablePolicyConfig = new DeprovisionConfig(disablePolicyObj, domainName, DeprovisionUtil.DISABLE_POLICY_ID);
                policyList.add(disablePolicyConfig);
            }
            String message = DeprovisionUtil.addPolicyDetails(policyList, (AdventNetResourceBundle)rb);
            PrintWriter writer = response.getWriter();
            writer.print(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getExportHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList domainList = HDTDomainHandler.getDomainNamesList((Long)loginId);
            int count = ExchangeUtil.getExportRequestCount((ArrayList)domainList);
            Long cvId = ColumnConfiguration.getDefaultCvId((String)"ExportMbxRequests");
            ArrayList viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
            request.setAttribute("count", (Object)count);
            request.setAttribute("columnList", (Object)viewColumnList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("exportHistory");
    }

    public ActionForward listExportRequestRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ExchangeUtil.getExportRequestRows((HttpServletRequest)request, (Long)loginId, (AdventNetResourceBundle)rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("exportHistoryRows");
    }
}

