/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CustomOffices
extends Action {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.OFFICES_AND_COMPANIES_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        String add = "Add";
        String addOffice = request.getParameter("AddOffice");
        String addCompany = request.getParameter("Addcompany");
        ArrayList<Object> notDeletedAttribIdsList = new ArrayList();
        if (add.equalsIgnoreCase(addOffice) || add.equalsIgnoreCase(addCompany)) {
            try {
                String attName = "";
                String colName = "";
                String fieldValue = "";
                String fieldValues = "";
                String message = new String();
                Boolean duplicateValues = false;
                int duplicateCount = 0;
                int count = 0;
                if ("Add".equalsIgnoreCase(request.getParameter("AddOffice"))) {
                    attName = request.getParameter("officename");
                    colName = "OFFICE";
                    fieldValue = rb.getString("admp.common.attrib_disp_name.office");
                    fieldValues = rb.getString("admp.admin.custom_settgs.off_comp.text_offices");
                } else if ("Add".equalsIgnoreCase(request.getParameter("Addcompany"))) {
                    attName = request.getParameter("companyname");
                    colName = "COMPANY";
                    fieldValue = rb.getString("admp.common.attrib_disp_name.company");
                    fieldValues = rb.getString("admp.admin.custom_settgs.off_comp.text_companies");
                }
                String[] attributes = attName.split(";");
                for (int i = 0; i < attributes.length; ++i) {
                    if (attributes[i].trim().length() <= 0) continue;
                    Boolean duplicate = CustomOffices.duplicateCheck(attributes[i].trim(), colName, notDeletedAttribIdsList);
                    if (!duplicate.booleanValue()) {
                        DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        Row r = new Row("ADSMOrgAttributes");
                        r.set("ORG_ATTRIB_NAME", (Object)attributes[i].trim());
                        r.set("ORG_ATTRIB_TYPE", (Object)colName);
                        r.set("IS_DELETED", (Object)"FALSE");
                        obj.addRow(r);
                        ++count;
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
                        continue;
                    }
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_NAME"), (Object)attributes[i].trim(), 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_TYPE"), (Object)colName, 0));
                    DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMOrgAttributes", criteria);
                    if (!dataobj.isEmpty()) {
                        Row r = dataobj.getFirstRow("ADSMOrgAttributes");
                        String isDeleted = (String)r.get("IS_DELETED");
                        if (isDeleted.equals("TRUE")) {
                            r.set("ORG_ATTRIB_NAME", (Object)attributes[i].trim());
                            r.set("IS_DELETED", (Object)"FALSE");
                            dataobj.updateRow(r);
                            ++count;
                        } else {
                            duplicateValues = true;
                            ++duplicateCount;
                        }
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataobj);
                }
                message = CustomOffices.showStatus(fieldValues, fieldValue, duplicateValues, duplicateCount, count, rb);
                request.setAttribute("message", (Object)message);
                request.setAttribute("notDeleted", notDeletedAttribIdsList);
            }
            catch (DataAccessException e) {
                if (add.equalsIgnoreCase(addOffice)) {
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.off_comp.statmsg.off_name_exceeds"));
                }
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.off_comp.statmsg.comp_name_exceeds"));
            }
            catch (Exception e) {
                if (add.equalsIgnoreCase(addOffice)) {
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.off_comp.statmsg.error_in_saving_office"));
                } else {
                    request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.off_comp.statmsg.error_in_saving_company"));
                }
                e.printStackTrace();
            }
            finally {
                request.setAttribute("offices", (Object)AdminUtil.comboAttribs("OFFICE"));
                request.setAttribute("company", (Object)AdminUtil.comboAttribs("COMPANY"));
            }
        } else if ("true".equalsIgnoreCase(request.getParameter("Delete"))) {
            StringBuffer message = new StringBuffer();
            try {
                String attribIDs = request.getParameter("attribID");
                String[] attribID = attribIDs.split(",");
                notDeletedAttribIdsList = new ArrayList<String>(Arrays.asList(attribID));
                int deletedSize = 0;
                HashMap<String, Object> returnValues = AdminUtil.isDeletableOrgAtrrib(attribID, rb);
                ArrayList deletedAttribIdsList = (ArrayList)returnValues.get("deletedIds");
                notDeletedAttribIdsList.removeAll(deletedAttribIdsList);
                deletedSize = deletedAttribIdsList.size();
                if (deletedSize == attribID.length) {
                    message.append(rb.getString("admp.admin.custom_settgs.off_comp.statmsg.success_removed_values"));
                    request.setAttribute("deleted", (Object)deletedAttribIdsList);
                } else {
                    if (deletedSize == 0) {
                        message.append(rb.getString("admp.admin.custom_settgs.off_comp.statmsg.remov_unsuccessfull_values_currently_use"));
                    } else {
                        message.append(MessageFormat.format(rb.getString("admp.admin.custom_settgs.off_comp.statmsg.success_removed_values_only_other_values_currently_use"), deletedSize));
                    }
                    request.setAttribute("attribDetails", returnValues.get("attribDetails"));
                    request.setAttribute("notDeleted", notDeletedAttribIdsList);
                    request.setAttribute("type", returnValues.get("type"));
                }
                request.setAttribute("message", (Object)message.toString());
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.off_comp.statmsg.error_in_deleting_off_comp"));
                e.printStackTrace();
            }
            finally {
                request.setAttribute("offices", (Object)AdminUtil.comboAttribs("OFFICE"));
                request.setAttribute("company", (Object)AdminUtil.comboAttribs("COMPANY"));
            }
        } else if (request.getParameter("showCombo") != null) {
            Boolean showCombo = Boolean.valueOf(request.getParameter("showCombo"));
            String field = request.getParameter("refParam");
            if (field != null && !field.equals("")) {
                AdminUtil.setRefValue(field, showCombo);
            }
        }
        if (request.getParameter("officeIsSyncAD") != null) {
            Boolean officeIsSyncAD = new Boolean(request.getParameter("officeIsSyncAD"));
            AdminUtil.setRefValue("OFFICE_IS_SYNC_WITH_AD", officeIsSyncAD);
        }
        if (request.getParameter("compIsSyncAD") != null) {
            Boolean compIsSyncAD = new Boolean(request.getParameter("compIsSyncAD"));
            AdminUtil.setRefValue("COMP_IS_SYNC_WITH_AD", compIsSyncAD);
        }
        request.setAttribute("offices", (Object)AdminUtil.comboAttribs("OFFICE"));
        request.setAttribute("company", (Object)AdminUtil.comboAttribs("COMPANY"));
        return mapping.findForward("offices");
    }

    public static Boolean duplicateCheck(String attribValue, String colName, ArrayList<Long> notDeletedAttribIdsList) throws Exception {
        boolean isOrgCaseSensitiveorNot = CommonUtil.isOrgCaseSensitiveorNot();
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_NAME"), (Object)attribValue, 0, isOrgCaseSensitiveorNot);
        criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_TYPE"), (Object)colName, 0));
        DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMOrgAttributes", criteria);
        if (!dataobj.isEmpty()) {
            Row r = dataobj.getFirstRow("ADSMOrgAttributes");
            notDeletedAttribIdsList.add((Long)r.get("ORG_ATTRIB_ID"));
            return true;
        }
        return false;
    }

    public static String showStatus(String fieldValues, String fieldValue, Boolean duplicateValues, int duplicateCount, int newCount, AdventNetResourceBundle rb) throws Exception {
        String message = new String();
        if (!duplicateValues.booleanValue()) {
            message = newCount == 1 ? MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.specified_field_added"), fieldValue) : MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.specified_fields_added"), fieldValues);
        } else if (newCount != 0) {
            message = newCount == 1 ? MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.added_field"), fieldValue) : MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.added_fields"), newCount, fieldValues);
            message = duplicateCount == 1 ? message + MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.other_field_exists"), fieldValue) : message + MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.other_fields_exist"), fieldValues);
        } else {
            message = duplicateCount == 1 ? MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.specified_field_exists"), fieldValue) : MessageFormat.format(rb.getString("admp.admin.custom.settgs.statmsg.specified_fields_exist"), fieldValues);
        }
        return message;
    }
}

