/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.admin.CustomOffices;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class CustomTitles
extends Action {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String tile = "";
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.TILES_AND_DEPARTMENT_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        tile = "titles";
        Boolean duplicateValues = false;
        int count = 0;
        int duplicateCount = 0;
        String message = new String();
        String fieldValue = "";
        String fieldValues = "";
        ArrayList<Long> notDeleted = new ArrayList<Long>();
        if ("Add".equalsIgnoreCase(request.getParameter("AddTitle"))) {
            try {
                String titleName = request.getParameter("titlename");
                fieldValue = rb.getString("admp.common.attrib_disp_name.title");
                fieldValues = rb.getString("admp.admin.custom_settgs.title_dep.text_titles");
                String[] titles = titleName.split(";");
                for (int i = 0; i < titles.length; ++i) {
                    if (titles[i].trim().length() <= 0) continue;
                    Boolean duplicate = CustomOffices.duplicateCheck(titles[i].trim(), "TITLE", notDeleted);
                    if (!duplicate.booleanValue()) {
                        DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        Row r = new Row("ADSMOrgAttributes");
                        r.set("ORG_ATTRIB_NAME", (Object)titles[i].trim());
                        r.set("ORG_ATTRIB_TYPE", (Object)"TITLE");
                        r.set("IS_DELETED", (Object)"FALSE");
                        obj.addRow(r);
                        ++count;
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
                        continue;
                    }
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_NAME"), (Object)titles[i].trim(), 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_TYPE"), (Object)"TITLE", 0));
                    DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMOrgAttributes", criteria);
                    if (!dataobj.isEmpty()) {
                        Row r = dataobj.getFirstRow("ADSMOrgAttributes");
                        String isDeleted = (String)r.get("IS_DELETED");
                        if (isDeleted.equals("TRUE")) {
                            r.set("ORG_ATTRIB_NAME", (Object)titles[i].trim());
                            r.set("IS_DELETED", (Object)"FALSE");
                            dataobj.updateRow(r);
                            ++count;
                        } else {
                            duplicateValues = true;
                            ++duplicateCount;
                        }
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataobj);
                }
                message = CustomOffices.showStatus(fieldValues, fieldValue, duplicateValues, duplicateCount, count, rb);
                request.setAttribute("message", (Object)message);
                request.setAttribute("notDeleted", notDeleted);
            }
            catch (DataAccessException e) {
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.title_dep.statmsg.title_name_exceeds"));
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.title_dep.statmsg.error_in_saving_title"));
                e.printStackTrace();
            }
            finally {
                this.setTitlesAndDepts(request);
            }
        } else if ("Add".equalsIgnoreCase(request.getParameter("AddDept"))) {
            try {
                String deptName = request.getParameter("deptname");
                fieldValue = rb.getString("admp.common.attrib_disp_name.dept");
                fieldValues = rb.getString("admp.admin.custom_settgs.title_dep.text_departments");
                String[] depts = deptName.split(";");
                for (int i = 0; i < depts.length; ++i) {
                    if (depts[i].trim().length() <= 0) continue;
                    Boolean duplicate = CustomOffices.duplicateCheck(depts[i].trim(), "DEPT", notDeleted);
                    if (!duplicate.booleanValue()) {
                        DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        Row r = new Row("ADSMOrgAttributes");
                        r.set("ORG_ATTRIB_NAME", (Object)depts[i].trim());
                        r.set("ORG_ATTRIB_TYPE", (Object)"DEPT");
                        r.set("IS_DELETED", (Object)"FALSE");
                        obj.addRow(r);
                        ++count;
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(obj);
                        continue;
                    }
                    Criteria criteria = new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_NAME"), (Object)depts[i].trim(), 0);
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMOrgAttributes", (String)"ORG_ATTRIB_TYPE"), (Object)"DEPT", 0));
                    DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMOrgAttributes", criteria);
                    if (!dataobj.isEmpty()) {
                        Row r = dataobj.getFirstRow("ADSMOrgAttributes");
                        String isDeleted = (String)r.get("IS_DELETED");
                        if (isDeleted.equals("TRUE")) {
                            r.set("ORG_ATTRIB_NAME", (Object)depts[i].trim());
                            r.set("IS_DELETED", (Object)"FALSE");
                            dataobj.updateRow(r);
                            ++count;
                        } else {
                            duplicateValues = true;
                            ++duplicateCount;
                        }
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataobj);
                }
                message = CustomOffices.showStatus(fieldValues, fieldValue, duplicateValues, duplicateCount, count, rb);
                request.setAttribute("message", (Object)message);
                request.setAttribute("notDeleted", notDeleted);
            }
            catch (DataAccessException e) {
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.title_dep.statmsg.dept_name_exceeds"));
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.title_dep.statmsg.error_in_saving_dept"));
                e.printStackTrace();
            }
            finally {
                this.setTitlesAndDepts(request);
            }
        } else if ("true".equalsIgnoreCase(request.getParameter("Delete"))) {
            StringBuffer messageBuf = new StringBuffer();
            try {
                String attribIDs = request.getParameter("attribID");
                String[] attribID = attribIDs.split(",");
                ArrayList<String> notDeletedAttribIdsList = new ArrayList<String>(Arrays.asList(attribID));
                int deletedSize = 0;
                HashMap<String, Object> returnValues = AdminUtil.isDeletableOrgAtrrib(attribID, rb);
                ArrayList deletedAttribIdsList = (ArrayList)returnValues.get("deletedIds");
                notDeletedAttribIdsList.removeAll(deletedAttribIdsList);
                deletedSize = deletedAttribIdsList.size();
                if (deletedSize == attribID.length) {
                    messageBuf.append(rb.getString("admp.admin.custom_settgs.off_comp.statmsg.success_removed_values"));
                    request.setAttribute("deleted", (Object)deletedAttribIdsList);
                } else {
                    if (deletedSize == 0) {
                        messageBuf.append(rb.getString("admp.admin.custom_settgs.off_comp.statmsg.remov_unsuccessfull_values_currently_use"));
                    } else {
                        messageBuf.append(MessageFormat.format(rb.getString("admp.admin.custom_settgs.off_comp.statmsg.success_removed_values_only_other_values_currently_use"), deletedSize));
                    }
                    request.setAttribute("attribDetails", returnValues.get("attribDetails"));
                    request.setAttribute("notDeleted", notDeletedAttribIdsList);
                    request.setAttribute("type", returnValues.get("type"));
                }
                request.setAttribute("message", (Object)messageBuf.toString());
            }
            catch (Exception e) {
                request.setAttribute("message", (Object)rb.getString("admp.admin.custom_settgs.title_dep.statmsg.error_in_deleting_dept"));
                e.printStackTrace();
            }
            finally {
                this.setTitlesAndDepts(request);
            }
        } else if (request.getParameter("showCombo") != null) {
            Boolean showCombo = Boolean.valueOf(request.getParameter("showCombo"));
            String field = request.getParameter("refParam");
            if (field != null && !field.equals("")) {
                AdminUtil.setRefValue(field, showCombo);
            }
        }
        this.setTitlesAndDepts(request);
        if (request.getParameter("titleIsSyncAD") != null) {
            Boolean titleIsSyncAD = new Boolean(request.getParameter("titleIsSyncAD"));
            AdminUtil.setRefValue("TITLE_IS_SYNC_WITH_AD", titleIsSyncAD);
        }
        if (request.getParameter("deptIsSyncAD") != null) {
            Boolean deptIsSyncAD = new Boolean(request.getParameter("deptIsSyncAD"));
            AdminUtil.setRefValue("DEPT_IS_SYNC_WITH_AD", deptIsSyncAD);
        }
        return mapping.findForward(tile);
    }

    private void setTitlesAndDepts(HttpServletRequest request) {
        HashMap<String, Object> unSortedTitles = null;
        HashMap<String, Object> unSortedDepts = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            DataObject titleObj = AdminUtil.comboAttribs("TITLE");
            if (!titleObj.isEmpty()) {
                unSortedTitles = new HashMap<String, Object>();
                Iterator it = titleObj.getRows("ADSMOrgAttributes");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String isDeleted = (String)r.get("IS_DELETED");
                    if (!isDeleted.equals("FALSE")) continue;
                    unSortedTitles.put(rb.getString((String)r.get("ORG_ATTRIB_NAME")) + "_" + r.get("ORG_ATTRIB_ID"), r.get("ORG_ATTRIB_ID"));
                }
            }
            request.setAttribute("titles", (Object)CustomTitles.sortByValue(unSortedTitles));
            DataObject deptObj = AdminUtil.comboAttribs("DEPT");
            if (!deptObj.isEmpty()) {
                unSortedDepts = new HashMap<String, Object>();
                Iterator it = deptObj.getRows("ADSMOrgAttributes");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String isDeleted = (String)r.get("IS_DELETED");
                    if (!isDeleted.equals("FALSE")) continue;
                    unSortedDepts.put(rb.getString((String)r.get("ORG_ATTRIB_NAME")) + "_" + r.get("ORG_ATTRIB_ID"), r.get("ORG_ATTRIB_ID"));
                }
            }
            request.setAttribute("departments", (Object)CustomTitles.sortByValue(unSortedDepts));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map sortByValue(Map unSortedMap) throws Exception {
        TreeMap sortedMap = null;
        try {
            if (unSortedMap == null) {
                return null;
            }
            ValueComparator comparator = new ValueComparator(unSortedMap);
            sortedMap = new TreeMap(comparator);
            sortedMap.putAll(unSortedMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sortedMap;
    }

    public static class ValueComparator
    implements Comparator<String> {
        Map<String, Long> baseMap;

        public ValueComparator(Map<String, Long> map) {
            this.baseMap = map;
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareToIgnoreCase(s2);
        }
    }
}

