/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class CustomizePassword
extends DispatchAction {
    public ActionForward getPolicyPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.PASSWORD_POLICY_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        PasswordPolicy policy = new PasswordPolicy();
        policy.setPolicyDetails();
        request.setAttribute("policyObject", (Object)policy);
        return mapping.findForward("password");
    }

    public ActionForward getPolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            PasswordPolicy policy = new PasswordPolicy();
            policy.setPolicyDetails();
            JSONObject json = policy.serializeToJsonObject();
            PrintWriter writer = response.getWriter();
            writer.print(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward savePolicy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String jsonString = request.getParameter("PwdPolicyJson");
            PasswordPolicy policy = new PasswordPolicy(jsonString);
            policy.init();
            String message = policy.savePolicyDetails(rb);
            String samplePwdText = this.generateSamplePassword(rb);
            PrintWriter writer = response.getWriter();
            writer.print(message + samplePwdText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String generateSamplePassword(AdventNetResourceBundle rb) throws Exception {
        PasswordPolicy pwdPolicy = new PasswordPolicy();
        pwdPolicy.setPolicyDetails();
        String password = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
        return MessageFormat.format(rb.getString("admp.admin.custom_settgs.pwd_policy.statmsg.sample_password"), password);
    }
}

