/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationConstants;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.admin.NotificationProfileAction;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class NotificationTemplateAction
extends DispatchAction {
    ArrayList viewColumnList = null;
    private static Logger logger = Logger.getLogger(NotificationProfileAction.class.getName());

    public ActionForward listTemplates(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.NOTIFICATION_PROFILE_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        Long cvId = ColumnConfiguration.getDefaultCvId((String)"NotificationTemplate");
        this.viewColumnList = ColumnConfiguration.getViewColumnList((long)cvId);
        request.setAttribute("columnList", (Object)this.viewColumnList);
        return mapping.findForward("notificationTemplates");
    }

    public ActionForward saveTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String params = request.getParameter("params");
        logger.log(Level.INFO, "Template creation params: " + params);
        Long sessionLoginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Integer statusCode = 0;
        String statusMessage = "";
        logger.log(Level.INFO, " check template Name Called");
        JSONObject json = new JSONObject(params);
        String templateName = (String)json.get("templateName");
        Long currentTemplateId = Long.valueOf((String)json.get("templateId"));
        Long templateId = NotificationTemplateHandler.getTemplateId((String)templateName);
        Boolean isChangeModuleAllowed = Boolean.TRUE;
        String moduleCategory = (String)json.get("moduleCategory");
        if (!currentTemplateId.equals(0L)) {
            JSONObject templateDetails = NotificationTemplateHandler.getTemplateDetails((Long)currentTemplateId, (AdventNetResourceBundle)rb);
            String moduleName = (String)templateDetails.get("MODULE_NAME");
            System.out.print("moduleName::" + moduleName);
            if (!moduleName.equalsIgnoreCase(moduleCategory) && !NotificationTemplateHandler.isTemplateInUse((Long)currentTemplateId).equals(0)) {
                isChangeModuleAllowed = Boolean.FALSE;
            }
        }
        if (moduleCategory.equalsIgnoreCase("Workflow") && json.has("format")) {
            json.remove("format");
        }
        if ((templateId.equals(0L) || templateId.equals(currentTemplateId)) && isChangeModuleAllowed.booleanValue()) {
            statusCode = NotificationTemplateHandler.addTemplateDetails((JSONObject)json, (Long)sessionLoginId, (AdventNetResourceBundle)rb);
            if (statusCode.equals(NotificationConstants.EDIT_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.editTemplate_failure");
            } else if (statusCode.equals(NotificationConstants.CREATE_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.createTemplate_failure");
            } else if (statusCode.equals(NotificationConstants.EDIT_TEMPLATE_PARTIAL_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.editTemplate_partially_updated");
            } else if (statusCode.equals(NotificationConstants.EDIT_TEMPLATE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.editTemplate_success");
            } else if (statusCode.equals(NotificationConstants.CREATE_TEMPLATE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.createTemplate_success");
            }
            logger.log(Level.INFO, "Template creation : " + statusMessage);
        } else if (isChangeModuleAllowed.booleanValue()) {
            statusCode = NotificationConstants.DUPLICATE_TEMPLATE_NAME;
            statusMessage = rb.getString("admp.admin.notificationTemplate.duplicate_template_name");
        } else if (!isChangeModuleAllowed.booleanValue()) {
            statusCode = NotificationConstants.CANNOT_CHANGE_MODULE_NAME;
            statusMessage = rb.getString("admp.admin.notificationTemplate.cannot_change_module");
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("statusCode", (Object)statusCode);
        jsonObj.put("statusMessage", (Object)statusMessage);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward listTemplatesRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NotificationTemplateHandler.getTemplateList((HttpServletRequest)request, (ArrayList)this.viewColumnList, (AdventNetResourceBundle)ResourceBundleMgr.getInstance().getBundle(request));
        return mapping.findForward("templatesList");
    }

    public ActionForward isdeleteTemplateAllowed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long templateId = new Long(request.getParameter("templateId"));
        Integer statusCode = NotificationTemplateHandler.isTemplateInUse((Long)templateId);
        PrintWriter writer = response.getWriter();
        String statusMessage = "";
        if (statusCode.equals(NotificationConstants.DELETE_MGMT_TEMPLATE_FAILURE)) {
            statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure.used_in_profile");
        } else if (statusCode.equals(NotificationConstants.DELETE_AUTOMATION_TEMPLATE_FAILURE)) {
            statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure.used_in_automation");
        } else if (statusCode.equals(NotificationConstants.DELETE_WORKFLOW_TEMPLATE_FAILURE)) {
            statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure.used_in_workflow");
        }
        JSONObject json = new JSONObject();
        json.put("templateId", (Object)templateId);
        json.put("statusMessage", (Object)statusMessage);
        json.put("statusCode", (Object)statusCode);
        writer.print(json);
        return null;
    }

    public ActionForward deleteTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.log(Level.INFO, "Going to delete Layout");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String statusMessage = null;
        Integer statusCode = 0;
        try {
            String templateId = request.getParameter("templateId");
            if (templateId != null) {
                statusCode = NotificationTemplateHandler.deleteTemplate((Long)new Long(templateId));
            }
            if (statusCode.equals(NotificationConstants.DELETE_TEMPLATE_SUCCESS)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_success");
            } else if (statusCode.equals(NotificationConstants.DELETE_MGMT_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure") + rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure.used_in_profile");
            } else if (statusCode.equals(NotificationConstants.DELETE_AUTOMATION_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure") + rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure.used_in_automation");
            } else if (statusCode.equals(NotificationConstants.DELETE_WORKFLOW_TEMPLATE_FAILURE)) {
                statusMessage = rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure") + rb.getString("admp.admin.notificationTemplate.deleteTemplate_failure.used_in_workflow");
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("statusCode", (Object)statusCode);
            jsonObj.put("statusMessage", (Object)statusMessage);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward editTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Boolean isWorkflowConfigured = false;
        if (ClientAuthorizationUtil.isAuthorized(request, 8000L).booleanValue()) {
            isWorkflowConfigured = true;
        }
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        JSONObject templateDetails = null;
        String templateId = request.getParameter("templateId");
        if (templateId != null && !templateId.equals("")) {
            logger.log(Level.INFO, "Editing template Started ");
            templateDetails = NotificationTemplateHandler.getTemplateDetails((Long)Long.valueOf(templateId), (AdventNetResourceBundle)rb);
            logger.log(Level.INFO, "template details : " + templateDetails.toString());
        } else {
            templateDetails = new JSONObject();
        }
        if (request.getParameter("cancelMethod") != null) {
            request.setAttribute("cancelMethod", (Object)request.getParameter("cancelMethod"));
        }
        if (request.getParameter("saveMethod") != null) {
            request.setAttribute("saveMethod", (Object)request.getParameter("saveMethod"));
        }
        if (request.getParameter("moduleName") != null) {
            request.setAttribute("moduleName", (Object)request.getParameter("moduleName"));
        }
        request.setAttribute("templateDetails", (Object)templateDetails);
        Boolean isChangeModuleAllowed = true;
        if (templateId != null && !templateId.equals("") && !NotificationTemplateHandler.isTemplateInUse((Long)Long.valueOf(templateId)).equals(0)) {
            isChangeModuleAllowed = false;
        }
        request.setAttribute("isChangeModuleAllowed", (Object)isChangeModuleAllowed);
        request.setAttribute("recipientList", (Object)NotificationTemplateHandler.getRecipientList((Long)loginId, (AdventNetResourceBundle)rb, null));
        request.setAttribute("recipientMacroList", (Object)NotificationTemplateHandler.getRecipientMacroList((Long)loginId, (AdventNetResourceBundle)rb, null, (Boolean)isWorkflowConfigured));
        request.setAttribute("macroList", (Object)NotificationTemplateHandler.getMacrosList());
        request.setAttribute("recipientSMSMacroList", (Object)NotificationTemplateHandler.getRecipientSMSMacroList(null));
        return mapping.findForward("createEditTemplate");
    }

    public ActionForward getRecipientLists(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        JSONObject params = new JSONObject(request.getParameter("params"));
        if (request.getParameter("to") != null && Boolean.valueOf(request.getParameter("to").toString()).booleanValue() || request.getParameter("cc") != null && Boolean.valueOf(request.getParameter("cc").toString()).booleanValue()) {
            Boolean isWorkflowConfigured = false;
            if (ClientAuthorizationUtil.isAuthorized(request, 8000L).booleanValue()) {
                isWorkflowConfigured = true;
            }
            Hashtable recipientMacroList = NotificationTemplateHandler.getRecipientMacroList((Long)loginId, (AdventNetResourceBundle)rb, (String)params.getString("recipient"), (Boolean)isWorkflowConfigured);
            request.setAttribute("recipientMacroList", (Object)((JSONArray)recipientMacroList.get(params.getString("moduleCategory"))));
            request.setAttribute("autoFillRecipientList", (Object)NotificationTemplateHandler.getRecipientList((Long)loginId, (AdventNetResourceBundle)rb, (String)params.getString("recipient")));
            request.setAttribute("moduleCategory", (Object)params.getString("moduleCategory"));
            if (request.getParameter("to") != null && Boolean.valueOf(request.getParameter("to").toString()).booleanValue()) {
                request.setAttribute("autofillId", (Object)NotificationConstants.EMAIL_AUTO_FILL_ID);
            } else {
                request.setAttribute("autofillId", (Object)NotificationConstants.EMAIL_CC_AUTO_FILL_ID);
            }
        } else if (request.getParameter("sms") != null && Boolean.valueOf(request.getParameter("sms").toString()).booleanValue()) {
            request.setAttribute("recipientSMSMacroList", (Object)NotificationTemplateHandler.getRecipientSMSMacroList((String)params.getString("recipient")));
            request.setAttribute("autofillId", (Object)NotificationConstants.SMS_AUTO_FILL_ID);
        }
        return mapping.findForward("autoFillRecipients");
    }

    public ActionForward searchTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String paramStr = request.getParameter("params");
            JSONObject params = new JSONObject(paramStr);
            int pageNumber = 1;
            if (params.get("pageNumber") != null) {
                pageNumber = Integer.parseInt((String)params.get("pageNumber"));
            }
            JSONObject list = null;
            String searchText = "";
            if (!params.isNull("searchText")) {
                searchText = (String)params.get("searchText");
            }
            int range = 5;
            int startIndex = (pageNumber - 1) * range + 1;
            list = NotificationTemplateHandler.listTemplates((String)searchText, (int)startIndex, (int)range, (AdventNetResourceBundle)rb);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(list.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward searchTemplateFromPopup(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String searchStr = request.getParameter("searchString");
            String templateFormatId = request.getParameter("templateFormatId");
            Criteria crit = new Criteria(Column.getColumn((String)"MgmtNotifyTemplates", (String)"FORMAT_ID"), (Object)Integer.parseInt(templateFormatId), 0);
            JSONObject list = NotificationTemplateHandler.listTemplates((String)searchStr, (Criteria)crit, (int)-1, (int)-1, (AdventNetResourceBundle)rb);
            list.put("templateFormatId", (Object)templateFormatId);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(list.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

