/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.rss.core.DBConnectionListener;
import com.adventnet.rss.core.FeedReceiveListener;
import com.adventnet.rss.poller.FeedPoller;
import com.adventnet.rss.reader.FeedLoginParams;
import com.adventnet.rss.reader.FeedObject;
import com.adventnet.rss.reader.FeedURL;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.admin.RetreiveFeedHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.httpclient.HttpException;

public class RssConnector {
    private static RssConnector rssConnector;
    private static FeedPoller feedPoll;
    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static synchronized RssConnector getInstance() {
        if (rssConnector == null) {
            rssConnector = new RssConnector();
        }
        return rssConnector;
    }

    private RssConnector() {
        try {
            feedPoll.setDBConnectionListener((DBConnectionListener)new DBConnection());
            feedPoll.setCriteria("ManageEngine ServiceDesk Plus");
        }
        catch (Exception e) {
            throw new RuntimeException(this.rb.getString("client.admin.RssConnector.error_occurred_while_trying_to_connect_to_RSS_feed"), e);
        }
    }

    public void fetchRss(RetreiveFeedHandler rfh) {
        try {
            RetreiveFeedHandler feedListener = rfh;
            feedPoll.setFeedReceiveListener((FeedReceiveListener)feedListener);
            feedPoll.initialize();
            feedPoll.fetchRss();
        }
        catch (Exception e) {
            throw new RuntimeException(this.rb.getString("client.admin.RssConnector.error_occurred_while_trying_to_connect_to_RSS_feed"), e);
        }
    }

    public void fetchRss(RetreiveFeedHandler rfh, String append) throws IOException, HttpException, SQLException, Exception {
        try {
            RetreiveFeedHandler feedListener = rfh;
            feedPoll.setFeedReceiveListener((FeedReceiveListener)feedListener);
            feedPoll.initialize();
            Vector v = feedPoll.getRetrieveFeedVector();
            for (int i = 0; i < v.size(); ++i) {
                FeedObject fObj = (FeedObject)v.get(i);
                FeedLoginParams loginDetails = fObj.getFeedLoginParams();
                Vector<FeedURL> col = new Vector<FeedURL>();
                Collection feedUrlObjects = loginDetails.getFeedURLObjects();
                Iterator it = feedUrlObjects.iterator();
                if (!it.hasNext()) continue;
                FeedURL fURL = (FeedURL)it.next();
                String url = fURL.getFeedUrl();
                url = this.updateUrl(url);
                url = url + append;
                fURL.setFeedUrl(url);
                col.add(fURL);
                loginDetails.setFeedURLObjects(col);
                fObj.setFeedLoginParams(loginDetails);
                v.remove(i);
                v.add(fObj);
            }
            feedPoll.fetchRss(v);
        }
        catch (Exception e) {
            System.out.println("Error Message : " + e.getMessage());
            throw new Exception(e.getMessage(), e);
        }
    }

    private String updateUrl(String url) {
        int count = url.lastIndexOf("servlet/");
        url = url.substring(0, count + 8) + "WorkstationRssFeedServlet";
        return url;
    }

    static {
        feedPoll = new FeedPoller();
    }

    class DBConnection
    implements DBConnectionListener {
        DBConnection() {
        }

        public Connection getConnection() throws SQLException {
            RelationalAPI relapi = RelationalAPI.getInstance();
            return relapi.getConnection();
        }
    }
}

