/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin;

import com.adventnet.sym.adsm.common.server.admin.SmartCardHandler;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class SmartCardAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(SmartCardAction.class.getName());
    static String addCAMessage = "";
    static Boolean isAddCASuccess = Boolean.FALSE;

    public ActionForward addSmartCardConfiguration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        if (!ADSMPersUtil.checkSSL()) {
            addCAMessage = rb.getString("admp.admin.smartcard.please_enable_ssl_to_support");
            if (ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.CONNECTION_ACTION_ID).booleanValue()) {
                addCAMessage = addCAMessage + " <a href=\"javascript:CreateFormAndSubmit('/personalisePage.do?selectedTab=admp_admin&amp;selectedTile=ConnectionSettings&amp;methodToCall=showPersonalisePage','','');\" class=\"greenlinktxt\">" + rb.getString("jsp.authenticate.click_here") + "</a>.";
            }
            return null;
        }
        try {
            DynaActionForm imagekeyForm = (DynaActionForm)form;
            Map params = imagekeyForm.getMap();
            FormFile certFile = (FormFile)params.remove("cretFileUpload");
            String smartCardParams = request.getParameter("smartCardParams");
            JSONObject jsonObj = new JSONObject(smartCardParams);
            InputStream licenseFileContents = certFile.getInputStream();
            X509Certificate x509Cert = null;
            try {
                x509Cert = X509Certificate.getInstance(licenseFileContents);
            }
            catch (Exception e) {
                addCAMessage = rb.getString("admp.admin.smartcard.ImportRootCert.Root_Certificate_Import_failed");
                isAddCASuccess = Boolean.FALSE;
                e.printStackTrace();
                return null;
            }
            Date expiredOn = x509Cert.getNotAfter();
            Date currentDate = new Date();
            if (expiredOn.before(currentDate)) {
                addCAMessage = rb.getString("admp.admin.smartcard.ImportRootCert.cretificate_has_expired_already");
                isAddCASuccess = Boolean.FALSE;
                return null;
            }
            if (jsonObj.has(SmartCardHandler.CRETIFICATE_MAPPING_ATTRIBUTE) && jsonObj.has(SmartCardHandler.AD_MAPPING_ATTRIBUTE)) {
                Integer randomAliasName = new Random().nextInt();
                logger.log(Level.INFO, "Add Certificate To Trusted Store is called");
                String result = SmartCardHandler.addCertificateToTrustedStore((HttpServletResponse)response, (FormFile)certFile, (InputStream)certFile.getInputStream(), (Integer)randomAliasName);
                logger.log(Level.INFO, "Certificate To Trusted Store is result" + result);
                if (result.startsWith("Certificate was added to keystore")) {
                    SmartCardHandler.addSmartCardDetails((X509Certificate)x509Cert, (JSONObject)jsonObj, (String)certFile.getFileName(), (Integer)randomAliasName);
                    addCAMessage = rb.getString("admp.admin.smartCard.successfully_added_smartcard_auth");
                    isAddCASuccess = Boolean.TRUE;
                } else {
                    addCAMessage = result;
                    isAddCASuccess = Boolean.FALSE;
                }
                if (!SmartCardHandler.isSmartCardEnabled()) {
                    ADSMPersUtil.updateSyMParameter((String)"SMART_CARD_STATUS", (String)"true");
                    SmartCardHandler.updateClientAuth((String)"want");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateSmartCardConfiguration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        try {
            String smartCardParams = request.getParameter("params");
            JSONObject jsonObj = new JSONObject(smartCardParams);
            String uniqueId = jsonObj.getString(SmartCardHandler.UNIQUE_ID);
            String cretMappingAttr = jsonObj.getString(SmartCardHandler.CRETIFICATE_MAPPING_ATTRIBUTE);
            String adMappingAttr = jsonObj.getString(SmartCardHandler.AD_MAPPING_ATTRIBUTE);
            String ocspServerName = jsonObj.getString(SmartCardHandler.OCSP_SERVER_NAME);
            Integer ocspServerPort = jsonObj.getInt(SmartCardHandler.OCSP_SERVER_PORT);
            JSONObject linkedDomains = (JSONObject)jsonObj.get(SmartCardHandler.LINKED_DOMAINS);
            String message = null;
            message = SmartCardHandler.updateSmartCardDetails((String)uniqueId, (String)cretMappingAttr, (String)adMappingAttr, (String)ocspServerName, (Integer)ocspServerPort, (JSONObject)linkedDomains) ? "admp.admin.smartcard.updateSmartCardCert.Successfully_Updated" : "admp.admin.smartcard.updateSmartCardCert.update_failed";
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID);
            ArrayList configuredSmartCardList = SmartCardHandler.getSmartCardList(domainList);
            request.setAttribute("smartCardStatus", (Object)SmartCardHandler.isSmartCardEnabled());
            request.setAttribute("statusMessage", (Object)rb.getString(message));
            request.setAttribute("configuredSmartCardList", (Object)configuredSmartCardList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("SmartCardRows");
    }

    public ActionForward editSmartCardConfiguration(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        JSONObject json = new JSONObject();
        try {
            String uniqueId = request.getParameter("uniqueId");
            if (uniqueId != null) {
                ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID);
                json = SmartCardHandler.getSmartCardDetails(domainList, (Long)new Long(uniqueId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AjaxUtil.writeResponse(response, json.toString());
        return null;
    }

    public ActionForward showSmartCardConfigured(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        try {
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID);
            ArrayList configuredSmartCardList = SmartCardHandler.getSmartCardList(domainList);
            request.setAttribute("configuredSmartCardList", (Object)configuredSmartCardList);
            request.setAttribute("smartCardStatus", (Object)SmartCardHandler.isSmartCardEnabled());
            request.setAttribute("domainList", domainList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("SmartCard");
    }

    public ActionForward showSmartCardConfiguredRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        try {
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID);
            ArrayList configuredSmartCardList = SmartCardHandler.getSmartCardList(domainList);
            request.setAttribute("configuredSmartCardList", (Object)configuredSmartCardList);
            request.setAttribute("statusMessage", (Object)addCAMessage);
            request.setAttribute("isAddCASuccess", (Object)isAddCASuccess);
            request.setAttribute("smartCardStatus", (Object)SmartCardHandler.isSmartCardEnabled());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("SmartCardRows");
    }

    public ActionForward deleteSmartCardDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        String uniqueId = request.getParameter("uniqueId");
        if (uniqueId != null) {
            SmartCardHandler.deleteSmartCardDetails((Long)new Long(uniqueId));
            if (SmartCardHandler.isSmartCardDetailsEmpty()) {
                SmartCardHandler.updateClientAuth((String)"false");
                ADSMPersUtil.updateSyMParameter((String)"SMART_CARD_STATUS", (String)"false");
            }
            ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID);
            ArrayList configuredSmartCardList = SmartCardHandler.getSmartCardList(domainList);
            request.setAttribute("configuredSmartCardList", (Object)configuredSmartCardList);
            request.setAttribute("statusMessage", (Object)rb.getString("admp.admin.smart_card.text_status_msg_successfully_deleted_the_smart_card"));
            request.setAttribute("smartCardStatus", (Object)SmartCardHandler.isSmartCardEnabled());
        }
        return mapping.findForward("SmartCardRows");
    }

    public ActionForward updateSmartCardStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID).booleanValue()) {
            return new ActionForward("/403Error.do");
        }
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, AdminConfigConstants.SMART_CARD_AUTH_ACTION_ID);
        ArrayList configuredSmartCardList = SmartCardHandler.getSmartCardList(domainList);
        String smartCardStatus = request.getParameter("smartCardStatus");
        ADSMPersUtil.updateSyMParameter((String)"SMART_CARD_STATUS", (String)smartCardStatus);
        if (SmartCardHandler.isSmartCardEnabled()) {
            SmartCardHandler.updateClientAuth((String)"want");
            request.setAttribute("smartCardStatus", (Object)Boolean.TRUE);
            request.setAttribute("statusMessage", (Object)rb.getString("admp.admin.smartCard.smartcard_auth_successfully_enabled"));
        } else {
            SmartCardHandler.updateClientAuth((String)"false");
            request.setAttribute("smartCardStatus", (Object)Boolean.FALSE);
            request.setAttribute("statusMessage", (Object)rb.getString("admp.admin.smartCard.smartcard_auth_successfully_disabled"));
        }
        request.setAttribute("configuredSmartCardList", (Object)configuredSmartCardList);
        return mapping.findForward("SmartCardRows");
    }
}

