/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.admin.tools;

import com.adventnet.sym.adsm.common.server.admin.tools.DesktopSharingUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DesktopSharingAction
extends DispatchAction {
    public ActionForward remoteDesktop(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            request.setAttribute("list", (Object)DesktopSharingUtil.getComputerList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("desktopSharing");
    }

    public ActionForward connect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            String sessionId = session.getId();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String name = request.getParameter("name").trim();
            String userName = request.getParameter("userName").trim();
            String password = request.getParameter("password").trim();
            Properties p = HDTDomainHandler.getSelectedDomain((Long)loginId);
            String domainName = p.getProperty("DOMAIN_NAME");
            Hashtable hash = DesktopSharingUtil.doAction((String)sessionId, (Long)loginId, (String)domainName, (String)name, (String)userName, (String)password);
            this.getStatusXMLElement(response, (String)hash.get("ERROR_CODE"), (String)hash.get("MESSAGE"), (String)hash.get("computerName"), (String)hash.get("ip"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void getStatusXMLElement(HttpServletResponse response, String errorCode, String message, String computerName, String ip) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element creationStatusElement = document.createElement("status");
            creationStatusElement.setAttribute("errorCode", errorCode);
            creationStatusElement.setAttribute("message", message);
            creationStatusElement.setAttribute("computerName", computerName);
            creationStatusElement.setAttribute("ip", ip);
            data.appendChild(creationStatusElement);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

