/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.clientapi.mgmt.ADMgmtAPIcall;
import com.adventnet.sym.adsm.clientapi.mgmt.FileServerMgmtAPIcall;
import com.adventnet.sym.adsm.clientapi.mgmt.MAppEnrollmentCall;
import com.adventnet.sym.adsm.clientapi.mgmt.MComputerMgmtAPIcall;
import com.adventnet.sym.adsm.clientapi.mgmt.MGroupMgmtAPIcall;
import com.adventnet.sym.adsm.clientapi.mgmt.MReportAPIcall;
import com.adventnet.sym.adsm.clientapi.mgmt.MUserMgmtAPIcall;
import com.adventnet.sym.adsm.clientapi.mgmt.WFMgmtAPIcall;
import com.adventnet.sym.adsm.common.server.LocaleThreadLocal;
import com.adventnet.sym.adsm.common.server.api.APIRequestsCountHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.RestAPIAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.adventnet.sym.adsm.common.webclient.api.APIErrorHandler;
import com.adventnet.sym.adsm.common.webclient.api.CreateUserAPI;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import com.adventnet.sym.adsm.mobilesso.TicketHandler;
import com.adventnet.sym.adsm.serverapi.ADObject;
import com.adventnet.sym.adsm.serverapi.AdUser;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADMPAPIAction
extends Action {
    private static Logger out = Logger.getLogger("APILogger");
    private static Long CREATE_USER_API_ID = 63L;
    private static Long SEARCH_USER_API_ID = 64L;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        out.log(Level.INFO, " ADMPAPI Action entered ");
        String forward = "StatusPage";
        try {
            String resultResponse = null;
            String responseType = request.getParameter("RESPONSE_TYPE");
            String requestURI = request.getRequestURI();
            HttpSession session = request.getSession();
            LocaleThreadLocal.set((Locale)request.getLocale());
            if (requestURI.contains("CreateUserOld")) {
                Properties statusProps = ADMPAPIAction.createUser(request);
                if (responseType == null || responseType.equalsIgnoreCase("json")) {
                    resultResponse = ADMPAPIUtil.getJSONString(statusProps);
                }
            } else if (requestURI.contains("MTemplateNames")) {
                out.log(Level.INFO, "Get MTemplateNames entered...");
                resultResponse = MUserMgmtAPIcall.getLayoutUserTemplates(request);
            } else if (requestURI.contains("TemplateNames")) {
                LocaleThreadLocal.set(null);
                Properties templates = ADMPAPIAction.getUserTemplatesDetails(request);
                if (responseType == null || responseType.equalsIgnoreCase("json")) {
                    resultResponse = ADMPAPIUtil.getJSONString(templates);
                }
            } else if (requestURI.contains("ADUserList")) {
                out.log(Level.INFO, "ADUsersList entered");
                ADObject adObject = MReportAPIcall.getUserList(request);
                resultResponse = adObject.toJSONString();
            } else if (requestURI.contains("SearchUser")) {
                out.log(Level.INFO, "SearchUser entered");
                if (APIRequestsCountHandler.getInstance().isAllowed(SEARCH_USER_API_ID)) {
                    JSONObject jsonObject = MReportAPIcall.searchUsers(request);
                    resultResponse = jsonObject.toString();
                } else {
                    resultResponse = APIRequestsCountHandler.getInstance().limitationMsg();
                }
            } else if (requestURI.contains("ADComputerList")) {
                out.log(Level.INFO, "ADComputersList entered");
                ADObject adObject = MReportAPIcall.getComputerList(request);
                resultResponse = adObject.toJSONString();
            } else if (requestURI.contains("ADGroupList")) {
                out.log(Level.INFO, "ADGroupList entered");
                ADObject adObject = MReportAPIcall.getGroupList(request);
                resultResponse = adObject.toJSONString();
            } else if (requestURI.contains("UserDetails")) {
                out.log(Level.INFO, "User Details entered in ADMPAPI action");
                AdUser adUser = MReportAPIcall.getUserDetails(request);
                resultResponse = adUser.toJsonString();
            } else if (requestURI.contains("ComputerDetails")) {
                out.log(Level.INFO, "Computer Details entered in ADMPAPI action");
                JSONObject objectDetails = MReportAPIcall.getComputerDetails(request);
                resultResponse = objectDetails.toString();
            } else if (requestURI.contains("EnableUser")) {
                out.log(Level.INFO, "Enable user called ");
                resultResponse = MUserMgmtAPIcall.enableUser(request);
            } else if (requestURI.contains("AddRemoveGroups")) {
                out.log(Level.INFO, "Add/Remove Groups for User called ");
                resultResponse = MGroupMgmtAPIcall.addRemoveGroups(request);
            } else if (requestURI.contains("GetAuthInfo")) {
                out.log(Level.INFO, "getAuthInfo for User called ");
                resultResponse = ADMgmtAPIcall.getAuthInfo(request);
            } else if (requestURI.contains("DisableUser")) {
                out.log(Level.INFO, "Disable user called ");
                resultResponse = MUserMgmtAPIcall.disableUser(request);
            } else if (requestURI.contains("DeleteUser")) {
                out.log(Level.INFO, "DeleteUser called ");
                resultResponse = MUserMgmtAPIcall.deleteUser(request);
            } else if (requestURI.contains("UnlockUser")) {
                out.log(Level.INFO, " Unlock user in ADMPAPIACtion ");
                resultResponse = MUserMgmtAPIcall.unlockUser(request);
            } else if (requestURI.contains("ResetPwd")) {
                out.log(Level.INFO, "Reset Pwd single called");
                resultResponse = MUserMgmtAPIcall.resetPwd(request);
            } else if (requestURI.contains("ResetComputer")) {
                out.log(Level.INFO, "Reset computer called");
                resultResponse = MComputerMgmtAPIcall.resetComputer(request);
            } else if (requestURI.contains("DisableComputer")) {
                out.log(Level.INFO, "Disable computer called ");
                resultResponse = MComputerMgmtAPIcall.enableComputer(request);
            } else if (requestURI.contains("EnableComputer")) {
                out.log(Level.INFO, "Enable computer called ");
                resultResponse = MComputerMgmtAPIcall.enableComputer(request);
            } else if (requestURI.contains("DeleteComputer")) {
                out.log(Level.INFO, "DeleteComputer called ");
                resultResponse = MComputerMgmtAPIcall.deleteComputer(request);
            } else if (requestURI.contains("DomainList")) {
                out.log(Level.INFO, " Domain List ");
            } else if (requestURI.contains("UserTemplates")) {
                resultResponse = MUserMgmtAPIcall.getLayoutUserTemplates(request);
            } else if (requestURI.contains("CreateBulkUser")) {
                LocaleThreadLocal.set(null);
                resultResponse = MUserMgmtAPIcall.createBulkUser(request);
            } else if (requestURI.contains("CreateUser")) {
                LocaleThreadLocal.set(null);
                request.setAttribute("isLicenseRestricted", (Object)"true");
                resultResponse = MUserMgmtAPIcall.createBulkUser(request);
            } else if (requestURI.contains("ConfigureTrust")) {
                resultResponse = ADMgmtAPIcall.configureTrustedProduct(request);
            } else if (requestURI.contains("RemoveTrust")) {
                resultResponse = ADMgmtAPIcall.removeTrustedProduct(request);
            } else if (requestURI.contains("APIAuthToken")) {
                resultResponse = ADMgmtAPIcall.getAuthTokenForAPI(request);
            } else if (requestURI.contains("GetAuthToken")) {
                resultResponse = ADMgmtAPIcall.getAuthToken(request);
            } else if (requestURI.contains("RemoveAuthToken")) {
                resultResponse = ADMgmtAPIcall.removeAuthToken(request);
            } else if (requestURI.contains("GetAuthObject")) {
                JSONObject json = new JSONObject();
                String admpAuthObjectString = new String();
                String isAuthtokenFound = "false";
                out.log(Level.INFO, " Get Auth Object in ADMPAPIAction.java ");
                if (session.getAttribute("ADMP_AUTH_OBJECT") != null) {
                    ADMPAuthObject admpAuthObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                    admpAuthObjectString = admpAuthObject.toJSONStringForMobile();
                    isAuthtokenFound = "true";
                } else {
                    TicketHandler ticketHandler = TicketHandler.getInstance();
                    String authToken = request.getParameter("AuthToken");
                    Ticket authTokenObj = null;
                    Long loginIdd = -1L;
                    if (authToken != null) {
                        authTokenObj = ticketHandler.getTicketFrmCache(authToken);
                        if (authTokenObj != null) {
                            loginIdd = authTokenObj.getLoginId();
                            if (loginIdd != null && loginIdd != -1L) {
                                RestAPIAuthObject admpAuthObject = new RestAPIAuthObject(loginIdd, request);
                                session.setAttribute("ADMP_AUTH_OBJECT", (Object)admpAuthObject);
                                admpAuthObjectString = admpAuthObject.toJSONStringForMobile();
                                isAuthtokenFound = "true";
                            } else {
                                isAuthtokenFound = "false";
                            }
                        } else {
                            isAuthtokenFound = "false";
                        }
                    }
                }
                json.put("admpAuthObjectString", (Object)admpAuthObjectString);
                json.put("isAuthtokenFound", (Object)isAuthtokenFound);
                resultResponse = json.toString();
            } else if (requestURI.contains("GenerateReport")) {
                Long generationId = MReportAPIcall.generateReport(request);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("generationId", (Object)String.valueOf(generationId));
                resultResponse = jsonObject.toString();
            } else if (requestURI.contains("GetReportStatus")) {
                JSONObject jsonObject = MReportAPIcall.getReportStatus(request);
                resultResponse = jsonObject.toString();
            } else if (requestURI.contains("ReportResultList")) {
                ADObject adObject = MReportAPIcall.getReportObjectList(request);
                resultResponse = adObject.toJSONString();
            } else if (requestURI.contains("WFRequestList")) {
                out.log(Level.INFO, "WorkflowRequestList called...");
                resultResponse = WFMgmtAPIcall.getWFRequestList(request);
            } else if (requestURI.contains("WFRequestDetail")) {
                out.log(Level.INFO, "RequestDetails called...");
                resultResponse = WFMgmtAPIcall.getWFRequestDetail(request);
            } else if (requestURI.contains("WFRequestObjectList")) {
                out.log(Level.INFO, "ModifiedObjects called...");
                Long requestActionId = Long.parseLong(request.getParameter("REQUEST_ACTION_ID"));
                if (requestActionId.compareTo(WorkFlowUtil.CREATE_GROUP_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_CONTACT_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0 || requestActionId.compareTo(WorkFlowUtil.MODIFY_USER_ACTION_ID) == 0) {
                    session.setAttribute("FcBulkExecuteFormBean", (Object)WFMgmtAPIcall.getBulkExecuteFormBean(request));
                }
                resultResponse = WFMgmtAPIcall.getWFRequestObjectList(request);
            } else if (requestURI.contains("WFRequestMgmtAction")) {
                out.log(Level.INFO, "RequestMgmtAction called...");
                String operation = request.getParameter("OPERATION");
                JSONObject result = new JSONObject();
                if (operation != null && operation.equals("delete")) {
                    JSONObject json = new JSONObject(request.getParameter("SELECTED_GUID_STRING"));
                    String[] selectedGUIDsStr = new String[json.length()];
                    Iterator itr = json.keys();
                    int i = 0;
                    while (itr.hasNext()) {
                        selectedGUIDsStr[i] = (String)itr.next();
                        ++i;
                    }
                    WorkFlowUtil.deleteWFRequestSchedule((String[])selectedGUIDsStr, (String)operation);
                    Boolean isSuccess = WorkFlowUtil.deleteRequests((String[])selectedGUIDsStr);
                    result.put("isSuccess", (Object)isSuccess);
                } else if (operation != null && operation.equals("review")) {
                    result.put("isSuccess", WFMgmtAPIcall.reviewWFRequest(request));
                } else if (operation != null && operation.equals("approve")) {
                    result.put("isSuccess", WFMgmtAPIcall.approveWFRequest(request));
                } else if (operation != null && operation.equals("execute")) {
                    result.put("isSuccess", WFMgmtAPIcall.executeWFRequest(request));
                } else if (operation != null && operation.equals("reject")) {
                    result.put("isSuccess", WFMgmtAPIcall.rejectWFRequest(request));
                } else if (operation != null && operation.equals("close")) {
                    result.put("isSuccess", WFMgmtAPIcall.closeWFRequest(request));
                } else if (operation != null && operation.equals("cancel")) {
                    result.put("isSuccess", WFMgmtAPIcall.cancelWFRequest(request));
                } else if (operation != null && operation.equals("deleteWFRequestObject")) {
                    result.put("isSuccess", WFMgmtAPIcall.deleteWFRequestObject(request));
                }
                resultResponse = result.toString();
            } else if (requestURI.contains("GetTemplateLayout")) {
                out.log(Level.INFO, "Get TemplateLayout entered...");
                resultResponse = MUserMgmtAPIcall.getTemplateLayout(request);
            } else if (requestURI.contains("NamingValues")) {
                out.log(Level.INFO, "Get Template Naming Values Entered...");
                resultResponse = MUserMgmtAPIcall.getNamingFormatValues(request);
            } else if (requestURI.contains("GetContainerList")) {
                String output;
                out.log(Level.INFO, "Get Container list entered...");
                resultResponse = output = MUserMgmtAPIcall.getOuList(request);
            } else if (requestURI.contains("expandContainer")) {
                out.log(Level.INFO, "Expand Container entered...");
                resultResponse = MUserMgmtAPIcall.expandContainer(request);
            } else if (requestURI.contains("getManagerValues")) {
                String output;
                out.log(Level.INFO, "Get Manager Values entered...");
                resultResponse = output = MUserMgmtAPIcall.getManagerValues(request);
            } else if (requestURI.contains("GetGroupValues")) {
                out.log(Level.INFO, "Get Group Values Entered...");
                resultResponse = MUserMgmtAPIcall.getGroupValues(request);
            } else if (requestURI.contains("CreateSingleUser")) {
                out.log(Level.INFO, "CreateUser entered...");
                resultResponse = MUserMgmtAPIcall.createUser(request);
            } else if (requestURI.contains("EnrollDevice")) {
                out.log(Level.INFO, "Mobile App Enrollment Called...");
                resultResponse = new JSONObject().put("isSuccess", (Object)MAppEnrollmentCall.enrollApp(request)).toString();
            } else if (requestURI.contains("RemoveDevice")) {
                out.log(Level.INFO, "Remove Device Called...");
                resultResponse = new JSONObject().put("isSuccess", (Object)MAppEnrollmentCall.removeDevice(request)).toString();
            } else if (requestURI.contains("GetNamingFormat")) {
                out.log(Level.INFO, " GetNamingFormat in ADMPAPIAction ");
                resultResponse = MUserMgmtAPIcall.getNamingFormat(request);
            } else if (requestURI.contains("GetDepartmentList")) {
                out.log(Level.INFO, " GetDepartmentList in ADMPAPIAction ");
                resultResponse = MUserMgmtAPIcall.getDepartmentList().toString();
            } else if (requestURI.contains("BulkUserModify")) {
                out.log(Level.INFO, " BulkUserModify in ADMPAPIAction ");
                resultResponse = "";
                LocaleThreadLocal.set(null);
                try {
                    resultResponse = MUserMgmtAPIcall.modifyBulkUser(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (requestURI.contains("FSMFolderList")) {
                out.log(Level.INFO, "FSMFolderList Called...");
                JSONObject jsonObject = FileServerMgmtAPIcall.getFSMFolderList(request);
                resultResponse = jsonObject.toString();
            } else if (requestURI.contains("GroupsWithPermission")) {
                out.log(Level.INFO, "GroupsWithPermission Called...");
                JSONObject jsonObject = FileServerMgmtAPIcall.getGroupsWithSamePermission(request);
                resultResponse = jsonObject.toString();
            } else if (requestURI.contains("SetFolderPermissions")) {
                out.log(Level.INFO, "SetFolderPermissions Called...");
                JSONArray jsonArr = FileServerMgmtAPIcall.setFolderPermissions(request);
                resultResponse = jsonArr.toString();
            } else if (requestURI.contains("RemoveFolderPermissions")) {
                out.log(Level.INFO, "RemoveFolderPermissions Called...");
                JSONArray jsonArr = FileServerMgmtAPIcall.removeFolderPermissions(request);
                resultResponse = jsonArr.toString();
            }
            request.setAttribute("RESPONSE", (Object)resultResponse);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("RESPONSE", (Object)this.getErrorResponse(e.getMessage()));
        }
        response.addHeader("Access-Control-Allow-Origin", "*");
        return mapping.findForward("result");
    }

    private String getErrorResponse(String errorMsg) {
        String resultResponse = null;
        try {
            APIErrorHandler errorHandler = new APIErrorHandler();
            Properties statusProps = errorHandler.getErrorProperties(errorMsg, null);
            resultResponse = CommonUtil.getJSONString((Properties)statusProps);
        }
        catch (Exception e) {
            out.log(Level.INFO, " ", e);
        }
        return resultResponse;
    }

    private static Properties createUser(HttpServletRequest request) {
        Properties statusProps = new Properties();
        try {
            HttpSession session = request.getSession();
            String logonName = request.getParameter("HDT_NAME");
            String domainName = request.getParameter("DOMAIN_NAME");
            String userProps = request.getParameter("USER_PROPERTIES");
            String domainFlatName = request.getParameter("DOMAIN_FLAT_NAME");
            if (domainFlatName == null) {
                Properties loginDomainProps = DomainUtil.getDomainDetails((String)domainName, (String)"DOMAIN_NAME");
                domainFlatName = loginDomainProps.getProperty("DOMAIN_FLAT_NAME");
            }
            Hashtable<String, Object> userParams = new Hashtable<String, Object>();
            JSONObject jsonObj = new JSONObject(userProps);
            Iterator it = jsonObj.keys();
            while (it.hasNext()) {
                String attribName = (String)it.next();
                Object attribValue = jsonObj.get(attribName);
                if (attribName.equalsIgnoreCase("OUName")) {
                    attribName = "OUName";
                }
                userParams.put(attribName, attribValue);
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long templateId = UserTemplateHandler.getTemplateId((String)((String)userParams.get("templateName")));
            try {
                CreateUserAPI.isAuthorized(loginId, templateId, userParams, session);
            }
            catch (Exception e) {
                out.log(Level.INFO, "Problem in HDT Authorization : " + e);
                APIErrorHandler errorHandler = new APIErrorHandler();
                return errorHandler.getAPIStatus(e.getMessage());
            }
            Hashtable<String, Long> apiParams = new Hashtable<String, Long>();
            apiParams.put("templateId", templateId);
            apiParams.put("loginId", loginId);
            statusProps = CreateUserAPI.createUser(request, apiParams, userParams);
            out.log(Level.INFO, "Create User Status : " + statusProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusProps;
    }

    private static Properties getUserTemplatesDetails(HttpServletRequest request) {
        Properties templatesDetails = new Properties();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("DOMAIN_NAME");
            ArrayList templates = UserTemplateHandler.getTemplates((Long)loginId, (String)domainName);
            Long deafultTemplateID = UserTemplateUtil.getDefaultTemplate((Long)loginId);
            templatesDetails.put("templateList", templates);
            templatesDetails.put("deafultTemplateID", deafultTemplateID);
        }
        catch (Exception e) {
            out.log(Level.INFO, "Error occured while getting Templates : " + e);
            e.printStackTrace();
        }
        out.log(Level.INFO, "Templates : " + templatesDetails.toString());
        return templatesDetails;
    }
}

