/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.manageengine.ads.fw.api.RestAPIAuthorization;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ADMPAPIAuthorization
implements RestAPIAuthorization {
    private Logger logger = Logger.getLogger("ADSLogger");
    public static final Integer TIMEOUT = 120;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAuthorized(HttpServletRequest request) throws Exception {
        String requestAPI = request.getRequestURI();
        String userName = request.getParameter("userName");
        String domainName = request.getParameter("domainName");
        String domainFlatName = null;
        String isProductUser = request.getParameter("isProductUser");
        HttpSession session = request.getSession();
        session.setMaxInactiveInterval(TIMEOUT.intValue());
        if ("true".equalsIgnoreCase(isProductUser)) {
            domainFlatName = domainName = "ADManager Plus Authentication";
        } else {
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
            if (domainDetails.length() != 0) {
                domainName = domainDetails.getString("DOMAIN_NAME");
                domainFlatName = domainDetails.getString("DOMAIN_FLAT_NAME");
            }
        }
        this.logger.log(Level.INFO, "Inside ADMPAPIAuthorization - isAuthorized method");
        this.logger.log(Level.INFO, "requestAPI " + requestAPI);
        this.logger.log(Level.INFO, "userName " + userName);
        this.logger.log(Level.INFO, "domainName " + domainName);
        if (requestAPI.contains("GetDashboard")) {
            if (request.getParameter("params") == null) throw new Exception("00000009");
            JSONObject params = new JSONObject(request.getParameter("params"));
            this.logger.log(Level.INFO, "params = " + params);
            if (!params.has("domainName")) {
                throw new Exception("00000009");
            }
            String requestedDomain = params.getString("domainName");
            JSONObject domainDetails = DomainHandler.getDomainDetails((String)requestedDomain);
            if (domainDetails.length() != 0) {
                requestedDomain = domainDetails.getString("DOMAIN_NAME");
            }
            this.logger.log(Level.INFO, "requestedDomain = " + requestedDomain);
            this.isUserAuthorized(userName.trim(), domainName.trim(), requestedDomain.trim());
            return true;
        } else {
            if (!requestAPI.contains("WorkflowAPI")) return true;
            this.isWorkflowUserAuthorized(request.getParameter("PRODUCT_NAME"), userName, domainName, domainFlatName);
        }
        return true;
    }

    private boolean isUserAuthorized(String userName, String domainName, String requestedDomain) throws Exception {
        boolean isUserAuthorized = true;
        this.logger.log(Level.INFO, "Inside ADMPAPIAuthorization - isUserAuthorized method");
        try {
            ArrayList allConfiguredDomainList = DomainInfoCache.getInstance().getconfiguredDomainList();
            if (!allConfiguredDomainList.contains(requestedDomain)) {
                throw new Exception("00000010");
            }
            if (!domainName.equals("ADManager Plus Authentication")) {
                Properties domainProperties = DomainUtil.getDomainDetails((String)domainName, (String)"DOMAIN_NAME");
                domainName = domainProperties.getProperty("DOMAIN_FLAT_NAME");
            }
            try {
                AuthUtil.getUserId((String)userName, (String)domainName);
            }
            catch (Exception ex) {
                throw new Exception("00000004");
            }
            Long loginId = ADMPAPIUtil.getLoginId(userName, domainName);
            ArrayList domainList = HDTDomainHandler.getDomainNamesList((Long)loginId);
            if (!domainList.contains(requestedDomain)) {
                throw new Exception("00000008");
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        this.logger.log(Level.INFO, "isUserAuthorized = " + isUserAuthorized);
        return isUserAuthorized;
    }

    private boolean isWorkflowUserAuthorized(String productName, String userName, String domainName, String domainFlatName) throws Exception {
        ArrayList allConfiguredDomainList;
        boolean isAuthorized = false;
        if (!LicenseMgr.getInstance().isModuleLicensed("Workflow")) {
            throw new Exception("00001003");
        }
        if (!productName.equalsIgnoreCase("ManageEngine ADSelfService Plus")) {
            throw new Exception("00001002");
        }
        if (!domainName.equalsIgnoreCase("ADManager Plus Authentication") && !(allConfiguredDomainList = DomainInfoCache.getInstance().getconfiguredDomainList()).contains(domainName)) {
            throw new Exception("00000010");
        }
        Long loginId = ADMPAPIUtil.getLoginId(userName, domainFlatName);
        if (loginId == null) {
            try {
                ADMPUserHandler.checkAndAddSelfServiceUser((String)userName, (String)domainName);
            }
            catch (Exception e) {
                this.logger.log(Level.INFO, "", e);
            }
            loginId = ADMPAPIUtil.getLoginId(userName, domainFlatName);
        }
        if (loginId == null || !ADMPAPIUtil.isWFRequesterAccountActive(loginId)) {
            throw new Exception("00001001");
        }
        return isAuthorized;
    }
}

