/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIErrorHandler;
import java.util.Properties;
import java.util.logging.Logger;

public class APIErrorHandler
extends ADMPAPIErrorHandler {
    private static Logger out = Logger.getLogger("APILogger");
    public static final String NO_USER_FOUND = "00000001";
    public static final String NO_DOMAIN_ACCESS = "00000002";
    public static final String NO_ATTRIB_PERMISSION = "00000003";
    public static final String CREATE_USER_COUNT_EXIT = "00000004";
    public static final String NO_PRODUCT_CONFIGURED = "00000005";
    public static final String URL_CONNECTION_EXCEP = "00000006";
    public static final String INVALID_AUTHENTICATION = "00000007";
    public static final String MANDATORY_ATTRIBS_MISSING = "00000008";
    public static final String TEMPLATE_NOT_FOUND = "00000009";
    public static final String UNAUTHORIZED_TEMPLATE = "00000010";
    public static final String USER_ACC_IS_NOT_ACTIVE = "00000011";
    public static final String UNAUTHORIZED_CONTAINER = "00000012";
    public static final String NOT_SUPER_ADMIN_TO_CONFIGURE_TRUST = "00000013";
    public static final String INVALID_API_KEY = "00000014";
    public static final String INVALID_PRODUCT_NAME = "00000015";
    public static final String INVALID_INPUT_FORMAT = "00000016";

    public Properties getFormattedStatusProp(String severity, String statusMsg, String errorCode) {
        Properties props = new Properties();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            props.put("SEVERITY", severity);
            props.put("STATUS_MESSAGE", rb.getString(statusMsg));
            props.put("ERROR_CODE", errorCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public Properties getAPIStatus(String errorCode) {
        return this.getAPIStatus(errorCode, null);
    }

    public Properties getAPIStatus(String errorCode, Properties params) {
        if (errorCode.equals(INVALID_AUTHENTICATION)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.product_to_product_authentication", INVALID_AUTHENTICATION);
        }
        if (errorCode.equals(NO_PRODUCT_CONFIGURED)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.product_to_product_connection_error", NO_PRODUCT_CONFIGURED);
        }
        if (errorCode.equals(URL_CONNECTION_EXCEP)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.unable_to_connect", URL_CONNECTION_EXCEP);
        }
        if (errorCode.equals(NO_USER_FOUND)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.user_not_found", NO_USER_FOUND);
        }
        if (errorCode.equals(NO_DOMAIN_ACCESS)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.user_no_premission", NO_DOMAIN_ACCESS);
        }
        if (errorCode.equals(CREATE_USER_COUNT_EXIT)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.cannot_create_more_ad_object", CREATE_USER_COUNT_EXIT);
        }
        if (errorCode.equals(NO_ATTRIB_PERMISSION)) {
            if (params == null) {
                return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.no_premission_to_update_attributes", NO_ATTRIB_PERMISSION);
            }
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.no_premission_to_update" + params.get("UN_AUTHOR_ATTRIBS"), NO_ATTRIB_PERMISSION);
        }
        if (errorCode.equals(MANDATORY_ATTRIBS_MISSING)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.manadatory_attribute_needed_user_creation", MANDATORY_ATTRIBS_MISSING);
        }
        if (errorCode.equals(TEMPLATE_NOT_FOUND)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.given_template_not_found", TEMPLATE_NOT_FOUND);
        }
        if (errorCode.equals(UNAUTHORIZED_TEMPLATE)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.no_premission_for_template", UNAUTHORIZED_TEMPLATE);
        }
        if (errorCode.equals(USER_ACC_IS_NOT_ACTIVE)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.disabled_techinician_desired_operation", USER_ACC_IS_NOT_ACTIVE);
        }
        if (errorCode.equals(UNAUTHORIZED_CONTAINER)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.no_premission_for_container", UNAUTHORIZED_CONTAINER);
        }
        if (errorCode.equals(NOT_SUPER_ADMIN_TO_CONFIGURE_TRUST)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.super_admin_configure_trust", NOT_SUPER_ADMIN_TO_CONFIGURE_TRUST);
        }
        if (errorCode.equals(INVALID_API_KEY)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.api_key_invalid_key", INVALID_API_KEY);
        }
        if (errorCode.equals(INVALID_PRODUCT_NAME)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.given_product_name_invalid", INVALID_PRODUCT_NAME);
        }
        if (errorCode.equals(INVALID_INPUT_FORMAT)) {
            return this.getFormattedStatusProp("SEVERE", "admp.restapi.error.given_input_format_invalid", INVALID_INPUT_FORMAT);
        }
        return null;
    }

    @Override
    public Properties getErrorProperties(String errorCode, Properties params) {
        Properties prop = this.getAPIStatus(errorCode, params);
        if (prop == null) {
            prop = super.getErrorProperties(errorCode, params);
        }
        if (prop == null || prop.isEmpty()) {
            try {
                prop = new Properties();
                prop.put("SEVERITY", "SEVERE");
                prop.put("STATUS_MESSAGE", errorCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return prop;
    }
}

