/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticator;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ApplyTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.adventnet.sym.adsm.common.webclient.api.APIErrorHandler;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ExtendedAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CreateUserAPI {
    private static Logger out = Logger.getLogger("APILogger");

    public static void isAuthorized(Long loginId, Long templateId, Hashtable userParams, HttpSession session) throws Exception {
        if (loginId == null) {
            throw new Exception("00000001");
        }
        if (!ADMPAPIUtil.isUserAccountActive(loginId)) {
            throw new Exception("00000011");
        }
        boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt");
        if (isLicenseExceeded) {
            throw new Exception("00000004");
        }
        if (!userParams.containsKey("givenName") || !userParams.containsKey("templateName")) {
            throw new Exception("00000008");
        }
        if (templateId == null) {
            throw new Exception("00000009");
        }
        if (!UserTemplateHandler.isAuthorized((Long)loginId, (Long)templateId)) {
            throw new Exception("00000010");
        }
        ADMPADAuthenticator authenticator = new ADMPADAuthenticator();
        authenticator.setSessionAttributes(session, loginId);
        Hashtable templateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
        String templateDomainName = (String)templateDetails.get("TEMPLATE_DOMAIN_NAME");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList domainNameList = authObject.getDomainNameList();
        if (!domainNameList.contains(templateDomainName)) {
            throw new Exception("00000002");
        }
        String templateContainer = (String)templateDetails.get("container");
        String givenContainerName = (String)userParams.get("OUName");
        ArrayList ouList = (ArrayList)authObject.getDomainOUsMap().get(templateDomainName);
        if (!ouList.isEmpty() && givenContainerName != null && !ouList.contains(givenContainerName)) {
            throw new Exception("00000012");
        }
        if (!ouList.isEmpty() && givenContainerName == null && !ouList.contains(templateContainer)) {
            throw new Exception("00000012");
        }
    }

    public static Properties createUser(HttpServletRequest request, Hashtable apiProps, Hashtable userProps) {
        Properties statusProps = new Properties();
        try {
            Cloneable userDetails;
            ArrayList list = new ArrayList();
            Vector<String> headerVector = new Vector<String>();
            Vector valsVector = new Vector();
            Enumeration e = userProps.keys();
            while (e.hasMoreElements()) {
                String attributeName = (String)e.nextElement();
                headerVector.add(attributeName);
                valsVector.add(userProps.get(attributeName));
            }
            list.add(valsVector);
            Long loginId = (Long)apiProps.get("loginId");
            Long templateId = (Long)apiProps.get("templateId");
            HttpSession session = request.getSession();
            String sessionID = session.getId();
            Locale locale = request.getLocale();
            String hostId = request.getRemoteHost();
            Hashtable templateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
            String container = (String)templateDetails.get("container");
            String domainName = (String)templateDetails.get("TEMPLATE_DOMAIN_NAME");
            Properties domainProps = DomainUtil.getDomainDetails((String)domainName, (String)"DOMAIN_NAME");
            String defaultNamingContext = domainProps.getProperty("DEFAULT_NAMING_CONTEXT");
            String containerName = container == null || container.equals("") ? CreateUserAPI.getDefaultContainerName(domainName, defaultNamingContext, loginId) : container;
            Long userCreationID = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, templateId, loginId);
            Hashtable exchangeDetails = CreateUserAPI.getExchangeMailServerDetails(domainName);
            Properties passwordProps = PolicyHandler.getPolicies((String)domainName, (Long)loginId);
            Set extendedLdapList = ExtendedAttributesUtil.getDistinctMembersList("ATTRIB_LDAP_NAME");
            ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
            ArrayList unKnownAttribtesList = new ArrayList();
            ArrayList authorizedCustomAttribList = new ArrayList();
            ArrayList unAuthorizedAttributeList = new ArrayList();
            for (Object e2 : headerVector) {
                Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", e2);
                if (!attributesdetails.isEmpty()) {
                    Long actionId = (Long)attributesdetails.get("ACTION_ID");
                    if (actionId != null && !ClientUtil.checkAuthorization(request, domainName, (long)actionId)) {
                        unAuthorizedAttributeList.add(e2);
                        continue;
                    }
                    if (extendedLdapList.contains(e2.toString())) {
                        if (!ExtendedAttributesUtil.isAuthorized(request, e2.toString(), "ACTION_ID", domainName)) {
                            unAuthorizedAttributeList.add(e2);
                            continue;
                        }
                        if (attributeList.contains(attributesdetails)) continue;
                        attributeList.add(attributesdetails);
                        continue;
                    }
                    if (actionId != null) {
                        if (!attributeList.contains(attributesdetails) && actionId < 16000L) {
                            attributeList.add(attributesdetails);
                            continue;
                        }
                        if (actionId <= 16000L) continue;
                        authorizedCustomAttribList.add(e2);
                        continue;
                    }
                    if (actionId != null || attributeList.contains(attributesdetails)) continue;
                    attributeList.add(attributesdetails);
                    continue;
                }
                if (!AddUserClientUtil.checkAuthorizationForCustomAttributes(request, domainName, e2)) {
                    unAuthorizedAttributeList.add(e2);
                    continue;
                }
                unKnownAttribtesList.add(e2);
            }
            if (!unAuthorizedAttributeList.isEmpty()) {
                Properties statusParams = new Properties();
                statusParams.put("UN_AUTHOR_ATTRIBS", unAuthorizedAttributeList);
                APIErrorHandler aPIErrorHandler = new APIErrorHandler();
                return aPIErrorHandler.getAPIStatus("00000003", statusParams);
            }
            ArrayList<Hashtable> userDetailsList = new ArrayList<Hashtable>();
            ArrayList arrayList = new ArrayList();
            boolean templatePresent = false;
            if (headerVector != null && !list.isEmpty()) {
                for (Vector vector : list) {
                    try {
                        userDetails = new Hashtable();
                        ArrayList<Properties> arrayList2 = new ArrayList<Properties>();
                        for (int i = 0; i < vector.size(); ++i) {
                            Object object = vector.get(i);
                            String headerObject = (String)headerVector.get(i);
                            if (unKnownAttribtesList.contains(headerObject) || authorizedCustomAttribList.contains(headerObject)) {
                                String str = object.toString();
                                StringTokenizer token = new StringTokenizer(str, ";");
                                while (token.hasMoreElements()) {
                                    String s = (String)token.nextElement();
                                    if (headerObject.equalsIgnoreCase("templateName")) {
                                        Long id = UserTemplateHandler.getTemplateId((String)s);
                                        if (id == null || !UserTemplateHandler.isAuthorized((Long)loginId, (Long)id)) continue;
                                        templatePresent = true;
                                        Properties properties = new Properties();
                                        properties.setProperty("CUSTOM_ATTRIB_NAME", headerObject);
                                        properties.setProperty("CUSTOM_ATTRIB_VALUE", id.toString());
                                        arrayList2.add(properties);
                                        continue;
                                    }
                                    Properties properties = new Properties();
                                    properties.setProperty("CUSTOM_ATTRIB_NAME", headerObject);
                                    properties.setProperty("CUSTOM_ATTRIB_VALUE", s);
                                    arrayList2.add(properties);
                                }
                                continue;
                            }
                            for (Hashtable hashtable : attributeList) {
                                String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                                Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                                if (extendedLdapList.contains(headerObject) && !ExtendedAttributesUtil.isAuthorizedValue(request, headerObject, object, "ACTION_ID", domainName)) {
                                    Properties statusParams = new Properties();
                                    statusParams.put("UN_AUTHOR_ATTRIBS", headerObject);
                                    APIErrorHandler errorHandler = new APIErrorHandler();
                                    return errorHandler.getAPIStatus("00000003", statusParams);
                                }
                                if (relationalType == 1) {
                                    String[] multiValuesArray;
                                    ArrayList<String> l = new ArrayList<String>();
                                    String str = (String)object;
                                    for (String string : multiValuesArray = str.split("(?<!\\\\);")) {
                                        l.add(string);
                                    }
                                    if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                    ((Hashtable)userDetails).put(hashtable.get("ATTRIB_COLUMN_NAME"), l);
                                    continue;
                                }
                                if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                ((Hashtable)userDetails).put(hashtable.get("ATTRIB_COLUMN_NAME"), object);
                            }
                        }
                        userDetailsList.add((Hashtable)userDetails);
                        arrayList.add(arrayList2);
                    }
                    catch (ArrayIndexOutOfBoundsException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            AddUserHandler.getInstance().addUserDetailsList(userCreationID, userDetailsList, attributeList, arrayList);
            if (templatePresent) {
                CreateUserAPI.applyTemplate(userCreationID, loginId, templateId, domainName, attributeList, userDetailsList, passwordProps, exchangeDetails);
            }
            AddUserListener addUserListener = null;
            try {
                ArrayList arrayList3 = UserMgmtUtil.getGroupList((Long)loginId, (String)defaultNamingContext);
                userDetails = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                addUserListener = new AddUserListener(userCreationID, domainName, loginId, hostId, containerName, (ArrayList<Hashtable>)userDetails, arrayList3, attributeList);
                addUserListener.addUser(locale);
            }
            catch (Exception exception) {
                out.log(Level.INFO, "Problem while Create User : " + exception);
                exception.printStackTrace();
            }
            long l = 500L;
            boolean isCompleted = addUserListener.isCompleted();
            while (!isCompleted) {
                Thread.sleep(l);
                if (l == 500L) {
                    l = 200L;
                }
                isCompleted = addUserListener.isCompleted();
            }
            Properties props = addUserListener.getCreationStatusProps();
            APIErrorHandler errorHandler = new APIErrorHandler();
            statusProps = errorHandler.getFormattedStatusProp(props.getProperty("CREATION_STATUS"), props.getProperty("CREATION_MESSAGE"), props.getProperty("ERROR_CODE"));
        }
        catch (Exception e) {
            out.log(Level.INFO, "Error occured while creating user : " + e);
            e.printStackTrace();
        }
        return statusProps;
    }

    public static Hashtable getExchangeMailServerDetails(String domainName) {
        Hashtable<String, String> exchangeDetails = new Hashtable<String, String>();
        try {
            ArrayList mailGroupsList;
            ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
            ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
            ArrayList<String> mailServerDNs = new ArrayList<String>();
            ArrayList mailBoxStoresList = new ArrayList();
            ArrayList mailServers = new ArrayList();
            ArrayList mailBoxStores = new ArrayList();
            ArrayList mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
            if (mailServersList != null && !mailServersList.isEmpty()) {
                mailServers = (ArrayList)mailServersList.get(0);
                mailServerDNs = (ArrayList<String>)mailServersList.get(1);
            }
            if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)((String)mailServerDNs.get(0)));
            } else {
                mailServers = new ArrayList();
                mailServers.add("no_mail_server");
                mailServerDNs = new ArrayList<String>();
                mailServerDNs.add("0");
            }
            if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
            }
            if (mailBoxStores == null || mailBoxStores.isEmpty()) {
                mailBoxStores = new ArrayList();
                mailBoxStores.add("no_maibox_stores");
                mailBoxStoreDNs = new ArrayList<String>();
                mailBoxStoreDNs.add("0");
            }
            if (!(mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName)).isEmpty()) {
                ArrayList<String> msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
                msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
                if (msExchAdminGroupDNList.isEmpty()) {
                    msExchAdminGroupDisplayList = new ArrayList<String>();
                    msExchAdminGroupDisplayList.add("no_admin_group");
                    msExchAdminGroupDNList = new ArrayList<String>();
                    msExchAdminGroupDNList.add("0");
                }
            }
            exchangeDetails.put("MAIL_SERVER", (String)(mailServerDNs.get(0) != null ? mailServerDNs.get(0) : "0"));
            exchangeDetails.put("MAIL_BOX_STORE", (String)(mailBoxStoreDNs.get(0) != null ? mailBoxStoreDNs.get(0) : "0"));
            exchangeDetails.put("MS_EXCH_ADMIN_GROUP", (String)(msExchAdminGroupDNList.get(0) != null ? msExchAdminGroupDNList.get(0) : "0"));
        }
        catch (Exception e) {
            out.log(Level.INFO, "Error occured while getting Exchange Details");
            e.printStackTrace();
        }
        return exchangeDetails;
    }

    public static void applyTemplate(Long userCreationID, Long loginId, Long templateId, String domainName, ArrayList<Hashtable> attributeList, ArrayList<Hashtable> userDetailsList, Properties passwordProps, Hashtable exchangeDetails) {
        try {
            String domainDNSName = DomainHandler.getDomainDNSName((String)domainName);
            ArrayList toBeRemovedAttributes = new ArrayList();
            ArrayList<Hashtable> toBeUpdatedList = new ArrayList<Hashtable>();
            userDetailsList = AddUserHandler.getInstance().getSimpleUserDetailsList(userCreationID, attributeList);
            Hashtable presentTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)0L);
            Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
            for (Hashtable hashtable : userDetailsList) {
                Long userIndex = (Long)hashtable.get("USER_INDEX");
                Hashtable customValues = (Hashtable)customAttributes.get(userIndex);
                ArrayList l = (ArrayList)customValues.remove("templateName");
                if (l == null || l.isEmpty()) continue;
                templateId = Long.parseLong((String)l.get(0));
                Hashtable toBeSetTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
                Hashtable hash = ApplyTemplateHandler.applyTemplate((Hashtable)hashtable, attributeList, (Hashtable)toBeSetTemplateDetails, (Hashtable)presentTemplateDetails, (Properties)passwordProps, (String)domainName, (String)domainDNSName, toBeRemovedAttributes, (int)userDetailsList.indexOf(hashtable), (Hashtable)exchangeDetails, (Long)loginId);
                toBeUpdatedList.add(hash);
            }
            for (String string : toBeRemovedAttributes) {
                Hashtable hashtable = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                if (hashtable != null && hashtable.isEmpty() || !attributeList.contains(hashtable)) continue;
                attributeList.remove(hashtable);
            }
            AddUserHandler.getInstance().updateUserDetailsList(userCreationID, toBeUpdatedList, attributeList);
            AddUserHandler.getInstance().removeTemplateIds(userCreationID);
        }
        catch (Exception e) {
            out.log(Level.INFO, "Error occured while applyTemplate");
            e.printStackTrace();
        }
    }

    public static String getDefaultContainerName(String domainName, String defaultNamingContext, Long loginId) {
        try {
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            return UserMgmtUtil.getDefaultContainerName((String)defaultNamingContext, (ArrayList)ouList);
        }
        catch (Exception e) {
            out.log(Level.INFO, "Error occured while getting default Container Name");
            e.printStackTrace();
            return null;
        }
    }
}

