/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardRefreshHandler;
import com.adventnet.sym.adsm.common.webclient.dashboard.DashboardUtil;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.i18n.I18N;
import com.manageengine.ads.fw.i18n.I18NUtil;
import com.manageengine.ads.fw.layout.ComponentDataProvider;
import com.manageengine.ads.fw.layout.ComponentGenerator;
import com.manageengine.ads.fw.layout.LayoutAction;
import com.manageengine.ads.fw.layout.LayoutBean;
import com.manageengine.ads.fw.taglib.LayoutTag;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

public class GetDashboard
extends LayoutAction {
    Logger out = Logger.getLogger("ADSLogger");

    public ActionForward loadContainers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            String userName = request.getParameter("userName");
            String domainName = request.getParameter("domainName");
            String domainFlatName = request.getParameter("domainFlatName");
            String isProductUser = request.getParameter("isProductUser");
            if ("true".equalsIgnoreCase(isProductUser)) {
                domainFlatName = "ADManager Plus Authentication";
            }
            if (domainFlatName == null) {
                JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
                domainFlatName = domainDetails.getString("DOMAIN_FLAT_NAME");
            }
            Long userId = AuthUtil.getUserId((String)userName, (String)domainFlatName);
            Long loginId = HelpdeskUtil.getLoginId((Long)userId);
            ADSResourceBundle rb = params.has("locale") ? I18N.getInstance().getBundle(I18NUtil.getLocale((String)params.getString("locale"))) : I18N.getInstance().getBundle(request);
            String status = "";
            Long layoutId = null;
            Long defaultTabId = null;
            Criteria statusCri = new Criteria(Column.getColumn((String)"ADMPDashboard", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPDashboard", statusCri);
            if (dO.isEmpty()) {
                status = "reset";
            } else {
                Row row = dO.getFirstRow("ADMPDashboard");
                status = row.get("STATUS") != null ? (String)row.get("STATUS") : "";
                layoutId = (Long)row.get("LAYOUT_ID");
                defaultTabId = (Long)row.get("DEFAULT_TAB_ID");
            }
            if (!status.equals("")) {
                ADMPAuthObject authObject = new ADMPAuthObject(loginId);
                if (status.equalsIgnoreCase("reset")) {
                    DashboardUtil.resetLayout(loginId, layoutId, authObject);
                } else if (status.equalsIgnoreCase("checkPermission")) {
                    DashboardUtil.checkPermission(loginId, layoutId, defaultTabId, authObject);
                } else if (status.equalsIgnoreCase("checkDomain")) {
                    DashboardUtil.checkDomain(loginId, layoutId, defaultTabId, authObject);
                } else if (status.equalsIgnoreCase("checkWorkflow")) {
                    DashboardUtil.checkWorkflow(loginId, layoutId, defaultTabId, authObject);
                }
                dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPDashboard", statusCri);
                Row row = dO.getFirstRow("ADMPDashboard");
                defaultTabId = (Long)row.get("DEFAULT_TAB_ID");
            }
            LayoutBean layout = new LayoutBean();
            JSONObject tabContainers = layout.getTabContainerDetails(defaultTabId, rb);
            JSONArray lhsContainersData = tabContainers.getJSONArray("DATA");
            for (int i = 0; i < lhsContainersData.length(); ++i) {
                try {
                    JSONArray containers = lhsContainersData.getJSONArray(i);
                    for (int j = 0; j < containers.length(); ++j) {
                        JSONObject containerData = containers.getJSONObject(j);
                        containerData.put("MENUS", (Object)new JSONArray());
                        containerData.put("IS_CUSTOMIZABLE", false);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            response.getWriter().write(tabContainers.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward loadComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forward = "unavailable";
        String status = null;
        try {
            boolean refreshInProgress;
            String domNameForADMP;
            String domName;
            JSONObject responseobj = new JSONObject();
            JSONObject params = new JSONObject(request.getParameter("params"));
            Long conId = Long.parseLong(params.getString("containerId"));
            Long layoutTagId = params.has("layoutTagId") ? params.getLong("layoutTagId") : 1L;
            LayoutTag layoutTag = LayoutTag.getLayoutTag((Long)layoutTagId);
            layoutTag.setParams(params);
            request.setAttribute("layoutTag", (Object)layoutTag);
            ADSResourceBundle rb = params.has("locale") ? I18N.getInstance().getBundle(I18NUtil.getLocale((String)params.getString("locale"))) : I18N.getInstance().getBundle(request);
            String userName = request.getParameter("userName");
            String domainName = request.getParameter("domainName");
            String domainFlatName = request.getParameter("domainFlatName");
            String isProductUser = request.getParameter("isProductUser");
            if ("true".equalsIgnoreCase(isProductUser)) {
                domainFlatName = "ADManager Plus Authentication";
            }
            if (domainFlatName == null) {
                JSONObject domainDetails = DomainHandler.getDomainDetails((String)domainName);
                domainFlatName = domainDetails.getString("DOMAIN_FLAT_NAME");
            }
            Long userId = AuthUtil.getUserId((String)userName, (String)domainFlatName);
            Long loginId = HelpdeskUtil.getLoginId((Long)userId);
            params.put("loginId", (Object)loginId);
            if (!params.has("IS_EMBER") && params.optBoolean("isEmber")) {
                params.put("IS_EMBER", true);
            }
            if ((domName = params.getString("domainName")) != null && (domNameForADMP = (String)DomainInfoCache.getInstance().getDomainDNSNameVsDomainName().get(domName)) != null) {
                domName = domNameForADMP;
            }
            if (refreshInProgress = DashboardRefreshHandler.getInstance().checkStatus(loginId, conId, domName, null)) {
                responseobj.put("NAME", (Object)"html-component");
                responseobj.put("DATA", (Object)("<p class='fwdash-no-data'>" + rb.getString("ads.home.layout.update_in_progress") + "</p>"));
                responseobj.put("IS_REPORT_RUNNING", true);
                response.getWriter().write(responseobj.toString());
                return null;
            }
            JSONObject containerComponent = new LayoutBean(request).getContainerComponent(conId);
            if (containerComponent.length() != 0) {
                String dataProvider = containerComponent.getString("DATA_PROVIDER_CLASS");
                if (dataProvider.contains("ADMPSimplifiedChartComponentDataProvider")) {
                    dataProvider = dataProvider.replace("ADMPSimplifiedChartComponentDataProvider", "ADMPChartComponentDataProvider");
                }
                Class<?> classToInvoke = Class.forName(dataProvider);
                ComponentDataProvider componentDataProvider = (ComponentDataProvider)classToInvoke.newInstance();
                JSONObject dataModel = componentDataProvider.getDataModel(request, params);
                if (componentDataProvider.isDataAvailable()) {
                    block23: {
                        if (containerComponent.has("NAME")) {
                            forward = containerComponent.getString("NAME");
                        }
                        if (containerComponent.has("GENERATOR_CLASS")) {
                            try {
                                String generator = containerComponent.getString("GENERATOR_CLASS");
                                if (generator.contains("ADMPSimplifiedChartComponentDataProvider")) {
                                    generator = dataProvider;
                                }
                                classToInvoke = Class.forName(generator);
                                ComponentGenerator componentGenerator = (ComponentGenerator)classToInvoke.newInstance();
                                JSONObject componentModel = componentGenerator.generate(dataModel, new ADSResourceBundle[]{rb});
                                if (params.has("isEmber") && params.getBoolean("isEmber")) {
                                    response.getWriter().write(componentModel.toString());
                                    return null;
                                }
                                if (componentModel.has("responseType") && componentModel.getString("responseType").equalsIgnoreCase("JSON")) {
                                    response.getWriter().write(componentModel.toString());
                                    return null;
                                }
                            }
                            catch (Exception e) {
                                forward = "unavailable";
                                this.out.log(Level.INFO, "Error in Generating the Component!");
                                status = "ads.home.layout.container.component_no_comp_avail";
                                if (!params.has("isEmber") || !params.getBoolean("isEmber")) break block23;
                                JSONObject data = new JSONObject();
                                data.put("COMPONENT_ERROR_MESSAGE", (Object)rb.getString("ads.home.layout.container.component_no_comp_avail"));
                                data.put("PRODUCT_NAME", (Object)CommonUtil.getProductName());
                                responseobj.put("NAME", (Object)"service-unavailable");
                                responseobj.put("DATA", (Object)data);
                                response.getWriter().write(responseobj.toString());
                            }
                        }
                    }
                    request.setAttribute("DATA_MODEL", (Object)dataModel);
                } else {
                    if (params.has("isEmber") && params.getBoolean("isEmber")) {
                        responseobj.put("NAME", (Object)"html-component");
                        responseobj.put("DATA", (Object)("<div style='height:400px;'><p class='fwdash-no-data'><i class='no-data-icon'></i><span>" + rb.getString("admp.search.ADSearch.no_data_available.message") + "</span></p></div>"));
                        response.getWriter().write(responseobj.toString());
                        return null;
                    }
                    status = "ads.home.layout.container.component_no_rep_avail";
                }
            } else {
                if (params.has("isEmber") && params.getBoolean("isEmber")) {
                    JSONObject data = new JSONObject();
                    data.put("COMPONENT_ERROR_MESSAGE", (Object)rb.getString("ads.home.layout.container.component_no_comp_avail"));
                    data.put("PRODUCT_NAME", (Object)CommonUtil.getProductName());
                    responseobj.put("NAME", (Object)"service-unavailable");
                    responseobj.put("DATA", (Object)data);
                    response.getWriter().write(responseobj.toString());
                }
                status = "ads.home.layout.container.component_no_comp_avail";
            }
            if (status != null) {
                request.setAttribute("STATUS", (Object)status);
            }
            if ((forward.equalsIgnoreCase("unavailable") || forward.equalsIgnoreCase("quicklinks")) && params.has("layoutType") && params.getString("layoutType").equals("flat")) {
                forward = forward + "flat";
            }
        }
        catch (Exception e) {
            this.out.log(Level.INFO, " ", e);
        }
        return mapping.findForward(forward);
    }

    public JSONObject getHighChartData(JSONObject params, String type, Long containerId, ADSResourceBundle rb) {
        JSONObject series = new JSONObject();
        JSONObject chartData = new JSONObject();
        try {
            int colWidth = 150;
            JSONObject yAxis = new JSONObject();
            JSONObject title = new JSONObject();
            JSONObject credits = new JSONObject();
            JSONObject chart = new JSONObject();
            JSONObject xAxis = new JSONObject();
            JSONObject toolTip = new JSONObject();
            title.put("text", (Object)rb.getString("admp.common.text.count"));
            title.put("align", (Object)"middle");
            yAxis.put("title", (Object)title);
            credits.put("enabled", false);
            chart.put("height", 270);
            if (containerId == 3L) {
                chart.put("type", (Object)"bar");
            } else {
                chart.put("type", (Object)"column");
            }
            xAxis.put("type", (Object)"category");
            toolTip.put("useHTML", true);
            toolTip.put("headerFormat", (Object)"<span style=\"display:inline-block;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;max-width:35em;font-size: 10px\">{point.key}</span><br>");
            series.put("yAxis", (Object)yAxis);
            series.put("title", (Object)"");
            series.put("credits", (Object)credits);
            series.put("chart", (Object)chart);
            series.put("xAxis", (Object)xAxis);
            series.put("tooltip", (Object)toolTip);
            JSONObject plotOptions = new JSONObject();
            JSONArray seriesJSONArray = new JSONArray();
            JSONArray seriesArrayData = new JSONArray();
            JSONObject seriesJSONData = new JSONObject();
            JSONObject legendItem = params.getJSONObject("LEGEND_ITEM");
            JSONObject reportCounts = legendItem.getJSONObject("REPORT_COUNTS");
            JSONObject reportNames = legendItem.getJSONObject("REPORT_DISPLAY_NAMES");
            for (int i = 1; i <= reportNames.length(); ++i) {
                JSONArray seriesData = new JSONArray();
                String count = Integer.toString(i);
                seriesData.put((Object)reportNames.getString(count));
                seriesData.put(reportCounts.getLong(count));
                seriesArrayData.put((Object)seriesData);
            }
            colWidth /= reportNames.length();
            JSONObject dataLabels = new JSONObject();
            JSONObject plotBarData = new JSONObject();
            JSONObject plotColumnData = new JSONObject();
            dataLabels.put("enabled", true);
            plotBarData.put("dataLabels", (Object)dataLabels);
            plotOptions.put("bar", (Object)plotBarData);
            plotColumnData.put("dataLabels", (Object)dataLabels);
            plotColumnData.put("pointWidth", colWidth);
            plotOptions.put("column", (Object)plotColumnData);
            seriesJSONData.put("name", (Object)rb.getString("admp.common.text.count"));
            seriesJSONData.put("data", (Object)seriesArrayData);
            seriesJSONArray.put((Object)seriesJSONData);
            series.put("plotOptions", (Object)plotOptions);
            series.put("series", (Object)seriesJSONArray);
            chartData.put("DATA", (Object)series);
            chartData.put("responseType", (Object)"JSON");
            chartData.put("NAME", (Object)"chart-component");
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
        return chartData;
    }

    public ActionForward getUnusedWidgetDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject params = new JSONObject(request.getParameter("params"));
            String locale = params.has("locale") ? params.getString("locale") : null;
            ADSResourceBundle rb = locale != null ? I18N.getInstance().getBundle(I18NUtil.getLocale((String)locale)) : I18N.getInstance().getBundle(request);
            JSONObject widgetsList = new JSONObject();
            try {
                JSONArray usedWidgets = new JSONArray(params.getString("USED_WIDGETS"));
                Long[] usedList = new Long[usedWidgets.length()];
                for (int i = 0; i < usedWidgets.length(); ++i) {
                    usedList[i] = usedWidgets.getLong(i);
                }
                LayoutBean layout = new LayoutBean();
                Long productId = CommonUtil.getProductId();
                Long loginId = HelpdeskUtil.getLoginId((Long)params.getLong("userId"));
                Long layoutId = null;
                Long defaultTabId = null;
                Criteria statusCri = new Criteria(Column.getColumn((String)"ADMPDashboard", (String)"LOGIN_ID"), (Object)loginId, 0);
                DataObject statusDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPDashboard", statusCri);
                if (statusDO.isEmpty()) {
                    throw new Exception("Dashboard is not initialized for this user.");
                }
                Row row = statusDO.getFirstRow("ADMPDashboard");
                layoutId = (Long)row.get("LAYOUT_ID");
                defaultTabId = (Long)row.get("DEFAULT_TAB_ID");
                Criteria c = new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"TAB_ID"), (Object)defaultTabId, 0);
                c = c.and(new Criteria(Column.getColumn((String)"ADSTabVsContainer", (String)"CONTAINER_ID"), (Object)usedList, 9));
                DataObject dO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSTabVsContainer", c);
                Iterator i = dO.getRows("ADSTabVsContainer", c);
                while (i.hasNext()) {
                    try {
                        Row r = (Row)i.next();
                        Long containerId = (Long)r.get("CONTAINER_ID");
                        String containerName = "";
                        Criteria cri = new Criteria(Column.getColumn((String)"ADSLayoutContainers", (String)"CONTAINER_ID"), (Object)containerId, 0);
                        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSLayoutContainers", cri);
                        Row row2 = dataObj.getFirstRow("ADSLayoutContainers");
                        JSONObject containerDetails = new JSONObject();
                        List columns = row2.getColumns();
                        for (String col : columns) {
                            if (!col.equals("CONTAINER_NAME")) {
                                containerDetails.put(col, row2.get(col));
                                continue;
                            }
                            containerName = rb.getString((String)row2.get(col));
                            containerDetails.put(col, (Object)containerName);
                        }
                        containerDetails.put("PRODUCT_ID", (Object)productId);
                        JSONObject widgetDetails = new JSONObject();
                        JSONObject componentDetails = new JSONObject();
                        componentDetails.put("COMPONENT_ID", (Object)containerId);
                        componentDetails.put("PRODUCT_ID", (Object)productId);
                        componentDetails.put("COMPONENT_DISPLAY_NAME", (Object)containerName);
                        widgetDetails.put("CONTAINERDETAILS", (Object)containerDetails);
                        widgetDetails.put("COMPONENTDETAILS", (Object)componentDetails);
                        widgetDetails.put("CONTAINEROPTIONS", (Object)layout.getContainerOptions(containerId));
                        widgetsList.put(String.valueOf(containerId), (Object)widgetDetails);
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CommonUtil.setResponseText((HttpServletResponse)response, (String)widgetsList.toString());
        }
        catch (Exception e) {
            this.out.log(Level.INFO, " ", e);
        }
        return null;
    }
}

