/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.util.LicenseUpgradeAction;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.i18n.I18N;
import com.manageengine.ads.fw.i18n.I18NUtil;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.license.LicenseXMLParser;
import com.manageengine.ads.fw.license.promotion.LicensePromotionHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import java.io.File;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class LicenseMgrAction
extends DispatchAction {
    private static Logger out = Logger.getLogger("ADSLogger");
    private static final String SUCCESS = "Success";
    private static final String DOMAINS = "Domains";
    private static final String NO_OF_DOMAINS = "NumberOfDomains";
    private static final String HELP_DESK_USERS = "HelpDeskUsers";
    private static final String NO_OF_USERS = "NumberOfUsers";

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String licenseContent = request.getParameter("license");
            String parentAppLicense = request.getParameter("parentAppLicense");
            JSONObject licneseDetails = new JSONObject();
            LicenseManager licenseManager = new LicenseManager("ManageEngine ADManager Plus", licenseContent);
            String licenseFileLocation = licenseManager.getLicenseFileLocation();
            String licenseFileName = licenseFileLocation.substring(licenseFileLocation.lastIndexOf("\\") + 1);
            try {
                licneseDetails = LicenseManager.getLicenseDetails();
            }
            catch (Exception e) {
                out.log(Level.INFO, "Exception while fetching license details:", e);
            }
            String upgradeStatus = LicenseUpgradeAction.upgradeLicense(request, licenseFileName);
            String licenseStatus = rb.getString("admp.layout.license.upgrade.statmsg_license_upgraded_successfully");
            if (parentAppLicense != null) {
                try {
                    JSONObject parentLic = new JSONObject(parentAppLicense);
                    if (parentLic.has("PARENT_LICENSE")) {
                        LicenseManager.storeParentAppLicense((String)parentLic.getString("PARENT_LICENSE"));
                    } else {
                        LicenseManager.storeParentAppLicense((String)parentLic.getString(CommonUtil.getParentAppName()));
                    }
                }
                catch (Exception e) {
                    out.log(Level.INFO, "Invalid Parent App License");
                }
            }
            if (upgradeStatus.equals(licenseStatus)) {
                upgradeStatus = SUCCESS;
                LicensePromotionHandler.updatePromotionComponents((Boolean)false, (JSONObject)licneseDetails);
            }
            LicenseMgr.getInstance();
            LicenseMgr.resetValues();
            request.setAttribute("RESPONSE", (Object)upgradeStatus);
        }
        catch (Exception e) {
            request.setAttribute("RESPONSE", (Object)e.getMessage());
        }
        return mapping.findForward("result");
    }

    public ActionForward getLicenseDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String localeString = request.getParameter("locale");
        Locale locale = localeString != null ? I18NUtil.getLocale((String)localeString) : I18NUtil.getLocale((HttpServletRequest)request);
        ADSResourceBundle rb = I18N.getInstance().getBundle("adsm/ApplicationResources", locale);
        try {
            JSONObject displayText = new JSONObject().put(NO_OF_DOMAINS, (Object)"admp.upgradeLicense.license_upgrade.ads_number_of_domains");
            displayText.put(NO_OF_USERS, (Object)"admp.upgradeLicense.license_upgrade.ads_number_of_help_desk_technicians");
            LicenseManager licenseManager = new LicenseManager();
            JSONObject licenseDetails = licenseManager.getLicenseDetails();
            JSONObject componentDetails = licenseManager.getComponentDetails();
            JSONObject compDetails = new JSONObject();
            compDetails.put(rb.getString(displayText.getString(NO_OF_DOMAINS)), new JSONObject(componentDetails.getString(DOMAINS)).get(NO_OF_DOMAINS));
            compDetails.put(rb.getString(displayText.getString(NO_OF_USERS)), new JSONObject(componentDetails.getString(HELP_DESK_USERS)).get(NO_OF_USERS));
            licenseDetails.put("COMPONENT_DETAILS", (Object)compDetails);
            request.setAttribute("RESPONSE", (Object)licenseDetails.toString());
        }
        catch (Exception e) {
            request.setAttribute("RESPONSE", (Object)e.getMessage());
        }
        return mapping.findForward("result");
    }

    public static void handleParentAppLicense(String licenseFile, JSONObject licneseDetails) {
        try {
            boolean isParentAppLicense = false;
            LicenseXMLParser xmlParser = new LicenseXMLParser(licenseFile);
            String parentAppLicense = xmlParser.getParentAppLicense();
            if (parentAppLicense != null && !"".equals(parentAppLicense)) {
                isParentAppLicense = true;
                LicenseManager.storeParentAppLicense((String)parentAppLicense);
            } else {
                try {
                    String parentApp = CommonUtil.getParentAppName() != null ? CommonUtil.getParentAppName() : CommonUtil.getProductParamValue((String)"DEFAULT_LIC_PARENT_APP");
                    parentAppLicense = xmlParser.getProductLicense(parentApp);
                    isParentAppLicense = true;
                    LicenseManager.storeParentAppLicense((File)new File(licenseFile));
                }
                catch (Exception e) {
                    LicenseManager.purgeParentAppLicenseFile();
                    LicensePromotionHandler.updatePromotionComponents((Boolean)true, (JSONObject)licneseDetails);
                }
            }
            if (isParentAppLicense) {
                JSONObject status = LicenseManager.applyParentAppLicense();
                LicensePromotionHandler.updatePromotionComponents((Boolean)true, (JSONObject)licneseDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward applyComponentLicense(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String upgradeStatusMsg = null;
            String licenseContent = request.getParameter("license");
            String parentAppLicense = request.getParameter("PARENT_LICENSE");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            if (parentAppLicense != null) {
                try {
                    JSONObject licenseDetails = LicenseManager.getLicenseDetails();
                    LicenseManager licenseManager = new LicenseManager("ManageEngine ADManager Plus", parentAppLicense);
                    String status = LicenseUpgradeAction.upgradeAD360License(request, licenseManager.getLicenseFileLocation());
                    String successStatus = rb.getString("admp.layout.license.upgrade.statmsg_license_upgraded_successfully");
                    if (status.equals(successStatus)) {
                        upgradeStatusMsg = SUCCESS;
                        LicenseManager.storeParentAppLicense((String)parentAppLicense);
                        LicensePromotionHandler.updatePromotionComponents((Boolean)false, (JSONObject)licenseDetails);
                        LicenseManager.resetSentExpiryMail();
                    }
                }
                catch (Exception e) {
                    out.log(Level.INFO, "Error while applying parent app license: ", e);
                    CommonUtil.setResponseText((HttpServletResponse)response, (String)e.getMessage());
                }
            }
            LicenseMgr.getInstance();
            LicenseMgr.resetValues();
            request.setAttribute("RESPONSE", upgradeStatusMsg);
        }
        catch (Exception e) {
            request.setAttribute("RESPONSE", (Object)e.getMessage());
            e.printStackTrace();
        }
        return mapping.findForward("result");
    }
}

