/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.api.workflow;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIErrorHandler;
import com.adventnet.sym.adsm.common.webclient.api.ADMPAPIUtil;
import com.adventnet.sym.adsm.common.webclient.api.workflow.WorkflowAPIUtil;
import com.adventnet.sym.adsm.common.webclient.api.workflow.WorkflowUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import com.manageengine.ads.fw.i18n.I18NUtil;
import com.manageengine.ads.fw.util.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class WorkflowAPI
extends DispatchAction {
    Logger out = Logger.getLogger("ADSLogger");

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardResponse = new ADMPAPIErrorHandler().getErrorString("00000006");
        request.setAttribute("RESPONSE", (Object)forwardResponse);
        return mapping.findForward("result");
    }

    public ActionForward createRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardResponse = null;
        try {
            WorkflowUtil.isParametersPresent(request);
            JSONObject params = WorkflowAPIUtil.getActionParams(request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(I18NUtil.getLocale((String)request.getParameter("locale")));
            WorkFlowClientUtil.createRequest(request, params, rb);
            Long requestId = (Long)request.getAttribute("requestId");
            String message = (String)request.getAttribute("message");
            JSONObject result = new JSONObject();
            result.put("REQUEST_ID", (Object)requestId);
            result.put("STATUS", (Object)message);
            if (requestId == null) {
                result.put("ERROR_CODE", (Object)"00001005");
            }
            forwardResponse = result.toString();
        }
        catch (Exception e) {
            this.out.log(Level.FINE, "", e);
            forwardResponse = new ADMPAPIErrorHandler().getErrorString(e.getMessage());
        }
        request.setAttribute("RESPONSE", (Object)forwardResponse);
        return mapping.findForward("result");
    }

    public ActionForward getAllRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardResponse = null;
        this.out.log(Level.FINE, "Inside Get All Requests");
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(I18NUtil.getLocale((String)request.getParameter("locale")));
            forwardResponse = WorkflowAPIUtil.getAllRequests(request, rb).toString();
        }
        catch (Exception e) {
            this.out.log(Level.FINE, "", e);
            forwardResponse = new ADMPAPIErrorHandler().getErrorString(e.getMessage());
        }
        request.setAttribute("RESPONSE", (Object)forwardResponse);
        return mapping.findForward("result");
    }

    public ActionForward getRequestDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardResponse = null;
        try {
            String reqIdStr = request.getParameter("REQUEST_ID");
            if (reqIdStr == null) {
                throw new Exception("00000007");
            }
            Long loginId = ADMPAPIUtil.getLoginId(request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getResourceBundle(I18NUtil.getLocale((String)request.getParameter("locale")));
            forwardResponse = WorkflowAPIUtil.getRequestDetails(loginId, reqIdStr, rb).toString();
        }
        catch (Exception e) {
            this.out.log(Level.INFO, "", e);
            forwardResponse = new ADMPAPIErrorHandler().getErrorString(e.getMessage());
        }
        request.setAttribute("RESPONSE", (Object)forwardResponse);
        return mapping.findForward("result");
    }

    public ActionForward getRequestFilter(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String forwardResponse = null;
        try {
            Long loginId = ADMPAPIUtil.getLoginId(request);
            ArrayList filters = WorkFlowUserHandler.getRequestFilters((Long)loginId);
            forwardResponse = JSONUtil.getJSONArray((ArrayList)filters).toString();
        }
        catch (Exception e) {
            this.out.log(Level.FINE, "", e);
            forwardResponse = new ADMPAPIErrorHandler().getErrorString(e.getMessage());
        }
        request.setAttribute("RESPONSE", (Object)forwardResponse);
        return mapping.findForward("result");
    }

    public ActionForward getConfiguredDomains(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONArray result = new JSONArray((Collection)DomainUtil.getConfiguredDomainNamesList());
            request.setAttribute("RESPONSE", (Object)result.toString());
        }
        catch (Exception e) {
            this.out.log(Level.FINE, "", e);
        }
        return mapping.findForward("result");
    }
}

