/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.audit;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.audit.AuditTask;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.audit.HDDAuditReportListener;
import com.adventnet.sym.adsm.common.webclient.reports.ListenerUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class HDDAuditReportAction
extends DispatchAction {
    static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String tile = "DelegationAuditResult";
        if (!ClientAuthorizationUtil.isAuthorized(request, DelegationUtil.DELEGATION_AUDIT_ACTION_ID).booleanValue()) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        try {
            String isNavigate;
            int count = 0;
            Hashtable result = new Hashtable();
            ArrayList resultList = new ArrayList();
            String action = request.getParameter("action");
            String search = request.getParameter("search");
            String init = request.getParameter("init");
            if (init != null && init.equalsIgnoreCase("true")) {
                bean.set("FROM_INDEX", (Object)"");
                tile = "DelegationAudit";
            }
            int startIndex = 1;
            int range = 25;
            if (action == null || action.equalsIgnoreCase("")) {
                action = "showAll";
                this.init(bean);
                bean.initialize(mapping);
            }
            if (search == null || search.equalsIgnoreCase("")) {
                search = "false";
            }
            Criteria crit = null;
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(new Integer(7004), loginId);
            if (search.equalsIgnoreCase("true")) {
                crit = HDDAuditReportAction.getSearchCriteria(request, bean, attributelist);
                if (request.getParameter("FROM_INDEX") != null && request.getParameter("RANGE") != null) {
                    bean.set("FROM_INDEX", (Object)request.getParameter("FROM_INDEX"));
                }
            } else {
                bean.set("searchString", (Object)"");
            }
            if (request.getParameter("params") != null) {
                String json = request.getParameter("params");
                JSONObject jsonObj = new JSONObject(json);
                if (jsonObj.has("startIndex")) {
                    startIndex = (Integer)jsonObj.get("startIndex");
                }
                if (jsonObj.has("range")) {
                    range = (Integer)jsonObj.get("range");
                }
            }
            String ascending = (String)bean.get("isAscending");
            String sortColumn = (String)bean.get("sortColumn");
            if (sortColumn == null || sortColumn.equals("")) {
                sortColumn = "AUDIT_TIME";
            }
            if ((isNavigate = request.getParameter("isNavigate")) != null && isNavigate.equals("false")) {
                NavigateRangeUtil.setDefaultRange((String)"DelegationAudit", (int)range, (Long)loginId);
            } else if (isNavigate == null) {
                range = NavigateRangeUtil.getDefaultRange((String)"DelegationAudit", (Long)loginId);
                bean.set("RANGE", (Object)String.valueOf(range));
            }
            if (ascending == null) {
                ascending = "false";
            }
            if (action != null && action.equalsIgnoreCase("showAll")) {
                count = HDDAuditReportAction.getCount(crit);
            }
            if (count != 0 && count > 0) {
                result = HDDAuditReportAction.getRows(attributelist, startIndex, range, new Boolean(ascending), sortColumn, crit);
                resultList = (ArrayList)result.get("resultList");
            }
            request.setAttribute("resultList", resultList);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("reportId", (Object)7004L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    private static Criteria getSearchCriteria(HttpServletRequest request, DynaActionForm bean, ArrayList attributeList) {
        Criteria crit = null;
        try {
            if (request.getParameter("search") != null && Boolean.valueOf(request.getParameter("search")).booleanValue()) {
                String searchString = (String)bean.get("searchString");
                for (int i = 0; i < attributeList.size(); ++i) {
                    Properties attributeProps = (Properties)attributeList.get(i);
                    String columnName = (String)attributeProps.get("ATTRIB_COLUMN_NAME");
                    String val = null;
                    val = request.getParameter(columnName) != null ? request.getParameter(columnName) : ReportResultUtil.getSearchString(searchString, columnName);
                    if (val == null || val.equalsIgnoreCase("")) continue;
                    if (!searchString.equalsIgnoreCase("")) {
                        searchString = ReportResultUtil.setSearchString(searchString, columnName, val);
                    }
                    val = "*" + val + "*";
                    String tableName = "ADSMHDDAuditDetails";
                    crit = crit == null ? new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)val, 2) : crit.and(new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)val, 2));
                }
                bean.set("searchString", (Object)searchString);
                bean.set("FROM_INDEX", (Object)"1");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public static Hashtable getRows(ArrayList attributeList, int startIndex, int range, boolean ascending, String sortColumn, Criteria criteria) {
        return HDDAuditReportAction.getRows(attributeList, startIndex, range, ascending, sortColumn, criteria, null, false);
    }

    public static Hashtable getRows(ArrayList attributeList, int startIndex, int range, boolean ascending, String sortColumn, Criteria criteria, Long loginId, boolean isExport) {
        Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
        ArrayList resultList = new ArrayList();
        Boolean hasSubReport = false;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMHDDAuditDetails"));
            sq.setCriteria(criteria);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String table = attributeProperties.getProperty("TABLE_NAME");
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Column column = Column.getColumn((String)table, (String)columnName);
                if (sortColumn != null && sortColumn.equals(columnName)) {
                    sq.addSortColumn(new SortColumn(new Column(table, sortColumn), ascending));
                }
                selectColumnList.add(column);
            }
            sq.addSelectColumns(selectColumnList);
            sq.addSelectColumn(Column.getColumn((String)"ADSMHDDAuditDetails", (String)"AUDIT_ID"));
            if (startIndex != -1) {
                sq.setRange(new Range(startIndex, range));
            }
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            Object columnList = null;
            Hashtable categoryIdVsName = new Hashtable();
            if (!dataObj.isEmpty()) {
                Iterator ite = dataObj.getRows("ADSMHDDAuditDetails");
                while (ite.hasNext()) {
                    Hashtable<Object, Object> resultHash = new Hashtable<Object, Object>();
                    Row row = (Row)ite.next();
                    if (isExport) {
                        HDDAuditReportAction.fillResultHashForExport(row, resultHash, attributeList, categoryIdVsName, loginId);
                        resultHash.put(-1, row.get("AUDIT_ID").toString());
                        if (HDDAuditReportAction.isPropsAvailable((String)resultHash.get(19002), (String)resultHash.get(19005))) {
                            resultHash.put(-2, rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.details"));
                            hasSubReport = true;
                        } else {
                            resultHash.put(-2, "");
                        }
                    } else {
                        HDDAuditReportAction.fillResultHash(row, resultHash, attributeList, categoryIdVsName);
                    }
                    resultHash.put("AUDIT_ID", row.get("AUDIT_ID"));
                    resultHash.put("isPropsAvailable", HDDAuditReportAction.isPropertiesAvailable((String)resultHash.get(19002), (String)resultHash.get(19005)));
                    resultList.add(resultHash);
                }
            }
            result.put("resultList", resultList);
            result.put("hasSubReport", hasSubReport);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AuditTask listener = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        DynaActionForm bean = (DynaActionForm)form;
        rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            DataObject obj = ReportHandler.getReportDetails((Integer)new Integer(7004));
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            listener = (AuditTask)classToInvoke.newInstance();
            String format = request.getParameter("format");
            String search = request.getParameter("search");
            String searchString = (String)bean.get("searchString");
            if (search == null || search.equalsIgnoreCase("")) {
                search = "false";
            }
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(new Integer(7004), loginId);
            Criteria crit = null;
            if (search.equalsIgnoreCase("true")) {
                bean.set("searchString", (Object)searchString);
                crit = HDDAuditReportAction.getSearchCriteria(request, bean, attributelist);
            } else {
                bean.set("searchString", (Object)"");
            }
            String ascending = (String)bean.get("isAscending");
            String sortColumn = (String)bean.get("sortColumn");
            if (sortColumn == null || sortColumn.equals("")) {
                sortColumn = "AUDIT_TIME";
            }
            ArrayList techList = new ArrayList();
            listener.exportReport(null, null, "FILES", format, techList, loginId, -1L, -1L, response, request, ascending, sortColumn, crit, rb);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.action_name.audit_reports", (String)((String)r.get("REPORT_NAME")), (Integer)7004, (String)"-", (Boolean)Boolean.FALSE, (String)HDDAuditReportListener.getExportFileName(), (String)format.substring(0, format.indexOf("_")), (String)"-", (Integer)HDDAuditReportListener.getExportRowCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void fillResultHash(Row row, Hashtable resultHash, ArrayList attributeList, Hashtable categoryIdVsName) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                Object obj = null;
                if (row.get(columnName) == null) continue;
                obj = row.get(columnName);
                if (attributeId == 19002) {
                    resultHash.put("CATEGORY_ID", (Long)obj);
                    if (categoryIdVsName.get((Long)obj) == null) {
                        categoryIdVsName.put((Long)obj, HDDAuditReportAction.getCategoryName((Long)obj));
                    }
                    obj = categoryIdVsName.get((Long)obj);
                }
                resultHash.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void fillResultHashForExport(Row row, Hashtable resultHash, ArrayList attributeList, Hashtable categoryIdVsName, Long loginId) {
        for (int i = 0; attributeList != null && i < attributeList.size(); ++i) {
            try {
                Properties attributeProperties = (Properties)attributeList.get(i);
                String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                Object obj = null;
                if (row.get(columnName) == null) continue;
                obj = row.get(columnName);
                if (attributeId == 19002) {
                    resultHash.put("CATEGORY_ID", (Long)obj);
                    if (categoryIdVsName.get((Long)obj) == null) {
                        categoryIdVsName.put((Long)obj, HDDAuditReportAction.getCategoryName((Long)obj));
                    }
                    obj = categoryIdVsName.get((Long)obj);
                }
                if (attributeId == 19002 || attributeId == 19005) {
                    obj = rb.getString(obj.toString());
                } else if (attributeId == 19004) {
                    obj = DateTimeUtil.getDateFormat((Long)loginId).format(Long.parseLong(obj.toString()));
                }
                resultHash.put(attributeId, ListenerUtil.getUICustomizedValues(attributeId, obj));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getCategoryName(Long categoryId) {
        String categoryName = "";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMHDDCategory", (String)"CATEGORY_ID"), (Object)categoryId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMHDDCategory", crit);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow("ADSMHDDCategory");
                categoryName = (String)row.get("CATEGORY_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return categoryName;
    }

    public static String getSubCategoryName(Long subCategoryId) {
        String subCategoryName = "";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMHDDSubCategory", (String)"SUB_CATEGORY_ID"), (Object)subCategoryId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMHDDSubCategory", crit);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow("ADSMHDDSubCategory");
                subCategoryName = (String)row.get("SUB_CATEGORY_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return subCategoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(Criteria criteria) {
        int count = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMHDDAuditDetails"));
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            sq.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return count;
    }

    public static boolean isPropertiesAvailable(String categoryName, String actionName) {
        if (categoryName.equalsIgnoreCase("admp.deleg.hdt_deleg.hdd_reports.helpdesk_roles")) {
            return false;
        }
        return !actionName.equalsIgnoreCase("admp.deleg.hdt_deleg.hdd_reports.deleted") && !actionName.equalsIgnoreCase("admp.deleg.hdt_deleg.hdd_reports.enabled") && !actionName.equalsIgnoreCase("admp.deleg.hdt_deleg.hdd_reports.disabled");
    }

    public static boolean isPropsAvailable(String categoryName, String actionName) {
        if (categoryName.equalsIgnoreCase(rb.getString("admp.deleg.hdt_deleg.hdd_reports.helpdesk_roles"))) {
            return false;
        }
        return !actionName.equalsIgnoreCase(rb.getString("admp.deleg.hdt_deleg.hdd_reports.deleted")) && !actionName.equalsIgnoreCase(rb.getString("admp.deleg.hdt_deleg.hdd_reports.enabled")) && !actionName.equalsIgnoreCase(rb.getString("admp.deleg.hdt_deleg.hdd_reports.disabled"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONArray getProperties(Long auditId, Long categoryId) {
        JSONArray propsArray = new JSONArray();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMHDDAuditObjs", (String)"AUDIT_ID"), (Object)auditId, 0);
            String tableName = HDTAuditUtil.getTableForCategory((Long)categoryId);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMHDDAuditObjs"));
            sq.addJoin(new Join(new Table("ADSMHDDAuditObjs"), new Table(tableName), new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2));
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            sq.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                JSONObject props = new JSONObject();
                ArrayList configuredIamAppIds = O365MgmtHandler.getConfiguredIamAppIds();
                boolean fillAccountTypeDetails = configuredIamAppIds.size() != 1 || configuredIamAppIds.get(0) != Integer.valueOf(1);
                HDDAuditReportAction.fillDetails(dataSet, tableName, props, fillAccountTypeDetails);
                props.put("admp.deleg.hdt_deleg.hdd_reports.action_settings", (Object)HDDAuditReportAction.getSubCategoryName((Long)dataSet.getValue("SUB_CATEGORY_ID")));
                propsArray.put((Object)props);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return propsArray;
    }

    private static String getDisplayName(String columnName) {
        Hashtable<String, String> columnNameVsDisplayName = new Hashtable<String, String>();
        columnNameVsDisplayName.put("DOMAIN_NAME", "admp.deleg.hdt_deleg.hdd_reports.domain_name");
        columnNameVsDisplayName.put("VALUE", "admp.deleg.hdt_deleg.hdd_reports.values");
        return (String)columnNameVsDisplayName.get(columnName);
    }

    private static JSONObject fillDetails(DataSet dataSet, String tableName, JSONObject jsonObj, boolean fillAccountTypeDetails) {
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            List columnNames = tableDef.getColumnNames();
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                Object obj = dataSet.getValue(columnName);
                if (columnName.equalsIgnoreCase("IAM_APP_ID")) {
                    if (!fillAccountTypeDetails) continue;
                    String dispName = "admp.mgmt.fc_layout.common.account_type";
                    int iamAppId = (Integer)obj;
                    if (iamAppId == 1) {
                        jsonObj.put(dispName, (Object)"admp.mgmt.fc_layout.common.active_directory");
                        continue;
                    }
                    if (iamAppId == 3) {
                        jsonObj.put(dispName, (Object)"admp.mgmt.fc_layout.common.text_o365");
                        continue;
                    }
                    if (iamAppId != 2) continue;
                    jsonObj.put(dispName, (Object)"admp.mgmt.fc_layout.common.gsuite");
                    continue;
                }
                if (columnName.equalsIgnoreCase("OBJECT_ID") || columnName.equalsIgnoreCase("PROP_ID")) continue;
                jsonObj.put(HDDAuditReportAction.getDisplayName(columnName), (Object)obj.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getPropertiesList(Long auditId, Long categoryId) {
        ArrayList detailList = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMHDDAuditObjs", (String)"AUDIT_ID"), (Object)auditId, 0);
            String tableName = HDTAuditUtil.getTableForCategory((Long)categoryId);
            SelectQueryImpl sq = new SelectQueryImpl(new Table("ADSMHDDAuditObjs"));
            sq.addJoin(new Join(new Table("ADSMHDDAuditObjs"), new Table(tableName), new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2));
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            sq.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Hashtable<String, String> detailsRow = new Hashtable<String, String>();
                HDDAuditReportAction.fillDetails(dataSet, tableName, detailsRow);
                detailsRow.put("Settings", rb.getString(HDDAuditReportAction.getSubCategoryName((Long)dataSet.getValue("SUB_CATEGORY_ID"))));
                detailList.add(detailsRow);
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
        return detailList;
    }

    private static Hashtable fillDetails(DataSet dataSet, String tableName, Hashtable detailsRow) {
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            List columnNames = tableDef.getColumnNames();
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                Object obj = dataSet.getValue(columnName);
                if (columnName.equalsIgnoreCase("IAM_APP_ID")) {
                    int iamAppId = (Integer)obj;
                    if (iamAppId == 1) {
                        detailsRow.put("AccountType", rb.getString("admp.mgmt.fc_layout.common.active_directory"));
                    } else if (iamAppId == 3) {
                        detailsRow.put("AccountType", rb.getString("admp.mgmt.fc_layout.common.text_o365"));
                    } else if (iamAppId == 2) {
                        detailsRow.put("AccountType", rb.getString("admp.mgmt.fc_layout.common.gsuite"));
                    }
                }
                if (columnName.equalsIgnoreCase("OBJECT_ID") || columnName.equalsIgnoreCase("PROP_ID")) continue;
                if (columnName.equals("DOMAIN_NAME")) {
                    detailsRow.put("Domain Name", obj.toString());
                    continue;
                }
                if (!columnName.equals("VALUE")) continue;
                detailsRow.put("Values", rb.getString(obj.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return detailsRow;
    }

    private void init(DynaActionForm bean) {
        bean.set("sortColumn", (Object)"");
        bean.set("isAscending", (Object)"");
    }
}

