/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.audit;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.audit.AuditTask;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.webclient.audit.HDTAuditReportAction;
import com.adventnet.sym.adsm.common.webclient.audit.HDTAuditSchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.audit.ReportJRRewindableDataSource;
import com.adventnet.sym.adsm.common.webclient.delegation.HDTReportListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ZipUtility;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportExporter;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class HDTAuditReportListener
implements AuditTask {
    static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static Integer reportId = 0;
    private static ArrayList techList = null;
    public static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String productHome = null;
    private static String basepath = null;
    private static int exportCount = 0;
    private static String exportFileName = "";

    public HDTAuditReportListener() {
        reportId = new Integer(7003);
        techList = new ArrayList();
    }

    public HDTAuditReportListener(Integer reportId) {
        HDTAuditReportListener.reportId = reportId;
        techList = new ArrayList();
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, ArrayList selectedColumnList) {
        return this.exportReport(schedulerName, filePath, attachmentType, format, techList, loginId, startTime, endTime, null, null, null, null, null, rb, null, null, null, false, null, selectedColumnList);
    }

    public void exportReport(String filePath, String attachmentType, String format, Long loginId, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList) {
        long startTime = 0L;
        this.exportReport(null, filePath, attachmentType, format, null, loginId, startTime, startTime, null, null, null, null, null, rb, objectIds, resultList, viewColumnList, false, null);
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, AdventNetResourceBundle rb) {
        return this.exportReport(schedulerName, filePath, attachmentType, format, techList, loginId, startTime, endTime, response, request, ascending, sortColumn, criteria, rb, null, null, null, false, null);
    }

    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, AdventNetResourceBundle rb, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime) {
        return this.exportReport(schedulerName, filePath, attachmentType, format, techList, loginId, startTime, endTime, response, request, ascending, sortColumn, criteria, rb, objectIds, resultList, viewColumnList, fetchArchiveData, archiveTime, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportReport(String schedulerName, String filePath, String attachmentType, String format, ArrayList techList, Long loginId, long startTime, long endTime, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, AdventNetResourceBundle rb, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime, ArrayList selectedColumnList) {
        String reportType = "standard";
        boolean isEmptyReport = true;
        HDTAuditReportListener.rb = rb;
        if (format.contains("_")) {
            String[] parts = format.split("_");
            format = parts[0];
        }
        reportType = format != null && (format.toLowerCase().indexOf("xls") != -1 || format.toLowerCase().indexOf("csv") != -1) ? "standard" : "summary";
        try {
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId, loginId);
            ArrayList attribListTemp = (ArrayList)attributelist.clone();
            for (int i = 0; i < attribListTemp.size(); ++i) {
                Properties attribProp = (Properties)attribListTemp.get(i);
                Integer attribId = (Integer)attribProp.get("ATTRIB_ID");
                if (selectedColumnList.size() <= 0 || selectedColumnList.contains(attribId)) continue;
                attributelist.remove(attribProp);
            }
            if (format == null) {
                format = "pdf";
            }
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String reportFileName = (String)r.get("REPORT_FILE_NAME");
            String reportName = (String)r.get("REPORT_NAME");
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("desc", rb.getString((String)r.get("DESCRIPTION")));
            inputs.put("date", DateTimeUtil.getDateFormat((Long)loginId).format(System.currentTimeMillis()));
            if (reportType.equals("standard")) {
                reportFileName = "AuditReport.xml";
            }
            if ((productHome = System.getProperty("product.home")) == null) {
                productHome = System.getProperty("server.home");
            }
            basepath = productHome + File.separator + "webapps" + File.separator + "adsm" + File.separator;
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            Long[] technicians = null;
            if (techList != null) {
                technicians = new Long[techList.size()];
                for (int i = 0; i < techList.size(); ++i) {
                    technicians[i] = (Long)techList.get(i);
                }
            }
            isEmptyReport = HDTAuditReportListener.exportAuditReport(reportFileName, format, attributelist, reportName, technicians, startTime, endTime, inputs, filePath, loginId, reportType, response, request, ascending, sortColumn, criteria, objectIds, resultList, viewColumnList, fetchArchiveData, archiveTime);
            if (filePath != null) {
                if (PrivacyHandler.getInstance().isProtectExportFilesEnabled().booleanValue()) {
                    String exportPassword = PasswordUtil.getExportFilePassword((Long)loginId);
                    ZipUtility.makeZip(filePath, exportPassword);
                } else if (attachmentType.equalsIgnoreCase("zip") || attachmentType.equalsIgnoreCase("link")) {
                    ZipUtility.makeZip(filePath, null);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (PrivacyHandler.getInstance().isProtectExportFilesEnabled().booleanValue() && filePath != null) {
                    ReportHandler.deleteExportedFiles((String)filePath);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isEmptyReport;
    }

    private static boolean exportAuditReport(String reportFileName, String format, ArrayList attributelist, String reportName, Long[] technicians, long fromTime, long toTime, HashMap inputs, String filePath, Long loginId, String reportType, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime) {
        if (reportType.equals("standard")) {
            return HDTAuditReportListener.exportStandardViewAuditReport(reportFileName, format, attributelist, reportName, technicians, fromTime, toTime, inputs, filePath, loginId, response, request, ascending, sortColumn, criteria, objectIds, resultList, viewColumnList, fetchArchiveData, archiveTime);
        }
        return HDTAuditReportListener.exportSummaryViewAuditReport(reportFileName, format, attributelist, reportName, technicians, fromTime, toTime, inputs, filePath, loginId, response, request, ascending, sortColumn, criteria, objectIds, resultList, viewColumnList, fetchArchiveData, archiveTime);
    }

    private static boolean exportSummaryViewAuditReport(String reportFileName, String format, ArrayList attributelist, String reportName, Long[] technicians, long fromTime, long toTime, HashMap inputs, String filePath, Long loginId, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime) {
        String reportType = "summary";
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        Locale locale = I18NUtil.getDefaultLocale((Long)loginId);
        int AddToPgNumber = 0;
        if (request != null) {
            locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        }
        if (format.toLowerCase().indexOf("xls") != -1 || format.toLowerCase().indexOf("csv") != -1) {
            return HDTAuditReportListener.exportStandardViewAuditReport(reportFileName, format, attributelist, reportName, technicians, fromTime, toTime, inputs, filePath, loginId, response, request, ascending, sortColumn, criteria, objectIds, resultList, viewColumnList, fetchArchiveData, archiveTime);
        }
        try {
            JRDesignBand columnHeaderBand;
            Hashtable columnWidths;
            Hashtable list;
            reportName = rb.getString(reportName);
            int count = 0;
            if (technicians != null) {
                count = HDTAuditReportAction.getCount(technicians, fromTime, toTime, criteria, fetchArchiveData, archiveTime);
            }
            HDTAuditReportListener.setExportRowCount(count);
            ArrayList summaryResult = new ArrayList();
            ArrayList<Long> objectIdList = new ArrayList<Long>();
            ArrayList<Object> summaryViewPrintList = new ArrayList<Object>();
            ArrayList<JasperPrint> detailsPrintList = new ArrayList<JasperPrint>();
            ArrayList allAttribList = ReportAttributeHandler.getInstance().getViewColumn(reportId);
            if (count != 0) {
                if (ascending == null) {
                    ascending = "false";
                }
                list = HDTAuditSchedulerUtil.getRowsForAuditReport(technicians, fromTime, toTime, allAttribList, -1, -1, Boolean.valueOf(ascending), sortColumn, criteria, loginId, objectIdList, rb, fetchArchiveData, archiveTime);
                summaryResult = (ArrayList)list.get("resultList");
            } else if (objectIds != null) {
                if (ascending == null) {
                    ascending = "false";
                }
                list = HDTAuditSchedulerUtil.getRowsForNotification(objectIds, allAttribList, Boolean.valueOf(ascending), loginId, objectIdList, rb);
                summaryResult = (ArrayList)list.get("resultList");
            } else {
                return false;
            }
            Hashtable detailsHashTable = HDTAuditSchedulerUtil.getProperties(objectIdList, loginId, rb, resultList, viewColumnList, fetchArchiveData, archiveTime);
            boolean isDetailsAvailable = true;
            ArrayList<Hashtable> summaryResultForDataSource = new ArrayList<Hashtable>();
            for (int i = 0; i < summaryResult.size(); ++i) {
                ArrayList wfHistory;
                Hashtable summaryRow = (Hashtable)summaryResult.get(i);
                summaryRow = (Hashtable)summaryRow.clone();
                Long objid = Long.parseLong((String)summaryRow.get(new Integer(11150)));
                ArrayList detailsList = (ArrayList)detailsHashTable.get(objid);
                Hashtable wfDetails = (Hashtable)detailsHashTable.get("wfDetails");
                Hashtable reqIdVsObjIdMapping = (Hashtable)detailsHashTable.get("reqIdVsObjIdMapping");
                boolean containsWFDetails = false;
                Long wfId = null;
                if (reqIdVsObjIdMapping != null) {
                    wfId = (Long)reqIdVsObjIdMapping.get(objid);
                }
                if (wfId != null && wfDetails != null && wfDetails.containsKey(wfId) && (wfHistory = (ArrayList)wfDetails.get(wfId)).size() > 0) {
                    containsWFDetails = true;
                }
                if (detailsList.size() == 0 && !containsWFDetails) {
                    summaryRow.put(new Integer(11150), "JR_PAGE_ANCHOR_0_1");
                }
                summaryResultForDataSource.add(summaryRow);
            }
            ReportJRDataSource dataSource = new ReportJRDataSource(summaryResultForDataSource, new Hashtable(), showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            HDTReportListener.setPDFFontForTitleBand(format, jasperDesign, locale);
            reportFileName = HDTAuditReportListener.getFormattedFileName("AuditReport");
            if (format.toLowerCase().indexOf("pdf") != -1 || format.toLowerCase().indexOf("html") != -1) {
                inputs.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            if (!isDetailsAvailable) {
                Properties attributeProp;
                Integer columnName1;
                int i;
                for (i = 0; i < attributelist.size() && !(columnName1 = (Integer)(attributeProp = (Properties)attributelist.get(i)).get("ATTRIB_ID")).equals(new Integer(11150)); ++i) {
                }
                if (i < attributelist.size()) {
                    attributelist.remove(i);
                }
            }
            if (!(columnWidths = JRDesignUtil.calculateWidthForAuditReport(attributelist, summaryResultForDataSource, new Hashtable(), format, reportType)).isEmpty()) {
                JRDesignUtil.fillBandForAuditReport(columnWidths, jasperDesign, headerBand, detailBand, attributelist, format, null, 0, rb, loginId, reportType, showSerialNo, locale);
            } else {
                JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, format, rb, locale);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            if (reportName != null) {
                inputs.put("title", reportName);
            } else {
                inputs.put("title", " ");
            }
            inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            print = !columnWidths.isEmpty() ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs);
            AddToPgNumber += print.getPages().size();
            summaryViewPrintList.add(print);
            Hashtable reqIdVsObjIdMapping = (Hashtable)detailsHashTable.get("reqIdVsObjIdMapping");
            Hashtable wfDetails = (Hashtable)detailsHashTable.get("wfDetails");
            Hashtable requestorTable = (Hashtable)detailsHashTable.get("requestorDetails");
            String auditRepDetails = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "AuditReportDetails.xml";
            JasperDesign jasperDes = JRXmlLoader.load((String)auditRepDetails);
            JasperDesign desWithoutDetailBand = JRXmlLoader.load((String)auditRepDetails);
            JRDesignBand detailsBand = (JRDesignBand)desWithoutDetailBand.getDetail();
            if (detailBand != null) {
                JRDesignUtil.hideBand(detailsBand);
            }
            if ((columnHeaderBand = (JRDesignBand)desWithoutDetailBand.getColumnHeader()) != null) {
                JRDesignUtil.hideBand(columnHeaderBand);
            }
            HDTReportListener.setPDFFontForTitleBand(format, jasperDes, locale);
            JRDesignParameter param = new JRDesignParameter();
            param.setValueClass(String.class);
            param.setName("auditPhoto");
            jasperDes.addParameter((JRParameter)param);
            if (format.toLowerCase().indexOf("pdf") != -1) {
                int i1;
                JRElement[] elements1;
                JRFont reportPDFFont = JRFieldDesignUtil.getPDFExporterFont(locale);
                JRDesignReportFont normalFont = JRFieldDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, 12, false, false);
                if (jasperDes.getDetail() != null) {
                    JRDesignBand subDetailBand = (JRDesignBand)jasperDes.getDetail();
                    elements1 = subDetailBand.getElements();
                    for (i1 = 0; i1 < elements1.length; ++i1) {
                        if (!(elements1[i1] instanceof JRDesignTextField)) continue;
                        ((JRDesignTextField)elements1[i1]).setFont((JRFont)normalFont);
                    }
                }
                if (jasperDes.getSummary() != null) {
                    JRDesignBand summaryBand = (JRDesignBand)jasperDes.getSummary();
                    elements1 = summaryBand.getElements();
                    for (i1 = 0; i1 < elements1.length; ++i1) {
                        if (!(elements1[i1] instanceof JRDesignTextField)) continue;
                        ((JRDesignTextField)elements1[i1]).setFont((JRFont)normalFont);
                    }
                }
            }
            JasperReport jasperRep = JasperCompileManager.compileReport((JasperDesign)jasperDes);
            JasperReport jasperRepWithoutDetailBand = JasperCompileManager.compileReport((JasperDesign)desWithoutDetailBand);
            for (int i = 0; i < summaryResult.size(); ++i) {
                Hashtable summaryRow = (Hashtable)summaryResult.get(i);
                String objIdStr = (String)summaryRow.get(new Integer(11150));
                Long objid = Long.parseLong(objIdStr);
                ArrayList detailsList = (ArrayList)detailsHashTable.get(objid);
                boolean isDetailsListEmpty = false;
                JasperReport jReport = null;
                if (detailsList.size() == 0) {
                    isDetailsListEmpty = true;
                    jReport = jasperRepWithoutDetailBand;
                    Hashtable<String, String> hash = new Hashtable<String, String>();
                    hash.put("AttrName", " ");
                    hash.put("AttrValue", " ");
                    detailsList.add(hash);
                } else {
                    jReport = jasperRep;
                }
                JRDesignUtil.addUserPhotos(detailsList, format, rb);
                ReportJRRewindableDataSource datasrc = new ReportJRRewindableDataSource(detailsList);
                if (reportName != null) {
                    inputs.put("title", reportName);
                } else {
                    inputs.put("title", " ");
                }
                inputs.remove("WFTitle");
                inputs.remove("Requestor");
                inputs.remove("WFDetails");
                if (summaryRow != null) {
                    Long wfId;
                    Hashtable requestorDetails;
                    inputs.put("TechnicianName", summaryRow.get(new Integer(11151)));
                    inputs.put("ActionName", summaryRow.get(new Integer(11145)));
                    inputs.put("ObjectName", summaryRow.get(new Integer(11147)));
                    inputs.put("ActionTime", DateTimeUtil.getDateFormat((Long)loginId).format(Long.parseLong((String)summaryRow.get(new Integer(11146)))));
                    String moduleName = (String)summaryRow.get(new Integer(11154));
                    if (reqIdVsObjIdMapping.containsKey(objid) && !moduleName.equalsIgnoreCase("ManageEngine ServiceDesk Plus") && (requestorDetails = (Hashtable)requestorTable.get(wfId = (Long)reqIdVsObjIdMapping.get(objid))) != null && !requestorDetails.isEmpty()) {
                        String requestorStr = rb.getString((String)requestorDetails.get("description")) + "<br />";
                        requestorStr = requestorStr + rb.getString("admp.workflow.createrequest.option_subject") + "" + ClientUtil.htmlEscapeForAuditReport(rb.getString((String)requestorDetails.get("subject")));
                        ArrayList wfHistory = (ArrayList)wfDetails.get(wfId);
                        String wfStr = "";
                        for (int index = 0; index < wfHistory.size(); ++index) {
                            Hashtable wfCommitHash = (Hashtable)wfHistory.get(index);
                            wfStr = wfStr + rb.getString((String)wfCommitHash.get("description")) + "<br />" + rb.getString("admp.workflow.object_history.comments") + ": " + ClientUtil.htmlEscapeForAuditReport(rb.getString((String)wfCommitHash.get("comments"))) + "<br />";
                        }
                        inputs.put("WFTitle", rb.getString("admp.workflow.viewrequest.attribname.request_history"));
                        inputs.put("Requestor", requestorStr);
                        inputs.put("WFDetails", wfStr);
                    }
                } else {
                    inputs.put("TechnicianName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.technician_name"));
                    inputs.put("ActionName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.action_name"));
                    inputs.put("ObjectName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.object_name"));
                    inputs.put("ActionTime", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.action_time"));
                }
                if (isDetailsListEmpty && !inputs.containsKey("WFDetails")) continue;
                inputs.put("TechName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.technician_name"));
                inputs.put("ActName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.action_name"));
                inputs.put("ObjName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.object_name"));
                inputs.put("ActTime", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.action_time"));
                inputs.put("summaryView", rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.summary_view").toLowerCase());
                inputs.put("AttribName", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.attribute_name"));
                inputs.put("AttribValue", rb.getString("admp.deleg.hdt_deleg.hdt_reports.attrib_disp_name.attribute_value"));
                inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
                inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
                inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
                inputs.put("ObjectId", Long.toString(objid));
                inputs.put("AddToPgNumber", AddToPgNumber);
                JasperPrint jrPrintObject = JasperFillManager.fillReport((JasperReport)jReport, (Map)inputs, (JRDataSource)datasrc);
                AddToPgNumber += jrPrintObject.getPages().size();
                detailsPrintList.add(jrPrintObject);
            }
            summaryViewPrintList.addAll(detailsPrintList);
            HDTAuditReportListener.auditReportExporter(summaryViewPrintList, format, reportFileName, filePath, response, request, locale, loginId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    private static boolean exportStandardViewAuditReport(String reportFileName, String format, ArrayList attributelist, String reportName, Long[] technicians, long fromTime, long toTime, HashMap inputs, String filePath, Long loginId, HttpServletResponse response, HttpServletRequest request, String ascending, String sortColumn, Criteria criteria, Long[] objectIds, Hashtable resultList, ArrayList viewColumnList, boolean fetchArchiveData, Long archiveTime) {
        String reportType = "standard";
        Locale locale = I18NUtil.getDefaultLocale((Long)loginId);
        boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
        if (request != null) {
            locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        }
        try {
            Hashtable columnWidths;
            Hashtable list;
            reportName = rb.getString(reportName);
            int count = 0;
            count = 0;
            if (technicians != null) {
                count = HDTAuditReportAction.getCount(technicians, fromTime, toTime, criteria, fetchArchiveData, archiveTime);
            }
            HDTAuditReportListener.setExportRowCount(count);
            ArrayList result = new ArrayList();
            ArrayList<Long> objectIdList = new ArrayList<Long>();
            ArrayList<JasperPrint> printList = new ArrayList<JasperPrint>();
            if (count != 0) {
                if (ascending == null) {
                    ascending = "false";
                }
                list = HDTAuditSchedulerUtil.getRowsForAuditReport(technicians, fromTime, toTime, attributelist, -1, -1, Boolean.valueOf(ascending), sortColumn, criteria, loginId, objectIdList, rb, fetchArchiveData, archiveTime);
                result = (ArrayList)list.get("resultList");
            } else if (objectIds != null) {
                if (ascending == null) {
                    ascending = "false";
                }
                list = HDTAuditSchedulerUtil.getRowsForNotification(objectIds, attributelist, Boolean.valueOf(ascending), loginId, objectIdList, rb);
                result = (ArrayList)list.get("resultList");
            } else {
                return false;
            }
            Hashtable detailsHashTable = HDTAuditSchedulerUtil.getProperties(objectIdList, loginId, rb, resultList, viewColumnList, fetchArchiveData, archiveTime);
            boolean isDetailsAvailable = false;
            if (format.toLowerCase().indexOf("csv") != -1) {
                for (int ii = 0; ii < result.size(); ++ii) {
                    Hashtable row = (Hashtable)result.get(ii);
                    ArrayList detailsList = null;
                    Long rowObjId = Long.parseLong((String)row.get(new Integer(11150)));
                    detailsList = (ArrayList)detailsHashTable.get(rowObjId);
                    JRDesignUtil.addUserPhotos(detailsList, format, rb);
                    if (!detailsList.isEmpty()) {
                        isDetailsAvailable = true;
                    }
                    StringBuilder rowsString = new StringBuilder("");
                    for (int i = 0; i < detailsList.size(); ++i) {
                        Hashtable detailsRow = (Hashtable)detailsList.get(i);
                        rowsString.append(detailsRow.get("AttrName"));
                        rowsString.append(" : ");
                        rowsString.append(detailsRow.get("AttrValue"));
                        rowsString.append(" ; ");
                    }
                    String rowValue = rowsString.toString();
                    rowValue = rowValue.replaceAll("\\<B>", "");
                    rowValue = rowValue.replaceAll("\\</B>", "");
                    rowValue = rowValue.replaceAll("\\<br/>", "");
                    rowValue = rowValue.replaceAll("\\<span*>", "");
                    rowValue = rowValue.replaceAll("\\<//span>", "");
                    row.put(new Integer(11150), rowValue);
                }
            }
            ReportJRDataSource dataSource = new ReportJRDataSource(result, new Hashtable(), showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER, format);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            HDTReportListener.setPDFFontForTitleBand(format, jasperDesign, locale);
            jasperDesign.setName(reportName);
            HashMap<String, ReportJRRewindableDataSource> JrRewindDS = new HashMap<String, ReportJRRewindableDataSource>();
            if (format.toLowerCase().indexOf("csv") == -1) {
                for (Map.Entry ent : detailsHashTable.entrySet()) {
                    Map.Entry entry = ent;
                    if (!(entry.getKey() instanceof Long)) continue;
                    Long key = (Long)entry.getKey();
                    ArrayList resArraylist = (ArrayList)entry.getValue();
                    if (resArraylist.size() == 0) {
                        Hashtable<String, String> rowHash = new Hashtable<String, String>();
                        rowHash.put(new String("AttrName"), " ");
                        rowHash.put(new String("AttrValue"), " ");
                        resArraylist.add(rowHash);
                    } else {
                        isDetailsAvailable = true;
                    }
                    JRDesignUtil.addUserPhotos(resArraylist, format, rb);
                    JrRewindDS.put(key.toString(), new ReportJRRewindableDataSource(resArraylist));
                }
                inputs.put("SubReportDS", JrRewindDS);
                JRFont reportPDFFont = JRFieldDesignUtil.getPDFExporterFont(locale);
                inputs.put("font_name_val", reportPDFFont.getPdfFontName());
                inputs.put("font_encoding_val", reportPDFFont.getPdfEncoding());
                inputs.put("locale_code_val", locale.getLanguage());
                String subReportLoc = basepath + "jasperreports" + File.separator + "jasper" + File.separator + "AuditReportStandardSubreport.jasper";
                inputs.put("SubReportName", subReportLoc);
            }
            reportFileName = HDTAuditReportListener.getFormattedFileName("AuditReport");
            if (format.toLowerCase().indexOf("xls") != -1 || format.toLowerCase().indexOf("csv") != -1) {
                JRElement[] elements;
                if (format.toLowerCase().indexOf("csv") != -1) {
                    JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                    elements = titleBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        titleBand.removeElement((JRDesignElement)elements[i]);
                    }
                    titleBand.setHeight(0);
                    JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                    elements = pageHeaderBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        pageHeaderBand.removeElement((JRDesignElement)elements[i]);
                    }
                    pageHeaderBand.setHeight(0);
                }
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                elements = pageFooterBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements[i]);
                }
                pageFooterBand.setHeight(0);
                if (format.toLowerCase().indexOf("xls") == -1) {
                    JRDesignBand summaryBand = (JRDesignBand)jasperDesign.getSummary();
                    elements = summaryBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        summaryBand.removeElement((JRDesignElement)elements[i]);
                    }
                    summaryBand.setHeight(0);
                }
                inputs.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            } else if (format.toLowerCase().indexOf("pdf") != -1 || format.toLowerCase().indexOf("html") != -1) {
                inputs.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            JRDesignBand summary = (JRDesignBand)jasperDesign.getSummary();
            JRDesignElement subreportElement = null;
            JRElement[] elements = detailBand.getElements();
            subreportElement = (JRDesignElement)elements[elements.length - 1];
            detailBand.removeElement((JRDesignElement)elements[elements.length - 1]);
            if (format.toLowerCase().indexOf("csv") != -1) {
                detailBand.removeElement((JRDesignElement)elements[elements.length - 2]);
            }
            if (!isDetailsAvailable) {
                Properties attributeProp;
                Integer columnName1;
                int i;
                for (i = 0; i < attributelist.size() && !(columnName1 = (Integer)(attributeProp = (Properties)attributelist.get(i)).get("ATTRIB_ID")).equals(new Integer(11150)); ++i) {
                }
                if (i < attributelist.size()) {
                    attributelist.remove(i);
                }
            }
            if (!(columnWidths = JRDesignUtil.calculateWidthForAuditReport(attributelist, result, new Hashtable(), format, reportType)).isEmpty()) {
                JRDesignUtil.fillBandForAuditReport(columnWidths, jasperDesign, headerBand, detailBand, attributelist, format, null, 0, rb, loginId, reportType, showSerialNo, locale);
                if (subreportElement != null && format.toLowerCase().indexOf("csv") == -1 && isDetailsAvailable) {
                    detailBand.addElement(subreportElement);
                }
                if (!isDetailsAvailable) {
                    detailBand.removeElement((JRDesignElement)elements[elements.length - 2]);
                    detailBand.removeElement((JRDesignElement)elements[elements.length - 3]);
                    JRElement[] summaryEle = summary.getElements();
                    if (summaryEle.length > 0) {
                        summary.removeElement((JRDesignElement)summaryEle[summaryEle.length - 1]);
                    }
                }
            } else {
                JRDesignUtil.fillNoDataBand(jasperDesign, detailBand, format, rb, locale);
            }
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            if (reportName != null) {
                inputs.put("title", reportName);
            } else {
                inputs.put("title", " ");
            }
            inputs.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            inputs.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputs.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            print = !columnWidths.isEmpty() ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs, (JRDataSource)dataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputs);
            printList.add(print);
            HDTAuditReportListener.auditReportExporter(printList, format, reportFileName, filePath, response, request, locale, loginId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static void auditReportExporter(ArrayList printList, String format, String reportFileName, String filePath, HttpServletResponse response, HttpServletRequest request, Locale locale, Long loginId) throws Exception {
        String password = PasswordUtil.getExportFilePassword((Long)loginId);
        ReportExporter exporter = new ReportExporter(format.toLowerCase(), password);
        if (format.toLowerCase().indexOf("pdf") != -1) {
            if (filePath != null) {
                exporter.exportAsPdf(printList, reportFileName, new Long(0L), filePath);
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsPdf(printList, reportFileName, response, locale);
            }
        } else if (format.toLowerCase().indexOf("html") != -1) {
            if (filePath != null) {
                exporter.exportAsHtml(printList, filePath + File.separator + reportFileName + ".html", new HashMap());
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsHtml(printList, reportFileName, response, request.getSession());
            }
        } else if (format.toLowerCase().indexOf("xlsx") != -1) {
            if (filePath != null) {
                exporter.exportAsExcelForXlsx(printList, filePath + File.separator + reportFileName + ".xlsx", null);
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsXlsx(printList, reportFileName, response);
            }
        } else if (format.toLowerCase().indexOf("xls") != -1) {
            exporter.exportAsExcel(printList, filePath + File.separator + reportFileName + ".xls");
        } else if (format.toLowerCase().indexOf("csv") != -1) {
            if (filePath != null) {
                exporter.exportAsCsv(printList, filePath + File.separator + reportFileName + ".csv", loginId);
            } else {
                reportFileName = reportFileName.replaceAll("\\s", "");
                exporter.exportAsCsv(printList, reportFileName, response, loginId);
            }
        } else {
            reportLogger.log(Level.INFO, "Invalid Report Type");
        }
        HDTAuditReportListener.setExportFileName(exporter.getExportFile());
    }

    public static String getDetailsString(String objId) {
        try {
            Long objIdInLong = Long.parseLong(objId);
        }
        catch (Exception e) {
            return "";
        }
        return rb.getString("admp.deleg.hdt_deleg.hdt_reports.scheduler.view_details");
    }

    private static String getFormattedFileName(String reportFileName) {
        if (reportFileName != null) {
            String reportFileName1 = reportFileName;
            Vector<String> vector = new Vector<String>();
            String strTemp = new String();
            for (int i = 0; i < reportFileName1.length(); ++i) {
                char c = '/';
                if (reportFileName1.charAt(i) == c) {
                    vector.add(strTemp);
                    strTemp = new String();
                    continue;
                }
                strTemp = strTemp + reportFileName1.charAt(i);
            }
            vector.add(strTemp);
            String newreportFileName = "";
            for (int j = 0; j < vector.size(); ++j) {
                String name = (String)vector.elementAt(j);
                newreportFileName = newreportFileName + name;
            }
            reportFileName = newreportFileName;
        }
        return reportFileName;
    }

    public static void setExportRowCount(int count) {
        exportCount = count;
    }

    public static int getExportRowCount() {
        return exportCount;
    }

    public static void setExportFileName(String fileName) {
        exportFileName = fileName;
    }

    public static String getExportFileName() {
        return exportFileName;
    }
}

