/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.automation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.workflow.RequestExecutionFlow;
import com.adventnet.sym.adsm.common.server.workflow.ScheduledRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class AutomationCSVImportListener
extends ModifyUserListener {
    String baseTableName = "";
    String tableKey = "";
    String tempTableKey = "";
    String defaultNamingContext = "";
    String keyLdapName = "sAMAccountName";
    String keyLdapDisplayName = "SAM_ACCOUNT_NAME";
    Integer subCategoryId = null;
    Long loginId = CommonUtil.ADMIN_LOGIN_ID;
    private boolean connectToOffice365 = false;
    private String waadTenantId;
    private String pwd;
    private HashMap immutableIdProps;
    private boolean isDirSync;
    private boolean processLogicalJoin;
    private ArrayList attributePropsList = new ArrayList();

    @Override
    public void init(Long loginId, Integer subCategoryId, String domainName) {
        this.keyLdapName = "sAMAccountName";
        this.keyLdapDisplayName = "SAM_ACCOUNT_NAME";
        this.subCategoryId = subCategoryId;
        this.baseTableName = WorkFlowUtil.getDetailsTableName((Integer)subCategoryId);
        this.reportId = AutomationUtil.getReportIdForSubcategory((Integer)subCategoryId);
        this.tableKey = "OBJECT_GUID";
        this.setDomainName(domainName);
        this.defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainName);
        this.loginId = loginId;
        ADMPAuthObject authObj = new ADMPAuthObject(loginId);
        this.authorizedDomainOUHash = authObj.getDomainOUsMap();
        this.rb = ResourceBundleMgr.getInstance().getBundle(loginId);
    }

    private void initO365Connection() {
        try {
            Criteria waadCrit = new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"AD_DOMAIN_NAME"), (Object)this.domainName, 0);
            waadCrit = waadCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"IAMAPP_ID"), (Object)FcLayoutConstants.OFFICE_365_APPID, 0));
            DataObject waadIdDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADADDomainLinkDetails", waadCrit);
            Iterator it = waadIdDo.getRows("ADSMWAADADDomainLinkDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String waadDomainId = String.valueOf(r.get("WAAD_DOMAIN_ID"));
                long accId = (Long)r.get("WAAD_DOMAIN_ID");
                DataObject waadDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADDomainConfiguration", new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_DOMAIN_ID"), (Object)accId, 0));
                Iterator it2 = waadDO.getRows("ADSMWAADDomainConfiguration");
                Row r2 = (Row)it2.next();
                this.waadTenantId = (String)r2.get("WAAD_TENANT_ID");
                this.pwd = (String)r2.get("WAAD_TENANT_PASSWD");
                this.immutableIdProps = O365MgmtHandler.getImmutableIdDetails((Long)accId, (String)"user");
                this.isDirSync = (Boolean)r2.get("IS_DIR_SYNC_ENABLED");
                this.processLogicalJoin = false;
                ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(Integer.valueOf(46), "o365user");
                for (int i = 0; i < tableNames.size(); ++i) {
                    ArrayList l = ReportAttributeHandler.getInstance().getAttributes((String)tableNames.get(i), Integer.valueOf(46));
                    for (int j = 0; j < l.size(); ++j) {
                        Properties p = (Properties)l.get(j);
                        if (this.attributePropsList.contains(p.get("ATTRIB_LDAP_NAME"))) continue;
                        this.attributePropsList.add(p.get("ATTRIB_LDAP_NAME"));
                    }
                }
                if (!this.isDirSync) {
                    this.attributePropsList.remove("ImmutableId");
                    this.attributePropsList.remove("DecodedImmutableId");
                    if ((String)this.immutableIdProps.get("WAAD_ATTRIB_NAME") != null) {
                        this.processLogicalJoin = true;
                    }
                }
                if (this.connectToOffice365) continue;
                String connectionMsg = ADHandler.connectPowershellService((String)this.waadTenantId, (String)this.pwd);
                if (connectionMsg != null && connectionMsg.trim().length() > 0) {
                    this.isCompleted = true;
                    System.out.println("O365 connectionMsg --" + connectionMsg);
                }
                this.connectToOffice365 = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ArrayList getGUIDListFromCsv(ArrayList<Hashtable> attributeList, ArrayList<Hashtable> userDetailsList, boolean isADGuid, String csvADColumn, String csvO365Column, ScheduledRequest robo) {
        ArrayList guidList = null;
        this.keyLdapName = "sAMAccountName";
        this.keyLdapDisplayName = "SAM_ACCOUNT_NAME";
        String searchString = "";
        try {
            guidList = new ArrayList();
            ArrayList<Hashtable> O365UserDetailsList = new ArrayList<Hashtable>();
            Criteria waadCrit = new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"AD_DOMAIN_NAME"), (Object)this.domainName, 0);
            waadCrit = waadCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADADDomainLinkDetails", (String)"IAMAPP_ID"), (Object)FcLayoutConstants.OFFICE_365_APPID, 0));
            DataObject waadIdDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMWAADADDomainLinkDetails", waadCrit);
            Iterator it = waadIdDo.getRows("ADSMWAADADDomainLinkDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String waadDomainId = String.valueOf(r.get("WAAD_DOMAIN_ID"));
                long accId = (Long)r.get("WAAD_DOMAIN_ID");
                this.immutableIdProps = O365MgmtHandler.getImmutableIdDetails((Long)accId, (String)"user");
            }
            int i = 0;
            ArrayList<String> adGuidList = new ArrayList<String>();
            for (Hashtable singleUserDetails : userDetailsList) {
                Hashtable uiValues;
                Hashtable relationalTableRowMap;
                Hashtable tableRowMap;
                ++i;
                this.keyLdapName = "sAMAccountName";
                String keyLdapValue = (String)singleUserDetails.get(this.keyLdapDisplayName);
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("DISTINGUISHED_NAME");
                    this.keyLdapName = "distinguishedName";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("OBJECT_GUID");
                    this.keyLdapName = "objectGUID";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("EMPLOYEE_ID");
                    this.keyLdapName = "employeeID";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("EMPLOYEE_NUMBER");
                    this.keyLdapName = "employeeNumber";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("EMAIL_ADDRESS");
                    this.keyLdapName = "mail";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("FULL_NAME");
                    this.keyLdapName = "name";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("USER_PRINCIPAL_NAME");
                    this.keyLdapName = "UserPrincipalName";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("LOGON_NAME");
                    this.keyLdapName = "userPrincipalName";
                }
                if (keyLdapValue == null || keyLdapValue.equals("")) {
                    keyLdapValue = (String)singleUserDetails.get("OBJECT_ID");
                    this.keyLdapName = "ObjectId";
                }
                if (robo != null && keyLdapValue != null && !keyLdapValue.equals("")) {
                    HashMap<String, String> errDetailsMap = new HashMap<String, String>();
                    errDetailsMap.put("ldapKey", this.keyLdapName);
                    robo.setErrorCodeValues(AutomationConstants.INSUFFICIENT_DETAILS_FOR_GUID, errDetailsMap);
                }
                if (keyLdapValue == null && (keyLdapValue == null || keyLdapValue.equals(""))) continue;
                if (this.keyLdapName.equalsIgnoreCase("ObjectId") || !isADGuid && this.keyLdapName.equalsIgnoreCase("UserPrincipalName")) {
                    try {
                        if (!this.connectToOffice365) {
                            this.initO365Connection();
                        }
                        if (this.immutableIdProps == null) continue;
                        Properties props = ADHandler.getO365UserProperties((String)this.waadTenantId, (String)this.pwd, (ArrayList)this.attributePropsList, (String)((String)this.immutableIdProps.get("ATTRIB_LDAP_NAME")), (String)((String)this.immutableIdProps.get("WAAD_ATTRIB_NAME")), (boolean)this.processLogicalJoin, (boolean)this.isDirSync, (String)this.keyLdapName, (String)keyLdapValue);
                        ArrayList objectIdList = (ArrayList)props.get("ObjectId");
                        String objectId = null;
                        if (objectIdList != null) {
                            objectId = (String)objectIdList.get(0);
                        }
                        if (objectId == null) {
                            System.out.println(" object " + keyLdapValue + "  not found ");
                            continue;
                        }
                        if (guidList.contains(objectId)) continue;
                        tableRowMap = new Hashtable();
                        relationalTableRowMap = new Hashtable();
                        uiValues = new Hashtable();
                        String o365baseTableName = "O365UserGeneralDetails";
                        String o365TableKey = "OBJECT_ID";
                        this.addRow(props, objectId, tableRowMap, relationalTableRowMap, uiValues, 46, o365TableKey);
                        ArrayList<String> currentGuidList = new ArrayList<String>();
                        currentGuidList.add(objectId);
                        DBObjectUtil.addOrUpdate((String)o365baseTableName, (String)o365TableKey, currentGuidList, tableRowMap, relationalTableRowMap);
                        if (csvO365Column != null) {
                            ArrayList valueList = (ArrayList)props.get(csvO365Column);
                            if (valueList == null) continue;
                            guidList.add((String)valueList.get(0));
                            continue;
                        }
                        if (!isADGuid) {
                            guidList.add(objectId);
                            continue;
                        }
                        String key = (String)this.immutableIdProps.get("COLUMN_NAME");
                        Hashtable<String, String> o365UserDetails = new Hashtable<String, String>();
                        ArrayList list = (ArrayList)props.get("DecodedImmutableId");
                        if (list != null) {
                            o365UserDetails.put(key, (String)list.get(0));
                            O365UserDetailsList.add(o365UserDetails);
                        }
                        if (i != userDetailsList.size()) continue;
                        guidList = this.getGUIDListFromCsv(new ArrayList<Hashtable>(), O365UserDetailsList, isADGuid, null, null, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                searchString = this.getCSVQuery(this.keyLdapName, keyLdapValue, this.subCategoryId);
                ArrayList attib = this.getReportAttributeList();
                if (!attib.contains(this.keyLdapName)) {
                    attib.add(this.keyLdapName);
                }
                try {
                    Properties prop;
                    if (this.keyLdapName.equalsIgnoreCase("objectGUID")) {
                        keyLdapValue = keyLdapValue.substring(keyLdapValue.indexOf("{") + 1, keyLdapValue.indexOf("}"));
                        searchString = "<GUID=" + keyLdapValue + ">";
                        prop = ADHandler.getObjectProperties((String)this.domainName, (Long)this.loginId, (String)searchString, (ArrayList)attib);
                    } else {
                        prop = this.getAttributeValues(this.domainName, this.defaultNamingContext, this.loginId, attib, searchString);
                    }
                    System.out.println(" Search String :" + searchString + "\n Got attributes from AD " + prop);
                    String guid = this.getGuid(prop);
                    if (guid == null) {
                        System.out.println(" searchString " + searchString + " object matches found ");
                        continue;
                    }
                    if (guidList.contains(guid)) continue;
                    tableRowMap = new Hashtable();
                    relationalTableRowMap = new Hashtable();
                    uiValues = new Hashtable();
                    this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues);
                    ArrayList<String> guidListTemp = new ArrayList<String>();
                    guidListTemp.add(guid);
                    DBObjectUtil.addOrUpdate((String)this.baseTableName, (String)this.tableKey, guidListTemp, tableRowMap, relationalTableRowMap);
                    if (csvADColumn != null) {
                        ArrayList valueList = (ArrayList)prop.get(csvADColumn);
                        if (valueList == null) continue;
                        guidList.add((String)valueList.get(0));
                        continue;
                    }
                    if (isADGuid) {
                        guidList.add(guid);
                        continue;
                    }
                    String ldapKey = (String)this.immutableIdProps.get("ATTRIB_LDAP_NAME");
                    ArrayList list = (ArrayList)prop.get(ldapKey);
                    if (list != null) {
                        adGuidList.add((String)list.get(0));
                    }
                    if (i != userDetailsList.size()) continue;
                    guidList = this.getO365GuidList(adGuidList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guidList;
    }

    private ArrayList getO365GuidList(ArrayList adGuidList) {
        ArrayList<String> o365GuidList = new ArrayList<String>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"O365UserGeneralDetails"));
            sq.addSelectColumn(Column.getColumn((String)"O365UserGeneralDetails", (String)"OBJECT_ID"));
            sq.setCriteria(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)adGuidList.toArray(), 8));
            DataObject dao = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dao.isEmpty()) {
                Iterator it = dao.getRows("O365UserGeneralDetails");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    o365GuidList.add((String)row.get("OBJECT_ID"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return o365GuidList;
    }

    @Override
    public ArrayList getGUIDListFromModifyUserCsv(ArrayList<Hashtable> attributeList, ArrayList<Hashtable> userDetailsList, ArrayList<String> validSelectedValues) {
        ArrayList<String> guidList = null;
        String searchString = "";
        try {
            guidList = new ArrayList<String>();
            for (Hashtable singleUserDetails : userDetailsList) {
                Hashtable prop;
                int i;
                String keyLdapName = RequestExecutionFlow.getKeyLdapName(attributeList);
                String keyLdapValue = "";
                searchString = "(&(objectClass=user)(objectCategory=user)";
                if (validSelectedValues != null) {
                    for (i = 0; i < attributeList.size(); ++i) {
                        prop = attributeList.get(i);
                        for (int k = 0; k < validSelectedValues.size(); ++k) {
                            String index;
                            String attributeName = (String)prop.get("ATTRIB_LDAP_NAME");
                            if (!attributeName.equals(index = validSelectedValues.get(k))) continue;
                            Object attributeObjVal = singleUserDetails.get((String)prop.get("ATTRIB_COLUMN_NAME"));
                            int relationalType = (Integer)prop.get("RELATIONAL_TYPE");
                            String attributeValue = "";
                            if (relationalType == 1) continue;
                            attributeValue = (String)attributeObjVal;
                            attributeValue = attributeName.equalsIgnoreCase("objectGUID") ? CSVUserListener.convertGuidToHexDecimal(attributeValue) : CommonUtil.escapeSpecialCharacters((String)attributeValue);
                            searchString = searchString + "(" + attributeName + "=" + attributeValue + ")";
                        }
                    }
                } else {
                    for (i = 0; i < attributeList.size(); ++i) {
                        prop = attributeList.get(i);
                        String attributeName = (String)prop.get("ATTRIB_LDAP_NAME");
                        if (!attributeName.equals(keyLdapName)) continue;
                        keyLdapValue = CommonUtil.escapeSpecialCharacters((String)((String)singleUserDetails.get((String)prop.get("ATTRIB_LDAP_NAME"))));
                    }
                    searchString = searchString + "(" + keyLdapName + "=" + keyLdapValue + ")";
                }
                searchString = searchString + ")";
                ArrayList attib = this.getReportAttributeList();
                try {
                    prop = this.getAttributeValues(this.domainName, this.defaultNamingContext, this.loginId, attib, searchString);
                    System.out.println(" Search String :" + searchString + "\n Got attributes from AD " + prop);
                    String guid = this.getGuid((Properties)prop);
                    if (guid == null) {
                        System.out.println(" searchString " + searchString + " object matches found ");
                        continue;
                    }
                    if (guidList.contains(guid)) continue;
                    guidList.add(guid);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guidList;
    }

    public String getCSVQuery(String keyLdapName, String keyLdapValue, Integer subcategoryId) {
        String searchString = "";
        if (subcategoryId.compareTo(1) == 0 || subcategoryId.compareTo(11) == 0) {
            searchString = "(&(objectClass=user)(objectCategory=user)(" + keyLdapName + "=" + keyLdapValue + "))";
        } else if (subcategoryId.compareTo(2) == 0 || subcategoryId.compareTo(12) == 0) {
            searchString = "(&(objectClass=group)(objectCategory=group)(" + keyLdapName + "=" + keyLdapValue + "))";
        } else if (subcategoryId.compareTo(3) == 0 || subcategoryId.compareTo(13) == 0) {
            searchString = "(&(objectClass=computer)(objectCategory=computer)(" + keyLdapName + "=" + keyLdapValue + "))";
        } else if (subcategoryId.compareTo(4) == 0 || subcategoryId.compareTo(14) == 0) {
            searchString = "(&(objectClass=contact)(objectCategory=contact)(" + keyLdapName + "=" + keyLdapValue + "))";
        }
        return searchString;
    }
}

