/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.automation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Persistence;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.AdvancedReportsInterface;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportTask;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.ScheduledMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.SchedulerLicenseUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.server.workflow.RequestExecutionFlow;
import com.adventnet.sym.adsm.common.server.workflow.ScheduledRequest;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.WorkdayUtil;
import com.adventnet.sym.adsm.common.webclient.integration.ZPeopleUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.ScheduledMgmtActionUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.SchedulerExecution;
import com.adventnet.sym.adsm.common.webclient.workflow.SchedulerOperationHandler;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MgmtAutomationAction
extends DispatchAction {
    private static Logger out = Logger.getLogger("WFLogger");

    public ActionForward viewAutomation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (!ClientAuthorizationUtil.isAuthorized(request, AutomationConstants.MGMT_AUTOMATION_ACTION_ID).booleanValue()) {
            out.log(Level.INFO, "Authorization Failer to view Mgmt Automation page for the loginId " + loginId);
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        return mapping.findForward("viewAutomation");
    }

    public ActionForward roboExecutionHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        boolean isNewRange;
        String forwardPage = "requesterHistory";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        int startIndex = new Integer(request.getParameter("startIndex"));
        int count = NavigateRangeUtil.getDefaultRange((String)"AutomationExecutionHistory", (Long)loginId);
        Long roboId = 0L;
        if (request.getParameter("roboId") != null) {
            roboId = new Long(request.getParameter("roboId"));
        }
        if (isNewRange = Boolean.valueOf(request.getParameter("isNewRange")).booleanValue()) {
            NavigateRangeUtil.setDefaultRange((String)"AutomationExecutionHistory", (int)count, (Long)loginId);
        }
        String roboName = request.getParameter("roboName");
        request.setAttribute("roboName", (Object)roboName);
        request.setAttribute("roboId", (Object)roboId);
        request.setAttribute("range", (Object)count);
        return mapping.findForward(forwardPage);
    }

    public ActionForward roboExecutionHistoryResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        boolean isNewRange;
        String forwardPage = "roboHistoryResult";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        int startIndex = new Integer(request.getParameter("startIndex"));
        request.setAttribute("isDifferentAutomation", (Object)false);
        Boolean isDifferentAutomation = Boolean.valueOf(request.getParameter("isDifferentAutomation"));
        int count = new Integer(request.getParameter("count"));
        if (isDifferentAutomation.booleanValue()) {
            request.setAttribute("isDifferentAutomation", (Object)true);
            count = NavigateRangeUtil.getDefaultRange((String)"AutomationExecutionHistory", (Long)loginId);
        }
        Long roboId = 0L;
        if (request.getParameter("roboId") != null) {
            roboId = new Long(request.getParameter("roboId"));
        }
        if (isNewRange = Boolean.valueOf(request.getParameter("isNewRange")).booleanValue()) {
            NavigateRangeUtil.setDefaultRange((String)"AutomationExecutionHistory", (int)count, (Long)loginId);
        }
        String roboName = request.getParameter("roboName");
        request.setAttribute("roboName", (Object)roboName);
        request.setAttribute("roboId", (Object)roboId);
        ArrayList roboHistory = RequestExecutionFlow.getAutomationHistory((Long)roboId, (Long)loginId, (AdventNetResourceBundle)rb, (int)startIndex, (int)count);
        int totalCount = RequestExecutionFlow.getCount((Long)roboId);
        request.setAttribute("totalCount", (Object)totalCount);
        request.setAttribute("roboHistory", (Object)roboHistory);
        return mapping.findForward(forwardPage);
    }

    public ActionForward getAutomationActionComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String subCategory = request.getParameter("subCategory");
        Boolean isPolicyBasedAutomation = new Boolean(request.getParameter("isPolicyBasedAction"));
        String domainName = request.getParameter("domainName");
        ArrayList requestActionsList = AutomationUtil.getAutomationRequestActionType((Integer)new Integer(subCategory), (String)DomainUtil.getDomainName((String)domainName), (AdventNetResourceBundle)rb);
        request.setAttribute("requestActions", (Object)requestActionsList);
        request.setAttribute("isPolicyBasedAutomation", (Object)isPolicyBasedAutomation);
        return mapping.findForward("actionSelectionComponent");
    }

    public ActionForward isSuccessiveTasksExist(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long scheduleId = Long.valueOf(request.getParameter("scheduleId"));
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String action = request.getParameter("action");
        String statusMessage = "false";
        String messageType = "Success";
        Long requestId = 0L;
        Long automationId = 0L;
        try {
            automationId = AutomationUtil.getAutomationId((Long)scheduleId);
            requestId = AutomationUtil.getRequestId((Long)automationId, (boolean)false);
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            ArrayList wfTaskSetList = wfViewRequest.getSuccessiveTaskSetList();
            if (wfTaskSetList != null && wfTaskSetList.size() > 0) {
                statusMessage = "true";
            }
            out.log(Level.INFO, "isSuccessiveTasksExist - Action : " + action + " schedulere Id " + scheduleId + " isSuccessiveTasksExist :" + statusMessage);
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + e.getMessage();
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, messageType, statusMessage);
        return null;
    }

    public ActionForward updateAutomationStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long scheduleId = Long.valueOf(request.getParameter("scheduleId"));
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String action = request.getParameter("action");
        String isSuccessiveTaskDisabled = request.getParameter("isSuccessiveTaskDisabled");
        String statusMessage = rb.getString("admp.mgmt.common.text.successfully_modified");
        String messageType = "Success";
        out.log(Level.INFO, "updateAutomationStatus -- Action : " + action + " schedulere Id " + scheduleId + " isSuccessiveTaskDisabled :" + isSuccessiveTaskDisabled);
        boolean deleteHistoryRecords = false;
        try {
            if (SchedulerUtil.isActionsAllowedForScheduler((Long)scheduleId, (Long)loginId).booleanValue()) {
                if (action != null && action.equalsIgnoreCase("Disable")) {
                    AutomationUtil.enableDisableScheduler((Long)scheduleId, (int)4, (String)isSuccessiveTaskDisabled);
                } else if (action.equalsIgnoreCase("Enable")) {
                    boolean isLicensed = SchedulerLicenseUtil.isAutomationModuleLicensed((AdventNetResourceBundle)rb);
                    if (isLicensed) {
                        AutomationUtil.enableDisableScheduler((Long)scheduleId, (int)3, (String)isSuccessiveTaskDisabled);
                    } else {
                        out.log(Level.INFO, "As License Rescrition cant able to enable the automation. ");
                        statusMessage = rb.getString("admp.auto.automation.statmsg.error_in_enabling_automation_more_pls_purchase_additional_tech_pack");
                        messageType = "Error";
                    }
                } else if (action.equalsIgnoreCase("Delete")) {
                    Long automationId = AutomationUtil.getAutomationId((Long)scheduleId);
                    statusMessage = rb.getString("admp.mgmt.common.text.successfully_deleted");
                    deleteHistoryRecords = new Boolean(request.getParameter("deleteAll"));
                    out.log(Level.INFO, "Going the Delete the scheduleId " + scheduleId + " for the corresponding the AutomationId " + automationId + " Delete All History flag : " + deleteHistoryRecords);
                    AutomationUtil.deleteAutomationCreatedTables((Long)scheduleId);
                    ScheduledMgmtUtil.deleteRoboRequester((Long)scheduleId);
                    statusMessage = !deleteHistoryRecords ? rb.getString("admp.auto.automation.text.successfully_deleted_autoamtion_except_history") : rb.getString("admp.auto.automation.text.successfully_deleted_autoamtion_and_history");
                    AutomationUtil.deleteAutomationAndAssociatedRequestDetails((Long)automationId, (boolean)deleteHistoryRecords);
                    SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
                    runNowObj.setCompletedStatusForDeletedSchedule(scheduleId);
                }
            } else {
                messageType = "Error";
                statusMessage = rb.getString("admp.reports.sche_report.action.access_denied.donot_have_access_to_do_this_opertaion");
            }
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = rb.getString("admp.mgmt.user_mgmt.migrate_mailbox.statmsg.migrate_error") + e.getMessage();
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, messageType, statusMessage);
        return null;
    }

    public ActionForward checkAutomationName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        response.setContentType("application/json");
        try {
            Long schedulerId;
            String origName;
            HttpSession session = request.getSession();
            boolean isAvailable = true;
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("SchedulerMgmtBean");
            String actionType = request.getParameter("actionType");
            String scheduleName = request.getParameter("scheduleName");
            Long automationId = (Long)bean.get("roboId");
            isAvailable = actionType != null && actionType.equalsIgnoreCase("edit") ? ((origName = SchedulerUtil.getSchedulerName((long)(schedulerId = AutomationUtil.getSchedulerId((Long)automationId)))).equalsIgnoreCase(scheduleName) ? false : SchedulerUtil.checkForDuplicateScheduleName((String)scheduleName)) : SchedulerUtil.checkForDuplicateScheduleName((String)scheduleName);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("isSchedulerAvailable", isAvailable);
            String message = rb.getString("admp.auto.auto_policy.create_policy.text.automation_name_exists.error.message");
            jsonObj.put("message", (Object)message);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward previewReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        response.setContentType("application/json");
        Long generationId = 0L;
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String rfConfigDetailsStr = request.getParameter("rfConfigJSON");
            String distinguishedName = request.getParameter("distinguishedName");
            String domainName = request.getParameter("domainName");
            String selectedOUsStr = request.getParameter("selectedOus");
            String excludedOusStr = request.getParameter("excludedOus");
            Boolean isExcludeChildOU = new Boolean(request.getParameter("isExcludeChildOU"));
            Hashtable<String, Boolean> domainVsExcludeChildOU = new Hashtable<String, Boolean>();
            Hashtable excludeOUList = new Hashtable();
            JSONObject selectedOUsJson = new JSONObject(selectedOUsStr);
            ArrayList containerList = new ArrayList();
            ReportFilterConfig reportFilterConfig = new ReportFilterConfig(rfConfigDetailsStr);
            reportFilterConfig.init();
            Integer reportId = reportFilterConfig.getReportId();
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            if (Arrays.asList(ReportsUtil.o365Userreports).contains(reportId)) {
                AdvancedReportsInterface listener = null;
                generationId = ReportHandler.addReportGenerationDetails((Integer)reportId, (String)"", (Long)loginId);
                listener = (AdvancedReportsInterface)Class.forName(className.trim()).getConstructor(Integer.class, Long.class, AdventNetResourceBundle.class).newInstance(reportId, loginId, rb);
                listener.setGenerationId(generationId);
                DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Integer)reportId, (ArrayList)listener.getObjectIds());
                Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
                String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
                StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
                listener.start(reportFilterConfig, domainName, distinguishedName, statusUpdater);
            } else {
                Iterator itr = selectedOUsJson.keys();
                while (itr.hasNext()) {
                    String selectedOUDN = (String)itr.next();
                    if (containerList.contains(selectedOUDN)) continue;
                    containerList.add(selectedOUDN);
                }
                if (containerList.isEmpty()) {
                    containerList = ReportHandler.getContainerList((String)domainName, (Long)loginId);
                    isExcludeChildOU = Boolean.FALSE;
                }
                JSONObject excludedOusJson = new JSONObject(excludedOusStr);
                ArrayList<String> excludedOUList = new ArrayList<String>();
                itr = excludedOusJson.keys();
                while (itr.hasNext()) {
                    String selectedOUDN = (String)itr.next();
                    if (excludedOUList.contains(selectedOUDN)) continue;
                    excludedOUList.add(selectedOUDN);
                }
                ArrayList<String> excludedDNList = new ArrayList<String>();
                for (String excludedOUDN : excludedOUList) {
                    Boolean isParentSelected = Boolean.FALSE;
                    for (int i = 0; i < containerList.size(); ++i) {
                        String selectedOUDN = (String)containerList.get(i);
                        if (!excludedOUDN.endsWith(selectedOUDN)) continue;
                        isParentSelected = Boolean.TRUE;
                        break;
                    }
                    if (!isParentSelected.booleanValue()) continue;
                    excludedDNList.add(excludedOUDN);
                }
                excludeOUList.put(domainName, excludedDNList);
                domainVsExcludeChildOU.put(domainName, isExcludeChildOU);
                Class<?> classToInvoke = Class.forName(className.trim());
                ReportTask listener = null;
                listener = (ReportTask)classToInvoke.newInstance();
                listener.setRb(rb);
                listener.init(r);
                Hashtable domainsAndOUs = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
                Hashtable dnDomainNameMap = (Hashtable)domainsAndOUs.get("dnDomainNameMap");
                listener.executeTask(containerList, dnDomainNameMap, excludeOUList, domainVsExcludeChildOU, reportFilterConfig);
                generationId = listener.getGenerationId();
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("generationId", (Object)generationId);
            jsonObj.put("reportId", (Object)reportId);
            jsonObj.put("domainName", (Object)domainName);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getOutputFilters(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer rvcId = Integer.valueOf(request.getParameter("rvcId"));
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            JSONArray filtersList = AutomationUtil.getOutputFilterJsonArray((Long)loginId, (Integer)rvcId, (AdventNetResourceBundle)rb);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("outputFilters", (Object)filtersList);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward isEditableAutomation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long automationId = new Long(request.getParameter("automationId"));
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            boolean isEdit = true;
            JSONObject jsonObject = new JSONObject();
            Long requestId = 0L;
            if (SchedulerUtil.isActionsAllowedForScheduler((Long)AutomationUtil.getSchedulerId((Long)automationId), (Long)loginId).booleanValue()) {
                isEdit = AutomationUtil.isAutomationEditAccess((Long)automationId);
                if (!isEdit) {
                    requestId = AutomationUtil.getRequestId((Long)automationId, (boolean)true);
                }
                jsonObject.put("isEditable", isEdit);
                jsonObject.put("requestId", (Object)requestId);
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward runNowSchedulerStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String automationStatus = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long schedule_id = 0L;
            String schedule_idStr = request.getParameter("schedule_id");
            schedule_id = new Long(schedule_idStr);
            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            automationStatus = runNowObj.getSchedulerStatus(loginId, schedule_id);
        }
        catch (Exception e) {
            automationStatus = "Error Occured";
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("automationStatus", (Object)automationStatus);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward runNowScheduler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String messageType = "";
        String statusMessage = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            boolean isLicensed = SchedulerLicenseUtil.isAutomationModuleLicensed((AdventNetResourceBundle)rb);
            if (isLicensed) {
                Long schedule_id = 0L;
                String schedule_idStr = request.getParameter("schedule_id");
                schedule_id = new Long(schedule_idStr);
                SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                Long processingScheduleId = runNowObj.getProcessingScheduler(loginId);
                ArrayList scheduleIdList = SchedulerUtil.getSharedScheduleList((Long)loginId);
                if (!SchedulerUtil.isActionsAllowedForScheduler((Long)schedule_id, (Long)loginId).booleanValue() && !scheduleIdList.contains(schedule_id)) {
                    messageType = "Error";
                    statusMessage = rb.getString("admp.automation.run_now.error.automation_unauthorized");
                } else if (!runNowObj.isSchedulerSaved(loginId, schedule_id)) {
                    messageType = "Error";
                    statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.automation_not_saved");
                } else if (runNowObj.isSameSchedulerProcessing(loginId, schedule_id)) {
                    messageType = "Error";
                    statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.scheduler_already_in_progress");
                } else if (runNowObj.isSchedulerProcessing(loginId)) {
                    messageType = "Error";
                    statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.more_than_one_scheduler");
                } else if (!SchedulerHandler.isSchedulerEnabled((Long)schedule_id)) {
                    messageType = "Error";
                    statusMessage = rb.getString("admp.automation.run_now.error.automation_disabled");
                } else {
                    runNowObj.updateScheduleStatus(loginId, schedule_id, "PROCESSING", "", "");
                    Long taskInstanceId = SchedulerUtil.getTaskInstanceId((Long)schedule_id);
                    Long taskId = SchedulerUtil.getTaskID((String)"MgmtAutomation");
                    if (taskInstanceId != null) {
                        SchedulerOperationHandler.getInstanceForAutomation();
                        String stat = SchedulerOperationHandler.execute(taskInstanceId, taskId, loginId, request.getLocale());
                        if (stat.equals("LIMIT_REACHED")) {
                            messageType = "Error";
                            statusMessage = rb.getString("admp.reports.schedule_reports.scheduler_list.run_now_option_limit_reached");
                        } else {
                            messageType = "Success";
                            statusMessage = rb.getString("admp.automation.run_now.status.successfully_started");
                        }
                    }
                }
            } else {
                messageType = "Error";
                statusMessage = rb.getString("admp.mgmt.fc_layout_title.text_common_license_restriction");
            }
        }
        catch (Exception e) {
            messageType = "Error";
            statusMessage = e.getMessage();
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("messageType", (Object)messageType);
        jsonObj.put("statusMessage", (Object)statusMessage);
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward scheduledAutomationCreation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message;
        boolean isLicensed;
        AdventNetResourceBundle rb;
        String forwardPage;
        block35: {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            forwardPage = "createMgmtAutomation";
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            rb = ResourceBundleMgr.getInstance().getBundle(locale);
            isLicensed = LicenseMgr.getInstance().isModuleLicensed(LicenseUtil.AUTOMATION);
            message = null;
            String actionType = request.getParameter("actionType");
            String operation = request.getParameter("operation");
            if (!ClientAuthorizationUtil.isAuthorized(request, AutomationConstants.MGMT_AUTOMATION_ACTION_ID).booleanValue()) {
                out.log(Level.INFO, "Authorization Failer to view Mgmt Automation page for the loginId " + loginId);
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            Hashtable customProp = new Hashtable();
            HashMap timeValues = SchedulerInputsUtil.getScheduleTimeSummary(bean, rb, customProp);
            if (actionType != null && actionType.equalsIgnoreCase("Create")) {
                if (isLicensed && operation != null && operation.equalsIgnoreCase("save")) {
                    Long scheduleId = 0L;
                    try {
                        SchedulerLicenseUtil.checkAutomationRestriction((AdventNetResourceBundle)rb, (String)LicenseUtil.AUTOMATION);
                        scheduleId = SchedulerHandler.createScheduler((String)request.getParameter("roboName"), (String)((String)timeValues.get("scheduleType")), (int)((Integer)timeValues.get("hours")), (int)((Integer)timeValues.get("minutes")), (int)((Integer)timeValues.get("day")), (int)((Integer)timeValues.get("date")), (String)"MgmtAutomation", customProp);
                        out.log(Level.INFO, "Created the Robo Requester,robo id:" + scheduleId);
                        if (!scheduleId.equals(0L)) {
                            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
                            runNowObj.updateScheduleStatus(loginId, scheduleId, "SAVING", "", "");
                            ScheduledMgmtActionUtil.addAutomation(bean, scheduleId, request, loginId, timeValues);
                            String isAddCurrentRecords = "false";
                            Long requestAction = (Long)bean.get("requestAction");
                            String dataSourceType = request.getParameter("dataSourceType");
                            if (!"csv".equalsIgnoreCase(dataSourceType) && requestAction.equals(3L)) {
                                isAddCurrentRecords = "true";
                            } else if (request.getParameter("isAddCurrentRecords") != null) {
                                isAddCurrentRecords = request.getParameter("isAddCurrentRecords");
                            }
                            if (!isAddCurrentRecords.equalsIgnoreCase("true")) {
                                runNowObj.updateScheduleStatus(loginId, scheduleId, "COMPLETED", "", "");
                            }
                            if (request.getParameter("Run_Now") != null && request.getParameter("Run_Now").equals("true") && !isAddCurrentRecords.equalsIgnoreCase("true")) {
                                out.log(Level.INFO, "Run Now options selected.");
                                Long taskInstanceId = SchedulerUtil.getTaskInstanceId((Long)scheduleId);
                                Long taskId = SchedulerUtil.getTaskID((String)"MgmtAutomation");
                                out.log(Level.INFO, "Going the run the scheduler for the instance " + taskInstanceId);
                                if (taskInstanceId != null) {
                                    SchedulerExecution task = new SchedulerExecution(taskInstanceId, taskId);
                                    task.start();
                                }
                                message = rb.getString("admp.auto.automation.create_auto.text.successfully_created_automation_execution_started");
                            } else {
                                message = rb.getString("admp.auto.auto_policy.create_policy.text.successfully_created_automation");
                            }
                            forwardPage = "viewAutomation";
                            break block35;
                        }
                        message = rb.getString("admp.auto.auto_policy.create_policy.text.automation_name_exists.error.message");
                    }
                    catch (Exception e) {
                        out.log(Level.INFO, "Exception occurs while adding new automation" + e.getMessage());
                        e.printStackTrace();
                        message = rb.getString(e.getMessage());
                        SchedulerHandler.deleteScheduler((Long)scheduleId, null);
                    }
                } else if (operation != null && operation.equalsIgnoreCase("setOUs")) {
                    boolean isPolicyBasedAutomation = false;
                    if (request.getParameter("isPolicyBasedAutomation") != null) {
                        isPolicyBasedAutomation = new Boolean(request.getParameter("isPolicyBasedAutomation"));
                    }
                    request.setAttribute("isPolicyBasedAction", (Object)isPolicyBasedAutomation);
                    String domainName = (String)bean.get("domains");
                    String domainDNSName = DomainUtil.getDomainName((String)domainName);
                    this.updateTemplatesInBean(bean, loginId, domainDNSName, rb);
                    String isDomainChange = "false";
                    if (request.getParameter("isDomainChange") != null) {
                        isDomainChange = request.getParameter("isDomainChange");
                    }
                    if (isDomainChange.equalsIgnoreCase("true")) {
                        MgmtAutomationAction.initBeanProps(bean);
                        bean.set("reportValue", (Object)"");
                    }
                } else {
                    bean.initialize(mapping);
                    this.init(request, bean, loginId);
                    String domainName = (String)bean.get("domains");
                    String domainDNSName = "";
                    String[] defaultNamingList = (String[])bean.get("defaultNamingList");
                    String[] domainNames = (String[])bean.get("domainNames");
                    ArrayList domainList = (ArrayList)bean.get("domainList");
                    boolean flag = false;
                    if (domainName.equalsIgnoreCase("")) {
                        for (int i = 0; i < domainList.size(); ++i) {
                            Properties domainProp = (Properties)domainList.get(i);
                            String domain = domainProp.getProperty("DOMAIN_NAME");
                            String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                            String defaultDomain = domainProp.getProperty("IS_DEFAULT_DOMAIN");
                            if (!defaultDomain.equalsIgnoreCase("true")) continue;
                            flag = true;
                            domainName = defaultNamingContext;
                            domainDNSName = domain;
                            break;
                        }
                    }
                    if (domainName.equalsIgnoreCase("") && !flag) {
                        domainName = defaultNamingList[0];
                        domainDNSName = domainNames[0];
                    }
                    bean.set("domains", (Object)domainName);
                    this.updateTemplatesInBean(bean, loginId, domainDNSName, rb);
                }
            } else if (actionType != null && actionType.equalsIgnoreCase("edit")) {
                if (request.getParameter("roboId") != null) {
                    bean.set("roboId", (Object)new Long(request.getParameter("roboId")));
                }
                Long automationId = (Long)bean.get("roboId");
                Long schedulerId = AutomationUtil.getSchedulerId((Long)automationId);
                if (isLicensed && schedulerId != null && operation != null && operation.equalsIgnoreCase("save")) {
                    try {
                        boolean Status = SchedulerHandler.updateScheduler((Long)schedulerId, (String)request.getParameter("roboName"), (String)((String)timeValues.get("scheduleType")), (int)((Integer)timeValues.get("hours")), (int)((Integer)timeValues.get("minutes")), (int)((Integer)timeValues.get("day")), (int)((Integer)timeValues.get("date")), customProp);
                        ScheduledMgmtActionUtil.updateAutomation(bean, request, automationId, schedulerId, timeValues);
                        message = rb.getString("admp.auto.auto_policy.create_policy.text.modify_automation.success.message");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        message = rb.getString("admp.auto.auto_policy.create_policy.text.modify_automation.error.message");
                    }
                    forwardPage = "viewAutomation";
                } else if (operation != null && operation.equalsIgnoreCase("setOUs")) {
                    boolean isPolicyBasedAutomation = false;
                    if (request.getParameter("isPolicyBasedAutomation") != null) {
                        isPolicyBasedAutomation = new Boolean(request.getParameter("isPolicyBasedAutomation"));
                    }
                    request.setAttribute("isPolicyBasedAction", (Object)isPolicyBasedAutomation);
                    Integer reportId = (Integer)bean.get("reportId");
                    request.setAttribute("report_id", (Object)reportId);
                    String domainName = (String)bean.get("domains");
                    String domainDNSName = DomainUtil.getDomainName((String)domainName);
                    this.updateTemplatesInBean(bean, loginId, domainDNSName, rb);
                    String isDomainChange = "false";
                    if (request.getParameter("isDomainChange") != null) {
                        isDomainChange = request.getParameter("isDomainChange");
                    }
                    if (isDomainChange.equalsIgnoreCase("true")) {
                        MgmtAutomationAction.initBeanProps(bean);
                    }
                } else {
                    bean.initialize(mapping);
                    this.initAutomationDetails(request, bean, loginId, automationId, schedulerId);
                }
            }
        }
        if (!isLicensed) {
            message = rb.getString("admp.auto.common.license_error");
        }
        request.setAttribute("message", (Object)message);
        System.out.println("scheduledAutomationCreation Forward page " + forwardPage + " Message :::: " + message);
        return mapping.findForward(forwardPage);
    }

    public ActionForward saveReportFilterConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String rfConfigDetailsStr = request.getParameter("rfConfigJSON");
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            ReportFilterConfig reportFilterConfig = new ReportFilterConfig(rfConfigDetailsStr);
            reportFilterConfig.init();
            String reportValue = (String)reportFilterConfig.get("reportName");
            bean.set("rfConfig", (Object)reportFilterConfig);
            bean.set("reportValue", (Object)reportValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getReportFilterConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportFilterConfig reportFilterConfig = null;
        try {
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Long scheduleId = Long.parseLong(request.getParameter("scheduleId"));
            Integer categoryId = Integer.parseInt(request.getParameter("category"));
            Boolean isLoadFromBean = Boolean.parseBoolean(request.getParameter("isLoadFromBean"));
            if (isLoadFromBean.booleanValue()) {
                DynaValidatorForm bean = (DynaValidatorForm)form;
                reportFilterConfig = (ReportFilterConfig)bean.get("rfConfig");
            } else {
                reportFilterConfig = new ReportFilterConfig();
                reportFilterConfig.init(reportId, categoryId, scheduleId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        request.setAttribute("ReportFilterConfig", reportFilterConfig);
        return mapping.findForward("reportFilterConfig");
    }

    public ActionForward removeReportFilterConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            bean.set("rfConfig", (Object)new ReportFilterConfig());
            bean.set("reportValue", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void initAutomationDetails(HttpServletRequest request, DynaValidatorForm bean, Long loginId, Long automationId, Long schedulerId) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.init(request, bean, loginId);
        boolean custom = SchedulerUtil.isCustomScheduler((Long)schedulerId, (String)"ADSMAutomation");
        String scheduleTypes = SchedulerUtil.getScheduleType((Long)schedulerId);
        SchedulerInputsUtil.setValues(scheduleTypes, schedulerId, custom, bean);
        ScheduledRequest robo = new ScheduledRequest(automationId, schedulerId, rb);
        String csvLocation = null;
        bean.set("roboId", (Object)robo.getRoboId());
        bean.set("roboName", (Object)robo.getRoboName());
        bean.set("description", (Object)robo.getDescription());
        bean.set("requestAction", (Object)robo.getRequestAction());
        request.setAttribute("isPolicyBasedAction", (Object)robo.isPolicyBasedAutomation());
        bean.set("subject", (Object)robo.getSubject());
        bean.set("domains", (Object)DomainUtil.getDefaultNamingContext((String)robo.getDomainName()));
        bean.set("domainOUList", (Object)robo.getDomainOUList());
        bean.set("excludedOUList", (Object)robo.getDomainExcludeOUList());
        bean.set("domainVsExcludeChildOU", (Object)robo.getDomainExcludeChildOUList());
        bean.set("reportValue", (Object)rb.getString(ScheduledMgmtUtil.getReportDetails((Long)schedulerId)));
        bean.set("subCategory", (Object)robo.getSubCategory());
        bean.set("autoExecution", (Object)String.valueOf(!robo.isAutoExecution()));
        bean.set("isAppendedCSVData", (Object)String.valueOf(robo.isAppendedData_csv()));
        request.setAttribute("isNotificationEnabled", (Object)robo.isNotificationEnabled());
        if (robo.isNotificationEnabled()) {
            request.setAttribute("selectedTemplateList", (Object)ScheduledMgmtUtil.getSelectedTemplateList((Long)automationId));
        }
        ArrayList reportIds = robo.getReportIDS();
        Integer reportId = 0;
        if (!reportIds.isEmpty()) {
            String key = "report_id";
            for (int j = 0; j < reportIds.size(); ++j) {
                Hashtable reportDetailsMap = (Hashtable)reportIds.get(j);
                reportId = (Integer)reportDetailsMap.get(key);
                request.setAttribute("report_id", (Object)reportId);
            }
        }
        ReportFilterConfig rfConfig = new ReportFilterConfig();
        rfConfig.setRb(rb);
        rfConfig.init(reportId, robo.getSubCategory(), schedulerId);
        bean.set("rfConfig", (Object)rfConfig);
        BeanMap props = (BeanMap)bean.get("props");
        HashMap actionInputsMap = robo.getActionInputs();
        String templateId = (String)actionInputsMap.get("template");
        csvLocation = (String)actionInputsMap.get("csvLocation");
        String hideFromAddrList = (String)actionInputsMap.get("hideFromAddrList");
        String isRemoveAllO365License = null;
        String selectedO365Licenses = null;
        String isMuchChangePwdAtNextLogon = null;
        String isPasswordNeverExpires = null;
        String isCantChangePassword = null;
        String password = "";
        String passwordType = null;
        Object customScript = null;
        String disableDeleteMailbox = null;
        String drive = null;
        String path = null;
        String mailAlias = null;
        String server = null;
        String store = null;
        String servername = null;
        String retain = null;
        String folderpath = null;
        String format = null;
        String attributeName = null;
        String autoReply = null;
        String sendOutsideMsg = null;
        String isTimeBased = null;
        String replyStartDate = null;
        String replyEndDate = null;
        String startHr = null;
        String startMin = null;
        String endHr = null;
        String endMin = null;
        String insideMsg = null;
        String outsideMsg = null;
        String dataSourceType = null;
        String dbConfigId = null;
        String isAddCurrentRecords = null;
        Long integAdvncCriteriaId = null;
        ArrayList inputDetailsList = new ArrayList();
        if (csvLocation == null) {
            csvLocation = robo.getCsvFileLocation();
        }
        if (robo.isMultipleInput()) {
            Hashtable<String, String> removeFromGroupSidVsNameMap;
            Hashtable<String, String> groupSidVsNameMap = (Hashtable<String, String>)props.get("addToGroupSidVsNameMap");
            if (groupSidVsNameMap == null) {
                groupSidVsNameMap = new Hashtable<String, String>();
            }
            if ((removeFromGroupSidVsNameMap = (Hashtable<String, String>)props.get("removeFromGroupSidVsNameMap")) == null) {
                removeFromGroupSidVsNameMap = new Hashtable<String, String>();
            }
            ArrayList inputList = (ArrayList)actionInputsMap.get("multiInputValuesList");
            try {
                for (FcOption fcOption : inputList) {
                    if (fcOption.getLabel().equalsIgnoreCase("UserMustChangePwd")) {
                        isMuchChangePwdAtNextLogon = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("CantChangePwd")) {
                        isCantChangePassword = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("PwdNeverExpires")) {
                        isPasswordNeverExpires = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("drive")) {
                        drive = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("path")) {
                        path = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("mailFormat")) {
                        mailAlias = fcOption.getValue();
                        mailAlias = mailAlias.trim();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("serverName")) {
                        server = fcOption.getValue();
                        server = server.trim();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("retain")) {
                        retain = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("serverNameValue")) {
                        servername = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("folderpath")) {
                        folderpath = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("format")) {
                        format = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("attributeName")) {
                        attributeName = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("mailBoxStore")) {
                        store = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("Password")) {
                        password = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("PasswordType")) {
                        passwordType = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("IsSendAutoReply")) {
                        autoReply = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("IsSendOutsideMsg")) {
                        sendOutsideMsg = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("IsAutoReplyTimeBased")) {
                        isTimeBased = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("ReplyStartDate")) {
                        replyStartDate = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("ReplyEndDate")) {
                        replyEndDate = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("StartHr")) {
                        startHr = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("StartMin")) {
                        startMin = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("EndHr")) {
                        endHr = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("EndMin")) {
                        endMin = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("InsideMessage")) {
                        insideMsg = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("OutsideMessage")) {
                        outsideMsg = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("DisableDeleteMailbox")) {
                        disableDeleteMailbox = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("dataSourceType")) {
                        dataSourceType = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("dbConfigId")) {
                        dbConfigId = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("isRemoveAllO365License")) {
                        isRemoveAllO365License = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("selectedO365Licenses")) {
                        selectedO365Licenses = fcOption.getValue();
                        continue;
                    }
                    if (robo.getRequestAction().compareTo(WorkFlowUtil.ADDTO_GROUP_ACTION_ID) == 0 || robo.getRequestAction().compareTo(WorkFlowUtil.COMPUTER_ADDTO_GROUP_ACTION_ID) == 0 || robo.getRequestAction().compareTo(WorkFlowUtil.CONTACT_ADDTO_GROUP_ACTION_ID) == 0 || robo.getRequestAction().compareTo(WorkFlowUtil.GROUP_ADDTO_GROUP_ACTION_ID) == 0) {
                        groupSidVsNameMap.put(fcOption.getValue(), fcOption.getLabel());
                        continue;
                    }
                    if (robo.getRequestAction().compareTo(WorkFlowUtil.REMOVEFROM_GROUP_ACTION_ID) == 0 || robo.getRequestAction().compareTo(WorkFlowUtil.COMPUTER_REMOVEFROM_GROUP_ACTION_ID) == 0 || robo.getRequestAction().compareTo(WorkFlowUtil.CONTACT_REMOVEFROM_GROUP_ACTION_ID) == 0 || robo.getRequestAction().compareTo(WorkFlowUtil.GROUP_REMOVEFROM_GROUP_ACTION_ID) == 0) {
                        if (fcOption.getLabel().equalsIgnoreCase("isRemoveAllGroup")) {
                            props.put(fcOption.getLabel(), Boolean.parseBoolean(fcOption.getValue()));
                            continue;
                        }
                        removeFromGroupSidVsNameMap.put(fcOption.getValue(), fcOption.getLabel());
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("dbUsername") || fcOption.getLabel().equalsIgnoreCase("dbPassword") || fcOption.getLabel().equalsIgnoreCase("dbServerName") || fcOption.getLabel().equalsIgnoreCase("dbPortNumber") || fcOption.getLabel().equalsIgnoreCase("dbInstanceName") || fcOption.getLabel().equalsIgnoreCase("dbDatabaseName") || fcOption.getLabel().equalsIgnoreCase("dbTableName") || fcOption.getLabel().equalsIgnoreCase("attrMappingListInputs")) {
                        request.setAttribute(fcOption.getLabel(), (Object)fcOption.getValue());
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("integAdvncCriteriaId")) {
                        integAdvncCriteriaId = Long.parseLong(fcOption.getValue());
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("isAddCurrentRecords") || !fcOption.getValue().equalsIgnoreCase("true") && !fcOption.getValue().equalsIgnoreCase("on")) continue;
                    request.setAttribute("isAddCurrentRecords", (Object)"true");
                    isAddCurrentRecords = "true";
                }
                if (robo.getRequestAction().compareTo(WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID) == 0 && !inputList.isEmpty()) {
                    request.setAttribute("inputDetails", (Object)inputList);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (hideFromAddrList != null && !hideFromAddrList.equalsIgnoreCase("")) {
            request.setAttribute("hideFromAddrList", (Object)hideFromAddrList);
        }
        if (disableDeleteMailbox != null) {
            bean.set("disableDeleteMailbox", disableDeleteMailbox);
        }
        if (isMuchChangePwdAtNextLogon != null && isMuchChangePwdAtNextLogon.length() > 0) {
            request.setAttribute("isMuchChangePwdAtNextLogon", (Object)"true");
            if (isMuchChangePwdAtNextLogon.equalsIgnoreCase("true")) {
                bean.set("isMuchChangePwdAtNextLogon", (Object)isMuchChangePwdAtNextLogon);
            }
        }
        if (isCantChangePassword != null && isCantChangePassword.length() > 0) {
            request.setAttribute("isCantChangePwd", (Object)"true");
            if (isCantChangePassword.equalsIgnoreCase("true")) {
                bean.set("isCantChangePwd", (Object)isCantChangePassword);
            }
        }
        if (isPasswordNeverExpires != null && isPasswordNeverExpires.length() > 0) {
            request.setAttribute("isPwdNeverExpires", (Object)"true");
            if (isPasswordNeverExpires.equalsIgnoreCase("true")) {
                bean.set("isPwdNeverExpires", (Object)isPasswordNeverExpires);
            }
        }
        if (drive != null && path != null) {
            bean.set("homeDrive", drive);
            bean.set("homeDirectoryPath", path);
            bean.set("retainHomeFolder", retain);
        }
        if (mailAlias != null && server != null && store != null) {
            System.out.println(" setted" + mailAlias + " " + server + " " + servername);
            bean.set("mail_alias_format_sel", mailAlias);
            bean.set("ServerNameValues", server);
            bean.set("MailBoxStores", store);
            bean.set("ServerNameValues1", servername);
        }
        if (folderpath != null && format != null && attributeName != null) {
            bean.set("importPhotoSharePath", folderpath);
            bean.set("formatDisplay", format);
            bean.set("attribName", attributeName);
        }
        if (passwordType != null || password != null) {
            if (passwordType != null) {
                bean.set("passwordType", passwordType);
            } else {
                bean.set("passwordType", (Object)"ownPassword");
            }
            bean.set("newPassword", (Object)password);
        }
        if (autoReply != null) {
            bean.set("sendAutoReply", autoReply);
            bean.set("sendOutsideMsg", sendOutsideMsg);
            bean.set("isTimeBased", isTimeBased);
            bean.set("replyStartDate", replyStartDate);
            bean.set("replyEndDate", replyEndDate);
            bean.set("startHr", startHr);
            bean.set("startMin", startMin);
            bean.set("endHr", endHr);
            bean.set("endMin", endMin);
            try {
                bean.set("insideMsg", insideMsg);
                bean.set("outsideMsg", outsideMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        bean.set("template", (Object)templateId);
        bean.set("csvLocation", (Object)csvLocation);
        if (dataSourceType == null) {
            if (actionInputsMap.get("dataSourceType") != null) {
                dataSourceType = (String)actionInputsMap.get("dataSourceType");
                bean.set("dataSourceType", (Object)dataSourceType);
                bean.set("isAddCurrentRecords", actionInputsMap.get("isAddCurrentRecords"));
                if (!dataSourceType.equalsIgnoreCase("csv")) {
                    bean.set("dbConfigId", actionInputsMap.get("dbConfigId"));
                    if (actionInputsMap.get("integAdvncCriteriaId") != null) {
                        bean.set("integAdvncCriteriaId", (Object)Long.parseLong((String)actionInputsMap.get("integAdvncCriteriaId")));
                    }
                }
            }
        } else {
            bean.set("dataSourceType", dataSourceType);
            if (!dataSourceType.equalsIgnoreCase("csv")) {
                bean.set("dbConfigId", dbConfigId);
                bean.set("integAdvncCriteriaId", integAdvncCriteriaId);
            }
            bean.set("isAddCurrentRecords", isAddCurrentRecords);
        }
        bean.set("customScriptVal", actionInputsMap.get("CustomScript"));
        bean.set("inputValue", actionInputsMap.get("Container"));
        bean.set("domainSelect", actionInputsMap.get("domainSelect"));
        bean.set("selectedOUName", actionInputsMap.get("selectedOUName"));
        bean.set("isRemoveAllO365License", isRemoveAllO365License);
        bean.set("selectedO365Licenses", selectedO365Licenses);
        this.updateTemplatesInBean(bean, loginId, robo.getDomainName(), rb);
    }

    public void init(HttpServletRequest request, DynaValidatorForm bean, Long loginId) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String[] hoursDef = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
            Integer[] hourValues = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
            String[] minutesDef = new String[]{"0", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50", "55"};
            Integer[] minuteValues = new Integer[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
            Integer[] days = new Integer[]{1, 2, 3, 4, 5, 6, 7};
            String[] dayValues = new String[]{rb.getString("admp.common.days.sunday"), rb.getString("admp.common.days.monday"), rb.getString("admp.common.days.tuesday"), rb.getString("admp.common.days.wednesday"), rb.getString("admp.common.days.thursday"), rb.getString("admp.common.days.friday"), rb.getString("admp.common.days.saturday")};
            String[] dateDef = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30"};
            Integer[] dateValues = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
            String[] repeatValues = new String[]{rb.getString("admp.reports.sched_reports.sch_create.input_text.days"), rb.getString("admp.reports.sched_reports.sch_create.input_text.weeks"), rb.getString("admp.reports.sched_reports.sch_create.input_text.months"), rb.getString("admp.reports.sched_reports.sch_create.input_text.years"), rb.getString("admp.reports.sched_reports.sch_create.input_text.minutes")};
            String[] repeats = new String[]{"repdays", "repweeks", "repmonths", "repyears", "repminutes"};
            String[] frequencyType = new String[]{"repnone", "repeat"};
            String[] frequencyValues = new String[]{rb.getString("admp.reports.sched_reports.sch_create.input_text.run_once"), rb.getString("admp.reports.sched_reports.sch_create.input_text.repeat")};
            String[] weekValues = new String[]{rb.getString("admp.reports.sched_reports.sch_create.input_text.first_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.second_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.third_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.fourth_week"), rb.getString("admp.reports.sched_reports.sch_create.input_text.last_week")};
            Integer[] weeks = new Integer[]{1, 2, 3, 4, 5};
            Calendar cal = Calendar.getInstance();
            int currentHour = cal.get(11);
            int currentMinute = cal.get(12);
            if (currentMinute >= 55) {
                currentMinute = 0;
                ++currentHour;
            } else {
                currentMinute = currentMinute - currentMinute % 5 + 5;
            }
            System.out.println("Going to set default frequency values");
            bean.set("hours", (Object)hoursDef);
            bean.set("hourValues", (Object)hourValues);
            bean.set("minutes", (Object)minutesDef);
            bean.set("minuteValues", (Object)minuteValues);
            bean.set("days", (Object)days);
            bean.set("dayValues", (Object)dayValues);
            bean.set("date", (Object)dateDef);
            bean.set("dateValues", (Object)dateValues);
            bean.set("weeks", (Object)weeks);
            bean.set("weekValues", (Object)weekValues);
            bean.set("repeats", (Object)repeats);
            bean.set("repeatValues", (Object)repeatValues);
            bean.set("frequencyType", (Object)frequencyType);
            bean.set("frequencyValues", (Object)frequencyValues);
            bean.set("repSchedule", (Object)"hourly");
            bean.set("frequency", (Object)"repnone");
            bean.set("repeatType", (Object)"repdays");
            bean.set("selectedMonthValues", (Object)"");
            bean.set("selectedDayValues", (Object)"");
            bean.set("startDate", (Object)"");
            bean.set("dailysel1", (Object)currentHour);
            bean.set("dailysel2", (Object)currentMinute);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList subCategoryList = AutomationUtil.getAutomationSubCategoryDetails();
        HashMap categoryTable = (HashMap)subCategoryList.get(0);
        Integer subCategory = (Integer)categoryTable.get("SUB_CATEGORY");
        bean.set("subCategoryList", (Object)subCategoryList);
        bean.set("subCategory", (Object)subCategory);
        bean.set("requestTypeList", (Object)WorkFlowUtil.getRequestTypes(null, (Integer)subCategory));
        String name = MessageFormat.format(rb.getString("admp.auto.automation.create_auto.text.default_aumation_name"), 1);
        bean.set("roboName", (Object)name);
        bean.set("description", (Object)"");
        bean.set("subject", (Object)"");
        bean.set("scheduleType", (Object)"");
        bean.set("rfConfig", (Object)new ReportFilterConfig());
        bean.set("reportValue", (Object)"");
        bean.set("requestAction", (Object)-1L);
        try {
            Hashtable domains = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
            ArrayList domainList = (ArrayList)domains.get("domainList");
            bean.set("domainList", (Object)domainList);
            ArrayList<String> defaultNamingDomainList = new ArrayList<String>();
            ArrayList<String> domainNamesList = new ArrayList<String>();
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProp = (Properties)domainList.get(i);
                String domainName1 = domainProp.getProperty("DOMAIN_NAME");
                String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                if (!ClientAuthorizationUtil.isAuthorized(request, domainName1, AutomationConstants.MGMT_AUTOMATION_ACTION_ID).booleanValue()) continue;
                defaultNamingDomainList.add(defaultNamingContext);
                domainNamesList.add(domainName1);
            }
            String[] defaultNamingList = new String[defaultNamingDomainList.size()];
            defaultNamingList = defaultNamingDomainList.toArray(defaultNamingList);
            String[] domainNames = new String[domainNamesList.size()];
            domainNames = domainNamesList.toArray(domainNames);
            bean.set("rfConfig", (Object)new ReportFilterConfig());
            bean.set("defaultNamingList", (Object)defaultNamingList);
            bean.set("domainNames", (Object)domainNames);
            bean.set("domainOUList", new Hashtable());
            MgmtAutomationAction.initBeanProps(bean);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initBeanProps(DynaValidatorForm bean) {
        BeanMap props = (BeanMap)bean.get("props");
        String[] propsKeys = new String[]{"addToGroupSidVsNameMap", "removeFromGroupSidVsNameMap"};
        for (int index = 0; index < propsKeys.length; ++index) {
            props.put(propsKeys[index], new Hashtable());
        }
        props.put("isRemoveAllGroup", false);
    }

    private void updateTemplatesInBean(DynaValidatorForm bean, Long loginId, String domainName, AdventNetResourceBundle rb) {
        ArrayList contactCreationTemplateList;
        ArrayList groupCreationTemplateList;
        ArrayList userModificationTemplateList;
        ArrayList userCreationTemplateList = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)FcExecuteActionConstants.userCreationTemplateCategoryId, (String)domainName, (int)-1, null);
        if (userCreationTemplateList.isEmpty()) {
            System.out.println("As template list was empty for the selected domain.. So set empty status message");
            Properties p = new Properties();
            p.put("TEMPLATE_NAME", rb.getString("admp.mgmt.user_mgmt.cre_single_user.info.no_templates_available"));
            p.put("TEMPLATE_ID", (Object)-1L);
            userCreationTemplateList.add(p);
        }
        if ((userModificationTemplateList = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)FcExecuteActionConstants.userModificationTemplateCategoryId, (String)domainName, (int)-1, (String)"")).isEmpty()) {
            System.out.println("As template list was empty for the selected domain.. So set empty status message");
            Properties p = new Properties();
            p.put("TEMPLATE_NAME", rb.getString("admp.mgmt.user_mgmt.cre_single_user.info.no_templates_available"));
            p.put("TEMPLATE_ID", (Object)-1L);
            userModificationTemplateList.add(p);
        }
        if ((groupCreationTemplateList = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)FcExecuteActionConstants.groupCreationTemplateCategoryId, (String)domainName, (int)-1, (String)"")).isEmpty()) {
            System.out.println("As template list was empty for the selected domain.. So set empty status message");
            Properties p = new Properties();
            p.put("TEMPLATE_NAME", rb.getString("admp.mgmt.user_mgmt.cre_single_user.info.no_templates_available"));
            p.put("TEMPLATE_ID", (Object)-1L);
            groupCreationTemplateList.add(p);
        }
        if ((contactCreationTemplateList = FcLayoutViewHandler.getTemplateNames((Long)loginId, (Long)FcExecuteActionConstants.contactCreationTemplateCategoryId, (String)domainName, (int)-1, (String)"")).isEmpty()) {
            System.out.println("As template list was empty for the selected domain.. So set empty status message");
            Properties p = new Properties();
            p.put("TEMPLATE_NAME", rb.getString("admp.mgmt.user_mgmt.cre_single_user.info.no_templates_available"));
            p.put("TEMPLATE_ID", (Object)-1L);
            contactCreationTemplateList.add(p);
        }
        Hashtable<Long, ArrayList> templatesDetails = new Hashtable<Long, ArrayList>();
        templatesDetails.put(FcExecuteActionConstants.userCreationTemplateCategoryId, userCreationTemplateList);
        templatesDetails.put(FcExecuteActionConstants.userModificationTemplateCategoryId, userModificationTemplateList);
        templatesDetails.put(FcExecuteActionConstants.groupCreationTemplateCategoryId, groupCreationTemplateList);
        templatesDetails.put(FcExecuteActionConstants.contactCreationTemplateCategoryId, contactCreationTemplateList);
        bean.set("templateList", templatesDetails);
        Set templateCategoryIds = templatesDetails.keySet();
        for (Long templateCategoryId : templateCategoryIds) {
            ArrayList templateList = (ArrayList)templatesDetails.get(templateCategoryId);
        }
    }

    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forwardPage = "actionInputDetails";
        ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
        ArrayList customAttributeList = new ArrayList();
        String adSearchQuery = "(&(objectClass=user)(objectCategory=user))";
        try {
            String fileName = request.getParameter("csvLocation");
            ScheduledMgmtActionUtil.csvImport(fileName, attributeList, customAttributeList, rb);
        }
        catch (FileNotFoundException ex) {
            request.setAttribute("importErrorMessage", (Object)rb.getString(ex.getMessage()));
        }
        catch (Exception e) {
            request.setAttribute("importErrorMessage", (Object)e.getMessage());
            e.printStackTrace();
        }
        String keyLdapName = RequestExecutionFlow.getKeyLdapName(attributeList);
        request.setAttribute("attributeList", attributeList);
        request.setAttribute("customAttributeList", customAttributeList);
        request.setAttribute("adSearchQuery", (Object)adSearchQuery);
        request.setAttribute("keyLdapName", (Object)keyLdapName);
        return mapping.findForward(forwardPage);
    }

    public ActionForward dBImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forwardPage = "actionInputDetails";
        ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
        ArrayList<String> customAttributeList = new ArrayList<String>();
        String adSearchQuery = "(&(objectClass=user)(objectCategory=user))";
        try {
            String configId = request.getParameter("configId");
            String dataSourceType = request.getParameter("dataSourceType");
            String tableName = "TPIntegrationAttrMapping";
            if (dataSourceType.equalsIgnoreCase("workday")) {
                tableName = "WorkdayIntegAttrMapping";
            } else if (dataSourceType.equalsIgnoreCase("zPeople")) {
                tableName = "ZohoIntegAttrMapping";
            }
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CONFIG_ID"), (Object)configId, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(tableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String ldapAttribute = r.get("GENERIC_COLUMN").toString();
                    Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)ldapAttribute);
                    if (!attributesdetails.isEmpty()) {
                        Long modifyId = (Long)attributesdetails.get("MODIFY_ID");
                        Long actionId = (Long)attributesdetails.get("ACTION_ID");
                        if (modifyId != null) {
                            if (!attributeList.contains(attributesdetails) && modifyId < 16000L) {
                                attributeList.add(attributesdetails);
                                continue;
                            }
                            if (modifyId <= 16000L || customAttributeList.contains(ldapAttribute)) continue;
                            customAttributeList.add(ldapAttribute);
                            continue;
                        }
                        if (modifyId != null) continue;
                        if (actionId != null && actionId > 16000L) {
                            if (customAttributeList.contains(ldapAttribute)) continue;
                            customAttributeList.add(ldapAttribute);
                            continue;
                        }
                        if (attributeList.contains(attributesdetails)) continue;
                        attributeList.add(attributesdetails);
                        continue;
                    }
                    if (customAttributeList.contains(ldapAttribute)) continue;
                    customAttributeList.add(ldapAttribute);
                }
            }
        }
        catch (Exception e) {
            request.setAttribute("importErrorMessage", (Object)e.getMessage());
            e.printStackTrace();
        }
        String keyLdapName = RequestExecutionFlow.getKeyLdapName(attributeList);
        request.setAttribute("attributeList", attributeList);
        request.setAttribute("customAttributeList", customAttributeList);
        request.setAttribute("adSearchQuery", (Object)adSearchQuery);
        request.setAttribute("keyLdapName", (Object)keyLdapName);
        return mapping.findForward(forwardPage);
    }

    public ActionForward copyAutomation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Persistence per = CommonUtil.getPersistence((boolean[])new boolean[0]);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String newAutoName = request.getParameter("newAutoName");
            JSONObject jsonObj = new JSONObject();
            String message = "";
            boolean isNameExists = SchedulerUtil.checkForDuplicateScheduleName((String)newAutoName);
            boolean isLicensed = LicenseMgr.getInstance().isModuleLicensed(LicenseUtil.AUTOMATION);
            if (!ClientAuthorizationUtil.isAuthorized(request, AutomationConstants.MGMT_AUTOMATION_ACTION_ID).booleanValue()) {
                out.log(Level.INFO, "Authorization Failer to view Mgmt Automation page for the loginId " + loginId);
                throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
            }
            SchedulerLicenseUtil.checkAutomationRestriction((AdventNetResourceBundle)rb, (String)LicenseUtil.AUTOMATION);
            if (!isLicensed) {
                message = rb.getString("admp.auto.common.license_error");
                jsonObj.put("status", (Object)"error");
            } else if (isNameExists) {
                message = rb.getString("admp.auto.auto_policy.create_policy.text.automation_name_exists.error.message");
                jsonObj.put("status", (Object)"error");
            } else {
                Long existAutomationId = Long.parseLong(request.getParameter("automationId"));
                Long existScheduleId = AutomationUtil.getSchedulerId((Long)existAutomationId);
                DataObject dObj = AutomationUtil.getExistDataObject((Long)existScheduleId);
                Hashtable schedulerInput = SchedulerHandler.getFrequencyDetails((Long)existScheduleId);
                Long scheduleId = SchedulerHandler.createScheduler((String)request.getParameter("newAutoName"), (String)((String)schedulerInput.get("scheduleType")), (int)Integer.parseInt((String)schedulerInput.get("hours")), (int)Integer.parseInt((String)schedulerInput.get("mins")), (int)Integer.parseInt((String)schedulerInput.get("day")), (int)Integer.parseInt((String)schedulerInput.get("date")), (String)"MgmtAutomation", (Hashtable)schedulerInput);
                if (scheduleId.equals(0L)) {
                    return null;
                }
                Row row = AutomationUtil.copyAutomationRows((DataObject)dObj, (Long)scheduleId, (String)newAutoName, (Long)loginId);
                DataObject dataObject = per.constructDataObject();
                dataObject.addRow(row);
                DataAccess.fillGeneratedValues((DataObject)dataObject);
                Long newAutoId = (Long)row.get("AUTOMATION_ID");
                Integer categoryId = (Integer)row.get("OBJECT_TYPE");
                boolean isPolicyBasedAutomation = (Boolean)row.get("IS_POLICYBASED_AUTOMATION");
                ArrayList notificationTemplateIds = ScheduledMgmtUtil.getSelectedTemplateList((Long)existAutomationId);
                ScheduledMgmtUtil.setSelectedTemplateList((DataObject)dataObject, (Long)newAutoId, (Long[])notificationTemplateIds.toArray(new Long[notificationTemplateIds.size()]));
                dataObject = AutomationUtil.copyReqPolicy((DataObject)dObj, (DataObject)dataObject, (Long)existAutomationId, (Long)newAutoId, (boolean)isPolicyBasedAutomation);
                dataObject = AutomationUtil.copyOUMapping((DataObject)dObj, (DataObject)dataObject, (Long)existScheduleId, (Long)scheduleId);
                dataObject = AutomationUtil.copyOUExclMappings((DataObject)dObj, (DataObject)dataObject, (Long)existScheduleId, (Long)scheduleId);
                dataObject = AutomationUtil.copyTPDataSourceConfigs((DataObject)dObj, (DataObject)dataObject, (Long)existScheduleId, (Long)scheduleId);
                Criteria crit = new Criteria(new Column("ADSMScheduleReportsMapping", "SCHEDULE_ID"), (Object)existScheduleId, 0);
                Row rfRow = dObj.getRow("ADSMScheduleReportsMapping", crit);
                if (rfRow != null) {
                    Integer reportId = (Integer)rfRow.get("REPORT_ID");
                    ReportFilterConfig rfConfig = new ReportFilterConfig();
                    rfConfig.setRb(rb);
                    rfConfig.init(reportId, categoryId, existScheduleId);
                    SchedulerInputsUtil.addReportFilterDetails(rfConfig, scheduleId, dataObject, false);
                }
                out.log(Level.INFO, "dataObject: " + dataObject.toString());
                per.add(dataObject);
                message = rb.getString("admp.auto.auto_policy.create_policy.text.successfully_created_automation");
                jsonObj.put("status", (Object)"created");
            }
            jsonObj.put("message", (Object)message);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            out.log(Level.INFO, "Exception: " + e.toString());
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getAutoIntegAdvncCriteriaDetails(Long CriteriaId) {
        DataObject dataObject = null;
        try {
            ArrayList subCriteriaList = new ArrayList();
            Criteria criteria = new Criteria(Column.getColumn((String)"AutoIntegAdvncCriteria", (String)"CRITERIA_ID"), (Object)CriteriaId, 0);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAutomation"));
            query.addSelectColumn(Column.getColumn((String)"AutoIntegAdvncCriteria", (String)"CRITERIA_ID"));
            query.addJoin(new Join("AutoIntegAdvncCriteria", "AutoIntegAdvncCriteriaDetails", new String[]{"CRITERIA_ID"}, new String[]{"CRITERIA_ID"}, 2));
            query.addSelectColumn(Column.getColumn((String)"AutoIntegAdvncCriteriaDetails", (String)"*"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AutoIntegAdvncCriteriaDetails", (String)"PROCESSING_ORDER"), true));
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getColumnListForDataSourceConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray columnArray = new JSONArray();
        JSONObject columnTypeMap = new JSONObject();
        String configType = request.getParameter("configType");
        int configId = Integer.parseInt(request.getParameter("configId"));
        TreeSet<Object> columnSet = new TreeSet<Object>();
        if (configType.equalsIgnoreCase("mssql") || configType.equalsIgnoreCase("oracle")) {
            columnArray = DBDataSourceUtil.getDBAttrMapping(configId);
            columnTypeMap = DBDataSourceUtil.getColumnNameVsTypeMapping(configId);
        } else if (configType.equalsIgnoreCase("workday")) {
            columnArray = WorkdayUtil.getDBAttrMapping(configId);
            columnTypeMap = WorkdayUtil.getColumnNameVsTypeMapping();
        } else if (configType.equalsIgnoreCase("zPeople")) {
            columnArray = ZPeopleUtil.getDBAttrMapping(configId);
            columnTypeMap = ZPeopleUtil.getColumnNameVsTypeMapping();
        }
        for (int i = 0; i < columnArray.length(); ++i) {
            JSONObject jsonObj = (JSONObject)columnArray.get(i);
            columnSet.add(jsonObj.get("dbColumnName"));
        }
        columnArray = new JSONArray(columnSet);
        JSONObject obj = new JSONObject();
        System.out.println("columnArray :" + columnArray);
        try {
            obj.put("columnArray", (Object)columnArray);
            obj.put("columnTypeMap", (Object)columnTypeMap);
            PrintWriter writer = response.getWriter();
            writer.print(obj.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getExixtingAdvncConfDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject json = new JSONObject();
        Long configId = Long.parseLong(request.getParameter("configId"));
        Criteria c = new Criteria(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"CRITERIA_ID"), (Object)configId, 0);
        SelectQueryImpl critQuery = new SelectQueryImpl(Table.getTable((String)"AutoIntegAdvancCriteriaDetails"));
        critQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        critQuery.addSortColumn(new SortColumn(Column.getColumn((String)"AutoIntegAdvancCriteriaDetails", (String)"PROCESSING_ORDER"), true));
        critQuery.setCriteria(c);
        DataObject obj = DataAccess.get((SelectQuery)critQuery);
        boolean rowCount = true;
        JSONArray jsonArray = new JSONArray();
        if (obj != null) {
            Iterator it = obj.getRows("AutoIntegAdvancCriteriaDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                JSONObject details = new JSONObject();
                details.put("columnNameSelect", (Object)r.get("COLUMN_NAME").toString());
                details.put("matchCriteria", (Object)r.get("MATCH_CRITERIA").toString());
                details.put("processMatchCriteria", (Object)r.get("PROCESS_MATCH_CRITERIA").toString());
                details.put("conditionFieldValue", (Object)r.get("COLUMN_VALUE").toString());
                details.put("proccessingOrder", (Object)r.get("PROCESSING_ORDER").toString());
                jsonArray.put((Object)details);
            }
        }
        try {
            json.put("configDetails", (Object)jsonArray);
            json.put("criteriaId", (Object)configId.toString());
            PrintWriter writer = response.getWriter();
            writer.print(json.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

