/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.computermanagement.ComputerMgmtHandler;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.computermanagement.CSVComputerBean;
import com.adventnet.sym.adsm.common.webclient.computermanagement.CSVComputerListener;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserAction;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class CSVComputerAction
extends CSVUserAction {
    public ActionForward bulkComputer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forward = "bulkComputer";
        ComputerMgmtHandler computerMgmtHandler = ComputerMgmtHandler.getInstance();
        try {
            CSVComputerBean bean = (CSVComputerBean)form;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String init = request.getParameter("init");
            if (init != null && init.equals("true")) {
                bean.init(request);
                this.init(bean, loginId);
            }
            String operation = (String)bean.get("operation");
            Integer range = (Integer)bean.get("RANGE");
            Long startIndex = (Long)bean.get("FROM_INDEX");
            Long count = null;
            String isNavigate = request.getParameter("isNavigate");
            if (isNavigate != null && isNavigate.equals("false")) {
                bean.setRange(loginId);
            }
            if (operation.equals("Create")) {
                bean.addComputer(request);
                CSVComputerListener listener = (CSVComputerListener)bean.getListener();
                if (!listener.isCompleted()) {
                    request.setAttribute("listener", (Object)listener);
                }
                ArrayList userDetailsList = (ArrayList)request.getAttribute("userDetailsList");
                count = new Long(userDetailsList.size());
                this.init(bean, loginId);
                forward = "modifyResult";
            } else if (operation.equals("ShowResult")) {
                ArrayList userDetailsList = computerMgmtHandler.getUserDetailsList((Long)bean.get("userCreationID"), (ArrayList)bean.get("resultAttributeList"), (int)startIndex.longValue(), range.intValue(), null);
                count = new Long(computerMgmtHandler.getCount((Long)bean.get("userCreationID")).intValue());
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                forward = "modifyResult";
            } else if (operation.equalsIgnoreCase("Stop")) {
                CSVComputerListener listener = (CSVComputerListener)bean.getListener();
                if (!listener.isCompleted()) {
                    listener.stop();
                }
                ArrayList userDetailsList = computerMgmtHandler.getUserDetailsList((Long)bean.get("userCreationID"), (ArrayList)bean.get("resultAttributeList"), (int)startIndex.longValue(), range.intValue(), null);
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                count = new Long(computerMgmtHandler.getCount((Long)bean.get("userCreationID")).intValue());
                forward = "modifyResult";
            } else if (operation.equalsIgnoreCase("ReCreate")) {
                bean.reCreateList(request);
                count = new Long(computerMgmtHandler.getCount((Long)bean.get("userCreationID")).intValue());
            } else {
                count = new Long(computerMgmtHandler.getCount((Long)bean.get("userCreationID")).intValue());
            }
            request.setAttribute("count", (Object)count);
            request.setAttribute("domainList", (Object)HDTDomainHandler.getConfiguredList((Long)loginId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forward);
    }

    @Override
    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            CSVComputerBean computerBean = (CSVComputerBean)form;
            HttpSession session = request.getSession();
            String sessionID = session.getId();
            String domainName = (String)computerBean.get("domainName");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties properties = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")));
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = "CN=Computers," + defaultNamingContext;
            if (ouList.size() > 0) {
                containerName = (String)ouList.get(0);
            }
            Long userCreationID = ComputerMgmtHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
            computerBean.set("userCreationID", userCreationID);
            ArrayList customAttributesList = new ArrayList();
            FormFile formFile = (FormFile)computerBean.get("browse");
            ArrayList userDetailsList = this.csvImport(request, computerBean, (AddUserHandler)ComputerMgmtHandler.getInstance(), customAttributesList);
            if (userDetailsList != null) {
                ArrayList attributeList = (ArrayList)computerBean.get("attributeList");
                if (!userDetailsList.isEmpty()) {
                    ComputerMgmtHandler.getInstance().addUserDetailsList(userCreationID, userDetailsList, attributeList, customAttributesList);
                }
                Integer count = ComputerMgmtHandler.getInstance().getCount(userCreationID);
                request.setAttribute("count", (Object)new Long(count.intValue()));
                if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                    DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.mgmt", (String)"admp.deleg.hdt_deleg.cre_role.action_name.cre_bulk_comp", (Integer)ReportsUtil.BULK_COMPUTER_CREATION_REPORT_ID, (String)"-", (Boolean)Boolean.TRUE, (String)formFile.getFileName(), (String)"csv", (String)"-", (Integer)count);
                }
            }
        }
        catch (DataAccessException dAE) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("client.groups.CSVGroupAction.db_error_occured_please_check_the_LDAP_attribute_names_their_values_in_the_CSV_file")));
            dAE.printStackTrace();
        }
        catch (Exception e) {
            request.setAttribute("importErrorMessage", (Object)new JSONObject().put("errorMsg", (Object)rb.getString("admp.mgmt.bulk_creation.common.statmsg.unknown_err_occ_pls_chk_ldap_attrib_names_in_csv_file")));
            e.printStackTrace();
        }
        return mapping.findForward("bulkComputer");
    }

    @Override
    public ActionForward getUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ArrayList attributeList;
            CSVComputerBean bean = (CSVComputerBean)form;
            String operation = (String)bean.get("operation");
            if (operation.equals("UpdateColumns")) {
                bean.updateColumns(request);
            }
            if ((attributeList = (ArrayList)bean.get("attributeList")) == null) {
                attributeList = new ArrayList();
            }
            Integer range = (Integer)bean.get("RANGE");
            Long startIndex = (Long)bean.get("FROM_INDEX");
            ArrayList userDetailsList = ComputerMgmtHandler.getInstance().getUserDetailsList((Long)bean.get("userCreationID"), attributeList, (int)startIndex.longValue(), range.intValue(), null);
            int attribSize = attributeList.size();
            request.setAttribute("attribSize", (Object)attribSize);
            request.setAttribute("userDetailsList", (Object)userDetailsList);
            request.setAttribute("customAttributes", (Object)AddUserHandler.getInstance().getCustomAttributesList((Long)bean.get("userCreationID")));
            if (userDetailsList.isEmpty()) {
                request.setAttribute("listEmpty", (Object)"true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("userDetails");
    }

    @Override
    public ActionForward modifyAttribute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        CSVComputerBean userBean = (CSVComputerBean)form;
        try {
            String index = request.getParameter("index");
            String attribute = request.getParameter("attribute");
            String value = request.getParameter("value");
            ArrayList attributeList = (ArrayList)userBean.get("attributeList");
            Hashtable attributeDetails = ComputerMgmtHandler.getInstance().getAttributeDetails(attribute, attributeList);
            String tableName = (String)attributeDetails.get("AU_TABLE_NAME");
            Long actionId = (Long)attributeDetails.get("ACTION_ID");
            String domainName = (String)userBean.get("domainName");
            if (actionId == null || ClientUtil.checkAuthorization(request, domainName, (long)actionId)) {
                Long longIndex = new Long(index);
                UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
                Criteria criteria = new Criteria(new Column(tableName, "USER_INDEX"), (Object)longIndex, 0);
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn(attribute, (Object)value);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
            }
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        if (saveFlag) {
            ClientUtil.setStatusXMLElement(response, "Success", "");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward selectContainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        if (domainName != null) {
            CSVComputerBean bean = (CSVComputerBean)form;
            request.getSession().setAttribute("userCreationDomain", (Object)domainName);
            bean.set("domainName", domainName);
        }
        return mapping.findForward("selectContainer");
    }

    private void init(CSVComputerBean bean, Long loginId) {
        bean.set("RANGE", NavigateRangeUtil.getDefaultRange((String)"CSVModification", (Long)loginId));
        bean.set("PAGE_NUMBER", "1");
        bean.set("FROM_INDEX", new Long(1L));
    }
}

