/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class CSVComputerListener
extends CSVUserListener {
    AdventNetResourceBundle rb = null;
    private String containerName = null;
    private ArrayList attributeList = null;
    private ArrayList resultAttributeList = null;

    public CSVComputerListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList) {
        super(loginId, ids, domainVsIds, groupList);
    }

    public void init(Long userCreationID, String domainName, ArrayList<Hashtable> userDetailsList, String keyLdapName, String container, ArrayList attributeList, ArrayList resultAttributeList) {
        this.userCreationID = userCreationID;
        this.domainName = domainName;
        this.userDetailsList = userDetailsList;
        this.keyLdapName = keyLdapName;
        this.containerName = container;
        this.attributeList = attributeList;
        this.resultAttributeList = resultAttributeList;
        this.reportId = 2006;
    }

    public void addComputers(HttpServletRequest request) {
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String hostId = request.getRemoteHost();
        Action action = new Action(this, hostId);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    @Override
    protected void reloadUI() {
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.out.write("<script>window.location.href='CSVComputers.do?methodToCall=bulkComputer&selectedTab=admin&operation=ShowResult'</script>");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Properties getBulkUserErrorMessage(String domainName, ArrayList groupList, NativeError errHdlr, String objectName, String containerName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        String searchName = CommonUtil.escapeSpecialCharacters((String)objectName);
        String searchString = "(&(objectClass=Computer)(objectCategory=Computer)(name=" + searchName + "))";
        if (errHdlr.getErrorMessage((Object)domainName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)domainName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)domainName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)containerName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)containerName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)containerName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)objectName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)objectName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)objectName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)searchString, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)searchString, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)searchString);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : groupList) {
            if (errHdlr.getErrorMessage(object, this.rb) == null) continue;
            messageBuilder.append(errHdlr.getErrorMessage(object, this.rb));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", messageBuilder.toString());
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    private class Action
    extends Thread {
        private CSVComputerListener modifyUserListener;
        private String hostId;

        public Action(CSVComputerListener modifyUserListener, String hostId) {
            this.modifyUserListener = modifyUserListener;
            this.hostId = hostId;
        }

        @Override
        public void run() {
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)CSVComputerListener.this.loginId, (String)this.hostId, (Integer)CSVComputerListener.this.reportId, (DataObject)auditDataObj, (ArrayList)CSVComputerListener.this.attributeList, (AdventNetResourceBundle)CSVComputerListener.this.rb);
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                audit_info.put("audit_id", audit_id);
                boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"computerMgmt");
                String name = "";
                String defaultNamingcontext = DomainUtil.getDefaultNamingContext((String)CSVComputerListener.this.domainName);
                String searchString = "";
                Hashtable customAttributesList = AddUserHandler.getInstance().getCustomAttributesList(CSVComputerListener.this.userCreationID);
                Hashtable resultList = new Hashtable();
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (Hashtable hashtable : CSVComputerListener.this.userDetailsList) {
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
                    ArrayList customList = new ArrayList();
                    ArrayList nonExchPropList = new ArrayList();
                    ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                    ArrayList<String> groupList = new ArrayList<String>();
                    Properties props = new Properties();
                    CSVComputerListener.this.getProperties("create", valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props, "Computer");
                    String computerName = "";
                    if (props.get("userName") != null) {
                        computerName = props.getProperty("userName");
                    }
                    String samAccountName = "";
                    samAccountName = props.get("samAccountName") != null ? props.getProperty("samAccountName") : computerName;
                    if (samAccountName.length() > 15) {
                        samAccountName = samAccountName.substring(0, 15);
                    }
                    if (!samAccountName.endsWith("$")) {
                        samAccountName = samAccountName.concat("$");
                    }
                    String password = computerName.toLowerCase();
                    Hashtable nameVsValues = (Hashtable)customAttributesList.get(userIndex);
                    if (nameVsValues != null) {
                        Enumeration e = nameVsValues.keys();
                        while (e.hasMoreElements()) {
                            String attributeName = (String)e.nextElement();
                            ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                            for (int i = 0; i < CSVComputerListener.this.attributeList.size(); ++i) {
                                Hashtable attribHash = (Hashtable)CSVComputerListener.this.attributeList.get(i);
                                String attribName = (String)attribHash.get("ATTRIB_COLUMN_NAME");
                                if (!attribName.equalsIgnoreCase(attributeName)) continue;
                                attributeName = (String)attribHash.get("ATTRIB_LDAP_NAME");
                            }
                            Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                            customTable.put("ATTRIB_LDAP_NAME", attributeName);
                            customTable.put("DATA_HANDLER_TYPE", 3L);
                            customTable.put("ATTRIB_VALUE_COUNT", 1L);
                            if (values != null && values.size() > 1) {
                                ArrayList<String> list = new ArrayList<String>();
                                for (Object string : values) {
                                    list.add(string.toString().trim());
                                }
                                customTable.put("ATTRIB_VALUE", list);
                                customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                            } else if (values != null && values.size() == 1) {
                                customTable.put("ATTRIB_VALUE", values.get(0));
                            } else {
                                customTable.put("ATTRIB_VALUE", "");
                            }
                            customList.add(customTable);
                        }
                    }
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    logProps.put("domainName", CSVComputerListener.this.domainName);
                    logProps.put("userName", computerName);
                    logProps.put("propList", propList);
                    logProps.put("customList", customList);
                    logProps.put("modifyList", modifyList);
                    logProps.put("tsList", tsList);
                    logProps.put("winNTAttributeList", winNTAttributeList);
                    logProps.put("groupList", groupList);
                    String container = (String)props.get("OUName");
                    if (container != null) {
                        CSVComputerListener.this.containerName = container;
                    }
                    if (!objectOUList.contains(CSVComputerListener.this.containerName)) {
                        objectOUList.add(CSVComputerListener.this.containerName);
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (Long)userIndex, (String)computerName, (String)CSVComputerListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("user_index", userIndex);
                    if (props.get("manager") != null) {
                        Hashtable<String, String> userVsmanager = new Hashtable<String, String>();
                        userVsmanager.put("manager", props.get("manager").toString());
                        resultList.put(computerName, userVsmanager);
                    }
                    if (CSVComputerListener.this.stop) break;
                    if (!isLicenseExceeded) {
                        NativeError error = new NativeError();
                        error = ADHandler.addComputer((String)CSVComputerListener.this.domainName, (Long)CSVComputerListener.this.loginId, (String)CSVComputerListener.this.containerName, (String)computerName, (String)samAccountName, (String)password, propList, new ArrayList(), groupList);
                        Properties prop = CSVComputerListener.this.getBulkUserErrorMessage(CSVComputerListener.this.domainName, groupList, error, computerName, CSVComputerListener.this.containerName);
                        System.out.println("Create ComputerError Message properties are " + prop);
                        String CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                        prop.put("USER_INDEX", userIndex);
                        String distinguishedName = "cn=" + computerName + "," + CSVComputerListener.this.containerName;
                        if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            String CREATION_MESSAGE = prop.getProperty("CREATION_MESSAGE");
                            CREATION_MESSAGE = CREATION_MESSAGE == null ? CSVComputerListener.this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp") : CSVComputerListener.this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp") + " - " + CREATION_MESSAGE;
                            prop.setProperty("CREATION_MESSAGE", CREATION_MESSAGE);
                            if (!customList.isEmpty()) {
                                String searchName = CommonUtil.escapeSpecialCharacters((String)computerName);
                                searchString = "(&(objectClass=Computer)(objectCategory=Computer)(name=" + searchName + "))";
                                NativeError customError = ADHandler.searchAndModifyComputer((String)CSVComputerListener.this.domainName, (Long)CSVComputerListener.this.loginId, (String)CSVComputerListener.this.containerName, (String)searchString, null, customList, new ArrayList(), (boolean)false);
                                Properties customErrorProp = CSVComputerListener.this.getBulkUserErrorMessage(CSVComputerListener.this.domainName, groupList, customError, computerName, CSVComputerListener.this.containerName);
                                String CUSTOM_CREATION_STATUS = customErrorProp.getProperty("CREATION_STATUS");
                                if (CUSTOM_CREATION_STATUS.equalsIgnoreCase("SEVERE") || CUSTOM_CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                                    prop.setProperty("CREATION_STATUS", "WARNING");
                                    prop.setProperty("CREATION_MESSAGE", prop.getProperty("CREATION_MESSAGE") + ", " + customErrorProp.getProperty("CREATION_MESSAGE"));
                                }
                            }
                            try {
                                if (!CREATION_STATUS.equalsIgnoreCase("SEVERE") && props.get("preventDeletion") != null) {
                                    String rootName = StrUtil.getContainerDNFromDN((String)distinguishedName);
                                    String value = "";
                                    if (((Boolean)props.get("preventDeletion")).booleanValue()) {
                                        value = "true";
                                        CSVComputerListener.this.updatePreventDeletion(distinguishedName, "add");
                                        if (!rootName.equalsIgnoreCase(defaultNamingcontext)) {
                                            CSVComputerListener.this.updateParent(rootName);
                                        }
                                    } else {
                                        value = "false";
                                        CSVComputerListener.this.updatePreventDeletion(distinguishedName, "delete");
                                    }
                                    Properties grpList = new Properties();
                                    grpList.put("ATTRIB_LDAP_NAME", "preventDeletion");
                                    grpList.put("ATTRIB_DISP_NAME", CSVComputerListener.this.rb.getString("admp.common.attrib_disp_name.prevent_deletion"));
                                    grpList.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                    grpList.put("ATTRIB_VALUE", value);
                                    propList.add(grpList);
                                    logProps.put("propList", propList);
                                }
                                prop.setProperty("CREATION_MESSAGE", CSVComputerListener.this.rb.getString("admp.mgmt.comp_mgmt.cre_bulk_comp.statmsg.success_created_comp"));
                                prop.setProperty("CREATION_STATUS", "SUCCESS");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                            }
                            catch (Exception e) {
                                prop.setProperty("CREATION_MESSAGE", e.getMessage());
                                prop.setProperty("CREATION_STATUS", "SEVERE");
                                prop.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                            }
                        }
                        TechAuditAPI.getInstance().auditLogs(CSVComputerListener.this.loginId, logProps, prop.getProperty("CREATION_MESSAGE"), CSVComputerListener.this.rb.getString("admp.mgmt.comp_mgmt.text.computer_creation"), CSVComputerListener.this.rb);
                        CSVComputerListener.this.addRow(prop);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                        if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            auditObjectIdList.add(object_id);
                        }
                    } else {
                        Properties prop = new Properties();
                        prop.setProperty("CREATION_STATUS", "WARNING");
                        prop.setProperty("CREATION_MESSAGE", CSVComputerListener.this.rb.getString("admp.mgmt.bulk_creation.common.statmsg.could_not_upd_more_than_100_lic_level_exceed"));
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                        prop.put("USER_INDEX", userIndex);
                        CSVComputerListener.this.addRow(prop);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                    }
                    mgmtLog.log(Level.INFO, "After User Creation");
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties hdtProp = HelpdeskUtil.getHDTProp((Long)CSVComputerListener.this.loginId, (AdventNetResourceBundle)CSVComputerListener.this.rb);
                    String hdtName = hdtProp.getProperty("FULL_NAME");
                    logProps.put("technicianName", hdtName);
                    this.modifyUserListener.sendSysLogs(logProps, 2006, (String)audit_info.get("error_msg"), CSVComputerListener.this.rb.getString("admp.ad_explorer.view_props.computer.attrib_disp_name.computer_name"), CSVComputerListener.this.rb);
                }
                this.modifyUserListener.isCompleted = true;
                CSVComputerListener.this.updatedCount = 0;
                DomainHandler.updateDomainDatas((String)CSVComputerListener.this.domainName, (Long)CSVComputerListener.this.loginId, (String[])new String[]{"Computer"}, (boolean)false);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 3;
                    CSVComputerListener.this.triggerNotification(auditDataObj, auditObjectIdList, objectId, resultList, CSVComputerListener.this.loginId, CSVComputerListener.this.reportId, CSVComputerListener.this.domainName, CSVComputerListener.this.rb, this.modifyUserListener.resultAttributeList, objectOUList);
                }
            }
            catch (Exception e) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

