/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.computermanagement.ModifyComputerListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;

public class DeleteComputers
extends ModifyComputerListener {
    public DeleteComputers() {
        this.reportId = new Integer(2005);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, AdmpInput admpInput, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        return this.modifyUser(result, attributeList, domainName, loginId, audit_info, auditDataObj);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        return this.modifyUser(result, attributeList, domainName, loginId, audit_info, auditDataObj);
    }

    private String modifyUser(Hashtable result, ArrayList attributeList, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1200L})) {
            return this.rb.getString("client.computermanagement.DeleteComputers.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            try {
                String dn = this.getValue(result, 3020);
                System.out.println("Delete computer listener: " + domainName + " : DN : " + dn);
                ADHandlerForMgmt.deleteUser((String)domainName, (Long)loginId, (String)CommonUtil.escapeDN((String)dn));
                UserHandler.deleteUser((String)domainName, (Long)loginId, (String)dn);
                message.append(this.rb.getString("client.computermanagement.DeleteComputers.successfully_deleted_the_computer"));
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.DeleteComputers.unable_to_delete_the_computer") + " " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.DeleteComputers.unable_to_delete_the_computer") + " " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditDeleteComputer(loginId, this.rb.getString("admp.mgmt.comp_mgmt.common.mgmtname.delete_computers"), this.getValue(result, 3001), domainName, message.toString(), this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

