/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.webclient.computermanagement.ModifyComputerListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class EnableDisableComputers
extends ModifyComputerListener {
    public EnableDisableComputers() {
        this.reportId = new Integer(2004);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, AdmpInput admpInput, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        HashMap<String, String> props = new HashMap<String, String>();
        Integer mgmtID = Integer.parseInt(admpInput.getValue());
        if (mgmtID == RVCConstants.RV_MGMT_DISABLECOMPUTER_ID) {
            props.put("accountEnableDisable", "disable");
        } else if (mgmtID == RVCConstants.RV_MGMT_ENABLECOMPUTER_ID) {
            props.put("accountEnableDisable", this.rb.getString("admp.mgmt.common.input.enable"));
        }
        return this.modifyUser(result, attributeList, props, listener, domainName, loginId, audit_info, auditDataObj);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        ModifyUserListener listener = (ModifyUserListener)bean.getListener();
        BeanMap props = (BeanMap)bean.get("props");
        return this.modifyUser(result, attributeList, props, (NativeListener)listener, domainName, loginId, audit_info, auditDataObj);
    }

    private String modifyUser(Hashtable result, ArrayList attributeList, HashMap props, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1036L})) {
            return this.rb.getString("client.computermanagement.EnableDisableComputers.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String accountStatus = "";
            String sid = this.getValue(result, 3018);
            String dn = this.getValue(result, 3020);
            ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
            Hashtable<String, String> logProps = new Hashtable<String, String>();
            logProps.put(this.rb.getString("client.computermanagement.domainName"), domainName);
            logProps.put(this.rb.getString("client.computermanagement.computerName"), this.getValue(result, 3001));
            logProps.put(this.rb.getString("client.computermanagement.EnableDisableComputers.Account"), (String)props.get("accountEnableDisable"));
            if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1036L)) {
                String accountEnableDisable = (String)props.get("accountEnableDisable");
                int userAccountControl = 0;
                int andUserAccountControl = 0xFFFFFFF;
                if (props.get("accountEnableDisable").equals(this.rb.getString("admp.mgmt.common.input.enable"))) {
                    andUserAccountControl &= 0xFFFFFD;
                    accountStatus = this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.enabled");
                } else {
                    userAccountControl |= 2;
                    accountStatus = this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.disabled");
                }
                Properties p = new Properties();
                p.put("DATA_HANDLER_TYPE", new Long(7L));
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "userAccountControl");
                p.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
                p.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
                modifyAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY Computer, DOMAIN :  " + domainName + " SID : " + sid + " Modify List :  " + modifyAttributeList);
            try {
                if (modifyAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, new ArrayList(), modifyAttributeList, (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("client.computermanagement.EnableDisableComputers.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("client.computermanagement.EnableDisableComputers.successfully_modified_error"));
                    }
                } else {
                    message.insert(0, this.rb.getString("client.computermanagement.EnableDisableComputers.unable_to_modify_the_computer_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.EnableDisableComputers.unable_to_modify_the_computer") + " " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.computermanagement.EnableDisableComputers.unable_to_modify_the_computer") + " " + e.getMessage());
            }
            if (!accountStatus.equals("")) {
                Properties p2 = (Properties)modifyAttributeList.get(0);
                p2.put("ATTRIB_LDAP_NAME", "UserAccountStatus");
                p2.put("ATTRIB_VALUE", accountStatus);
            }
            TechAuditAPI.getInstance().auditComputerModification(loginId, this.rb.getString("admp.mgmt.comp_mgmt.enab_dis_comps.mgmtname.enab_dis_comps"), this.getValue(result, 3001), domainName, new ArrayList(), modifyAttributeList, new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

