/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.computermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.webclient.computermanagement.ModifyComputerListener;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RestoreDeletedComputers
extends ModifyComputerListener {
    public RestoreDeletedComputers() {
        this.reportId = new Integer(2007);
    }

    @Override
    public boolean checkAuthorization(String domainName, Long loginId, String guid) {
        boolean ret = false;
        ArrayList ouList = (ArrayList)this.authorizedDomainOUHash.get(domainName);
        try {
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("lastKnownParent");
            guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList objList = ADHandler.getDeletedObjectsWithOutListener((Properties)domainDetails, attribList, (String)("name=*" + guid));
            if (!objList.isEmpty()) {
                Properties prop = (Properties)objList.get(0);
                String dn = (String)((ArrayList)prop.get("lastKnownParent")).get(0);
                int ind = dn.indexOf("\\0A");
                if (ind != -1) {
                    dn = "CN=computers," + prop.get("DEFAULT_NAMING_CONTEXT");
                }
                ret = ClientAuthorizationUtil.isAuthorizedObject(dn, ouList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1075L})) {
            return rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            block10: {
                logger.log(Level.INFO, "Calling Modify User in the RestoreDeletedComputers");
                try {
                    int index;
                    String deletedDN = this.getValue(result, 3020);
                    String parentDN = this.getValue(result, 3024);
                    String sid = this.getValue(result, 3018);
                    Boolean OUDeleted = false;
                    String[] domain = (String[])bean.get("domains");
                    String defaultNamingContext = domain[0];
                    int ind = parentDN.indexOf("\\0A");
                    if (ind != -1) {
                        OUDeleted = true;
                        parentDN = "CN=computers," + defaultNamingContext;
                    }
                    if ((index = deletedDN.indexOf("\\0A")) != -1) {
                        String restoreDN = deletedDN.substring(0, index) + "," + parentDN;
                        logger.log(Level.INFO, "Restoring the computer,deletedDN: " + deletedDN + " to the destination: " + parentDN);
                        ADHandlerForMgmt.restoreDeletedObject((String)domainName, (Long)loginId, (String)deletedDN, (String)restoreDN, (String)parentDN);
                        DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"Computer"}, (boolean)false);
                        if (OUDeleted.booleanValue()) {
                            message.append(rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.successfully_restored_in_computers_container"));
                        } else {
                            message.append(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.successfully_restored"));
                        }
                        break block10;
                    }
                    logger.log(Level.INFO, "Invalid Deleted DN");
                    throw new Exception(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.invalid_dn"));
                }
                catch (LocalizedException le) {
                    le.printStackTrace();
                    message = new StringBuffer(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.unable_restore_computer") + " " + le.getMessage(rb));
                }
                catch (Exception e) {
                    message = new StringBuffer(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.unable_restore_computer") + " " + e.getMessage());
                }
            }
            TechAuditAPI.getInstance().auditDeleteComputer(loginId, rb.getString("admp.mgmt.comp_mgmt.common.mgmtname.restore_deleted_computers"), this.getValue(result, 3032), domainName, message.toString(), rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "Returned Message is " + message.toString());
        return message.toString();
    }

    @Override
    public void search(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)loginId);
            logger.log(Level.INFO, "Generation ID : " + this.generationId);
            ArrayList attributeList = this.getReportAttributeList();
            String searchString = request.getParameter("searchString");
            ArrayList containerList = this.getContainerList(request, bean);
            logger.log(Level.INFO, "The container list is : " + containerList);
            logger.log(Level.INFO, "Form to Action : ");
            Action action = new Action(loginId, containerList, attributeList, this.getSearchQuery(searchString, bean), this, dnDomainNameMap);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getCSVQuery(String keyLdapName, String keyLdapValue) {
        return "(&(isDeleted=TRUE)(objectClass=computer)(" + keyLdapName + "=" + keyLdapValue + "))";
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        str.append("(&(isDeleted=TRUE)(objectClass=computer)");
        if (searchString != null && !searchString.equals("")) {
            StringTokenizer token = new StringTokenizer(searchString, ",");
            str.append("(|");
            while (token.hasMoreTokens()) {
                String s = (String)token.nextElement();
                str.append("(samAccountName=*" + s + "*)");
                str.append("(name=*" + s + "*)");
            }
            str.append(")");
        }
        str.append(")");
        return str.toString();
    }

    @Override
    protected Properties getAttributeValues(String domainName, String defaultNamingContext, Long loginId, ArrayList attributeList, String searchString) throws Exception {
        ArrayList values = null;
        Properties prop = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        values = ADHandler.getDeletedObjectsWithOutListener((Properties)HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId), (ArrayList)attributeList, (String)searchString);
        logger.log(Level.INFO, " Object Values : " + values + " for the search : " + searchString);
        if (values == null || values.size() == 0) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.object_not_exist_access_denied"));
        }
        if (values.size() > 1) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.duplicate_object_exists"));
        }
        return (Properties)values.get(0);
    }

    protected class Action
    extends Thread {
        private ArrayList containerList = null;
        private NativeListener listener = null;
        private String searchString = null;
        private Hashtable dnDomainNameMap = null;
        private ArrayList attributeList = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attrib, String s, NativeListener li, Hashtable d) {
            this.loginId = loginId;
            this.containerList = list;
            this.listener = li;
            this.searchString = s;
            this.dnDomainNameMap = d;
            this.attributeList = attrib;
        }

        @Override
        public void run() {
            RestoreDeletedComputers.this.errorMessage = null;
            RestoreDeletedComputers.this.guidList = new ArrayList();
            RestoreDeletedComputers.this.registerQueue();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    RestoreDeletedComputers.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    RestoreDeletedComputers.this.setTableProps(RestoreDeletedComputers.this.domainName);
                    QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
                    RestoreDeletedComputers.this.addlResultIps.put("MESSAGE", queryGen.getDBNullValue());
                    logger.log(Level.INFO, "Searching the SIDs for the String " + this.searchString + " from the domain " + dn);
                    ADHandler.getDeletedObjects((String)RestoreDeletedComputers.this.domainName, (Long)this.loginId, (ArrayList)this.attributeList, (String)this.searchString, (NativeListener)this.listener);
                    RestoreDeletedComputers.this.updateQueue();
                    continue;
                }
                catch (Exception e) {
                    RestoreDeletedComputers.this.errorMessage = e.getMessage();
                    e.printStackTrace();
                }
            }
            RestoreDeletedComputers.this.updatedCount = 0;
            RestoreDeletedComputers.this.totalCount = 0;
            RestoreDeletedComputers.this.completedAction();
            RestoreDeletedComputers.this.addlResultIps.clear();
        }
    }
}

