/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.contacts;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class CSVContactListener
extends CSVUserListener {
    AdventNetResourceBundle rb = null;
    private String containerName = null;
    private ArrayList attributeList = null;
    private ArrayList resultAttributeList = null;

    public CSVContactListener(Long loginId, Long[] ids, Hashtable domainVsIds, ArrayList groupList) {
        super(loginId, ids, domainVsIds, groupList);
    }

    public void addContacts(HttpServletRequest request) {
        Locale locale = request.getLocale();
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String hostId = request.getRemoteHost();
        Action action = new Action(this, hostId);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void init(Long userCreationID, String domainName, ArrayList<Hashtable> userDetailsList, String keyLdapName, String container, ArrayList attributeList, ArrayList resultAttributeList) {
        this.userCreationID = userCreationID;
        this.domainName = domainName;
        this.userDetailsList = userDetailsList;
        this.keyLdapName = keyLdapName;
        this.containerName = container;
        this.attributeList = attributeList;
        this.resultAttributeList = resultAttributeList;
        this.reportId = 3001;
    }

    @Override
    protected void reloadUI() {
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.out.write("<script>window.location.href='CSVContacts.do?methodToCall=bulkContact&selectedTab=admin&operation=ShowResult'</script>");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMailRelatedAttributes(ArrayList propList, Properties props) {
        String msExchPoliciesExcludedValue;
        boolean isTargetAddressExists = props.get("targetAddress") != null;
        boolean isProxyAddressExists = props.get("proxyAddresses") != null;
        boolean msExchPoliciesExcluded = props.get("msExchPoliciesExcluded") != null;
        boolean hasPrimarySmtp = false;
        boolean isProxyAddressExistsByTargetAddress = false;
        String effectiveMailAddress = "";
        String targetAddress = "";
        if (msExchPoliciesExcluded && (msExchPoliciesExcludedValue = (String)props.get("msExchPoliciesExcluded")).equals("")) {
            msExchPoliciesExcluded = false;
        }
        if (!msExchPoliciesExcluded) {
            hasPrimarySmtp = true;
        }
        ArrayList proxyAddressList = new ArrayList();
        if (isProxyAddressExists) {
            proxyAddressList = (ArrayList)props.get("proxyAddresses");
        }
        for (int index = 0; index < proxyAddressList.size(); ++index) {
            String mailType;
            String proxyAddr = (String)proxyAddressList.get(index);
            if (proxyAddr.startsWith("SMTP:") && !hasPrimarySmtp) {
                hasPrimarySmtp = true;
                if (effectiveMailAddress.length() != 0) continue;
                effectiveMailAddress = proxyAddr.substring(5);
                continue;
            }
            if (!hasPrimarySmtp || !(mailType = proxyAddr.substring(0, 5)).equalsIgnoreCase("SMTP:")) continue;
            proxyAddr = mailType.toLowerCase() + proxyAddr.substring(5);
            proxyAddressList.set(index, proxyAddr);
        }
        if (isTargetAddressExists && msExchPoliciesExcluded) {
            targetAddress = (String)props.get("targetAddress");
        }
        if (!(targetAddress.equals("") || proxyAddressList.contains("smtp:" + targetAddress.substring(5)) || proxyAddressList.contains("SMTP:" + targetAddress.substring(5)) || proxyAddressList.contains(targetAddress))) {
            String targetAddressToAdd = "";
            isProxyAddressExistsByTargetAddress = true;
            if (hasPrimarySmtp) {
                targetAddressToAdd = "smtp:" + targetAddress.substring(targetAddress.indexOf(":") + 1);
            } else {
                targetAddressToAdd = "SMTP:" + targetAddress.substring(targetAddress.indexOf(":") + 1);
                if (effectiveMailAddress.length() == 0) {
                    effectiveMailAddress = targetAddressToAdd.substring(5);
                }
            }
            proxyAddressList.add(targetAddressToAdd);
        }
        if (isTargetAddressExists && !proxyAddressList.contains((String)props.get("targetAddress")) && !msExchPoliciesExcluded) {
            targetAddress = (String)props.get("targetAddress");
            proxyAddressList.add("SMTP:" + targetAddress.substring(targetAddress.indexOf(":") + 1));
        }
        int proxyAddrIndex = -1;
        int mailIndex = -1;
        for (int i = 0; i < propList.size(); ++i) {
            Hashtable prop = (Hashtable)propList.get(i);
            String attribName = (String)prop.get("ATTRIB_LDAP_NAME");
            if (attribName.equalsIgnoreCase("proxyAddresses")) {
                proxyAddrIndex = i;
            }
            if (!attribName.equalsIgnoreCase("mail")) continue;
            mailIndex = i;
        }
        if ((isProxyAddressExists || isProxyAddressExistsByTargetAddress) && proxyAddressList.size() > 0) {
            Hashtable<String, Object> proxyAddresses = new Hashtable<String, Object>();
            proxyAddresses.put("ATTRIB_LDAP_NAME", "proxyAddresses");
            if (proxyAddressList.size() > 1) {
                proxyAddresses.put("ATTRIB_VALUE", proxyAddressList);
            } else {
                proxyAddresses.put("ATTRIB_VALUE", (String)proxyAddressList.get(0));
            }
            proxyAddresses.put("ATTRIB_VALUE_COUNT", proxyAddressList.size());
            proxyAddresses.put("ATTRIB_COLUMN_NAME", "EMAIL_PROXY_ADDRESSES");
            proxyAddresses.put("DW_CONTROL_CODE", msExchPoliciesExcluded ? 2L : 3L);
            proxyAddresses.put("DATA_HANDLER_TYPE", new Long(3L));
            if (proxyAddrIndex != -1) {
                propList.set(proxyAddrIndex, proxyAddresses);
            } else {
                propList.add(proxyAddresses);
            }
        }
        if (effectiveMailAddress.length() > 0) {
            Hashtable<String, Object> mailAttrHash = new Hashtable<String, Object>();
            mailAttrHash.put("ATTRIB_VALUE", effectiveMailAddress);
            mailAttrHash.put("ATTRIB_COLUMN_NAME", "EMAIL_ADDRESS");
            mailAttrHash.put("ATTRIB_LDAP_NAME", "mail");
            mailAttrHash.put("ATTRIB_DATA_TYPE", new Integer(1));
            mailAttrHash.put("DATA_HANDLER_TYPE", new Long(3L));
            mailAttrHash.put("ATTRIB_VALUE_COUNT", new Long(1L));
            mailAttrHash.put("DW_CONTROL_CODE", new Long(2L));
            if (mailIndex != -1) {
                propList.set(mailIndex, mailAttrHash);
            } else {
                propList.add(mailAttrHash);
            }
        }
    }

    private Properties getBulkUserErrorMessage(String domainName, ArrayList groupList, NativeError errHdlr, String containerName, String objectName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        if (errHdlr.getErrorMessage((Object)domainName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)domainName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)domainName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)containerName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)containerName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)containerName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)objectName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)objectName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)objectName);
            if (errorSeverity != null && errorSeverity.equals("SEVERE")) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : groupList) {
            if (errHdlr.getErrorMessage(object, this.rb) == null) continue;
            messageBuilder.append(errHdlr.getErrorMessage(object, this.rb));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.successfully_created_the_contact") + " " + messageBuilder.toString());
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.successfully_created_the_contact"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    private Properties getBulkUserModificationErrorMessage(String domainName, ArrayList groupList, NativeError errHdlr, String containerName, String objectName) {
        Properties statusProps = new Properties();
        StringBuilder messageBuilder = new StringBuilder();
        String message = null;
        String errorSeverity = null;
        if (errHdlr.getErrorMessage((Object)domainName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)domainName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)domainName);
            if (errorSeverity != null && (errorSeverity.equals("SEVERE") || errorSeverity.equals("WARNING"))) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)containerName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)containerName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)containerName);
            if (errorSeverity != null && (errorSeverity.equals("SEVERE") || errorSeverity.equals("WARNING"))) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        } else if (errHdlr.getErrorMessage((Object)objectName, this.rb) != null) {
            message = errHdlr.getErrorMessage((Object)objectName, this.rb);
            errorSeverity = errHdlr.getSeverityLevel((Object)objectName);
            if (errorSeverity != null && (errorSeverity.equals("SEVERE") || errorSeverity.equals("WARNING"))) {
                statusProps.setProperty("CREATION_STATUS", errorSeverity);
                statusProps.setProperty("CREATION_MESSAGE", message);
                statusProps.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                statusProps.setProperty("CREATION_MESSAGE_STYLE", "redtxtbold");
                return statusProps;
            }
            messageBuilder.append(message);
        }
        for (Object object : groupList) {
            if (errHdlr.getErrorMessage(object, this.rb) == null) continue;
            messageBuilder.append(errHdlr.getErrorMessage(object, this.rb));
        }
        if (messageBuilder.length() > 0) {
            statusProps.setProperty("CREATION_STATUS", "WARNING");
            statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.successfully_created_the_contact") + " " + messageBuilder.toString());
            statusProps.setProperty("CREATION_IMAGE", "/images/alert.gif");
            statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
            return statusProps;
        }
        statusProps.setProperty("CREATION_STATUS", "SUCCESS");
        statusProps.setProperty("CREATION_MESSAGE", this.rb.getString("client.contacts.CSVContactListener.successfully_created_the_contact"));
        statusProps.setProperty("CREATION_MESSAGE_STYLE", "greentxtbold");
        return statusProps;
    }

    private class Action
    extends Thread {
        private CSVContactListener modifyUserListener;
        private String hostId;

        public Action(CSVContactListener modifyUserListener, String hostId) {
            this.modifyUserListener = modifyUserListener;
            this.hostId = hostId;
        }

        @Override
        public void run() {
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)CSVContactListener.this.loginId, (String)this.hostId, (Integer)CSVContactListener.this.reportId, (DataObject)auditDataObj, (ArrayList)CSVContactListener.this.attributeList, (AdventNetResourceBundle)CSVContactListener.this.rb);
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                audit_info.put("audit_id", audit_id);
                boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"contactMgmt");
                Hashtable customAttributesList = AddUserHandler.getInstance().getCustomAttributesList(CSVContactListener.this.userCreationID);
                Hashtable resultList = new Hashtable();
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (Hashtable hashtable : CSVContactListener.this.userDetailsList) {
                    Hashtable nameVsValues;
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
                    ArrayList customList = new ArrayList();
                    ArrayList nonExchPropList = new ArrayList();
                    ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                    ArrayList<String> groupList = new ArrayList<String>();
                    Properties props = new Properties();
                    CSVContactListener.this.getProperties("create", valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props, "Contact");
                    String userName = "";
                    if (props.get("userName") != null) {
                        userName = props.getProperty("userName");
                    }
                    String adminGroup = null;
                    String mailAlias = null;
                    boolean usePowerShell = false;
                    String targetAddress = null;
                    if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                        adminGroup = props.getProperty("adminGroup");
                    }
                    if (props.get("mailAlias") != null) {
                        mailAlias = props.getProperty("mailAlias");
                    }
                    if (props.get("targetAddress") != null) {
                        targetAddress = props.getProperty("targetAddress");
                    }
                    if (adminGroup != null) {
                        usePowerShell = ExchangeUtil.checkExchangeGroup2007((String)adminGroup);
                    }
                    if ((nameVsValues = (Hashtable)customAttributesList.get(userIndex)) != null) {
                        Enumeration e = nameVsValues.keys();
                        while (e.hasMoreElements()) {
                            String attributeName = (String)e.nextElement();
                            ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                            Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                            customTable.put("ATTRIB_LDAP_NAME", attributeName);
                            customTable.put("DATA_HANDLER_TYPE", 3L);
                            customTable.put("ATTRIB_VALUE_COUNT", 1L);
                            if (values != null && values.size() > 1) {
                                ArrayList<String> list = new ArrayList<String>();
                                for (Object string : values) {
                                    list.add(string.toString().trim());
                                }
                                customTable.put("ATTRIB_VALUE", list);
                                customTable.put("ATTRIB_VALUE_COUNT", new Long(list.size()));
                            } else if (values != null && values.size() == 1) {
                                customTable.put("ATTRIB_VALUE", values.get(0));
                            } else {
                                customTable.put("ATTRIB_VALUE", "");
                            }
                            customList.add(customTable);
                        }
                    }
                    CSVContactListener.this.setMailRelatedAttributes(propList, props);
                    String searchName = userName;
                    userName = CommonUtil.escapeString((String)userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
                    Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                    logProps.put("domainName", CSVContactListener.this.domainName);
                    logProps.put("userName", userName);
                    logProps.put("propList", propList);
                    logProps.put("customList", customList);
                    logProps.put("modifyList", modifyList);
                    logProps.put("tsList", tsList);
                    logProps.put("winNTAttributeList", winNTAttributeList);
                    logProps.put("groupList", groupList);
                    String container = (String)props.get("OUName");
                    if (container != null) {
                        CSVContactListener.this.containerName = container;
                    }
                    if (!objectOUList.contains(CSVContactListener.this.containerName)) {
                        objectOUList.add(CSVContactListener.this.containerName);
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (Long)userIndex, (String)userName, (String)CSVContactListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("user_index", userIndex);
                    if (props.get("manager") != null) {
                        Hashtable<String, String> userVsmanager = new Hashtable<String, String>();
                        userVsmanager.put("manager", props.get("manager").toString());
                        resultList.put(userName, userVsmanager);
                    }
                    if (CSVContactListener.this.stop) break;
                    if (!isLicenseExceeded) {
                        String distinguishedName;
                        NativeError error = new NativeError();
                        error = !usePowerShell ? ADHandler.addContact((String)CSVContactListener.this.domainName, (Long)CSVContactListener.this.loginId, (String)CSVContactListener.this.containerName, (String)userName, propList, modifyList, groupList) : ADHandler.addContact((String)CSVContactListener.this.domainName, (Long)CSVContactListener.this.loginId, (String)CSVContactListener.this.containerName, (String)userName, nonExchPropList, modifyList, groupList);
                        Properties prop = CSVContactListener.this.getBulkUserErrorMessage(CSVContactListener.this.domainName, groupList, error, CSVContactListener.this.containerName, userName);
                        String CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        if (usePowerShell && !CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            distinguishedName = "CN=" + userName + "," + CSVContactListener.this.containerName;
                            Properties exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)CSVContactListener.this.domainName, (String)adminGroup, (Long)CSVContactListener.this.loginId);
                            String exchErrMessage = "";
                            if (targetAddress != null && mailAlias != null) {
                                exchErrMessage = ADHandler.createMailEnabledContact2007((String)CSVContactListener.this.domainName, (long)CSVContactListener.this.loginId, (String)distinguishedName, (String)mailAlias, (String)targetAddress, (Properties)exchangeServerDetails);
                            }
                            searchName = CommonUtil.escapeSpecialCharacters((String)searchName);
                            String searchString = "(&(objectClass=contact)(objectCategory=contact)(name=" + searchName + "))";
                            NativeError nonExchPropError = ADHandler.searchAndModifyContact((String)CSVContactListener.this.domainName, (Long)CSVContactListener.this.loginId, (String)CSVContactListener.this.containerName, (String)searchString, null, propList, new ArrayList(), (boolean)false);
                            Properties nonExchProp = CSVContactListener.this.getBulkUserModificationErrorMessage(CSVContactListener.this.domainName, groupList, nonExchPropError, CSVContactListener.this.containerName, searchString);
                            String NON_EXCH_CREATION_STATUS = nonExchProp.getProperty("CREATION_STATUS");
                            if (NON_EXCH_CREATION_STATUS.equalsIgnoreCase("SEVERE") || NON_EXCH_CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                                prop.setProperty("CREATION_STATUS", "WARNING");
                                prop.setProperty("CREATION_MESSAGE", prop.getProperty("CREATION_MESSAGE") + ", " + nonExchProp.getProperty("CREATION_MESSAGE"));
                            }
                            if (exchErrMessage.length() != 0) {
                                prop.setProperty("CREATION_MESSAGE", prop.getProperty("CREATION_MESSAGE") + ", " + MessageFormat.format(CSVContactListener.this.rb.getString("admp.mgmt.user_mgmt.cre_contacts.statmsg.mail_enabled"), CSVContactListener.this.rb.getString(exchErrMessage)));
                            }
                        }
                        if (!(CREATION_STATUS = prop.getProperty("CREATION_STATUS")).equalsIgnoreCase("SEVERE") && !customList.isEmpty()) {
                            distinguishedName = "CN=" + userName + "," + CSVContactListener.this.containerName;
                            searchName = CommonUtil.escapeSpecialCharacters((String)distinguishedName);
                            String searchString = "(&(objectClass=contact)(objectCategory=contact)(distinguishedName=" + searchName + "))";
                            NativeError customError = ADHandler.searchAndModifyContact((String)CSVContactListener.this.domainName, (Long)CSVContactListener.this.loginId, (String)CSVContactListener.this.containerName, (String)searchString, null, customList, new ArrayList(), (boolean)false);
                            Properties customErrorProp = CSVContactListener.this.getBulkUserModificationErrorMessage(CSVContactListener.this.domainName, groupList, customError, CSVContactListener.this.containerName, searchString);
                            String CUSTOM_CREATION_STATUS = customErrorProp.getProperty("CREATION_STATUS");
                            if (CUSTOM_CREATION_STATUS.equalsIgnoreCase("SEVERE") || CUSTOM_CREATION_STATUS.equalsIgnoreCase("WARNING")) {
                                prop.setProperty("CREATION_STATUS", "WARNING");
                                prop.setProperty("CREATION_MESSAGE", prop.getProperty("CREATION_MESSAGE") + ", " + customErrorProp.getProperty("CREATION_MESSAGE"));
                            }
                        }
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                        prop.put("USER_INDEX", userIndex);
                        TechAuditAPI.getInstance().auditLogs(CSVContactListener.this.loginId, logProps, prop.getProperty("CREATION_MESSAGE"), CSVContactListener.this.rb.getString("admp.mgmt.cont_mgmt.cre_contacts.mgmtname.contact_creation"), CSVContactListener.this.rb);
                        CSVContactListener.this.addRow(prop);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                        if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            auditObjectIdList.add(object_id);
                        }
                    } else {
                        Properties prop = new Properties();
                        prop.setProperty("CREATION_STATUS", "WARNING");
                        prop.setProperty("CREATION_MESSAGE", CSVContactListener.this.rb.getString("client.contacts.CSVContactListener.could_not_update_more_than_100_objects_license_level_exceeded"));
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                        prop.put("USER_INDEX", userIndex);
                        CSVContactListener.this.addRow(prop);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                    }
                    mgmtLog.log(Level.INFO, "After User Creation");
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                    Properties hdtProp = HelpdeskUtil.getHDTProp((Long)CSVContactListener.this.loginId, (AdventNetResourceBundle)CSVContactListener.this.rb);
                    String hdtName = hdtProp.getProperty("FULL_NAME");
                    logProps.put("technicianName", hdtName);
                    this.modifyUserListener.sendSysLogs(logProps, 3001, (String)audit_info.get("error_msg"), CSVContactListener.this.rb.getString("admp.ad_explorer.view_props.computer.attrib_disp_name.contact_name"), CSVContactListener.this.rb);
                }
                this.modifyUserListener.isCompleted = true;
                CSVContactListener.this.updatedCount = 0;
                DomainHandler.updateDomainDatas((String)CSVContactListener.this.domainName, (Long)CSVContactListener.this.loginId, (String[])new String[]{"CONTACT"}, (boolean)false);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    Integer objectId = 4;
                    CSVContactListener.this.triggerNotification(auditDataObj, auditObjectIdList, objectId, resultList, CSVContactListener.this.loginId, CSVContactListener.this.reportId, CSVContactListener.this.domainName, CSVContactListener.this.rb, this.modifyUserListener.resultAttributeList, objectOUList);
                }
            }
            catch (Exception e) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

