/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.contacts;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.contacts.ModifyContactListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ContactAttributeListener
extends ModifyContactListener {
    public ContactAttributeListener() {
        this.reportId = new Integer(3004);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1073L})) {
            return this.rb.getString("client.contacts.ContactAttributeListener.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            String guid = this.getValue(result, 10050);
            String dn = this.getValue(result, 10004);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            BeanMap props = (BeanMap)bean.get("props");
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p = new Properties();
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                String beanValue = props.getProperty(selectedAttributes[j]);
                if (beanValue.equals("")) {
                    p.put("DW_CONTROL_CODE", new Long(1L));
                }
                p.put("ATTRIB_VALUE", beanValue);
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                if (selectedAttributes[j].equals("mailFormat")) {
                    String val = FormatClientUtil.getFormatValue(new Long(props.getProperty("mailFormat")), result, domainName, "contact");
                    if (val.indexOf("@") == -1) {
                        val = val + "@" + FormatClientUtil.getFormatValue(props.getProperty("mailDomain"), result, domainName, "contact");
                    }
                    p.put("ATTRIB_LDAP_NAME", "mail");
                    p.put("ATTRIB_VALUE", val);
                } else if (selectedAttributes[j].equals("desc")) {
                    p.put("ATTRIB_LDAP_NAME", "description");
                }
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "Modifying Contact Object , DOMAIN :  " + domainName + " GUID : " + guid + " attributeList : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandler.modifyContact((String)domainName, (Long)loginId, (String)guid, (String)dn, setAttributeList, (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("client.contacts.ContactAttributeListener.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("client.contacts.ContactAttributeListener.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, this.rb.getString("client.contacts.ContactAttributeListener.unable_to_modify_the_contact_error") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("client.contacts.ContactAttributeListener.unable_to_modify_the_contact") + " " + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("client.contacts.ContactAttributeListener.unable_to_modify_the_contact") + " " + e.getMessage());
            }
            TechAuditAPI.getInstance().auditContactModification(loginId, this.rb.getString("admp.mgmt.common.mgmtcategory.modify_contact_attribs"), this.getValue(result, 10004), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        String[] actionValues = new String[]{"telephoneNumber", "wWWHomePage", "desc", "physicalDeliveryOfficeName", "homePhone", "pager", "mobile", "facsimileTelephoneNumber", "ipPhone"};
        String[] actionLabelsStr = new String[]{"admp.mgmt.user_mgmt.contact_attribs.input.telephone_number", "admp.mgmt.user_mgmt.contact_attribs.input.web_page", "admp.mgmt.user_mgmt.contact_attribs.input.description", "admp.mgmt.user_mgmt.contact_attribs.input.office", "admp.mgmt.user_mgmt.contact_attribs.input.home_phone", "admp.mgmt.user_mgmt.contact_attribs.input.pager", "admp.mgmt.user_mgmt.contact_attribs.input.mobile", "admp.mgmt.user_mgmt.contact_attribs.input.fax", "admp.mgmt.user_mgmt.contact_attribs.input.ip_phone"};
        MgmtUtil.setEmptyFieldsMessage(request, bean, actionValues, actionLabelsStr);
    }
}

