/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.contacts;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.contacts.ModifyContactListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;

public class MoveContactsListener
extends ModifyContactListener {
    public MoveContactsListener() {
        this.reportId = new Integer(3013);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1078L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        String dn = this.getValue(result, 10004);
        String guid = this.getValue(result, 10050);
        guid = guid.substring(guid.indexOf("{") + 1, guid.indexOf("}"));
        BeanMap props = (BeanMap)bean.get("props");
        if (ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1078L)) {
            try {
                ADHandlerForMgmt.moveObject((String)domainName, (Long)loginId, (String)dn, (String)props.getProperty("moveUsersDN"));
                ADHandler.updateContact((String)domainName, (Long)loginId, (String)guid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.contact_mgmt.common.statmsg.unable_to_modify_contact_error"), new String(le.getMessage(this.rb))));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.contact_mgmt.common.statmsg.unable_to_modify_contact_error"), new String(e.getMessage())));
            }
            String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
            TechAuditAPI.getInstance().auditMoveContact(loginId, this.rb.getString("admp.mgmt.common.mgmtname.move_contact"), this.getValue(result, 10008), domainName, sourceDN, props.getProperty("moveUsersDN"), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        return message.toString();
    }
}

